<?xml version="1.0" encoding="iso-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="/">
        <html>
            <head>
                <style type="text/css">
                    body {
                    font-family: "Frutiger LT Std 45 Light", "Verdana";
                    font-size: 12px;
                    color:
                    #000000;
                    }
                    table {
                    font-size: 12px;
                    border-style: solid;
                    border-width: 1px;
                    border-color: #808080;
                    border-spacing: 0px;
                    border-collapse:
                    collapse;
                    }
                    tr.ghost {
                    opacity:0.15;
                    }
                    td {
                    vertical-align:
                    top;
                    border-style: solid;
                    border-width: 1px;
                    border-color: #808080;
                    padding-top: 6px;
                    padding-bottom:
                    6px;
                    padding-left:
                    10px;
                    padding-right: 10px;
                    }
                    pre {
                    display:inline;
                    }
                </style>
            </head>
            <body>
                <xsl:apply-templates/>
            </body>
        </html>
    </xsl:template>

    <xsl:template match="properties">
        <table>
            <td>
                <b>Name</b>
            </td>
            <td>
                <b>Type</b>
            </td>
            <td>
                <b>Writable</b>
            </td>
            <td>
                <b>Description</b>
            </td>
            <xsl:apply-templates/>
        </table>
    </xsl:template>

    <xsl:template match="property">
        <tr>
            <xsl:choose>
                <xsl:when test="@api != 'true'">
                    <xsl:attribute name="class">ghost</xsl:attribute>
                </xsl:when>
            </xsl:choose>
            <td>
                <xsl:value-of select="@name"/>
            </td>
            <xsl:apply-templates select="type"/>
            <td>
                <xsl:variable name="writable" select="@writable"/>
                <xsl:choose>
                    <xsl:when test="$writable = 'true'">
                        <span style="color:#00d000">
                            <b>Yes</b>
                        </span>
                    </xsl:when>
                    <xsl:otherwise>
                        <span>No</span>
                    </xsl:otherwise>
                </xsl:choose>
            </td>
            <xsl:apply-templates select="description"/>
        </tr>
    </xsl:template>

    <xsl:template match="type">
        <td>
            <xsl:copy-of select="node()"/>
        </td>
    </xsl:template>

    <xsl:template match="description">
        <td>
            <xsl:copy-of select="node()"/>
        </td>
    </xsl:template>

</xsl:stylesheet>
