package com.pdftools.pdf2imgapi;
import com.pdftools.NativeLibrary;

public class Ocg extends NativeLibrary
{
	/**
	 * Return the name of the OCG.
	 * 
	 * @return the name of the OCG.
	 */
    public native String getName();

	/**
	 * Get whether this is a label or an optional content group.
	 * <p>
	 * Labels are used to label groups of OCGs in the hierarchy. Setting their
	 * visibility has no effect.
	 * 
	 * @return the property.
	 */
    public native boolean getLabel();

	/**
	 * Get whether or not the optional content group is visible. Content is
	 * extracted from visible groups only.
	 * 
	 * @see #setVisible
	 * @return the visibility.
	 */
    public native boolean getVisible();

	/**
	 * Set whether or not the optional content group is visible. Content is
	 * extracted from visible groups only.
	 * <p>
	 * This property controls the extraction of content objects. The default
	 * value is the one configured in the PDF document.</br>
	 * Note that though invisible paths generate no marks on the page, they
	 * still have an effect on the graphics state. For example their effect on
	 * the current drawing position and the clipping region does not change.
	 * Therefore, all paths are "active" and extracted regardless of their
	 * visibility. Invisible paths just use the end path operator "n", instead
	 * of a filling or stroking operator.
	 * <p>
	 * Example 1:</br>
	 * id, OCGs, Level; Hierarchy</br>
	 * 0, OCG A, 0; - OCG A</br>
	 * 1, OCG B, 0; - OCG B</br>
	 * 2, OCG B1, 1; -- OCG B1</br>
	 * 3, OCG B2, 1; -- OCG B2</br>
	 * 4, OCG C, -1; hidden: OCG C</br>
	 * <p>
	 * Example 2:</br>
	 * id, OCGs/Labels, Level; Hierarchy</br>
	 * 0, OCG A, 0; - OCG A</br>
	 * 1, Label B, 1; - Label B</br>
	 * 2, OCG B1, 1; -- OCG B1</br>
	 * 3, OCG B2, 1; -- OCG B2</br>
	 * 4, Label C, 1; - Label C</br>
	 * 5, OCG C1, 1; -- OCG C1</br>
	 * 6, OCG D, 0; - OCG D
	 */
    public native void setVisible(boolean isVisible);

	/**
	 * The nesting level of the optional content group.
	 * <p>
	 * In user interfaces OCGs can be shown in a tree. The property Level
	 * indicates the hierarchy level of the OCG in that tree.</br>
	 * OCG with Level 0 is a top level OCG.</br>
	 * Level -1 means that the OCG is not part of the hierarchy, it should not
	 * be presented to the user.</br>
	 * Parent elements in the OCG hierarchy can be labels or OCGs. If the level
	 * of a label b is higher than its predecessor a, b is the parent element of
	 * the following objects of the same level as b. If the level of an OCG b is
	 * higher than its predecessor OCG a, a is the parent of the following
	 * objects of the same level as b.</br>
	 * Note that the hierarchy reflects actual nesting of OCGs in the content.
	 * Setting the visibility of an OCG to True only has an effect if the
	 * visibilities of all its parents are set to True.
	 * 
	 * @return the level.
	 */
    public native int getLevel();

    protected long _handle;
}
