/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.visuslaf.support;

import java.beans.PropertyEditorSupport;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class CezanneStylePropertyEditor
extends PropertyEditorSupport {
    protected String[] styleNames;

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        String value = null;
        if (text != null && text.length() > 0) {
            value = text;
        }
        this.setValue(value);
    }

    @Override
    public String getAsText() {
        Object value = this.getValue();
        if (value == null) {
            return "";
        }
        return String.valueOf(value);
    }

    @Override
    public String[] getTags() {
        if (this.styleNames == null) {
            this.styleNames = this.createStyleNames();
        }
        return this.styleNames;
    }

    protected String[] createStyleNames() {
        HashSet<String> names = new HashSet<String>();
        HashSet checkedHolders = new HashSet();
        for (Class<?> styleNameHolder : this.getStyleNameHolders()) {
            this.addStyleNames(names, styleNameHolder, checkedHolders);
        }
        ArrayList nameList = new ArrayList(names);
        Collections.sort(nameList);
        nameList.add(0, null);
        return nameList.toArray(new String[nameList.size()]);
    }

    protected abstract Class<?>[] getStyleNameHolders();

    protected void addStyleNames(Set<String> names, Class<?> holder, Set<Class<?>> checkedHolders) {
        if (holder == null) {
            return;
        }
        if (checkedHolders.contains(holder)) {
            return;
        }
        for (Field field : holder.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || field.getType() != String.class) continue;
            try {
                field.setAccessible(true);
                String name = (String)field.get(null);
                if (name == null || !name.startsWith(":") || name.endsWith(":")) continue;
                names.add(name);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.addStyleNames(names, holder.getSuperclass(), checkedHolders);
        for (AnnotatedElement annotatedElement : holder.getInterfaces()) {
            this.addStyleNames(names, (Class<?>)annotatedElement, checkedHolders);
        }
    }
}

