/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.visuslaf.support;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.ColorUIResource;

public class CezanneLookAndFeelControl {
    public static final int SCALE_TYPE_COMMON = 0;
    public static final int SCALE_TYPE_FONT_SIZE = 1;
    public static final int SCALE_TYPE_DIVIDER_SIZE = 2;
    public static final int SCALE_TYPE_ROW_HEIGHT = 3;
    public static final int VALIDATION_STATE_NONE = 0;
    public static final int VALIDATION_STATE_INVALID = 1;
    public static final String TEXTFIELD_DELETE_ALL_ACTION_IGNORE_EDITABLE_KEY = "Cezanne.IgnoreEditable";
    public static final String BORDER_ASSIMILATION_OFF = "Off";
    public static final String BORDER_ASSIMILATION_MEDIUM = "Medium";
    public static final String BORDER_ASSIMILATION_AGGRESSIVE = "Aggressive";
    protected static final String TAG_PROPERTYNAME = "Cezanne.Tag";
    protected static final String UI_DEFAULTS_KEY_REMOTE_CEZANNE_METHOD_INVOCATION = "Cezanne.RemoteMethodInvocation";
    protected static final String UI_DEFAULTS_KEY_PRODUCT_RUNTIME_SIGNATURE = "Cezanne.productRuntimeSignature";
    protected static final String UI_DEFAULTS_KEY_SCALE = "Cezanne.Scaling";
    protected static final String UIDEFAULTSKEY_TEXT_HIGHTLIGHT_PATTERN = "Cezanne.TextHighlightPattern";
    protected static final String UIDEFAULTSKEY_TEXT_HIGHTLIGHT_COLOR = "Cezanne.TextHighlightColor";
    protected static final String CLIENTPROPERTYNAME_TRANSITIONS_ENABLED = "Cezanne.TransitionsEnabled";
    protected static final String CLIENTPROPERTYNAME_RENDER_COMPONENT_MARK = "Cezanne.RenderComponentMark";
    protected static final String CLIENTPROPERTYNAME_SLIDER_VALUE_DISPLAY_CONFIG = "Cezanne.SliderValueDisplayConfig";
    protected static final String CLIENTPROPERTYNAME_BORDER_ASSIMILATION = "Cezanne.BorderAssimilation";
    protected static final String REMOTE_METHOD_NAME_REFRESH_CONTEXT = "refreshContext";
    protected static final String REMOTE_METHOD_NAME_UPDATE_STYLE = "updateStyle";
    protected static final String REMOTE_METHOD_NAME_LOAD_THEME_DESIGN = "loadThemeDesign";
    protected static final String REMOTE_METHOD_NAME_REMOVE_THEME_DESIGN = "removeThemeDesign";
    protected static final String REMOTE_METHOD_GET_CUMULATED_SCALE = "getCumulatedScale";
    protected static final String REMOTE_METHOD_GET_LOCAL_SCALE = "getLocalScale";
    protected static final String REMOTE_METHOD_SET_LOCAL_SCALE = "setLocalScale";
    protected static final String REMOTE_METHOD_SET_GLOBAL_SCALE = "setGlobalScale";
    protected static final String REMOTE_METHOD_GET_LEADING_TITLEPANE_CUSTOMIZATION_CONTAINER = "getLeadingTitlePaneCustomizationContainer";
    protected static final String REMOTE_METHOD_GET_TRAILING_TITLEPANE_CUSTOMIZATION_CONTAINER = "getTrailingTitlePaneCustomizationContainer";
    protected static final String REMOTE_METHOD_OVERRIDE_COMPONENT_ATTRIBUTE = "overrideComponentAttribute";
    protected static final String REMOTE_METHOD_REVERT_OVERRIDDEN_COMPONENT_ATTRIBUTE = "revertOverriddenComponentAttribute";
    protected static final String REMOTE_METHOD_SET_VALIDATION_STATE = "setValidationState";
    protected static final String REMOTE_METHOD_OVERRIDE_DEFAULT_STYLE = "overrideDefaultStyle";
    protected static final String REMOTE_METHOD_GET_GLOBAL_SCALE = "getGlobalScale";
    protected static final String REMOTE_METHOD_SET_NETBEANS_TABBEDCONTAINER_TAB_CLOSABLE = "setNetBeansTabbedContainerTabClosable";
    protected static final String REMOTE_METHOD_IS_NETBEANS_TABBEDCONTAINER_TAB_CLOSABLE = "isNetBeansTabbedContainerTabClosable";
    protected static final String REMOTE_METHOD_GET_LEADING_TABBEDPANE_CUSTOMIZATION_CONTAINER = "getLeadingTabbedPaneCustomizationContainer";
    protected static final String REMOTE_METHOD_GET_TRAILING_TABBEDPANE_CUSTOMIZATION_CONTAINER = "getTrailingTabbedPaneCustomizationContainer";
    protected static final String REMOTE_METHOD_GET_LEADING_TABBEDCONTAINER_CUSTOMIZATION_CONTAINER = "getLeadingTabbedContainerCustomizationContainer";
    protected static final String REMOTE_METHOD_GET_TRAILING_TABBEDCONTAINER_CUSTOMIZATION_CONTAINER = "getTrailingTabbedContainerCustomizationContainer";
    protected static final String REMOTE_METHOD_STYLE_TABLE_CELL_RENDER_COMPONENT = "styleTableCellRenderComponent";
    protected static final String REMOTE_METHOD_SET_COMPONENT_ACTION_BUTTON = "setComponentActionButton";
    protected static final String REMOTE_METHOD_GET_COMPONENT_ACTION_BUTTON_ACTION = "getComponentActionButtonAction";
    protected static final String REMOTE_METHOD_SET_TEXT_FIELD_HINT = "setTextFieldHint";
    protected static final String REMOTE_METHOD_GET_TEXT_FIELD_HINT = "getTextFieldHint";
    protected static final String REMOTE_METHOD_SET_EXTENDED_FONT_STYLE = "setExtendedFontStyle";
    protected static final String REMOTE_METHOD_IS_LINEWRAP_ENABLED = "isLinewrapEnabled";
    protected static final String REMOTE_METHOD_SET_LINEWRAP_ENABLED = "setLinewrapEnabled";
    protected static final String REMOTE_METHOD_RESET_BACKGROUND_COLOR = "resetBackgroundColor";
    protected static final String REMOTE_METHOD_ADD_RESOURCE_BUNDLE = "addResourceBundle";
    protected static final String REMOTE_METHOD_REMOVE_RESOURCE_BUNDLE = "removeResourceBundle";
    protected static final ColorUIResource DUMMY_COLOR_UI_RESOURCE = new ColorUIResource(0);

    public void setStyle(JComponent component, String style) {
        if (component == null) {
            return;
        }
        component.putClientProperty(TAG_PROPERTYNAME, style);
        if (component.getClientProperty(CLIENTPROPERTYNAME_RENDER_COMPONENT_MARK) != null) {
            this.invokeRemoteCezanneMethod(REMOTE_METHOD_NAME_UPDATE_STYLE, component);
        }
    }

    public String getStyle(JComponent component) {
        if (component == null) {
            return null;
        }
        Object style = component.getClientProperty(TAG_PROPERTYNAME);
        if (!(style instanceof String)) {
            return null;
        }
        return (String)style;
    }

    public void removeStyle(JComponent component) {
        if (component == null) {
            return;
        }
        component.putClientProperty(TAG_PROPERTYNAME, null);
    }

    public void removeStyle(JComponent component, String style) {
        if (component == null || style == null) {
            return;
        }
        String appliedStyle = this.getStyle(component);
        if (style.equals(appliedStyle)) {
            this.removeStyle(component);
        }
    }

    protected Object invokeRemoteCezanneMethod(String name) {
        return this.invokeRemoteCezanneMethod(name, new Object[0]);
    }

    protected Object invokeRemoteCezanneMethod(String name, Object ... arguments) {
        Object[] command = new Object[]{name, arguments, null};
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        uiDefaults.put(UI_DEFAULTS_KEY_REMOTE_CEZANNE_METHOD_INVOCATION, command);
        uiDefaults.put(UI_DEFAULTS_KEY_REMOTE_CEZANNE_METHOD_INVOCATION, (Object)null);
        Object result = command[2];
        return result;
    }

    public String getLookAndFeelClassName() {
        return null;
    }

    public boolean isLookAndFeelActive() {
        return this.isLookAndFeelActive(this.getLookAndFeelClassName());
    }

    protected boolean isLookAndFeelActive(String lookAndFeelName) {
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel == null) {
            return false;
        }
        return lookAndFeel.getClass().getName().equals(lookAndFeelName);
    }

    public void switchLookAndFeel(String lookAndFeelName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lookAndFeelName);
        this.updateUiAfterLookAndFeelSwitch();
    }

    public void switchLookAndFeel(LookAndFeel lookAndFeel) throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(lookAndFeel);
        this.updateUiAfterLookAndFeelSwitch();
    }

    public void updateUiAfterLookAndFeelSwitch() {
        this.updateAllUIs();
    }

    public void updateAllUIs() {
        try {
            Class<?> cezanneUtilClass = Class.forName("de.pixopia.cezanne.util.CezanneUtil");
            Method updateMethod = cezanneUtilClass.getMethod("updateAllUIs", new Class[0]);
            updateMethod.invoke(null, new Object[0]);
            return;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        for (Window window : Window.getWindows()) {
            if ("org.swingexplorer.FRMSwingExplorer".equals(window.getClass().getName())) continue;
            SwingUtilities.updateComponentTreeUI(window);
        }
    }

    public void updateComponentTreeUI(Component component) {
        try {
            Class<?> cezanneUtilClass = Class.forName("de.pixopia.cezanne.util.CezanneUtil");
            Method updateMethod = cezanneUtilClass.getMethod("updateComponentTreeRootUi", Component.class);
            updateMethod.invoke(null, component);
            return;
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SwingUtilities.updateComponentTreeUI(component);
    }

    public boolean isTransitionsEnabled(JComponent component) {
        if (component == null) {
            return false;
        }
        return !Boolean.FALSE.equals(component.getClientProperty(CLIENTPROPERTYNAME_TRANSITIONS_ENABLED));
    }

    public void setTransitionsEnabled(JComponent component, boolean enabled) {
        if (component == null) {
            return;
        }
        if (enabled == this.isTransitionsEnabled(component)) {
            return;
        }
        if (!enabled) {
            component.putClientProperty(CLIENTPROPERTYNAME_TRANSITIONS_ENABLED, Boolean.FALSE);
        }
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_NAME_REFRESH_CONTEXT, component);
        if (enabled) {
            component.putClientProperty(CLIENTPROPERTYNAME_TRANSITIONS_ENABLED, null);
        }
    }

    public String getProductRuntimeSignature() {
        return UIManager.getLookAndFeelDefaults().getString(UI_DEFAULTS_KEY_PRODUCT_RUNTIME_SIGNATURE);
    }

    public void loadThemeDesign(URL themeDesignURL) throws IOException {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_NAME_LOAD_THEME_DESIGN, themeDesignURL);
    }

    public void removeThemeDesign() {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_NAME_REMOVE_THEME_DESIGN);
    }

    @Deprecated
    public float getEffectiveScale(JComponent component) {
        return this.getCumulatedScale(component, 0);
    }

    @Deprecated
    public float getLocalScale(JComponent component) {
        return this.getLocalScale(component, 0, true);
    }

    @Deprecated
    public void setLocalScale(JComponent component, float scale) {
        this.setLocalScale(component, scale, 0, true);
    }

    public float getCumulatedScale(JComponent component, int type) {
        Object result = this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_CUMULATED_SCALE, component, type);
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        return 1.0f;
    }

    public float getLocalScale(JComponent component, int type, boolean inheriting) {
        Object result = this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_LOCAL_SCALE, component, type, inheriting);
        if (result instanceof Number) {
            return ((Number)result).floatValue();
        }
        return 1.0f;
    }

    public void setLocalScale(JComponent component, float localScale, int type, boolean inheriting) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_LOCAL_SCALE, component, Float.valueOf(localScale), type, inheriting);
    }

    @Deprecated
    public void setGlobalScale(float scale) {
        UIManager.getDefaults().put(UI_DEFAULTS_KEY_SCALE, Float.valueOf(scale).toString());
    }

    public void setGlobalScale(float scale, int type) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_GLOBAL_SCALE, Float.valueOf(scale), type);
    }

    @Deprecated
    public float getGlobalScale() {
        Object value = this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_GLOBAL_SCALE);
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        return 1.0f;
    }

    public float getGlobalScale(int type) {
        float globalScale = 1.0f;
        Object result = this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_GLOBAL_SCALE, type);
        if (result instanceof Float) {
            globalScale = ((Float)result).floatValue();
        }
        return globalScale;
    }

    public void configureSliderValueDisplay(JSlider slider, NumberFormat format, String displayPrototypeValue) {
        if (slider == null) {
            throw new IllegalArgumentException("Slider must not be null.");
        }
        slider.putClientProperty(CLIENTPROPERTYNAME_SLIDER_VALUE_DISPLAY_CONFIG, new Object[]{format, displayPrototypeValue});
    }

    public String getTextHighlightPattern() {
        return UIManager.getLookAndFeelDefaults().getString(UIDEFAULTSKEY_TEXT_HIGHTLIGHT_PATTERN);
    }

    public void setTextHighlightPattern(String pattern) {
        UIManager.getLookAndFeelDefaults().put(UIDEFAULTSKEY_TEXT_HIGHTLIGHT_PATTERN, pattern);
    }

    public Color getTextHighlightColor() {
        return UIManager.getLookAndFeelDefaults().getColor(UIDEFAULTSKEY_TEXT_HIGHTLIGHT_COLOR);
    }

    public void setTextHighlightColor(Color color) {
        UIManager.getLookAndFeelDefaults().put(UIDEFAULTSKEY_TEXT_HIGHTLIGHT_COLOR, color);
    }

    public void overrideDefaultStyle(String componentTypeName, String overridingStyleName) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_OVERRIDE_DEFAULT_STYLE, componentTypeName, overridingStyleName);
    }

    public JComponent getLeadingTitlePaneCustomizationContainer(JRootPane rootPane) {
        return (JComponent)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_LEADING_TITLEPANE_CUSTOMIZATION_CONTAINER, rootPane);
    }

    public JComponent getTrailingTitlePaneCustomizationContainer(JRootPane rootPane) {
        return (JComponent)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_TRAILING_TITLEPANE_CUSTOMIZATION_CONTAINER, rootPane);
    }

    public void overrideFontStyle(JComponent component, int style) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_OVERRIDE_COMPONENT_ATTRIBUTE, component, "FontStyle", style);
    }

    public void revertOverriddenFontStyle(JComponent component) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_REVERT_OVERRIDDEN_COMPONENT_ATTRIBUTE, component, "FontStyle");
    }

    public void setValidationState(JComponent component, int state) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_VALIDATION_STATE, component, state);
    }

    public void setNetBeansTabbedContainerTabClosable(JComponent tabbedContainer, int tabIndex, boolean closable) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_NETBEANS_TABBEDCONTAINER_TAB_CLOSABLE, tabbedContainer, tabIndex, closable);
    }

    public boolean isNetBeansTabbedContainerTabClosable(JComponent tabbedContainer, int tabIndex) {
        return Boolean.TRUE.equals(this.invokeRemoteCezanneMethod(REMOTE_METHOD_IS_NETBEANS_TABBEDCONTAINER_TAB_CLOSABLE, tabbedContainer, tabIndex));
    }

    public JComponent getLeadingTabbedPaneCustomizationContainer(JTabbedPane tabbedPane) {
        return (JComponent)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_LEADING_TABBEDPANE_CUSTOMIZATION_CONTAINER, tabbedPane);
    }

    public JComponent getTrailingTabbedPaneCustomizationContainer(JTabbedPane tabbedPane) {
        return (JComponent)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_TRAILING_TABBEDPANE_CUSTOMIZATION_CONTAINER, tabbedPane);
    }

    public JComponent getLeadingTabbedContainerCustomizationContainer(JComponent tabbedContainer) {
        return (JComponent)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_LEADING_TABBEDCONTAINER_CUSTOMIZATION_CONTAINER, tabbedContainer);
    }

    public JComponent getTrailingTabbedContainerCustomizationContainer(JComponent tabbedContainer) {
        return (JComponent)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_TRAILING_TABBEDCONTAINER_CUSTOMIZATION_CONTAINER, tabbedContainer);
    }

    public void styleTableCellRenderComponent(Component renderComponent, JTable table, Object value, boolean selected, boolean focused, int rowIndex, int columnIndex) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_STYLE_TABLE_CELL_RENDER_COMPONENT, renderComponent, table, value, selected, focused, rowIndex, columnIndex);
    }

    public void setComponentActionButton(JComponent component, Object type, boolean supported, Action customAction) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_COMPONENT_ACTION_BUTTON, component, type, supported, customAction);
    }

    public Action getComponentActionButtonAction(JComponent component, Object type) {
        return (Action)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_COMPONENT_ACTION_BUTTON_ACTION, component, type);
    }

    public void setTextFieldHint(JTextField textField, String hint) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_TEXT_FIELD_HINT, textField, hint);
    }

    public String getTextFieldHint(JTextField textField) {
        return (String)this.invokeRemoteCezanneMethod(REMOTE_METHOD_GET_TEXT_FIELD_HINT, textField);
    }

    public void setExtendedFontStyle(JComponent component, Boolean underline) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_EXTENDED_FONT_STYLE, component, underline);
    }

    public boolean isLinewrapEnabled(JComponent component) {
        return Boolean.TRUE.equals(this.invokeRemoteCezanneMethod(REMOTE_METHOD_IS_LINEWRAP_ENABLED, component));
    }

    public void setLinewrapEnabled(JComponent component, boolean linewrapEnabled) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_SET_LINEWRAP_ENABLED, component, linewrapEnabled);
    }

    public boolean resetBackgroundColor(JComponent component) {
        return (Boolean)this.invokeRemoteCezanneMethod(REMOTE_METHOD_RESET_BACKGROUND_COLOR, component);
    }

    public void addResourceBundle(String baseName, ClassLoader loader) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_ADD_RESOURCE_BUNDLE, baseName, loader);
    }

    public void removeResourceBundle(String baseName) {
        this.invokeRemoteCezanneMethod(REMOTE_METHOD_REMOVE_RESOURCE_BUNDLE, baseName);
    }

    public void setBorderAssimilation(JComponent component, String assimilation) {
        if (component == null) {
            return;
        }
        component.putClientProperty(CLIENTPROPERTYNAME_BORDER_ASSIMILATION, assimilation);
    }
}

