/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.cezanne.image;

import de.pixopia.cezanne.CezanneContext;
import de.pixopia.cezanne.CezanneLookAndFeel;
import de.pixopia.cezanne.H;
import de.pixopia.cezanne.color.CezanneColorRegular;
import de.pixopia.cezanne.image.CezanneImageFilter;
import de.pixopia.cezanne.image.ImageContentsLostException;
import de.pixopia.cezanne.image.ImageType;
import de.pixopia.cezanne.image.ScaledImage;
import de.pixopia.cezanne.image.c;
import de.pixopia.cezanne.image.d;
import de.pixopia.cezanne.image.filter.CIFColorReplacement;
import de.pixopia.cezanne.jvm.CezanneJVMInternals;
import de.pixopia.cezanne.platform.PlatformUtil;
import de.pixopia.cezanne.swing.properties.CezannePropertiesComponent;
import de.pixopia.cezanne.util.CezanneJavaUtil;
import de.pixopia.cezanne.util.CezanneUtil;
import de.pixopia.cezanne.util.log.CezanneLogger;
import de.pixopia.util.integrated.CodeGroup;
import de.pixopia.util.integrated.PrivateAPI;
import de.pixopia.util.integrated.ReflectionTarget;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImageProducer;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@PrivateAPI
@CodeGroup(value={"cezanne-core"})
public class CezanneImageUtil {
    @ReflectionTarget
    public static final int SCALE_DEFAULT = 1;
    @ReflectionTarget
    public static final int SCALE_FAST = 2;
    @ReflectionTarget
    public static final int SCALE_SMOOTH = 4;
    @ReflectionTarget
    public static final int SCALE_REPLICATE = 8;
    @ReflectionTarget
    public static final int SCALE_AREA_AVERAGING = 16;
    @PrivateAPI
    @ReflectionTarget
    public static final int SCALE_BILINEAR = 100;
    @ReflectionTarget
    public static final int SCALE_BICUBIC = 101;
    @ReflectionTarget
    public static final int SCALE_BILINEAR5 = 102;
    @ReflectionTarget
    public static final int SCALE_BICUBIC5 = 103;
    @ReflectionTarget
    public static final int SCALE_BILINEAR_INCREMENTAL = 104;
    @ReflectionTarget
    public static final int SCALE_BICUBIC_INCREMENTAL = 105;
    @ReflectionTarget
    public static final int SCALE_WITH_PADDING = 106;
    @ReflectionTarget
    public static final int SCALE_RASTER_REPLICATION = 107;
    protected static final CezanneImageUtil a;
    protected static final CezanneLogger b;
    protected static final Hashtable<String, Object> c;
    protected MediaTracker d;
    protected int e;
    private static final String[] f;

    @PrivateAPI
    public static CezanneImageUtil get(CezanneContext<?> context) {
        CezanneLookAndFeel cezanneLookAndFeel;
        CezanneImageUtil cezanneImageUtil;
        CezanneImageUtil cezanneImageUtil2 = cezanneImageUtil = context == null ? null : context.getImageUtil();
        if (cezanneImageUtil == null && (cezanneLookAndFeel = CezanneUtil.getCezanneLookAndFeel(null)) != null) {
            cezanneImageUtil = cezanneLookAndFeel.getImageUtil();
        }
        if (cezanneImageUtil == null) {
            cezanneImageUtil = a;
        }
        return cezanneImageUtil;
    }

    protected float a(int n2, int n3, int n4, int n5) {
        float f2 = (float)n4 / (float)n2;
        f2 = Math.min(f2, (float)n5 / (float)n3);
        return f2;
    }

    @PrivateAPI
    public Image scale(Image image, float scale, int quality, Insets scalingHint, ImageType resultType, GraphicsConfiguration gc) throws ImageContentsLostException {
        if (image == null) {
            return null;
        }
        int n2 = Math.round((float)image.getWidth(null) * scale);
        int n3 = Math.round((float)image.getHeight(null) * scale);
        return this.a(image, scale, n2, n3, quality, scalingHint, resultType, gc);
    }

    @PrivateAPI
    public Image stretch(Image image, int width, int height, int quality, Insets scalingHint, ImageType resultType, GraphicsConfiguration gc) throws ImageContentsLostException {
        if (image == null) {
            return null;
        }
        return this.a(image, 0.0f, width, height, quality, scalingHint, resultType, gc);
    }

    protected Image a(Image image, float f2, int n2, int n3, int n4, Insets insets, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        Image image2;
        block34: {
            int n5;
            int n6;
            block33: {
                if (image == null) {
                    return null;
                }
                image2 = null;
                if (f2 == 1.0f) {
                    image2 = image;
                } else {
                    block32: {
                        n6 = image.getWidth(null);
                        n5 = image.getHeight(null);
                        if (n2 > 0 && n3 > 0) break block32;
                        return null;
                    }
                    if (n2 != n6 || n3 != n5) break block33;
                    image2 = image;
                }
                break block34;
            }
            switch (n4) {
                case 100: 
                case 101: {
                    image2 = this.a(n2, n3, ImageType.getRecommendedWritableOutputType(this.b(image), imageType), graphicsConfiguration);
                    Graphics2D graphics2D = (Graphics2D)image2.getGraphics();
                    Object object = n4 == 100 ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                    Object object2 = object;
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
                    graphics2D.drawImage(image, 0, 0, n2, n3, 0, 0, n6, n5, null);
                    graphics2D.dispose();
                    break;
                }
                case 102: 
                case 103: {
                    image2 = this.a(n2, n3, ImageType.getRecommendedWritableOutputType(this.b(image), imageType), graphicsConfiguration);
                    Graphics2D graphics2D = (Graphics2D)image2.getGraphics();
                    Object object = n4 == 102 ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : RenderingHints.VALUE_INTERPOLATION_BICUBIC;
                    Object object3 = object;
                    graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object3);
                    graphics2D.drawImage(image, 0, 0, n2, n3, 0, 0, n6, n5, null);
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
                    for (int i2 = -1; i2 <= 1; i2 += 2) {
                        for (int i3 = -1; i3 <= 1; i3 += 2) {
                            graphics2D.drawImage(image, i3, i2, n2 + i3, n3 + i2, 0, 0, n6, n5, null);
                        }
                        continue;
                    }
                    graphics2D.dispose();
                    break;
                }
                case 104: 
                case 105: {
                    float f3 = Math.min((float)n6 / (float)n2, (float)n5 / (float)n3);
                    float f4 = 1.5f;
                    image2 = image;
                    ImageType imageType2 = ImageType.getRecommendedWritableOutputType(this.b(image), imageType);
                    float f5 = f2;
                    if (f3 > f4) {
                        f5 = f4;
                        float f6 = f2 / f5;
                        image2 = this.scale(image2, f6, n4, insets, imageType2, graphicsConfiguration);
                    }
                    int n7 = n4 == 104 ? 100 : 101;
                    int n8 = n7;
                    image2 = this.scale(image2, f5, n8, insets, imageType2, graphicsConfiguration);
                    break;
                }
                case 106: {
                    image2 = this.a(n2, n3, ImageType.getRecommendedWritableOutputType(this.b(image), imageType), graphicsConfiguration);
                    Graphics2D graphics2D = (Graphics2D)image2.getGraphics();
                    graphics2D.drawImage(image, (n2 - n6) / 2, (n3 - n5) / 2, null);
                    graphics2D.dispose();
                    break;
                }
                case 107: {
                    if (f2 == 0.0f) {
                        throw new IllegalArgumentException(f[14]);
                    }
                    image2 = new d().a(this, image, f2, insets, imageType, graphicsConfiguration);
                    break;
                }
                default: {
                    image2 = image.getScaledInstance(n2, n3, n4);
                    this.a(image2);
                }
            }
        }
        image2 = this.getImage(image2, imageType, graphicsConfiguration);
        return image2;
    }

    public Icon a(Icon icon, int n2, int n3, int n4) throws ImageContentsLostException {
        if (icon == null) {
            return null;
        }
        return this.a(icon, this.a(icon.getIconWidth(), icon.getIconHeight(), n2, n3), n4);
    }

    public Icon a(Icon icon, float f2, int n2) throws ImageContentsLostException {
        if (icon == null) {
            return null;
        }
        Image image = this.scale(this.getImage(icon), f2, n2, null, null, null);
        if (image == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(image);
        return imageIcon;
    }

    @PrivateAPI
    public Image getImage(Icon icon) {
        if (icon == null) {
            return null;
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        Image image = this.a(icon.getIconWidth(), icon.getIconHeight(), ImageType.BUFFERED_INT_ARGB, null);
        Graphics graphics = image.getGraphics();
        icon.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return image;
    }

    public Image a(int n2, int n3, ImageType imageType, GraphicsConfiguration graphicsConfiguration) {
        return this.a(n2, n3, imageType, graphicsConfiguration, 3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image a(int n2, int n3, ImageType imageType, GraphicsConfiguration graphicsConfiguration, int n4) {
        switch (imageType) {
            case BUFFERED: 
            case BUFFERED_COMPATIBLE: {
                return graphicsConfiguration.createCompatibleImage(n2, n3, n4);
            }
            case BUFFERED_INT_ARGB: {
                return this.a(n2, n3, new int[n2 * n3], imageType, graphicsConfiguration);
            }
            case ACCELERATED: 
            case VOLATILE: {
                VolatileImage volatileImage = graphicsConfiguration.createCompatibleVolatileImage(n2, n3, n4);
                if (volatileImage != null && volatileImage.validate(graphicsConfiguration) == 2) {
                    volatileImage.flush();
                    return null;
                }
                if (volatileImage == null) return volatileImage;
                this.d(volatileImage);
                return volatileImage;
            }
        }
        throw new IllegalArgumentException(f[25] + (Object)((Object)imageType) + ".");
    }

    public Image a(int n2, int n3, int[] nArray, ImageType imageType, GraphicsConfiguration graphicsConfiguration) {
        if (imageType == null) {
            imageType = ImageType.BUFFERED_INT_ARGB;
        }
        switch (imageType) {
            case BUFFERED: 
            case BUFFERED_COMPATIBLE: {
                BufferedImage bufferedImage = (BufferedImage)this.a(n2, n3, ImageType.BUFFERED_COMPATIBLE, graphicsConfiguration);
                bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
                return bufferedImage;
            }
            case BUFFERED_INT_ARGB: {
                ColorModel colorModel = ColorModel.getRGBdefault();
                int[] nArray2 = new int[]{0xFF0000, 65280, 255, -16777216};
                DataBufferInt dataBufferInt = new DataBufferInt(nArray, n2 * n3);
                WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n2, n3, n2, nArray2, null);
                BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, false, c);
                return bufferedImage;
            }
            case TOOLKIT: 
            case TOOLKIT_SOURCE_MEMORY: {
                MemoryImageSource memoryImageSource = new MemoryImageSource(n2, n3, nArray, 0, n2);
                Image image = this.a(memoryImageSource);
                return image;
            }
            case ACCELERATED: 
            case VOLATILE: {
                Image image = this.a(n2, n3, nArray, ImageType.BUFFERED_INT_ARGB, graphicsConfiguration);
                image = this.getImageSafe(image, ImageType.VOLATILE, graphicsConfiguration);
                return image;
            }
        }
        throw new IllegalArgumentException(f[18] + (Object)((Object)imageType) + ".");
    }

    @PrivateAPI
    public Image createImage(Image image, ImageType requiredType, GraphicsConfiguration gc) throws ImageContentsLostException {
        return this.a(image, requiredType, gc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(Image image) {
        if (CezanneJavaUtil.a(image)) {
            int n2;
            MediaTracker mediaTracker;
            Object object = this;
            synchronized (object) {
                if (this.d == null) {
                    this.d = new MediaTracker(new Component(){
                        private static final long serialVersionUID = 1L;
                    });
                }
                mediaTracker = this.d;
                n2 = this.e++;
            }
            object = mediaTracker;
            synchronized (object) {
                mediaTracker.addImage(image, n2);
                try {
                    mediaTracker.waitForID(n2, 0L);
                }
                catch (InterruptedException interruptedException) {
                    b.warn(this, f[17], new Object[0]);
                }
                mediaTracker.removeImage(image, n2);
            }
        }
    }

    @PrivateAPI
    public Image loadImage(URL url, ImageType requiredType, GraphicsConfiguration gc) {
        Image image;
        block21: {
            block22: {
                block18: {
                    block20: {
                        block23: {
                            block19: {
                                if (url == null) {
                                    return null;
                                }
                                image = null;
                                c c2 = new c(url);
                                try {
                                    image = c2.a(requiredType, gc, this);
                                }
                                catch (c.d d2) {
                                }
                                catch (Throwable throwable) {
                                    b.warn(this, f[6] + url + f[8], throwable);
                                }
                                if (image != null) break block18;
                                if (!f[7].equals(url.getProtocol())) break block19;
                                String string = url.getPath();
                                if (PlatformUtil.a().l()) {
                                    string = string.substring(1);
                                }
                                image = Toolkit.getDefaultToolkit().createImage(string);
                                break block23;
                            }
                            image = Toolkit.getDefaultToolkit().createImage(url);
                        }
                        this.a(image);
                        if (image.getWidth(null) > 0 && image.getHeight(null) > 0) break block20;
                        image = null;
                    }
                    image = this.getImageSafe(image, requiredType, gc);
                }
                if (image == null) break block21;
                if (image.getWidth(null) <= 0) break block22;
                if (image.getHeight(null) > 0) break block21;
            }
            image.flush();
            image = null;
        }
        if (image == null) {
            b.warn(this, f[4] + url + f[5], new Object[0]);
        }
        return image;
    }

    public Image a(ImageProducer imageProducer) {
        Image image = Toolkit.getDefaultToolkit().createImage(imageProducer);
        this.a(image);
        return image;
    }

    public ImageType b(Image image) {
        block29: {
            block30: {
                if (image == null) {
                    return null;
                }
                if (CezanneJavaUtil.a(image)) {
                    block28: {
                        block27: {
                            ImageProducer imageProducer;
                            block26: {
                                block25: {
                                    imageProducer = image.getSource();
                                    if (imageProducer instanceof c || CezanneJavaUtil.a(imageProducer)) break block25;
                                    if (!CezanneJavaUtil.b(imageProducer)) break block26;
                                }
                                return ImageType.TOOLKIT_SOURCE_URL;
                            }
                            if (imageProducer instanceof MemoryImageSource || imageProducer instanceof RenderableImageProducer) break block27;
                            if (CezanneJavaUtil.c(imageProducer)) break block27;
                            if (!CezanneJavaUtil.d(imageProducer)) break block28;
                        }
                        return ImageType.TOOLKIT_SOURCE_MEMORY;
                    }
                    return ImageType.TOOLKIT;
                }
                if (!(image instanceof BufferedImage)) break block29;
                if (image.getProperty(f[20], null) != f[21]) break block30;
                return ImageType.BUFFERED_INT_ARGB;
            }
            return ImageType.BUFFERED_COMPATIBLE;
        }
        if (image instanceof VolatileImage) {
            return ImageType.VOLATILE;
        }
        return ImageType.UNKNOWN;
    }

    public ImageType c(Image image) {
        ImageType imageType = this.b(image);
        if (imageType == ImageType.VOLATILE) {
            throw new IllegalArgumentException(f[10] + (Object)((Object)imageType) + f[9] + image);
        }
        return imageType;
    }

    public boolean a(ImageType imageType, ImageType imageType2) {
        if (imageType == null) {
            return true;
        }
        if (imageType2 == null) {
            return false;
        }
        return imageType2.is(imageType);
    }

    public ScaledImage a(ScaledImage scaledImage, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        block10: {
            if (scaledImage != null && imageType != null) break block10;
            return scaledImage;
        }
        Image image = scaledImage.getImage();
        if (image == null) {
            return null;
        }
        Image image2 = this.getImage(image, imageType, graphicsConfiguration);
        if (image == image2) {
            return scaledImage;
        }
        return new ScaledImage(image2, scaledImage.getScale());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PrivateAPI
    public Image getImageSafe(Image image, ImageType requiredType, GraphicsConfiguration gc) {
        if (image == null || requiredType == null) {
            return image;
        }
        ImageType imageType = this.c(image);
        try {
            return this.getImage(image, requiredType, gc);
        }
        catch (ImageContentsLostException imageContentsLostException) {
            throw new Error(f[24] + (Object)((Object)imageType) + f[23], imageContentsLostException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PrivateAPI
    public Image getImage(Image image, ImageType requiredType, GraphicsConfiguration gc) throws ImageContentsLostException {
        if (image == null) return image;
        if (requiredType == null) {
            return image;
        }
        ImageType imageType = this.b(image);
        boolean bl = this.a(requiredType, imageType);
        switch (this.a(image, gc)) {
            case 0: {
                break;
            }
            case 1: {
                throw new ImageContentsLostException(image);
            }
            case 2: {
                bl = false;
                break;
            }
        }
        if (bl) return image;
        Image image2 = this.a(image, requiredType, gc);
        return image2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image a(Image image, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        switch (imageType) {
            case TOOLKIT: 
            case TOOLKIT_SOURCE_MEMORY: {
                return this.a(n2, n3, this.f(image), ImageType.TOOLKIT_SOURCE_MEMORY, graphicsConfiguration);
            }
            case BUFFERED: 
            case BUFFERED_COMPATIBLE: 
            case BUFFERED_INT_ARGB: 
            case ACCELERATED: 
            case VOLATILE: {
                Image image2 = this.a(n2, n3, imageType, graphicsConfiguration);
                this.a(image2, image, true);
                return image2;
            }
        }
        throw new IllegalArgumentException(f[0] + (Object)((Object)imageType) + ".");
    }

    public void d(Image image) {
        this.a(image, 0, 0, image.getWidth(null), image.getHeight(null));
    }

    public void a(Image image, int n2, int n3, int n4, int n5) {
        Graphics2D graphics2D = (Graphics2D)image.getGraphics();
        graphics2D.setComposite(AlphaComposite.Clear);
        graphics2D.fillRect(n2, n3, n4, n5);
        graphics2D.dispose();
    }

    @PrivateAPI
    public void drawImage(Graphics g2, Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer, boolean conversionTolerated) throws ImageContentsLostException {
        image = this.a(image, g2);
        image = this.a(image, g2, conversionTolerated);
        g2.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        if (this.h(image)) {
            throw new ImageContentsLostException(image);
        }
    }

    @PrivateAPI
    public void drawImage(Graphics g2, Image image, int x2, int y2, ImageObserver observer, boolean conversionTolerated) throws ImageContentsLostException {
        image = this.a(image, g2);
        image = this.a(image, g2, conversionTolerated);
        g2.drawImage(image, x2, y2, observer);
        if (this.h(image)) {
            throw new ImageContentsLostException(image);
        }
    }

    @PrivateAPI
    public void drawImageSafe(Graphics g2, Image image, int x2, int y2, ImageObserver observer, boolean conversionTolerated) {
        ImageType imageType = this.c(image);
        try {
            this.drawImage(g2, image, x2, y2, observer, conversionTolerated);
        }
        catch (ImageContentsLostException imageContentsLostException) {
            throw new Error(f[3] + (Object)((Object)imageType) + f[2], imageContentsLostException);
        }
    }

    public void a(Image image, Image image2, boolean bl) throws ImageContentsLostException {
        block5: {
            if (image2 != null && image != null) break block5;
            return;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        Graphics graphics = image.getGraphics();
        if (graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setComposite(AlphaComposite.Clear);
            graphics2D.fillRect(0, 0, n2, n3);
            graphics2D.setComposite(AlphaComposite.SrcOver);
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        }
        this.drawImage(graphics, image2, 0, 0, null, bl);
        graphics.dispose();
    }

    public void a(Image image, Image image2, Graphics2D graphics2D, int n2, int n3, float f2) throws ImageContentsLostException {
        graphics2D.setComposite(AlphaComposite.SrcOver);
        this.drawImage(graphics2D, image2, 0, 0, null, false);
        graphics2D.setComposite(AlphaComposite.SrcIn);
        this.drawImage(graphics2D, image, 0, 0, null, false);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f - f2));
        this.drawImage(graphics2D, image2, 0, 0, null, false);
    }

    public Image a(Image image, Graphics graphics, boolean bl) throws ImageContentsLostException {
        return this.a(image, this.b(graphics), bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image a(Image image, GraphicsConfiguration graphicsConfiguration, boolean bl) throws ImageContentsLostException {
        if (image == null) return image;
        if (graphicsConfiguration == null) {
            return image;
        }
        if (this.h(image)) {
            throw new ImageContentsLostException(image);
        }
        switch (this.a(image, graphicsConfiguration)) {
            case 0: {
                return image;
            }
            case 1: {
                throw new ImageContentsLostException(image);
            }
            case 2: {
                boolean bl2;
                boolean bl3 = bl2 = !bl;
                if (bl2 && CezanneJavaUtil.a(graphicsConfiguration)) {
                    bl2 = false;
                }
                if (bl2) {
                    b.infoWithStackTrace(this, f[22], CezanneJVMInternals.get().a((VolatileImage)image), graphicsConfiguration);
                }
                BufferedImage bufferedImage = ((VolatileImage)image).getSnapshot();
                if (!this.h(image)) return bufferedImage;
                throw new ImageContentsLostException(image);
            }
        }
        return image;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image a(Image image, Graphics graphics) throws ImageContentsLostException {
        if (!CezanneJavaUtil.b(graphics)) {
            return image;
        }
        this.a(image);
        int n3 = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n3 <= 0) return image;
        if (n2 <= 0) {
            return image;
        }
        BufferedImage bufferedImage = (BufferedImage)this.a(n3, n2, ImageType.BUFFERED_INT_ARGB, null);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        if (this.h(image)) {
            throw new ImageContentsLostException(image);
        }
        try {
            int n4;
            DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
            int[] nArray = dataBufferInt.getData();
            int n5 = bufferedImage.getMinX();
            int n6 = bufferedImage.getMinY();
            int n7 = n5 + bufferedImage.getWidth();
            int n8 = n6 + bufferedImage.getHeight();
            int n9 = ((SinglePixelPackedSampleModel)bufferedImage.getRaster().getSampleModel()).getScanlineStride();
            boolean bl = false;
            boolean bl2 = false;
            block8: for (n4 = n6; n4 < n8; ++n4) {
                int n10 = n4 * n9 + n5;
                for (int n11 = n5; n11 < n7; ++n10, ++n11) {
                    if ((nArray[n10] & 0xFF000000) == -16777216) continue;
                    bl = true;
                    if (n4 != n6) break block8;
                    bl2 = true;
                    break block8;
                }
            }
            if (!bl) return bufferedImage;
            if (bl2) return bufferedImage;
            n4 = n6 * n9 + n5;
            nArray[n4] = nArray[n4] & 0xFEFFFFFF;
            return bufferedImage;
        }
        catch (Throwable throwable) {
            b.warn(this, f[1], throwable);
        }
        return bufferedImage;
    }

    public GraphicsConfiguration b(Graphics graphics) {
        GraphicsConfiguration graphicsConfiguration = null;
        if (graphics instanceof Graphics2D) {
            graphicsConfiguration = ((Graphics2D)graphics).getDeviceConfiguration();
        }
        return graphicsConfiguration;
    }

    public int[] e(Image image) {
        ImageType imageType = this.c(image);
        try {
            return this.f(image);
        }
        catch (ImageContentsLostException imageContentsLostException) {
            throw new Error(f[12] + (Object)((Object)imageType) + f[11], imageContentsLostException);
        }
    }

    public int[] f(Image image) throws ImageContentsLostException {
        if (image == null) {
            return null;
        }
        ImageType imageType = this.b(image);
        return this.a(image, imageType, (Boolean)null);
    }

    public int[] g(Image image) throws ImageContentsLostException {
        if (image == null) {
            return null;
        }
        ImageType imageType = this.b(image);
        return this.a(image, imageType, Boolean.TRUE);
    }

    protected int[] a(Image image, ImageType imageType, Boolean bl) throws ImageContentsLostException {
        switch (imageType) {
            case BUFFERED_INT_ARGB: {
                int[] nArray = this.a((BufferedImage)image);
                if (Boolean.FALSE.equals(bl)) {
                    int[] nArray2 = new int[nArray.length];
                    System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                    nArray = nArray2;
                }
                return nArray;
            }
        }
        if (Boolean.TRUE.equals(bl)) {
            return null;
        }
        int n2 = image.getWidth(null);
        int n3 = image.getHeight(null);
        Image image2 = this.a(n2, n3, ImageType.BUFFERED_INT_ARGB, null);
        this.a(image2, image, true);
        int[] nArray = this.a((BufferedImage)image2);
        image2.flush();
        return nArray;
    }

    protected int[] a(BufferedImage bufferedImage) {
        DataBufferInt dataBufferInt = (DataBufferInt)bufferedImage.getRaster().getDataBuffer();
        return dataBufferInt.getData();
    }

    public int a(Image image, GraphicsConfiguration graphicsConfiguration) {
        if (image instanceof VolatileImage) {
            int n2;
            block12: {
                block11: {
                    VolatileImage volatileImage = (VolatileImage)image;
                    if (graphicsConfiguration == null || !this.a(graphicsConfiguration)) break block11;
                    if (this.a(volatileImage)) break block11;
                    return 2;
                }
                n2 = ((VolatileImage)image).validate(graphicsConfiguration);
                if (n2 == 0 || !b.isDebugEnabled(this)) break block12;
                b.debug(this, f[19], n2, image);
            }
            return n2;
        }
        return 0;
    }

    protected boolean a(GraphicsConfiguration graphicsConfiguration) {
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsDevice == null) {
            return false;
        }
        boolean bl = graphicsDevice.getType() == 0;
        return bl;
    }

    protected boolean a(VolatileImage volatileImage) {
        GraphicsConfiguration graphicsConfiguration = CezanneJVMInternals.get().a(volatileImage);
        if (graphicsConfiguration == null) {
            return false;
        }
        GraphicsDevice graphicsDevice = graphicsConfiguration.getDevice();
        if (graphicsDevice == null) {
            return false;
        }
        boolean bl = graphicsDevice.getType() == 0;
        return bl;
    }

    public boolean a(ScaledImage scaledImage) {
        if (scaledImage == null) {
            return false;
        }
        return this.h(scaledImage.getImage());
    }

    public boolean h(Image image) {
        if (image instanceof VolatileImage) {
            boolean bl;
            block5: {
                bl = ((VolatileImage)image).contentsLost();
                if (!bl || !b.isDebugEnabled(this)) break block5;
                b.debug(this, f[13], image);
            }
            return bl;
        }
        return false;
    }

    public <S> Map.Entry<Dimension, S> a(Map<Dimension, S> map, Dimension dimension, boolean bl) {
        Map.Entry<Dimension, S> entry;
        block23: {
            int n2;
            Dimension dimension2;
            block22: {
                int n3;
                Dimension dimension3;
                block21: {
                    if (map != null && !map.isEmpty()) break block21;
                    return null;
                }
                entry = null;
                if (!bl) break block22;
                int n4 = 0;
                for (Map.Entry<Dimension, S> entry2 : map.entrySet()) {
                    dimension3 = entry2.getKey();
                    if (dimension3.width < dimension.width || dimension3.height < dimension.height) continue;
                    n3 = dimension3.width * dimension3.height;
                    if (entry != null && n3 >= n4) continue;
                    entry = entry2;
                    n4 = n3;
                }
                if (entry != null) break block23;
                n4 = 0;
                for (Map.Entry<Dimension, S> entry2 : map.entrySet()) {
                    dimension3 = entry2.getKey();
                    n3 = dimension3.width * dimension3.height;
                    if (entry != null && n3 <= n4) continue;
                    entry = entry2;
                    n4 = n3;
                }
                break block23;
            }
            int n5 = 0;
            for (Map.Entry<Dimension, S> entry3 : map.entrySet()) {
                dimension2 = entry3.getKey();
                if (dimension2.width > dimension.width || dimension2.height > dimension.height) continue;
                n2 = dimension2.width * dimension2.height;
                if (entry != null && n2 <= n5) continue;
                entry = entry3;
                n5 = n2;
            }
            if (entry == null) {
                n5 = 0;
                for (Map.Entry<Dimension, S> entry3 : map.entrySet()) {
                    dimension2 = entry3.getKey();
                    n2 = dimension2.width * dimension2.height;
                    if (entry != null && n2 >= n5) continue;
                    entry = entry3;
                    n5 = n2;
                }
            }
        }
        return entry;
    }

    public ScaledImage a(ScaledImage scaledImage, Dimension dimension, boolean bl, Color color, Color color2, CezanneImageFilter cezanneImageFilter, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        ScaledImage scaledImage2 = this.a(scaledImage, dimension, bl, imageType, graphicsConfiguration);
        scaledImage2 = this.a(scaledImage2, color, color2, cezanneImageFilter, imageType, graphicsConfiguration);
        return scaledImage2;
    }

    public ScaledImage a(ScaledImage scaledImage, Dimension dimension, boolean bl, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        int n2;
        int n3;
        Image image;
        block14: {
            if (scaledImage == null) {
                return null;
            }
            image = scaledImage.getImage();
            if (image == null) {
                return scaledImage;
            }
            n3 = image.getWidth(null);
            int n4 = image.getHeight(null);
            if (n3 != dimension.width || n4 != dimension.height) break block14;
            return scaledImage;
        }
        if (n3 > dimension.width) {
            n2 = 102;
        } else {
            int n5 = bl ? 100 : 106;
            n2 = n5;
        }
        image = this.stretch(image, dimension.width, dimension.height, n2, null, imageType, graphicsConfiguration);
        return new ScaledImage(image);
    }

    public ScaledImage a(ScaledImage scaledImage, Color color, Color color2, CezanneImageFilter cezanneImageFilter, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        block7: {
            block6: {
                if (scaledImage == null) break block6;
                if (color != null) break block7;
                if (cezanneImageFilter != null) break block7;
            }
            return scaledImage;
        }
        return this.a(scaledImage, color, color2, cezanneImageFilter, this, imageType, graphicsConfiguration);
    }

    protected ScaledImage a(ScaledImage scaledImage, Color color, Color color2, CezanneImageFilter cezanneImageFilter, CezanneImageUtil cezanneImageUtil, ImageType imageType, GraphicsConfiguration graphicsConfiguration) throws ImageContentsLostException {
        if (scaledImage == null) {
            return scaledImage;
        }
        Image image = scaledImage.getImage();
        if (image == null) {
            return scaledImage;
        }
        CIFColorReplacement cIFColorReplacement = new CIFColorReplacement();
        H h2 = new H(null);
        if (color2 != null) {
            h2.a(f[16], new CezanneColorRegular(color2, true));
        }
        h2.a(f[15], new CezanneColorRegular(color, true));
        cIFColorReplacement.setParameters(h2);
        ScaledImage scaledImage2 = cIFColorReplacement.filterImage(null, null, Boolean.FALSE, scaledImage, null, null);
        if (cezanneImageFilter != null) {
            scaledImage2 = cezanneImageFilter.filterImage(null, null, Boolean.FALSE, scaledImage2, null, null);
        }
        scaledImage2 = this.a(scaledImage2, imageType, graphicsConfiguration);
        return scaledImage2;
    }

    public Icon a(CezanneContext<?> cezanneContext, Icon icon) {
        block6: {
            if (icon != null) {
                CezanneImageFilter cezanneImageFilter = CezannePropertiesComponent.q.get(cezanneContext);
                if (cezanneImageFilter == null || !(icon instanceof ImageIcon)) break block6;
                CezanneUtil.validateIcon(icon, cezanneContext);
                Image image = ((ImageIcon)icon).getImage();
                if (image != null) {
                    try {
                        ScaledImage scaledImage = new ScaledImage(image);
                        ScaledImage scaledImage2 = cezanneImageFilter.filterImage(cezanneContext, ImageType.ACCELERATED, Boolean.TRUE, scaledImage, null, null);
                        icon = new ImageIcon(scaledImage2.getImage());
                    }
                    catch (ImageContentsLostException imageContentsLostException) {
                        // empty catch block
                    }
                }
            }
        }
        return icon;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block80: {
            block79: {
                v0 = new String[26];
                v1 = v0;
                v2 = v0;
                v3 = 0;
                v4 = "^J,[JvJ`LHfS)LHs\u00064G]r\u0006";
                v5 = -1;
                break block79;
lbl8:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 1;
                    v4 = "TI5RI7H/J\rdE!P\r~K!YH7R2_CdV!LHyE9\u001eKxT`N_~H4WCp\b";
                    v5 = 0;
                    break block79;
                    break;
                }
lbl16:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 2;
                    v4 = "7U(QX{B`PHaC2\u001eAxU%\u001eDcU`]ByR%PYd\b";
                    v5 = 1;
                    break block79;
                    break;
                }
lbl24:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 3;
                    v4 = "^K!YH7I&\u001eYnV%\u001e";
                    v5 = 2;
                    break block79;
                    break;
                }
lbl32:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 4;
                    v4 = "TG.\u0019Y7J/_I7O-_Jr\u0006&LBz\u0006g";
                    v5 = 3;
                    break block79;
                    break;
                }
lbl40:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 5;
                    v4 = "0\b";
                    v5 = 4;
                    break block79;
                    break;
                }
lbl48:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 6;
                    v4 = "QG)RXeC`RBvB)PJ7O-_Jr\u0006&LBz\u0006g";
                    v5 = 5;
                    break block79;
                    break;
                }
lbl56:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 7;
                    v4 = "qO,[";
                    v5 = 6;
                    break block79;
                    break;
                }
lbl64:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 8;
                    v4 = "0\b";
                    v5 = 7;
                    break block79;
                    break;
                }
lbl72:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 9;
                    v4 = "-\u0006";
                    v5 = 8;
                    break block79;
                    break;
                }
lbl80:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 10;
                    v4 = "^K!YH7O3\u001eCxR`MLqCz\u001e";
                    v5 = 9;
                    break block79;
                    break;
                }
lbl88:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 11;
                    v4 = "7U(QX{B`PHaC2\u001eAxU%\u001eDcU`]ByR%PYd\b";
                    v5 = 10;
                    break block79;
                    break;
                }
lbl96:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 12;
                    v4 = "^K!YH7I&\u001eYnV%\u001e";
                    v5 = 11;
                    break block79;
                    break;
                }
lbl104:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 13;
                    v4 = "^K!YH7E/PYrH4M\r{I3J\u00177]pC";
                    v5 = 12;
                    break block79;
                    break;
                }
lbl112:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 14;
                    v4 = "EG3JHe\u00062[]{O#_Y~I.\u001eCrC$M\rdE!RH7@!]YxTn";
                    v5 = 13;
                    break block79;
                    break;
                }
lbl120:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 15;
                    v4 = "EC0RLtC-[Cce/RBe";
                    v5 = 14;
                    break block79;
                    break;
                }
lbl128:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 16;
                    v4 = "\\C9}B{I2";
                    v5 = 15;
                    break block79;
                    break;
                }
lbl136:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 17;
                    v4 = "^H4[_eS0JHs\u00067VD{C`RBvB)PJ7o-_Jr\b";
                    v5 = 16;
                    break block79;
                    break;
                }
lbl144:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 18;
                    v4 = "^J,[JvJ`W@vA%\u001eYnV%\u001e";
                    v5 = 17;
                    break block79;
                    break;
                }
lbl152:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 19;
                    v4 = "^K!YH7H/J\rxMz\u001eV'[`E\u001cj";
                    v5 = 18;
                    break block79;
                    break;
                }
lbl160:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 20;
                    v4 = "^h\u0014alEa\u0002";
                    v5 = 19;
                    break block79;
                    break;
                }
lbl168:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 21;
                    v4 = "^h\u0014alEa\u0002";
                    v5 = 20;
                    break block79;
                    break;
                }
lbl176:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 22;
                    v4 = "BH%F]rE4[I7O-_Jr\u0006#QCaC2MDxH`X_xK`E\u001dj\u00064Q\rl\u0017=\u0010";
                    v5 = 21;
                    break block79;
                    break;
                }
lbl184:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 23;
                    v4 = "7U(QX{B`PHaC2\u001eAxU%\u001eDcU`]ByR%PYd\b";
                    v5 = 22;
                    break block79;
                    break;
                }
lbl192:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 24;
                    v4 = "^K!YH7I&\u001eYnV%\u001e";
                    v5 = 23;
                    break block79;
                    break;
                }
lbl200:
                // 1 sources

                while (true) {
                    v1[v3] = v6.intern();
                    v1 = v2;
                    v2 = v2;
                    v3 = 25;
                    v4 = "^J,[JvJ`W@vA%\u001eYnV%\u001e";
                    v5 = 24;
                    break block79;
                    break;
                }
lbl208:
                // 1 sources

                while (true) {
                    continue;
                    break;
                }
            }
            v7 = v4.toCharArray();
            var0 = 0;
            v8 = v7.length;
            v9 = v7;
            v10 = v8;
            if (v8 > 1) ** GOTO lbl248
            do {
                v11 = v9;
                v12 = v9;
                v13 = var0;
                while (true) {
                    v14 = v11[v13];
                    switch (var0 % 5) {
                        case 0: {
                            v15 = 23;
                            break;
                        }
                        case 1: {
                            v15 = 38;
                            break;
                        }
                        case 2: {
                            v15 = 64;
                            break;
                        }
                        case 3: {
                            v15 = 62;
                            break;
                        }
                        default: {
                            v15 = 45;
                        }
                    }
                    v11[v13] = (char)(v14 ^ v15);
                    ++var0;
                    v9 = v12;
                    v10 = v10;
                    if (v10 != 0) break;
                    v12 = v9;
                    v16 = v10;
                    v13 = v10;
                    v11 = v9;
                }
lbl248:
                // 2 sources

                v17 = v9;
                v16 = v10;
            } while (v10 > var0);
            v6 = new String(v17);
            switch (v5) {
                default: {
                    ** continue;
                }
                case 0: {
                    ** continue;
                }
                case 1: {
                    ** continue;
                }
                case 2: {
                    ** continue;
                }
                case 3: {
                    ** continue;
                }
                case 4: {
                    ** continue;
                }
                case 5: {
                    ** continue;
                }
                case 6: {
                    ** continue;
                }
                case 7: {
                    ** continue;
                }
                case 8: {
                    ** continue;
                }
                case 9: {
                    ** continue;
                }
                case 10: {
                    ** continue;
                }
                case 11: {
                    ** continue;
                }
                case 12: {
                    ** continue;
                }
                case 13: {
                    ** continue;
                }
                case 14: {
                    ** continue;
                }
                case 15: {
                    ** continue;
                }
                case 16: {
                    ** continue;
                }
                case 17: {
                    ** continue;
                }
                case 18: {
                    ** continue;
                }
                case 19: {
                    ** continue;
                }
                case 20: {
                    ** continue;
                }
                case 21: {
                    ** continue;
                }
                case 22: {
                    ** continue;
                }
                case 23: {
                    ** continue;
                }
                ** case 24:
lbl305:
                // 1 sources

                ** continue;
            }
lbl306:
            // 1 sources

            while (true) {
                v18 = "^h\u0014alEa\u0002".toCharArray();
                var0 = 0;
                v19 = v18.length;
                v20 = v18;
                v21 = v19;
                if (v19 > 1) ** GOTO lbl344
                do {
                    v22 = v20;
                    v23 = v20;
                    v24 = var0;
                    while (true) {
                        v25 = v22[v24];
                        switch (var0 % 5) {
                            case 0: {
                                v26 = 23;
                                break;
                            }
                            case 1: {
                                v26 = 38;
                                break;
                            }
                            case 2: {
                                v26 = 64;
                                break;
                            }
                            case 3: {
                                v26 = 62;
                                break;
                            }
                            default: {
                                v26 = 45;
                            }
                        }
                        v22[v24] = (char)(v25 ^ v26);
                        ++var0;
                        v20 = v23;
                        v21 = v21;
                        if (v21 != 0) break;
                        v23 = v20;
                        v27 = v21;
                        v24 = v21;
                        v22 = v20;
                    }
lbl344:
                    // 2 sources

                    v28 = v20;
                    v27 = v21;
                } while (v21 > var0);
                break block80;
                break;
            }
lbl348:
            // 1 sources

            while (true) {
                v29 = "^h\u0014alEa\u0002".toCharArray();
                var0 = 0;
                v30 = v29.length;
                v31 = v29;
                v32 = v30;
                if (v30 > 1) ** GOTO lbl386
                do {
                    v33 = v31;
                    v34 = v31;
                    v35 = var0;
                    while (true) {
                        v36 = v33[v35];
                        switch (var0 % 5) {
                            case 0: {
                                v37 = 23;
                                break;
                            }
                            case 1: {
                                v37 = 38;
                                break;
                            }
                            case 2: {
                                v37 = 64;
                                break;
                            }
                            case 3: {
                                v37 = 62;
                                break;
                            }
                            default: {
                                v37 = 45;
                            }
                        }
                        v33[v35] = (char)(v36 ^ v37);
                        ++var0;
                        v31 = v34;
                        v32 = v32;
                        if (v32 != 0) break;
                        v34 = v31;
                        v38 = v32;
                        v35 = v32;
                        v33 = v31;
                    }
lbl386:
                    // 2 sources

                    v39 = v31;
                    v38 = v32;
                } while (v32 > var0);
                v40 = new String(v39);
                ** continue;
                break;
            }
            v1[v3] = v6.intern();
            CezanneImageUtil.f = v2;
            CezanneImageUtil.a = new CezanneImageUtil();
            CezanneImageUtil.b = CezanneLogger.getLogger(CezanneImageUtil.class);
            CezanneImageUtil.c = new Hashtable<K, V>();
            ** while (true)
        }
        CezanneImageUtil.c.put(v40.intern(), new String(v28).intern());
    }
}

