/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.cezanne.function;

import de.pixopia.util.integrated.CodeGroup;
import de.pixopia.util.integrated.PrivateAPI;

@PrivateAPI
@CodeGroup(value={"cezanne-core"})
public class CubicBezierCurve {
    protected double a;
    protected double b;
    protected double c;
    protected double d;
    protected double e;
    protected double f;
    protected int g;
    protected double[] h;
    protected int i;
    protected double j;
    private static final String[] k;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @PrivateAPI
    public CubicBezierCurve(double y0, double x1, double y1, double x2, double y2, double y3) {
        block7: {
            if (x1 < 0.0) throw new IllegalArgumentException(k[1]);
            if (x1 > 1.0) {
                throw new IllegalArgumentException(k[1]);
            }
            if (!(x2 < 0.0) && !(x2 > 1.0)) break block7;
            throw new IllegalArgumentException(k[0]);
        }
        this.a = y0;
        this.b = x1;
        this.c = y1;
        this.d = x2;
        this.e = y2;
        this.f = y3;
        this.g = 100;
        this.i = 1;
    }

    @PrivateAPI
    public double getY(double x2) {
        if (x2 <= 0.0) {
            return this.a;
        }
        if (x2 >= 1.0) {
            return this.f;
        }
        double[] dArray = this.a();
        int n2 = (int)((double)this.g * x2);
        double d2 = (x2 - (double)n2 / (double)this.g) * (double)this.g;
        double d3 = dArray[n2];
        double d4 = n2 == this.g - 1 ? this.f : dArray[n2 + 1];
        double d5 = d4;
        double d6 = d3 + (d5 - d3) * d2;
        return d6;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected double[] a() {
        if (this.h != null) return this.h;
        switch (this.i) {
            case 1: {
                this.h = this.d();
                return this.h;
            }
        }
        this.h = this.c();
        return this.h;
    }

    protected double[] c() {
        double[] dArray = new double[this.g];
        double d2 = 1.0 / (double)this.g;
        double d3 = 0.0;
        int n2 = 0;
        double d4 = 1.0 / (double)this.g / 10.0;
        double d5 = 0.0;
        while (true) {
            block7: {
                double d6;
                block6: {
                    d6 = 3.0 * this.b * d5 * (1.0 - d5) * (1.0 - d5) + 3.0 * this.d * d5 * d5 * (1.0 - d5) + d5 * d5 * d5;
                    if (!(d6 < d3)) break block6;
                    break block7;
                }
                double d7 = Math.abs(d6 - (double)n2 * d2);
                this.j += d7 * d7;
                double d8 = this.a * (1.0 - d5) * (1.0 - d5) * (1.0 - d5) + 3.0 * this.c * d5 * (1.0 - d5) * (1.0 - d5) + 3.0 * this.e * d5 * d5 * (1.0 - d5) + this.f * d5 * d5 * d5;
                dArray[n2] = d8;
                if (++n2 == this.g) {
                    break;
                }
                d3 += d2;
            }
            d5 += d4;
        }
        return dArray;
    }

    protected double[] d() {
        double[] dArray = new double[this.g];
        dArray[0] = this.a;
        int n2 = 0;
        double d2 = 1.0 / (double)this.g / 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 1.0;
        for (int i2 = 1; i2 < this.g; ++i2) {
            double d6;
            double d7 = (double)i2 / (double)this.g;
            while (true) {
                d6 = d4 - d7;
                double d8 = d6 * d6;
                if (d8 < 1.0E-8) {
                    this.j += d8;
                    break;
                }
                double d9 = -d6 / d5;
                if (d9 > d2) {
                    d9 = d2;
                } else if (d9 < -d2) {
                    d9 = -d2;
                }
                double d10 = 3.0 * this.b * (d3 += d9) * (1.0 - d3) * (1.0 - d3) + 3.0 * this.d * d3 * d3 * (1.0 - d3) + d3 * d3 * d3;
                d5 = (d10 - d4) / d9;
                d4 = d10;
                ++n2;
            }
            dArray[i2] = d6 = this.a * (1.0 - d3) * (1.0 - d3) * (1.0 - d3) + 3.0 * this.c * d3 * (1.0 - d3) * (1.0 - d3) + 3.0 * this.e * d3 * d3 * (1.0 - d3) + this.f * d3 * d3 * d3;
        }
        return dArray;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[2];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = " \u001e;\bT+X;\u0007DxEuEzh\u0017*8";
        int n3 = -1;
        block9: while (true) {
            char[] cArray;
            block14: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block13: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block13;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block14;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 88;
                                break;
                            }
                            case 1: {
                                n9 = 44;
                                break;
                            }
                            case 2: {
                                n9 = 27;
                                break;
                            }
                            case 3: {
                                n9 = 101;
                                break;
                            }
                            default: {
                                n9 = 33;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = " \u001d;\bT+X;\u0007DxEuEzh\u0017*8";
                    n3 = 0;
                    continue block9;
                }
                case 0: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        k = stringArray3;
    }
}

