/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.utils.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class View {
    private static Logger logger = Logger.getLogger("net.hussnain.utils.ui.View");

    public static final boolean changeLook(JFrame p_owner, String p_lnf, String p_currentLnf) {
        try {
            if (p_lnf.equals("CDE/Motif") & !p_currentLnf.equals("CDE/Motif")) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (p_lnf.equals("Native") & !p_currentLnf.equals("Native")) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else if (p_lnf.equals("Metal") & !p_currentLnf.equals("Metal")) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException e) {
            logger.warning("Class not found for LAF " + p_lnf);
            return false;
        }
        catch (UnsupportedLookAndFeelException e) {
            logger.warning("Can't change look and feel to " + p_lnf);
            return false;
        }
        catch (InstantiationException e) {
            logger.warning("new instance for native look couldn't be created for " + p_lnf);
            return false;
        }
        catch (IllegalAccessException e) {
            logger.warning("class or initializer isn't accessible for " + p_lnf);
            return false;
        }
        SwingUtilities.updateComponentTreeUI(p_owner);
        return true;
    }

    public static final void setLocationToMid(Component p_comp) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = p_comp.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        p_comp.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void setLogger(Logger p_logger) {
        logger = p_logger;
    }
}

