/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.io.im;

import java.awt.Image;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import net.hussnain.io.file.RabtFileFilter;
import net.hussnain.io.im.RabtInputMethod;

public class RabtInputMethodDescriptor
implements InputMethodDescriptor {
    private static Logger logger = Logger.getLogger("RabtInputMethodDescriptor");
    Hashtable locales = new Hashtable();
    Hashtable localesProps = new Hashtable();

    public RabtInputMethodDescriptor() {
        this.addLocales();
    }

    public Locale[] getAvailableLocales() {
        return this.locales.values().toArray(new Locale[0]);
    }

    public boolean hasDynamicLocaleList() {
        return true;
    }

    public synchronized String getInputMethodDisplayName(Locale inputLocale, Locale displayLanguage) {
        return "RabtPad Input Methods";
    }

    public Image getInputMethodIcon(Locale inputLocale) {
        return null;
    }

    public InputMethod createInputMethod() throws Exception {
        return new RabtInputMethod(this.locales, this.localesProps);
    }

    public String toString() {
        Locale[] loc = this.getAvailableLocales();
        String locnames = null;
        for (int i = 0; i < loc.length; ++i) {
            locnames = locnames == null ? loc[i].toString() : locnames + "," + loc[i];
        }
        return this.getClass().getName() + "[" + "locales=" + locnames + ",localelist=" + (this.hasDynamicLocaleList() ? "dynamic" : "static") + "]";
    }

    private void addLocales() {
        File refMapsFolder;
        URL fileUrl = this.getClass().getResource("/net/hussnain/io/im/urdu.rid");
        this.addLocale(fileUrl);
        fileUrl = this.getClass().getResource("/net/hussnain/io/im/arabic.rid");
        this.addLocale(fileUrl);
        String homeFolderPath = System.getProperty("user.home");
        File homeFolder = new File(homeFolderPath);
        File refRabtFolder = new File(homeFolder, ".rabtPad");
        if (refRabtFolder.exists() && (refMapsFolder = new File(refRabtFolder, "mappings")).exists()) {
            RabtFileFilter filter = new RabtFileFilter("Rapt InputMaps");
            filter.addFileExtention("rid", "rabt input method description");
            File[] mapDefs = refMapsFolder.listFiles(filter);
            for (int i = 0; i < mapDefs.length; ++i) {
                File currFile = mapDefs[i];
                if (!currFile.isFile()) continue;
                try {
                    this.addLocale(mapDefs[i].toURL());
                    continue;
                }
                catch (MalformedURLException exp) {
                    logger.warning("error loading locale from file " + mapDefs[i].getAbsolutePath());
                }
            }
        }
    }

    public void addLocale(URL p_url) {
        logger.info("adding locale from file " + p_url.toString());
        Properties locProp = new Properties();
        try {
            BufferedInputStream in = new BufferedInputStream(p_url.openStream());
            locProp.load(in);
        }
        catch (IOException exp) {
            logger.info(exp.getMessage());
            return;
        }
        String localeCode = locProp.getProperty("LocaleLanguageCode");
        String localeCountry = locProp.getProperty("LocaleCountry");
        String localeVariant = locProp.getProperty("LocaleVariant");
        Locale newLocale = null;
        if (localeCode != null && localeCountry != null && localeVariant != null) {
            newLocale = new Locale(localeCode, localeCountry, localeVariant);
        } else if (localeCode != null && localeCountry != null) {
            newLocale = new Locale(localeCode, localeCountry);
        } else if (localeCode != null) {
            newLocale = new Locale(localeCode);
        }
        this.locales.put(localeCode, newLocale);
        this.localesProps.put(localeCode, locProp);
    }
}

