/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.io.file;

import java.io.File;
import java.io.FileFilter;
import java.util.Hashtable;
import net.hussnain.utils.FileUtilities;

public class RabtFileFilter
implements FileFilter {
    private Hashtable acceptedExtenions = new Hashtable();
    private String filterDescription;

    public RabtFileFilter(String p_description) {
        this.filterDescription = p_description;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = FileUtilities.getExtension(f);
        if (extension != null && this.acceptedExtenions.containsKey(extension)) {
            extension = null;
            return true;
        }
        return false;
    }

    public String getDescription() {
        return this.filterDescription;
    }

    public void setDescription(String p_description) {
        this.filterDescription = p_description;
    }

    public void addFileExtention(String p_extention, String p_fileDescrption) {
        this.acceptedExtenions.put(p_extention, p_fileDescrption);
    }
}

