/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.io.file;

import java.io.File;
import java.util.Hashtable;
import javax.swing.filechooser.FileFilter;
import net.hussnain.utils.FileUtilities;

public class RabtFileChooserFilter
extends FileFilter {
    private Hashtable acceptedExtenions = new Hashtable();
    private String filterDescription;

    public RabtFileChooserFilter(String p_description) {
        this.filterDescription = p_description;
    }

    public boolean accept(File f) {
        if (f.isDirectory()) {
            return true;
        }
        String extension = FileUtilities.getExtension(f);
        return extension != null && this.acceptedExtenions.containsKey(extension);
    }

    public String getDescription() {
        return this.filterDescription;
    }

    public void setDescription(String p_description) {
        this.filterDescription = p_description;
    }

    public void addFileExtention(String p_extention, String p_fileDescrption) {
        this.acceptedExtenions.put(p_extention, p_fileDescrption);
    }

    public static final RabtFileChooserFilter createDocumentFilter() {
        RabtFileChooserFilter filter = new RabtFileChooserFilter("Accepted Documents");
        filter.addFileExtention("htm", "html file");
        filter.addFileExtention("html", "html file");
        filter.addFileExtention("rtf", "richt text file");
        filter.addFileExtention("txt", "plain text file");
        return filter;
    }

    public static final RabtFileChooserFilter createBitmapFilter() {
        RabtFileChooserFilter filter = new RabtFileChooserFilter("Accepted Bitmaps");
        filter.addFileExtention("gif", "Gif bitmap file");
        filter.addFileExtention("jpg", "Jpeg bitmap file");
        filter.addFileExtention("jpeg", "Jpeg bitmap file");
        filter.addFileExtention("png", "PNG bitmap file");
        return filter;
    }
}

