/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.beans.calendar;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class RabtCalendarPanel
extends JPanel
implements ItemListener,
ActionListener,
Serializable {
    private GregorianCalendar currentDate;
    private GregorianCalendar previousDate;
    private GregorianCalendar today;
    private int currentDateIndex;
    private int previousDateIndex;
    private int showPosX;
    private int showPosY;
    private JLabel[] monthDays = new JLabel[42];
    private Color weekdayBackground;
    private Color dayBackgound;
    private Color currentDayBackground;
    private Border dayPanelBorder;
    private JPanel set_panel;
    private JComboBox month_choice;
    private JButton decYearButton;
    private JTextField year_choice;
    private JButton incYearButton;
    private JSeparator JSep_year;
    private JPanel cal_panel;
    final String[] MONTHNAMES = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public RabtCalendarPanel(GregorianCalendar p_sourceDate) {
        this.today = new GregorianCalendar();
        this.previousDateIndex = this.currentDateIndex = this.today.get(5) + this.getFirstWeekOffset(this.today) - 1;
        this.weekdayBackground = Color.CYAN;
        this.dayBackgound = Color.WHITE;
        this.currentDayBackground = Color.ORANGE;
        this.dayPanelBorder = BorderFactory.createRaisedBevelBorder();
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.initComponents();
        this.previousDate = (GregorianCalendar)p_sourceDate.clone();
        this.currentDate = p_sourceDate;
        this.month_choice.addItem("January");
        this.month_choice.addItem("February");
        this.month_choice.addItem("March");
        this.month_choice.addItem("April");
        this.month_choice.addItem("May");
        this.month_choice.addItem("June");
        this.month_choice.addItem("July");
        this.month_choice.addItem("August");
        this.month_choice.addItem("September");
        this.month_choice.addItem("October");
        this.month_choice.addItem("November");
        this.month_choice.addItem("December");
        this.month_choice.addItemListener(this);
        this.month_choice.setSelectedIndex(this.currentDate.get(2));
        this.year_choice.setText("" + this.currentDate.get(1));
        this.year_choice.setEditable(false);
        this.decYearButton.addActionListener(this);
        this.incYearButton.addActionListener(this);
        this.cal_panel.add(this.createWeekDay("Mo"));
        this.cal_panel.add(this.createWeekDay("Tu"));
        this.cal_panel.add(this.createWeekDay("We"));
        this.cal_panel.add(this.createWeekDay("Th"));
        this.cal_panel.add(this.createWeekDay("Fr"));
        this.cal_panel.add(this.createWeekDay("Sa"));
        this.cal_panel.add(this.createWeekDay("Su"));
        for (int day = 0; day < this.monthDays.length; ++day) {
            this.monthDays[day] = new JLabel();
            this.monthDays[day].addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent p_Event) {
                    RabtCalendarPanel.this.dayLabelClicked(p_Event);
                }
            });
            this.monthDays[day].setBackground(this.dayBackgound);
            this.monthDays[day].setOpaque(true);
            this.monthDays[day].setHorizontalAlignment(0);
            this.monthDays[day].setBorder(this.dayPanelBorder);
            this.cal_panel.add(this.monthDays[day]);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.set_panel = new JPanel();
        this.month_choice = new JComboBox();
        this.JSep_year = new JSeparator();
        this.decYearButton = new JButton();
        this.year_choice = new JTextField();
        Font yearFont = this.year_choice.getFont();
        this.year_choice.setFont(new Font(yearFont.getFamily(), yearFont.getStyle(), yearFont.getSize() + 4));
        this.incYearButton = new JButton();
        this.set_panel.add(this.month_choice);
        this.JSep_year.setMaximumSize(new Dimension(30, 0));
        this.JSep_year.setMinimumSize(new Dimension(30, 0));
        this.JSep_year.setPreferredSize(new Dimension(30, 0));
        this.set_panel.add(this.JSep_year);
        this.decYearButton.setText("<");
        this.set_panel.add(this.decYearButton);
        this.set_panel.add(this.year_choice);
        this.incYearButton.setText(">");
        this.set_panel.add(this.incYearButton);
        this.cal_panel = new JPanel();
        this.cal_panel.setLayout(new GridLayout(7, 7));
        this.add((Component)this.cal_panel, "Center");
        this.add((Component)this.set_panel, "North");
    }

    public GregorianCalendar getDate() {
        return this.currentDate;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int actMonthNumber = this.currentDate.get(2);
        int actMonthDays = this.getDaysOfAMonth(actMonthNumber);
        int firstWeekOffset = this.getFirstWeekOffset(this.currentDate);
        int dayCounter = 1;
        for (int day = 0; day < this.monthDays.length; ++day) {
            int setNumber = 0;
            setNumber = day < firstWeekOffset || dayCounter > actMonthDays ? 0 : dayCounter++;
            if (setNumber != 0) {
                this.monthDays[day].setText("" + setNumber);
                continue;
            }
            this.monthDays[day].setText("");
        }
        this.monthDays[this.previousDateIndex].setBackground(this.dayBackgound);
        this.previousDateIndex = this.currentDate.get(5) + firstWeekOffset - 1;
        this.monthDays[this.previousDateIndex].setBackground(this.weekdayBackground);
        this.today = new GregorianCalendar();
        if (this.today.get(2) == this.currentDate.get(2) && this.today.get(1) == this.currentDate.get(1)) {
            this.monthDays[this.currentDateIndex].setBackground(this.dayBackgound);
            this.currentDateIndex = this.today.get(5) + firstWeekOffset - 1;
            this.monthDays[this.currentDateIndex].setBackground(this.currentDayBackground);
        } else {
            this.monthDays[this.currentDateIndex].setBackground(this.dayBackgound);
        }
    }

    public final int getDaysOfAMonth(int p_month) {
        int montDays = 0;
        if (p_month <= 6) {
            int n = montDays = p_month % 2 == 0 ? 31 : 30;
            if (p_month == 1) {
                montDays -= this.currentDate.isLeapYear(this.currentDate.get(1)) ? 1 : 2;
            }
        } else {
            montDays = p_month % 2 == 0 ? 30 : 31;
        }
        return montDays;
    }

    private final int getFirstWeekOffset(GregorianCalendar p_date) {
        GregorianCalendar firstDate = (GregorianCalendar)p_date.clone();
        firstDate.set(5, 1);
        return firstDate.get(7) == 1 ? 6 : firstDate.get(7) - 2;
    }

    private final JLabel createWeekDay(String p_weekDayName) {
        JLabel tempLabel = new JLabel(p_weekDayName);
        tempLabel.setBackground(this.weekdayBackground);
        tempLabel.setOpaque(true);
        tempLabel.setHorizontalAlignment(0);
        tempLabel.setBorder(this.dayPanelBorder);
        return tempLabel;
    }

    public void itemStateChanged(ItemEvent event) {
        JComboBox choice = (JComboBox)event.getItemSelectable();
        this.previousDate = (GregorianCalendar)this.currentDate.clone();
        this.currentDate.set(2, choice.getSelectedIndex());
        this.repaint();
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("<")) {
            this.previousDate = (GregorianCalendar)this.currentDate.clone();
            this.currentDate.set(1, this.currentDate.get(1) - 1);
            this.year_choice.setText("" + this.currentDate.get(1));
            this.repaint();
        } else if (cmd.equals(">")) {
            this.previousDate = (GregorianCalendar)this.currentDate.clone();
            this.currentDate.set(1, this.currentDate.get(1) + 1);
            this.year_choice.setText("" + this.currentDate.get(1));
            this.repaint();
        }
    }

    private void dayLabelClicked(MouseEvent p_Event) {
        JLabel clickedDayLabel = (JLabel)p_Event.getComponent();
        String dayText = clickedDayLabel.getText();
        if (dayText != null && dayText.length() > 0) {
            try {
                this.currentDate.set(5, Integer.parseInt(dayText));
                this.repaint();
            }
            catch (NumberFormatException exp) {
                System.out.println("day of the month couldnt be converted to int.");
            }
        }
    }

    public Border getDayPanelBorder() {
        return this.dayPanelBorder;
    }

    public void setDayPanelBorder(Border dayPanelBorder) {
        this.dayPanelBorder = dayPanelBorder;
    }

    public Color getWeekdayBackground() {
        return this.weekdayBackground;
    }

    public void setWeekdayBackground(Color weekdayBackground) {
        this.weekdayBackground = weekdayBackground;
    }

    public Color getDayBackgound() {
        return this.dayBackgound;
    }

    public void setDayBackgound(Color dayBackgound) {
        this.dayBackgound = dayBackgound;
    }

    public Color getCurrentDayBackground() {
        return this.currentDayBackground;
    }

    public void setCurrentDayBackground(Color currentDayBackground) {
        this.currentDayBackground = currentDayBackground;
    }

    public void mouseClicked(MouseEvent e) {
    }
}

