/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.nativeWin32.lz4;

import java.util.Arrays;

public class LZ4Encoder {
    private static final int LZ4_MAGIC = 407708164;
    private static final int LZ4_FRAME_DESCRIPTOR_LENGTH = 15;
    private static final int LZ4_DEFAULT_BLOCK_LENGTH = 0x400000;
    private static final byte FLG_DEFAULT = 104;
    private static final byte BD_DEFAULT = 112;

    private LZ4Encoder() {
    }

    public static byte[] encodeFromByte(byte[] byArray, int n) {
        int n2 = LZ4Encoder.getEstimatedCompressedSize(byArray.length);
        LZ4Encoder.checkEstimatedCompressedSize(n2);
        byte[] byArray2 = new byte[15 + n2];
        LZ4Encoder.writeFrameDescriptor(byArray2, byArray.length);
        int n3 = LZ4Encoder.nativeEncodeFromByte(byArray, byArray.length, byArray2, 15, byArray2.length, 0x400000, n, false, false);
        if (n3 < 0) {
            throw new IllegalStateException("Could not encode byte[] to LZ4, error code " + n3);
        }
        if (n3 != n2) {
            byArray2 = Arrays.copyOf(byArray2, 15 + n3);
        }
        return byArray2;
    }

    public static byte[] encodeFromShort(short[] sArray, int n) {
        int n2 = LZ4Encoder.getEstimatedCompressedSize(sArray.length * 2);
        LZ4Encoder.checkEstimatedCompressedSize(n2);
        byte[] byArray = new byte[15 + n2];
        LZ4Encoder.writeFrameDescriptor(byArray, sArray.length * 2);
        int n3 = LZ4Encoder.nativeEncodeFromShort(sArray, sArray.length * 2, byArray, 15, byArray.length, 0x400000, n, false, false);
        if (n3 < 0) {
            throw new IllegalStateException("Could not encode short[] to LZ4, error code " + n3);
        }
        if (n3 != n2) {
            byArray = Arrays.copyOf(byArray, 15 + n3);
        }
        return byArray;
    }

    public static byte[] encodeFromInt(int[] nArray, int n) {
        int n2 = LZ4Encoder.getEstimatedCompressedSize(nArray.length * 4);
        LZ4Encoder.checkEstimatedCompressedSize(n2);
        byte[] byArray = new byte[15 + n2];
        LZ4Encoder.writeFrameDescriptor(byArray, nArray.length * 4);
        int n3 = LZ4Encoder.nativeEncodeFromInt(nArray, nArray.length * 4, byArray, 15, byArray.length, 0x400000, n, false, false);
        if (n3 < 0) {
            throw new IllegalStateException("Could not encode int[] to LZ4, error code " + n3);
        }
        if (n3 != n2) {
            byArray = Arrays.copyOf(byArray, 15 + n3);
        }
        return byArray;
    }

    private static void writeFrameDescriptor(byte[] byArray, int n) {
        LZ4Encoder.writeInt(byArray, 0, 407708164);
        LZ4Encoder.writeInt(byArray, 4, 104);
        LZ4Encoder.writeInt(byArray, 5, 112);
        LZ4Encoder.writeInt(byArray, 6, n);
        LZ4Encoder.writeInt(byArray, 10, 0);
    }

    private static void writeInt(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 & 0xFF);
        byArray[n++] = (byte)(n2 >> 8 & 0xFF);
        byArray[n++] = (byte)(n2 >> 16 & 0xFF);
        byArray[n] = (byte)(n2 >> 24 & 0xFF);
    }

    private static int getEstimatedCompressedSize(int n) {
        int n2 = n / 0x400000;
        int n3 = n % 0x400000;
        int n4 = LZ4Encoder.nativeCompressedSizeEstimation(n2 * 0x400000 + n3);
        int n5 = Math.max(1, n2 + 1) * 4;
        return n4 + n5;
    }

    private static void checkEstimatedCompressedSize(int n) {
        if (n + 15 < 0) {
            throw new IllegalStateException("Could not encode LZ4, negative estimated output size (" + n + ")");
        }
    }

    private static native int nativeCompressedSizeEstimation(int var0);

    private static native int nativeEncodeFromByte(byte[] var0, int var1, byte[] var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    private static native int nativeEncodeFromShort(short[] var0, int var1, byte[] var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);

    private static native int nativeEncodeFromInt(int[] var0, int var1, byte[] var2, int var3, int var4, int var5, int var6, boolean var7, boolean var8);
}

