/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.util.resource.locale.localization_plugin;

import com.visustt.tools.ab.ac;
import com.visustt.tools.ab.ad;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.util.resource.locale.localization_plugin.LocalizationPluginException;
import com.visustt.tools.util.resource.locale.localization_plugin.aa;
import com.visustt.tools.util.resource.locale.localization_plugin.ab;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class LocalizationPlugin {
    private Logger logger = LoggerFactory.getInstance("visus.localization");
    private Set<Locale> availableLanguages = ad.aa();
    private Set<Locale> blockedLanguages = ad.aa();
    private Set<ab> pluginInfos;
    private String appVersion;

    public LocalizationPlugin(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        this.appVersion = attributes.getValue("PROP_PRODUCT_VERSION");
        String string = attributes.getValue("PROP_PRODUCT_RC");
        String string2 = attributes.getValue("TranslationAcceptedForVersions");
        String string3 = attributes.getValue("TranslationRequiredModules");
        this.initPluginLanguages(this.appVersion, string, string2, string3);
    }

    private void initPluginLanguages(String string, String string2, String string3, String string4) throws IOException {
        this.availableLanguages.add(Locale.ENGLISH);
        this.availableLanguages.add(Locale.GERMAN);
        this.pluginInfos = this.getLocalizationPluginInfos();
        HashMap<String, ab> hashMap = ac.aa();
        for (ab ab5 : this.pluginInfos) {
            try {
                if (this.logger.debugIsEnabled()) {
                    this.logger.debug("LocalizationPluginInfo=" + ab5.aa);
                }
            }
            catch (IOException iOException) {
                throw LocalizationPlugin.a(iOException);
            }
            this.checkDoubleLanguageLocalizations(hashMap, ab5);
        }
        for (ab ab5 : this.pluginInfos) {
            this.checkVersionForLocalizations(string, string2, string3, string4, ab5);
        }
    }

    private void checkVersionForLocalizations(String string, String string2, String string3, String string4, ab ab5) {
        if (ab5.ac(string4)) {
            if (!ab5.aa(string, string2, string3)) {
                ab5.aj = string;
                this.logger.warn(ab5.ab());
            }
            this.availableLanguages.add(new Locale(ab5.ad));
        } else {
            this.blockedLanguages.add(new Locale(ab5.ad));
            ab5.ai = aa.aa(string4, ab5.ae);
            this.logger.warn(ab5.ad());
        }
    }

    private void checkDoubleLanguageLocalizations(Map<String, ab> map, ab ab5) {
        String string = ab5.ad;
        if (map.containsKey(string)) {
            ab ab6 = map.get(string);
            ab6.ak = true;
            this.logger.error(ab6.ab());
        } else if ("de".equals(string) || "en".equals(string)) {
            ab5.ak = true;
            this.logger.error(ab5.ab());
        } else {
            map.put(string, ab5);
        }
    }

    public void checkLocalizationClassPath() throws LocalizationPluginException {
        for (String string : this.getLocalizationClassPath()) {
            try {
                if (string.toLowerCase().matches(".*[/\\\\]jivexresources_..\\.jar")) continue;
                throw new LocalizationPluginException("invalid JAR within plugin-directory localization/: '" + string + "'. Only language plugins named 'jiveXResources_XX.jar' are allowed within the localization directory.");
            }
            catch (LocalizationPluginException localizationPluginException) {
                throw LocalizationPlugin.a(localizationPluginException);
            }
        }
    }

    public String getLanguageMisconfigureWarning(Locale locale) {
        ab ab5 = this.getPluginInfo(locale);
        if (ab5 != null) {
            return ab5.ab();
        }
        return "";
    }

    public String getPluginValidationWarning(Locale locale) {
        ab ab5 = this.getPluginInfo(locale);
        if (ab5 != null) {
            return ab5.ac();
        }
        return "";
    }

    public String getLanguageRemovedError(Locale locale) {
        ab ab5 = this.getPluginInfo(locale);
        if (ab5 != null) {
            return ab5.ad();
        }
        return "";
    }

    private ab getPluginInfo(Locale locale) {
        Locale locale2 = new Locale(locale.getLanguage());
        for (ab ab5 : this.pluginInfos) {
            if (!locale2.equals(new Locale(ab5.ad))) continue;
            return ab5;
        }
        return null;
    }

    public Set<Locale> getAvailableLanguages() {
        return new HashSet<Locale>(this.availableLanguages);
    }

    public Set<Locale> getBlockedLanguages() {
        return new HashSet<Locale>(this.blockedLanguages);
    }

    private Set<ab> getLocalizationPluginInfos() throws IOException {
        List<URL> list = this.getManifestURLs();
        HashSet<ab> hashSet = ad.aa();
        for (URL uRL : list) {
            ab ab5;
            block12: {
                ab5 = new ab(uRL);
                try {
                    block11: {
                        try {
                            try {
                                try {
                                    try {
                                        if (!ab5.aa()) continue;
                                        if (ab5.ad == null) break block11;
                                    }
                                    catch (IOException iOException) {
                                        throw LocalizationPlugin.a(iOException);
                                    }
                                    if (ab5.ab == null) break block11;
                                }
                                catch (IOException iOException) {
                                    throw LocalizationPlugin.a(iOException);
                                }
                                if (ab5.ac == null) break block11;
                            }
                            catch (IOException iOException) {
                                throw LocalizationPlugin.a(iOException);
                            }
                            if (ab5.ae != null) break block12;
                        }
                        catch (IOException iOException) {
                            throw LocalizationPlugin.a(iOException);
                        }
                    }
                    this.logger.error("corrupt language-plugin Manifest '" + uRL + "' - missing attributes");
                    continue;
                }
                catch (IOException iOException) {
                    throw LocalizationPlugin.a(iOException);
                }
            }
            hashSet.add(ab5);
        }
        return hashSet;
    }

    protected List<URL> getManifestURLs() throws IOException {
        Enumeration<URL> enumeration = LocalizationPlugin.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        return Collections.list(enumeration);
    }

    protected Set<String> getLocalizationClassPath() {
        String string = this.getClassPath();
        HashSet<String> hashSet = ad.aa();
        for (String string2 : string.split(File.pathSeparator)) {
            if (!string2.toLowerCase().matches(".*[/\\\\]localization[/\\\\].*") || string2.matches(".*[/\\\\]\\*")) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    protected String getClassPath() {
        return System.getProperty("java.class.path");
    }

    public void setVersioninPluginInfosforValidation(String string, String string2) {
        for (ab ab5 : this.pluginInfos) {
            ab5.aj = this.appVersion;
            ab5.ab = string;
            ab5.ac = string2;
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

