/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.util.jar;

import com.visustt.tools.control.license.util.VisusVersionString;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.util.jar.aa;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ManifestAnalyzer {
    private static final String VALUE_RC = "rc";
    private static final String VALUE_TRUE = "true";
    private static final String VALUE_SRV_E_BUILD = "srv-e-build";
    private static final Logger LOGGER = LoggerFactory.getInstance("jx.manifest.init");
    private static final String PROP_PRODUCT_VERSION = "PROP_PRODUCT_VERSION";
    private static final String PROP_PRODUCT_RELEASED = "PROP_PRODUCT_RELEASED";
    private static final String PROP_PRODUCT_RC = "PROP_PRODUCT_RC";
    private static final String PROP_BUILD_HOST = "PROP_BUILD_HOST";
    private static Manifest applicationManifest;
    private static Manifest backupManifest;
    private static boolean isReleased;
    private static boolean alreadyInitialized;
    private static boolean loggingEnabled;
    private static String JX_DEBUG_VALIDATE_RISK_MITIGATION_MEASURES;
    private static Attributes mainAttributes;
    private static final Pattern APP_VERSION_PATTERN;

    private ManifestAnalyzer() {
    }

    private static synchronized void init(Manifest manifest, boolean bl) {
        ManifestAnalyzer.reset();
        loggingEnabled = bl;
        applicationManifest = manifest;
        if (manifest == null) {
            if (bl) {
                LOGGER.error("Missing MANIFEST.MF for application - no released version.");
            }
            return;
        }
        mainAttributes = manifest.getMainAttributes();
        ManifestAnalyzer.setIsReleasedVersion();
        alreadyInitialized = true;
    }

    public static void init(Manifest manifest) {
        ManifestAnalyzer.init(manifest, true);
    }

    public static boolean checkIsManifestReleased(Manifest manifest) {
        backupManifest = applicationManifest;
        ManifestAnalyzer.init(manifest, false);
        boolean bl = ManifestAnalyzer.isReleasedVersion();
        ManifestAnalyzer.init(backupManifest, false);
        loggingEnabled = true;
        return bl;
    }

    public static void setJXDebugValidateRiskMitigationMeasures(boolean bl) {
        if (bl) {
            System.setProperty(JX_DEBUG_VALIDATE_RISK_MITIGATION_MEASURES, VALUE_TRUE);
        } else {
            System.setProperty(JX_DEBUG_VALIDATE_RISK_MITIGATION_MEASURES, "false");
        }
    }

    public static boolean isAlreadyInitialized() {
        return alreadyInitialized;
    }

    /*
     * Loose catch block
     */
    private static void setIsReleasedVersion() {
        block28: {
            if (mainAttributes == null) break block28;
            try {
                block29: {
                    boolean bl;
                    String string;
                    block27: {
                        block26: {
                            String string2;
                            block32: {
                                boolean bl2;
                                String string3;
                                block25: {
                                    block24: {
                                        block30: {
                                            string = mainAttributes.getValue(PROP_BUILD_HOST);
                                            string3 = mainAttributes.getValue(PROP_PRODUCT_RC);
                                            string2 = mainAttributes.getValue(PROP_PRODUCT_RELEASED);
                                            if (string3 == null) break block24;
                                            if (string2 == null) break block24;
                                            break block30;
                                            catch (Exception exception) {
                                                throw ManifestAnalyzer.a(exception);
                                            }
                                        }
                                        try {
                                            block31: {
                                                if (string == null) break block24;
                                                break block31;
                                                catch (Exception exception) {
                                                    throw ManifestAnalyzer.a(exception);
                                                }
                                            }
                                            bl2 = true;
                                            break block25;
                                        }
                                        catch (Exception exception) {
                                            throw ManifestAnalyzer.a(exception);
                                        }
                                    }
                                    bl2 = false;
                                }
                                boolean bl3 = bl2;
                                if (!bl3) break block26;
                                if (!ManifestAnalyzer.isRC(string3)) break block26;
                                break block32;
                                catch (Exception exception) {
                                    throw ManifestAnalyzer.a(exception);
                                }
                            }
                            try {
                                block33: {
                                    if (!ManifestAnalyzer.isReleased(string2)) break block26;
                                    break block33;
                                    catch (Exception exception) {
                                        throw ManifestAnalyzer.a(exception);
                                    }
                                }
                                bl = true;
                                break block27;
                            }
                            catch (Exception exception) {
                                throw ManifestAnalyzer.a(exception);
                            }
                        }
                        bl = false;
                    }
                    boolean bl4 = bl;
                    if (!bl4) break block28;
                    try {
                        block34: {
                            if (ManifestAnalyzer.validBuildsystem(string)) break block29;
                            break block34;
                            catch (Exception exception) {
                                throw ManifestAnalyzer.a(exception);
                            }
                        }
                        if (!ManifestAnalyzer.isPatch()) break block28;
                    }
                    catch (Exception exception) {
                        throw ManifestAnalyzer.a(exception);
                    }
                }
                isReleased = true;
                return;
            }
            catch (Exception exception) {
                try {
                    if (loggingEnabled) {
                        LOGGER.warn("Invalid manifest");
                    }
                }
                catch (Exception exception2) {
                    throw ManifestAnalyzer.a(exception2);
                }
            }
        }
        try {
            if (loggingEnabled) {
                LOGGER.warn("Application is not a released version.");
            }
        }
        catch (Exception exception) {
            throw ManifestAnalyzer.a(exception);
        }
        isReleased = false;
    }

    private static boolean validBuildsystem(String string) {
        return string.toLowerCase().contains(VALUE_SRV_E_BUILD);
    }

    private static boolean isReleased(String string) {
        return string.toLowerCase().contains(VALUE_TRUE);
    }

    private static boolean isRC(String string) {
        return string.toLowerCase().contains(VALUE_RC);
    }

    public static boolean isDebugModeEnabled() {
        return Boolean.getBoolean(JX_DEBUG_VALIDATE_RISK_MITIGATION_MEASURES);
    }

    public static synchronized boolean isReleasedVersion() {
        if (ManifestAnalyzer.isDebugModeEnabled()) {
            return false;
        }
        if (ManifestAnalyzer.isPatch()) {
            return true;
        }
        if (!alreadyInitialized && loggingEnabled) {
            LOGGER.warn("ManifestAnalyzer has not been initialized!");
        }
        return isReleased;
    }

    private static boolean isPatch() {
        if (mainAttributes != null) {
            String string = mainAttributes.getValue(PROP_PRODUCT_VERSION);
            if (string == null) {
                if (loggingEnabled) {
                    LOGGER.warn("Manifest incomplete. PROP_PRODUCT_VERSION is missing");
                }
                return false;
            }
            if (!ManifestAnalyzer.isValidAppVersion(string)) {
                return false;
            }
            String string2 = new VisusVersionString(string).getVersionExtra();
            int n = 0;
            if (ManifestAnalyzer.isInteger(string2)) {
                n = Integer.parseInt(string2);
            }
            return n > 0;
        }
        return false;
    }

    protected static boolean isValidAppVersion(String string) {
        Matcher matcher = APP_VERSION_PATTERN.matcher(string);
        int n = 0;
        while (matcher.find()) {
            ++n;
        }
        return n <= 1 && (n != 1 || Character.isLetter(string.charAt(string.length() - 1)));
    }

    protected static boolean isInteger(String string) {
        return ManifestAnalyzer.isInteger(string, 10);
    }

    private static boolean isInteger(String string, int n) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (!(i == 0 && string.charAt(i) == '-' ? string.length() == 1 : Character.digit(string.charAt(i), n) < 0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isServerReleased(Map map) {
        try {
            String string = (String)map.get(PROP_PRODUCT_RELEASED);
            String string2 = (String)map.get(PROP_PRODUCT_RC);
            String string3 = (String)map.get(PROP_BUILD_HOST);
            String string4 = (String)map.get(PROP_PRODUCT_VERSION);
            Manifest manifest = aa.aa(string2, string, string3, string4);
            return ManifestAnalyzer.checkIsManifestReleased(manifest);
        }
        catch (Exception exception) {
            LOGGER.debug("Check, if server is released has failed");
            return false;
        }
    }

    private static void reset() {
        alreadyInitialized = false;
        isReleased = false;
        mainAttributes = null;
        loggingEnabled = true;
    }

    public static void destroy() {
        alreadyInitialized = false;
        isReleased = false;
        mainAttributes = null;
        loggingEnabled = true;
        backupManifest = null;
        applicationManifest = null;
    }

    static {
        isReleased = false;
        alreadyInitialized = false;
        loggingEnabled = true;
        JX_DEBUG_VALIDATE_RISK_MITIGATION_MEASURES = "jx.debug.validate_risk_mitigation_measures";
        APP_VERSION_PATTERN = Pattern.compile("[a-zA-Z]{1}+");
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

