/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.text;

import com.visustt.tools.lang.StringTool;
import com.visustt.tools.text.ab.ab;
import com.visustt.tools.text.ab.ac;
import com.visustt.tools.text.al;
import com.visustt.tools.text.am;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;

public class DateUtils {
    public static final long MINUTES_DAY = 1440L;
    public static final long SECONDS_HOUR = 3600L;
    public static final long SECONDS_DAY = 86400L;
    public static final long MILLISECONDS_MINUTE = 60000L;
    public static final long MILLISECONDS_HOUR = 3600000L;
    public static final long MILLISECONDS_DAY = 86400000L;
    public static final String dateFormaterPattern = "dd.MM.yyyy";
    public static final String isoDateFormaterPattern = "yyyy-MM-dd";
    public static final String simpleDateTimeFormaterPattern = "yy-MM-dd HH:mm";
    public static final String simpleDateFormaterPattern = "yyyyMMdd";
    public static final String simpleDateFormaterPattern2 = "ddMMyyyy";
    public static final String isoDateTimeFormaterPattern = "yyyy-MM-dd'T'HH:mm:ss.SSSSSS";
    public static final String simpleIsoDateTimeFormaterPattern = "yyyy-MM-dd HH:mm:ss";
    public static final String sqlTimestampFormaterPattern = "yyyy-MM-dd HH:mm:ss.S";
    @Deprecated
    public static final String mysqlDateTimePattern = "yyyyMMddHHmmss";
    public static final String mySQLTimestampFormaterPattern = "yyyyMMddHHmmss";
    public static final al mysqlDateTimeSDF = am.aa("yyyyMMddHHmmss");
    public static final String dicomDateTimeFormatter = "yyyyMMddHHmmss.SSSSSS";
    public static final String longDateTimeFormaterPattern = "yyyyMMddHHmmssSSS";
    public static final String notSoLongDateTimeFormaterPattern = "yyyyMMdd'T'HHmmss";
    public static final String isoDateTimeFormaterPattern_old = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String longLogDateTimeFormaterPattern = "d. MMMM yyyy HH:mm:ss z";
    public static final String fileDateTimeFormaterPattern = "yyyy_MM_dd_HH_mm_ss_SSSSSS";
    public static final String isoDateTimeWithZonePattern = "yyyy-MM-dd'T'HH:mm:ssX";
    public static final String isoDateTimeWithLongZonePattern = "yyyy-MM-dd'T'HH:mm:ssXXX";
    public static final String FILE_DATE_YEAR_AND_MONTH_FORMATTER_PATTERN = "yyyy_MM";
    public static String fileDateDayFormaterPattern = "dd";
    public static final String isoTimeFormaterPattern = "'T'HH:mm:ss.SSSSSS";
    public static final String dateTimeFormaterPattern = "dd.MM.yyyy:HH.mm.ss";
    public static final String timeFormaterPattern = "HH:mm:ss:SSSSSS";
    public static final String timeDicomFormaterPattern = "HH:mm:ss.SSSSSS";
    public static final String simpleTimeFormaterPattern = "HH:mm:ss";
    public static final String shortTimeFormaterPattern = "HH:mm";
    public static final String shortDcmTMFormaterPattern = "HHmmss";
    public static final al simpleDateSDF = am.aa("yyyyMMdd");
    public static final al simpleTimeSDF = am.aa("HH:mm:ss");
    public static final al timeDicomSDF = am.aa("HH:mm:ss.SSSSSS");
    public static final al shortDicomTimeSDF = am.aa("HHmmss");
    public static final al simpleIsoDateTimeSDF = am.aa("yyyy-MM-dd HH:mm:ss");
    public static final al dicomDttmSDF = am.aa("yyyyMMddHHmmss.SSSSSS");
    public static final al isoDateSDF = am.aa("yyyy-MM-dd");
    public static final al isoDateTimeOldSDF = am.aa("yyyy-MM-dd'T'HH:mm:ss");
    public static final al isoSDF = am.aa("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
    public static final al longSDF = am.aa("yyyyMMddHHmmssSSS");
    public static final al nSLongSDF = am.aa("yyyyMMdd'T'HHmmss");

    public static final boolean isToday(Date date) {
        boolean bl;
        try {
            bl = date.getTime() / 86400000L == System.currentTimeMillis() / 86400000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return bl;
    }

    public static final boolean isToday(Calendar calendar) {
        boolean bl;
        try {
            bl = calendar.getTimeInMillis() / 86400000L == System.currentTimeMillis() / 86400000L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return bl;
    }

    public static final Date addMinutes(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, n);
        return calendar.getTime();
    }

    public static final Date addDays(int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static final Date addDays(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static final Date addMillis(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(14, n);
        return calendar.getTime();
    }

    public static final Date addSeconds(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, n);
        return calendar.getTime();
    }

    public static final Calendar addDays(int n, Calendar calendar) {
        calendar.add(5, n);
        return calendar;
    }

    public static final Calendar addMinutes(int n, Calendar calendar) {
        calendar.add(12, n);
        return calendar;
    }

    public static final Calendar createDateWithoutTime(Calendar calendar) {
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static final Calendar createDateWithoutSeconds(Calendar calendar) {
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static final boolean isLastDays(Calendar calendar, int n, Calendar calendar2) {
        boolean bl;
        Calendar calendar3 = DateUtils.addDays(n, DateUtils.createDateWithoutTime(calendar));
        Calendar calendar4 = DateUtils.createDateWithoutTime(calendar2);
        try {
            bl = calendar3.getTime().getTime() >= calendar4.getTime().getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return bl;
    }

    public static Date caluculateDateHour(int n) {
        Calendar calendar;
        block3: {
            block2: {
                calendar = Calendar.getInstance();
                try {
                    if (n < 0) break block2;
                    calendar.add(10, -n);
                    break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DateUtils.a(illegalArgumentException);
                }
            }
            calendar.add(12, n);
        }
        return calendar.getTime();
    }

    public static final boolean isLastMinutes(Calendar calendar, int n, Calendar calendar2) {
        boolean bl;
        try {
            if (calendar == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        Calendar calendar3 = DateUtils.addMinutes(n, DateUtils.createDateWithoutSeconds(calendar));
        Calendar calendar4 = DateUtils.createDateWithoutSeconds(calendar2);
        try {
            bl = calendar3.getTime().getTime() >= calendar4.getTime().getTime();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return bl;
    }

    public static long getDiffNumberOfDays(Calendar calendar, Calendar calendar2) {
        long l = calendar.getTime().getTime() - calendar2.getTime().getTime();
        if (l < 0L) {
            l = -l;
        }
        return l / 86400000L;
    }

    public static long getDiffNumberOfDays(Date date, Date date2) {
        long l = date.getTime() - date2.getTime();
        if (l < 0L) {
            l = -l;
        }
        return l / 86400000L;
    }

    public static int getDaysBetween(Date date, Date date2) {
        LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = date2.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        return (int)ChronoUnit.DAYS.between(localDate, localDate2);
    }

    public static long getDiffNumberOfHours(Calendar calendar, Calendar calendar2) {
        long l = calendar.getTime().getTime() - calendar2.getTime().getTime();
        if (l < 0L) {
            l = -l;
        }
        return l / 86400000L;
    }

    public static final Date createDateFromTimeDefinition(Date date) {
        Calendar calendar;
        block9: {
            block10: {
                calendar = Calendar.getInstance();
                try {
                    if (date == null) {
                        return calendar.getTime();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DateUtils.a(illegalArgumentException);
                }
                try {
                    try {
                        try {
                            if (calendar.get(11) < date.getHours()) break block9;
                            if (calendar.get(11) != date.getHours()) break block10;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        if (calendar.get(12) < date.getMinutes()) break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DateUtils.a(illegalArgumentException);
                    }
                    calendar.add(5, 1);
                    break block9;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DateUtils.a(illegalArgumentException);
                }
            }
            calendar.add(5, 1);
        }
        calendar.set(11, date.getHours());
        calendar.set(12, date.getMinutes());
        calendar.set(13, date.getSeconds());
        return calendar.getTime();
    }

    public static long getMillisecondsWaitForHourRange(Calendar calendar, int n, int n2) {
        block11: {
            int n3;
            block9: {
                block10: {
                    n3 = calendar.get(11);
                    try {
                        try {
                            try {
                                if (n >= n2) break block9;
                                if (n3 < n) break block10;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DateUtils.a(illegalArgumentException);
                            }
                            if (n3 >= n2) break block10;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        return 0L;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DateUtils.a(illegalArgumentException);
                    }
                }
                Calendar calendar2 = (Calendar)calendar.clone();
                calendar2.set(11, n);
                calendar2.set(12, 0);
                calendar2.set(13, 0);
                calendar2.set(14, 0);
                if (n3 >= n) {
                    calendar2.set(11, 24);
                    long l = calendar2.getTime().getTime() - calendar.getTime().getTime();
                    return l + (long)(n * 60 * 60 * 1000);
                }
                calendar2.set(11, n);
                return calendar2.getTime().getTime() - calendar.getTime().getTime();
            }
            try {
                if (n3 >= n || n3 < n2) break block11;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DateUtils.a(illegalArgumentException);
            }
            Calendar calendar3 = (Calendar)calendar.clone();
            calendar3.set(11, n);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            return calendar3.getTime().getTime() - calendar.getTime().getTime();
        }
        return 0L;
    }

    public static Date parseIsoDateTimeString(String string) throws ParseException {
        block4: {
            try {
                try {
                    if (string != null && string.trim().length() != 0) break block4;
                }
                catch (ParseException parseException) {
                    throw DateUtils.a(parseException);
                }
                return null;
            }
            catch (ParseException parseException) {
                throw DateUtils.a(parseException);
            }
        }
        return isoSDF.aa(string);
    }

    public static Date parseLongDateTimeString(String string) throws ParseException {
        block4: {
            try {
                try {
                    if (string != null && string.trim().length() != 0) break block4;
                }
                catch (ParseException parseException) {
                    throw DateUtils.a(parseException);
                }
                return null;
            }
            catch (ParseException parseException) {
                throw DateUtils.a(parseException);
            }
        }
        return longSDF.aa(string);
    }

    public static long formatLongDateTime(Date date) {
        return Long.valueOf(longSDF.aa(date));
    }

    public static Date parseLongTimeStamp(long l) throws ParseException {
        String string;
        block4: {
            string = String.valueOf(l);
            try {
                try {
                    if (string != null && string.trim().length() == 14) break block4;
                }
                catch (ParseException parseException) {
                    throw DateUtils.a(parseException);
                }
                return null;
            }
            catch (ParseException parseException) {
                throw DateUtils.a(parseException);
            }
        }
        return mysqlDateTimeSDF.aa(string);
    }

    public static long formatLongTimeStamp(Date date) {
        return Long.valueOf(mysqlDateTimeSDF.aa(date));
    }

    public static String format(long l, String string) {
        return DateUtils.format(new Date(l), string);
    }

    public static String format(Date date, String string) {
        return am.aa(string).aa(date);
    }

    public static Date hl7toDate(String string) throws ParseException {
        if (StringTool.isDefined(string)) {
            String string2 = DateUtils.guessDateFormat(string);
            return new Date(DateUtils.parse(string, string2));
        }
        return null;
    }

    public static long parse(String string, String string2) throws ParseException {
        al al2 = am.aa(string2);
        Date date = al2.aa(string);
        return date.getTime();
    }

    public static final String guessDateFormat(String string) {
        block60: {
            block62: {
                block58: {
                    block56: {
                        block55: {
                            try {
                                try {
                                    if (string != null && !"".equals(string)) break block55;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DateUtils.a(illegalArgumentException);
                                }
                                return null;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DateUtils.a(illegalArgumentException);
                            }
                        }
                        try {
                            if (string.matches("^((1|2)\\d\\d\\d)$")) {
                                return "yyyy";
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^((1|2)\\d\\d\\d)-(0[1-9]|1[0-2])$")) {
                                return "yyyy-MM";
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^(\\d{4})-(\\d{2})-(\\d{2})$")) {
                                return isoDateFormaterPattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^(\\d{2})\\.(\\d{2})\\.(\\d{4})$")) {
                                return dateFormaterPattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^(\\d{8})T(\\d{6})$")) {
                                return notSoLongDateTimeFormaterPattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^((\\d{4})-(\\d{2})-(\\d{2})) (\\d{2}:\\d{2}:\\d{2})$")) {
                                return simpleIsoDateTimeFormaterPattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^((\\d{4})-(\\d{2})-(\\d{2}))T(\\d{2}:\\d{2}:\\d{2})$")) {
                                return isoDateTimeFormaterPattern_old;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^((\\d{4})-(\\d{2})-(\\d{2}))T(\\d{2}:\\d{2}:\\d{2}.\\d+)$")) {
                                return isoDateTimeFormaterPattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^((\\d{4})-(\\d{2})-(\\d{2}))T(\\d{2}:\\d{2}:\\d{2})((\\+|-)(((0[0-9]|1[0-3])(:?)[0-5][0-9])|14:00))$")) {
                                return isoDateTimeWithZonePattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            if (string.matches("^(\\d{4})-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}\\.\\d$")) {
                                return sqlTimestampFormaterPattern;
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        try {
                            block57: {
                                try {
                                    try {
                                        if (!string.matches("^(\\d{14})$")) break block56;
                                        if ("19".equals(string.substring(0, 2))) break block57;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw DateUtils.a(illegalArgumentException);
                                    }
                                    if (!"20".equals(string.substring(0, 2))) break block56;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DateUtils.a(illegalArgumentException);
                                }
                            }
                            return "yyyyMMddHHmmss";
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                    }
                    try {
                        block59: {
                            try {
                                try {
                                    if (!string.matches("^(\\d{12})$")) break block58;
                                    if ("19".equals(string.substring(0, 2))) break block59;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DateUtils.a(illegalArgumentException);
                                }
                                if (!"20".equals(string.substring(0, 2))) break block58;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DateUtils.a(illegalArgumentException);
                            }
                        }
                        return "yyyyMMhhHHmm";
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DateUtils.a(illegalArgumentException);
                    }
                }
                try {
                    block61: {
                        try {
                            try {
                                if (!string.matches("^(\\d{8})$")) break block60;
                                if ("19".equals(string.substring(4, 6))) break block61;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DateUtils.a(illegalArgumentException);
                            }
                            if (!"20".equals(string.substring(4, 6))) break block62;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                    }
                    return simpleDateFormaterPattern2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DateUtils.a(illegalArgumentException);
                }
            }
            return simpleDateFormaterPattern;
        }
        try {
            if (string.matches("^(\\d{4})_(\\d{2})$")) {
                return FILE_DATE_YEAR_AND_MONTH_FORMATTER_PATTERN;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return null;
    }

    public static String guessTimeFormat(String string) {
        block25: {
            try {
                try {
                    if (string != null && !"".equals(string)) break block25;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DateUtils.a(illegalArgumentException);
                }
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DateUtils.a(illegalArgumentException);
            }
        }
        try {
            if (string.matches("^(\\d{2}):(\\d{2}):(\\d{2}):(\\d{6})$")) {
                return timeFormaterPattern;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (string.matches("^(\\d{2}):(\\d{2}):(\\d{2}).(\\d{6})$")) {
                return timeDicomFormaterPattern;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (string.matches("^(\\d{2}):(\\d{2}):(\\d{2})$")) {
                return simpleTimeFormaterPattern;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (string.toLowerCase().matches("^(\\d{2}):(\\d{2}):(\\d{2}) ([ap]m)$")) {
                return "HH:mm:ss a";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (string.matches("^(\\d{2}):(\\d{2})$")) {
                return shortTimeFormaterPattern;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (string.matches("^(\\d{6})$")) {
                return shortDcmTMFormaterPattern;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (string.matches("^(\\d{4})$")) {
                return "HHmm";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return null;
    }

    public static String transformFormat(String string, String string2, String string3) throws ParseException {
        block13: {
            try {
                if (string == null) {
                    return null;
                }
            }
            catch (ParseException parseException) {
                throw DateUtils.a(parseException);
            }
            try {
                try {
                    if (string2 != null && string3 != null) break block13;
                }
                catch (ParseException parseException) {
                    throw DateUtils.a(parseException);
                }
                throw new IllegalArgumentException("Source (" + string2 + ") and destination (" + string3 + ") date format must not be null.");
            }
            catch (ParseException parseException) {
                throw DateUtils.a(parseException);
            }
        }
        int n = StringTool.eraseString(string2, "'").length();
        int n2 = string.length();
        try {
            if (n == n2) {
                return DateUtils.transformFormat_(string, string2, string3);
            }
        }
        catch (ParseException parseException) {
            throw DateUtils.a(parseException);
        }
        try {
            if (n < n2) {
                return DateUtils.transformFormat_(string.substring(0, n), string2, string3);
            }
        }
        catch (ParseException parseException) {
            throw DateUtils.a(parseException);
        }
        return DateUtils.transformFormat_(string, string2.substring(0, string.length()), string3);
    }

    private static String transformFormat_(String string, String string2, String string3) throws ParseException {
        return am.aa(string3).aa(am.aa(string2).aa(string));
    }

    public static Date setMinTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date setMaxTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date setTime(Date date, Date date2) {
        Calendar calendar = DateUtils.getCalendar(date);
        Calendar calendar2 = DateUtils.getCalendar(date2);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        calendar.set(14, calendar2.get(14));
        return calendar.getTime();
    }

    public static long getTime(Date date) {
        Calendar calendar = DateUtils.getCalendar(date);
        long l = 0L;
        l += (long)calendar.get(11) * 3600000L;
        l += (long)calendar.get(12) * 60000L;
        l += (long)(calendar.get(13) * 1000);
        return l += (long)calendar.get(14);
    }

    public static Calendar getCalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int getAge(Date date) {
        int n;
        block7: {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(date);
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
            n = gregorianCalendar2.get(1) - gregorianCalendar.get(1);
            try {
                block6: {
                    try {
                        try {
                            if (gregorianCalendar.get(2) > gregorianCalendar2.get(2)) break block6;
                            if (gregorianCalendar.get(2) != gregorianCalendar2.get(2)) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        if (gregorianCalendar.get(5) <= gregorianCalendar2.get(5)) break block7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DateUtils.a(illegalArgumentException);
                    }
                }
                --n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DateUtils.a(illegalArgumentException);
            }
        }
        return n;
    }

    public static final String getRoundedUpRetentionTime(long l) {
        if (l > 0L) {
            return isoDateSDF.aa(new Date(l += 86399999L));
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static final String getRoundedUpRetentionTime(String string) {
        block6: {
            if (string == null) break block6;
            try {
                block7: {
                    if (string.trim().equals("")) break block6;
                    break block7;
                    catch (Exception exception) {
                        throw DateUtils.a(exception);
                    }
                }
                if (string.equals("null")) break block6;
            }
            catch (Exception exception) {
                throw DateUtils.a(exception);
            }
            try {
                return DateUtils.getRoundedUpRetentionTime((long)Double.parseDouble(string));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static final long copyDaytime(Date date, Date date2) throws IllegalArgumentException {
        try {
            if (date == null) {
                throw new IllegalArgumentException("The date value can't be null!");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        try {
            if (date2 == null) {
                throw new IllegalArgumentException("The time value can't be null!");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(date);
        calendar2.setTime(date2);
        calendar.set(11, calendar2.get(11));
        calendar.set(12, calendar2.get(12));
        calendar.set(13, calendar2.get(13));
        calendar.set(14, calendar2.get(14));
        return calendar.getTimeInMillis();
    }

    public static final String replaceDate(String string) {
        return ab.aa(string, new aa(), false);
    }

    public static long[] getDurationComponents(long l) {
        long l2 = l / 86400000L;
        long l3 = (l %= 86400000L) / 3600000L;
        long l4 = (l %= 3600000L) / 60000L;
        long l5 = (l %= 60000L) / 1000L;
        long l6 = l % 1000L;
        return new long[]{l2, l3, l4, l5, l6};
    }

    public static boolean areSameDate(Date date, Date date2) {
        boolean bl;
        block14: {
            try {
                if (date == date2) {
                    return true;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DateUtils.a(illegalArgumentException);
            }
            try {
                block13: {
                    try {
                        try {
                            try {
                                if (date != null && date2 == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DateUtils.a(illegalArgumentException);
                            }
                            if (date != null) break block14;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DateUtils.a(illegalArgumentException);
                        }
                        if (date2 == null) break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DateUtils.a(illegalArgumentException);
                    }
                }
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DateUtils.a(illegalArgumentException);
            }
        }
        try {
            bl = DateUtils.getDiffNumberOfDays(date, date2) == 0L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public static String reformatDate(String string, String string2, String string3) {
        block7: {
            if (string2 == null) break block7;
            try {
                block8: {
                    if (!string2.equals(string3)) break block7;
                    break block8;
                    catch (Exception exception) {
                        throw DateUtils.a(exception);
                    }
                }
                return string;
            }
            catch (Exception exception) {
                throw DateUtils.a(exception);
            }
        }
        try {
            if (StringTool.isDefined(string.toString())) {
                return DateUtils.transformFormat(String.valueOf(string), string2, string3);
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error changing date format from \"" + string2 + "\" to \"" + string3 + "\" for value: '" + String.valueOf(string) + "'", exception);
        }
        return string;
    }

    public static Date convertLocalToUtc(Date date) {
        return DateUtils.convertTimezone(date, ZoneId.systemDefault(), ZoneId.of("UTC"));
    }

    public static Date convertUtcToLocal(Date date) {
        return DateUtils.convertTimezone(date, ZoneId.of("UTC"), ZoneId.systemDefault());
    }

    protected static Date convertTimezone(Date date, ZoneId zoneId, ZoneId zoneId2) {
        try {
            if (date == null) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DateUtils.a(illegalArgumentException);
        }
        Instant instant = date.toInstant();
        int n = ZonedDateTime.ofInstant(instant, zoneId).getOffset().getTotalSeconds();
        int n2 = ZonedDateTime.ofInstant(instant, zoneId2).getOffset().getTotalSeconds();
        long l = (long)(n2 - n) * 1000L;
        return new Date(date.getTime() + l);
    }

    public static String getTimestamp(String string) {
        return DateTimeFormatter.ofPattern(string).format(ZonedDateTime.now());
    }

    public static String getUTCTimestamp(String string) {
        return ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern(string));
    }

    public static String convertDate(String string, String string2, String string3) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string3);
        Date date = simpleDateFormat.parse(string);
        return simpleDateFormat2.format(date);
    }

    public static Date getStart(String string) throws ParseException {
        String string2 = DateUtils.guessDateFormat(string);
        return new SimpleDateFormat(string2).parse(string);
    }

    public static Date getEnd(String string) throws ParseException {
        String string2 = DateUtils.guessDateFormat(string);
        try {
            if (string2 == null) {
                throw new ParseException("invalid date fragment", 0);
            }
        }
        catch (ParseException parseException) {
            throw DateUtils.a(parseException);
        }
        Date date = new SimpleDateFormat(string2).parse(string);
        Calendar calendar = Calendar.getInstance();
        try {
            calendar.setTime(date);
            if ("yyyy".equals(string2)) {
                calendar.set(2, 11);
            }
        }
        catch (ParseException parseException) {
            throw DateUtils.a(parseException);
        }
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    static class aa
    implements ac {
        aa() {
        }

        @Override
        public String aa(String string) {
            if (string == null) {
                return null;
            }
            if (!string.startsWith("now")) {
                return string;
            }
            long l = System.currentTimeMillis();
            String string2 = DateUtils.simpleDateFormaterPattern;
            if (!string.equals("now")) {
                String string3 = string.substring(3);
                int n = string3.indexOf(58);
                if (n != -1) {
                    string2 = string3.substring(n + 1);
                    if ((string3 = string3.substring(0, n)).length() > 0 && string3.charAt(0) == '+') {
                        string3 = string3.substring(1);
                    }
                }
                if (string3.length() > 0) {
                    l += com.visustt.tools.ah.ab.aa(string3);
                }
            }
            return DateUtils.format(l, string2);
        }

        @Override
        public Set aa() {
            return null;
        }
    }
}

