/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.system;

import com.visustt.nativeWin32.NoSuchFunctionException;
import com.visustt.nativeWin32.aa;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.system.LibLoader;
import com.visustt.tools.system.OSVersion;
import com.visustt.tools.system.ac;
import java.lang.management.ManagementFactory;
import java.util.List;

public class SystemProperties
implements aa {
    private static Logger logger;
    private static final long PROGRAM_START_TIME;
    private static Long XMX;
    private static boolean libraryLoaded;

    private static void logWarning(Throwable throwable) {
        block3: {
            block2: {
                try {
                    if (!Boolean.getBoolean("jx.win.systemproperties.logwarnings")) break block2;
                    logger.warn(throwable);
                    break block3;
                }
                catch (NumberFormatException numberFormatException) {
                    throw SystemProperties.a(numberFormatException);
                }
            }
            logger.info(throwable);
        }
    }

    public static int winOS_getProcessorSpeed() {
        int n = -1;
        if (libraryLoaded) {
            try {
                n = SystemProperties.getWindowsProcessorSpeed();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return n;
    }

    public static long getMaxHeapSize() {
        if (XMX == null) {
            Object object;
            long l;
            block15: {
                l = 0L;
                try {
                    List<String> list;
                    object = ManagementFactory.getRuntimeMXBean();
                    if (object == null || (list = object.getInputArguments()) == null) break block15;
                    for (String string : list) {
                        if (string == null || !(string = string.trim()).startsWith("-Xmx")) continue;
                        l = com.visustt.tools.ah.aa.aa(string.substring(4));
                        break;
                    }
                }
                catch (Throwable throwable) {
                    SystemProperties.logWarning(throwable);
                }
            }
            if (l == 0L) {
                try {
                    object = System.getProperty("com.visustt.jre.mem.max", "0").replace('\"', ' ').trim();
                    l = Long.parseLong((String)object) * 1024L * 1024L;
                }
                catch (Exception exception) {
                    SystemProperties.logWarning(exception);
                }
            }
            if (l == 0L) {
                try {
                    object = System.getProperty("com.visustt.jre.max_heap_size", "0").replace('\"', ' ').trim();
                    l = Long.parseLong((String)object) * 1024L * 1024L;
                }
                catch (Exception exception) {
                    SystemProperties.logWarning(exception);
                }
            }
            if (l == 0L) {
                try {
                    object = System.getProperty("jnlpx.heapsize", "0,0").replace('\"', ' ').trim();
                    int n = ((String)object).indexOf(44);
                    if (n != -1) {
                        object = ((String)object).substring(n + 1);
                        l = com.visustt.tools.ah.aa.aa((String)object);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    SystemProperties.logWarning(numberFormatException);
                }
            }
            if (l == 0L) {
                l = Runtime.getRuntime().maxMemory();
            }
            XMX = l;
        }
        return XMX;
    }

    private static native int getWindowsProcessorSpeed();

    private static native int getWindowsProcessorCount();

    private static native String getWindowsProcessorType();

    private static native String getWindowsUserName();

    private static native int getWindowsMainMemory();

    private static native String getDLLVersion(String var0);

    private static native String getExecutableVersion(String var0, boolean var1);

    private static native String getOwnDLLVersion();

    private static native boolean isWindowsProcessRunning(String var0);

    private static native boolean isWindowsUserAdmin();

    private static native boolean killWindowsProcess(String var0);

    private static native boolean exitVoxarClient();

    public static native boolean isWindowsVirtualMachine();

    private static native boolean isWin64();

    private static native boolean setSystemFileCacheSize(long var0) throws Exception;

    private static native long getSystemFileCacheSize() throws Exception;

    public static int winOS_getNumberOfProcessors() {
        int n = -1;
        if (libraryLoaded) {
            try {
                n = SystemProperties.getWindowsProcessorCount();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        if (n <= 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        return n;
    }

    public static String winOS_getProcessorType() {
        String string = "";
        if (libraryLoaded) {
            try {
                string = SystemProperties.getWindowsProcessorType();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return string;
    }

    public static int winOS_getMainMemory() {
        int n = -1;
        if (libraryLoaded) {
            try {
                n = SystemProperties.getWindowsMainMemory();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return n;
    }

    public static String winOS_getOwnDLLVersion() {
        String string = "0.0.0.0";
        if (libraryLoaded) {
            try {
                string = SystemProperties.getOwnDLLVersion();
            }
            catch (Throwable throwable) {
                SystemProperties.logWarning(throwable);
            }
        }
        return string;
    }

    public static String winOS_getDLLVersion(String string) {
        String string2 = "0.0.0.0";
        if (libraryLoaded) {
            try {
                string2 = SystemProperties.getDLLVersion(string);
            }
            catch (Throwable throwable) {
                SystemProperties.logWarning(throwable);
            }
        }
        return string2;
    }

    public static String winOS_getExecutableVersion(String string, boolean bl) {
        String string2 = "0.0.0.0";
        if (libraryLoaded) {
            try {
                try {
                    if (logger.debugIsEnabled()) {
                        logger.debug("getExecutableVersion(" + string + "," + bl + ")");
                    }
                }
                catch (Throwable throwable) {
                    throw SystemProperties.a(throwable);
                }
                string2 = SystemProperties.getExecutableVersion(string, bl);
                try {
                    if (logger.debugIsEnabled()) {
                        logger.debug("getExecutableVersion(" + string + "," + bl + ")=" + string2);
                    }
                }
                catch (Throwable throwable) {
                    throw SystemProperties.a(throwable);
                }
            }
            catch (Throwable throwable) {
                SystemProperties.logWarning(throwable);
            }
        }
        return string2;
    }

    public static String winOS_getCurrentUserName() {
        String string = "";
        if (libraryLoaded) {
            try {
                string = SystemProperties.getWindowsUserName();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return string;
    }

    public static boolean winOS_isUserAdmin() {
        return SystemProperties.isWindowsUserAdmin();
    }

    public static boolean isProcessRunning(String string) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (!OSVersion.isWindows() || !libraryLoaded) break block4;
            }
            catch (Exception exception) {
                throw SystemProperties.a(exception);
            }
            try {
                bl = SystemProperties.isWindowsProcessRunning(string);
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return bl;
    }

    public static boolean exitVoxar() {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (!OSVersion.isWindows() || !libraryLoaded) break block4;
            }
            catch (Exception exception) {
                throw SystemProperties.a(exception);
            }
            try {
                bl = SystemProperties.exitVoxarClient();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return bl;
    }

    public static boolean killProcess(String string) {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (!OSVersion.isWindows() || !libraryLoaded) break block4;
            }
            catch (Exception exception) {
                throw SystemProperties.a(exception);
            }
            try {
                bl = SystemProperties.killWindowsProcess(string);
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return bl;
    }

    public static long getProgramStartTime() {
        return PROGRAM_START_TIME;
    }

    public static boolean winOS_isWin64() {
        boolean bl;
        block4: {
            bl = false;
            try {
                if (!OSVersion.isWindows() || !libraryLoaded) break block4;
            }
            catch (Exception exception) {
                throw SystemProperties.a(exception);
            }
            try {
                bl = SystemProperties.isWin64();
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public static boolean winOS_setSystemFileCacheSize(long l) {
        boolean bl;
        block11: {
            bl = false;
            if (!OSVersion.isWindows()) break block11;
            try {
                block14: {
                    if (l <= 0L) break block11;
                    break block14;
                    catch (NoSuchFunctionException noSuchFunctionException) {
                        throw SystemProperties.a(noSuchFunctionException);
                    }
                }
                if (!libraryLoaded) break block11;
            }
            catch (NoSuchFunctionException noSuchFunctionException) {
                throw SystemProperties.a(noSuchFunctionException);
            }
            try {
                block12: {
                    block13: {
                        if (ac.aa()) break block12;
                        long l2 = l >> 31;
                        if (l2 <= 0L) break block12;
                        try {
                            block15: {
                                if (!logger.warnIsEnabled()) break block13;
                                break block15;
                                catch (NoSuchFunctionException noSuchFunctionException) {
                                    throw SystemProperties.a(noSuchFunctionException);
                                }
                            }
                            logger.warn("A system file cache size of " + l + " is not applicable with 32 bit. Limiting the value to about 2048MB.");
                        }
                        catch (NoSuchFunctionException noSuchFunctionException) {
                            throw SystemProperties.a(noSuchFunctionException);
                        }
                    }
                    l = Integer.MAX_VALUE;
                }
                bl = SystemProperties.setSystemFileCacheSize(l);
            }
            catch (NoSuchFunctionException noSuchFunctionException) {
                SystemProperties.logWarning(noSuchFunctionException);
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return bl;
    }

    public static long winOS_getSystemFileCacheSize() {
        long l;
        block5: {
            l = -1L;
            try {
                if (!OSVersion.isWindows() || !libraryLoaded) break block5;
            }
            catch (NoSuchFunctionException noSuchFunctionException) {
                throw SystemProperties.a(noSuchFunctionException);
            }
            try {
                l = SystemProperties.getSystemFileCacheSize();
            }
            catch (NoSuchFunctionException noSuchFunctionException) {
                SystemProperties.logWarning(noSuchFunctionException);
            }
            catch (Exception exception) {
                SystemProperties.logWarning(exception);
            }
        }
        return l;
    }

    static {
        block7: {
            try {
                logger = LoggerFactory.getInstance("jx.win.systemproperties");
                PROGRAM_START_TIME = System.currentTimeMillis();
                libraryLoaded = false;
                libraryLoaded = LibLoader.loadLibrary("VisusClient");
                if (!libraryLoaded) {
                    libraryLoaded = LibLoader.loadLibrary("VisusServer");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw SystemProperties.a(numberFormatException);
            }
            try {
                try {
                    if (!OSVersion.isWindows() || libraryLoaded) break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw SystemProperties.a(numberFormatException);
                }
                logger.info("* MISSING RESOURCE:VisusClient and VisusServer not loaded!");
            }
            catch (NumberFormatException numberFormatException) {
                throw SystemProperties.a(numberFormatException);
            }
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

