/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.system;

import com.visustt.tools.system.SystemProperties;
import com.visustt.tools.system.ac;

public class OSVersion {
    private static final String NT_UNKNOWN = "nt (unknown)";
    private static final String OS_VERSION = "os.version";
    private static final String OS_NAME = "os.name";
    private static final String DEFAULT_OS_NAME = "error";
    private static final String OS_ARCHITECTURE = "os.arch";
    private static Boolean isWindows = null;
    private static Boolean isWindowsNTOrLater = null;
    private static Boolean isWindowsXP = null;
    private static Boolean isWindows2000 = null;
    private static Boolean isWindows2003 = null;
    private static Boolean isWindowsVista = null;
    private static Boolean isWindows7 = null;
    private static Boolean isWindows8 = null;
    private static Boolean isWindows8Point1 = null;
    private static Boolean isWindows10 = null;
    private static Boolean isWindows11 = null;
    private static Boolean isWindowsServer2008 = null;
    private static Boolean isWindowsServer2008R1 = null;
    private static Boolean isWindowsServer2012 = null;
    private static Boolean isWindowsServer2012R2 = null;
    private static Boolean isArchX86 = null;
    private static Boolean isSolaris = null;
    private static Boolean isApple = null;
    private static Boolean isLinux = null;
    private static Boolean is64BitOS = null;

    private OSVersion() {
    }

    public static boolean isArchX86() {
        if (isArchX86 == null) {
            boolean bl = OSVersion.isApple() ? "i386".equalsIgnoreCase(System.getProperty(OS_ARCHITECTURE, "")) : (OSVersion.isLinux() ? !"64".endsWith(System.getProperty(OS_ARCHITECTURE, "")) : "x86".equalsIgnoreCase(System.getProperty(OS_ARCHITECTURE, "")));
            isArchX86 = bl;
        }
        return isArchX86;
    }

    public static boolean isSolaris() {
        if (isSolaris == null) {
            boolean bl = System.getProperty(OS_NAME, DEFAULT_OS_NAME).toLowerCase().startsWith("sunos");
            isSolaris = bl;
        }
        return isSolaris;
    }

    public static boolean isWindows() {
        if (isWindows == null) {
            boolean bl = System.getProperty(OS_NAME, DEFAULT_OS_NAME).toLowerCase().startsWith("windows");
            isWindows = bl;
        }
        return isWindows;
    }

    public static boolean isWindowsServer2008R1() {
        if (isWindowsServer2008R1 == null) {
            boolean bl = OSVersion.isWindowsServer2008() && "6.0".equals(System.getProperty(OS_VERSION, DEFAULT_OS_NAME));
            isWindowsServer2008R1 = bl;
        }
        return isWindowsServer2008R1;
    }

    public static boolean isWindowsServer2012R2() {
        if (isWindowsServer2012R2 == null) {
            boolean bl = OSVersion.isWindowsServer2012() && "6.3".equals(System.getProperty(OS_VERSION, DEFAULT_OS_NAME));
            isWindowsServer2012R2 = bl;
        }
        return isWindowsServer2012R2;
    }

    public static boolean isWindowsNTOrLater() {
        if (isWindowsNTOrLater == null) {
            boolean bl = false;
            if (OSVersion.isWindows()) {
                String string = System.getProperty(OS_VERSION, "") + ".";
                if (string.length() > 1) {
                    try {
                        boolean bl2;
                        int n = string.indexOf(46);
                        String string2 = string.substring(0, n).trim();
                        int n2 = Integer.parseInt(string2);
                        try {
                            bl2 = n2 >= 5;
                        }
                        catch (Exception exception) {
                            throw OSVersion.a(exception);
                        }
                        bl = bl2;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (!bl) {
                    boolean bl3;
                    block18: {
                        block17: {
                            String string3 = System.getProperty(OS_NAME, DEFAULT_OS_NAME).toLowerCase();
                            try {
                                block16: {
                                    try {
                                        try {
                                            try {
                                                if (string3.indexOf("nt") >= 0 || OSVersion.isWindows2000()) break block16;
                                            }
                                            catch (Exception exception) {
                                                throw OSVersion.a(exception);
                                            }
                                            if (OSVersion.isWindowsXPOrLater()) break block16;
                                        }
                                        catch (Exception exception) {
                                            throw OSVersion.a(exception);
                                        }
                                        if (!OSVersion.isWindows2003()) break block17;
                                    }
                                    catch (Exception exception) {
                                        throw OSVersion.a(exception);
                                    }
                                }
                                bl3 = true;
                                break block18;
                            }
                            catch (Exception exception) {
                                throw OSVersion.a(exception);
                            }
                        }
                        bl3 = false;
                    }
                    bl = bl3;
                }
            }
            isWindowsNTOrLater = bl;
        }
        return isWindowsNTOrLater;
    }

    public static boolean isWindows2000() {
        if (isWindows2000 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            boolean bl = string != null && string.startsWith("windows 2000");
            isWindows2000 = bl;
        }
        return isWindows2000;
    }

    public static boolean isWindowsXP() {
        if (isWindowsXP == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            boolean bl = string != null && string.startsWith("windows xp");
            isWindowsXP = bl;
        }
        return isWindowsXP;
    }

    public static boolean isWindows2003() {
        if (isWindows2003 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            boolean bl = string != null && string.startsWith("windows 2003");
            isWindows2003 = bl;
        }
        return isWindows2003;
    }

    public static boolean isWindowsVista() {
        if (isWindowsVista == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            String string2 = System.getProperty(OS_VERSION, "").toLowerCase();
            boolean bl = false;
            if (string != null && !(bl = string.startsWith("windows vista")) && string2 != null) {
                bl = string.indexOf(NT_UNKNOWN) >= 0 && "6.0".equals(string2);
            }
            isWindowsVista = bl;
        }
        return isWindowsVista;
    }

    public static boolean isWindowsVistaOrLater() {
        return OSVersion.isWindowsVista() || OSVersion.isWindows7() || OSVersion.isWindows8OrLater();
    }

    public static boolean isWindows8OrLater() {
        return OSVersion.isWindows8() || OSVersion.isWindows8Point1() || OSVersion.isWindows10() || OSVersion.isWindows11();
    }

    public static boolean isWindows11() {
        if (isWindows11 == null) {
            isWindows11 = System.getProperty(OS_NAME, "").toLowerCase().startsWith("windows 11");
        }
        return isWindows11;
    }

    public static boolean isWindowsXPOrLater() {
        return OSVersion.isWindowsXP() || OSVersion.isWindowsVistaOrLater();
    }

    public static boolean isWindows7() {
        if (isWindows7 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            String string2 = System.getProperty(OS_VERSION, "").toLowerCase();
            boolean bl = false;
            if (string != null && !(bl = string.startsWith("windows 7")) && string2 != null) {
                bl = string.indexOf(NT_UNKNOWN) >= 0 && "6.1".equals(string2);
            }
            isWindows7 = bl;
        }
        return isWindows7;
    }

    public static boolean isWindows8() {
        if (isWindows8 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            String string2 = System.getProperty(OS_VERSION, "").toLowerCase();
            boolean bl = false;
            if (string != null && !(bl = string.startsWith("windows 8")) && string2 != null) {
                bl = string.indexOf(NT_UNKNOWN) >= 0 && "6.2".equals(string2);
            }
            isWindows8 = bl;
        }
        return isWindows8;
    }

    public static boolean isWindows8Point1() {
        if (isWindows8Point1 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            String string2 = System.getProperty(OS_VERSION, "").toLowerCase();
            boolean bl = false;
            if (string != null && !(bl = string.startsWith("windows 8")) && string2 != null) {
                bl = string.indexOf(NT_UNKNOWN) >= 0 && "6.3".equals(string2);
            }
            isWindows8Point1 = bl;
        }
        return isWindows8Point1;
    }

    public static boolean isWindows10() {
        if (isWindows10 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            String string2 = System.getProperty(OS_VERSION, "").toLowerCase();
            boolean bl = false;
            if (string != null && !(bl = string.startsWith("windows 10")) && string2 != null) {
                bl = string.indexOf(NT_UNKNOWN) >= 0 && "10.0".equals(string2);
            }
            isWindows10 = bl;
        }
        return isWindows10;
    }

    public static boolean isWindowsServerOS() {
        return OSVersion.isWindowsServer2008() || OSVersion.isWindowsServer2008R1() || OSVersion.isWindowsServer2012() || OSVersion.isWindowsServer2012R2();
    }

    public static boolean isWindowsServer2008() {
        if (isWindowsServer2008 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            boolean bl = string.startsWith("windows server 2008");
            isWindowsServer2008 = bl;
        }
        return isWindowsServer2008;
    }

    public static boolean isWindowsServer2012() {
        if (isWindowsServer2012 == null) {
            String string = System.getProperty(OS_NAME, "").toLowerCase();
            boolean bl = string.startsWith("windows server 2012");
            isWindowsServer2012 = bl;
        }
        return isWindowsServer2012;
    }

    public static boolean isWindows9x() {
        return OSVersion.isWindows() && !OSVersion.isWindowsNTOrLater();
    }

    public static boolean isApple() {
        if (isApple == null) {
            boolean bl = System.getProperty(OS_NAME, DEFAULT_OS_NAME).toLowerCase().equalsIgnoreCase("mac os x");
            boolean bl2 = !System.getProperty("mrj.version", DEFAULT_OS_NAME).equalsIgnoreCase(DEFAULT_OS_NAME);
            isApple = bl || bl2;
        }
        return isApple;
    }

    public static boolean isLinux() {
        if (isLinux == null) {
            boolean bl = System.getProperty(OS_NAME, DEFAULT_OS_NAME).toLowerCase().startsWith("linux");
            isLinux = bl;
        }
        return isLinux;
    }

    public static boolean is64BitOS() {
        if (is64BitOS == null) {
            boolean bl = ac.aa() ? true : (OSVersion.isArchX86() ? false : (OSVersion.isWindows() ? SystemProperties.winOS_isWin64() : true));
            is64BitOS = bl;
        }
        return is64BitOS;
    }

    static void resetFlagsCache() {
        isWindows = null;
        isWindowsNTOrLater = null;
        isWindowsXP = null;
        isWindows2000 = null;
        isWindows2003 = null;
        isWindowsVista = null;
        isWindows7 = null;
        isWindows8 = null;
        isWindows8Point1 = null;
        isWindows10 = null;
        isWindows11 = null;
        isWindowsServer2008 = null;
        isWindowsServer2008R1 = null;
        isWindowsServer2012 = null;
        isWindowsServer2012R2 = null;
        isArchX86 = null;
        isSolaris = null;
        isApple = null;
        isLinux = null;
        is64BitOS = null;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

