/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.system;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.FileIterator.aa;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.process.ad;
import com.visustt.tools.system.LibLoader;
import com.visustt.tools.system.OSVersion;
import com.visustt.tools.system.SystemProperties;
import com.visustt.tools.system.ac;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.filechooser.FileSystemView;

public class FilesystemProperties
implements com.visustt.nativeWin32.aa {
    public static final String MSVCR80DLL_VERSION_PREFIX = "8.0.50727.";
    private static FilesystemProperties theInstance;
    public static final int UNKNOWN_DRIVE_TYPE = -1;
    public static final int FIXED_DRIVE = 1;
    public static final int REMOVABLE_DRIVE = 2;
    public static final int NETWORK_DRIVE = 3;
    public static final int CDROM_DRIVE = 4;
    private static final long WINOS_DIR_COMMAND_TIMEOUT = 30000L;
    private static final long LINUX_DF_COMMAND_TIMEOUT = 30000L;
    private static final boolean DISABLE_NATIVE_SAME_PARTITION_CHECK;
    private static boolean libraryLoaded;
    private static boolean isFSCaseSensitive;
    private static final Logger logger;
    private static int DF_FREE_POS;
    private static int DF_SIZE_POS;
    private static long FILE_ATTRIBUTE_READONLY;

    private FilesystemProperties() {
    }

    private native String getWindowsDriveName(char var1);

    private native int getWindowsDriveType(char var1);

    private native long getWindowsDriveSizeUNC(String var1);

    private native long getWindowsDriveFreeUNC(String var1);

    private native boolean suppressWindowsNextAutorun(long var1);

    private native String getWindowsShortPath(String var1);

    private native boolean hasWindowsArchiveFlag(String var1);

    private native boolean hasWindowsFlag(String var1, long var2);

    private native boolean isWindowsSamePartition(String var1, String var2);

    public static String winOS_getDriveName(char c) {
        String string = "";
        if (libraryLoaded) {
            try {
                string = theInstance.getWindowsDriveName(c);
            }
            catch (Exception exception) {
                logger.error((Object)("winOS_getDriveName failed:" + exception), exception);
            }
        }
        return string;
    }

    public static String winOS_getShortPath(String string) {
        String string2 = string;
        if (libraryLoaded) {
            try {
                string2 = theInstance.getWindowsShortPath(string);
                if (string2.length() > string.length()) {
                    logger.warn("Short path: " + string2 + " is longer than long path: " + string + "! Using long path.");
                    string2 = string;
                }
            }
            catch (Exception exception) {
                logger.error((Object)("winOS_getShortPath failed:" + exception), exception);
            }
        }
        return string2;
    }

    public static boolean winOS_hasArchiveFlag(String string) {
        boolean bl = false;
        if (libraryLoaded) {
            try {
                bl = theInstance.hasWindowsArchiveFlag(string);
            }
            catch (Exception exception) {
                logger.error((Object)("winOS_hasArchiveFlag failed:" + exception), exception);
            }
        }
        return bl;
    }

    private static boolean winOS_hasFlag(String string, long l) {
        boolean bl = false;
        if (libraryLoaded) {
            try {
                bl = theInstance.hasWindowsFlag(string, l);
            }
            catch (Exception exception) {
                logger.error((Object)("winOS_hasArchiveFlag failed:" + exception), exception);
            }
        }
        return bl;
    }

    public static boolean winOS_hasReadOnlyFlag(String string) {
        return FilesystemProperties.winOS_hasFlag(string, FILE_ATTRIBUTE_READONLY);
    }

    public static int winOS_getDriveType(char c) {
        int n = -1;
        if (libraryLoaded) {
            try {
                n = theInstance.getWindowsDriveType(c);
            }
            catch (Exception exception) {
                logger.error((Object)("winOS_getDriveType failed:" + exception), exception);
            }
        }
        return n;
    }

    private static long winOS_getDriveSize(String string) {
        long l = 0L;
        if (libraryLoaded) {
            try {
                l = theInstance.getWindowsDriveSizeUNC(string);
            }
            catch (Exception exception) {
                logger.error((Object)("winOS_getDriveSize failed:" + exception), exception);
            }
        }
        return l;
    }

    private void winOS_supressNextAutorun(long l) {
        try {
            if (libraryLoaded) {
                new ab(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
    }

    public static void suppressNextAutorun(long l) {
        try {
            if (OSVersion.isWindows()) {
                theInstance.winOS_supressNextAutorun(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
    }

    private boolean winOS_isSamePartition(File file, File file2) {
        boolean bl;
        block6: {
            try {
                try {
                    if (!libraryLoaded || DISABLE_NATIVE_SAME_PARTITION_CHECK) break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw FilesystemProperties.a(numberFormatException);
                }
                return this.isWindowsSamePartition(file.getAbsolutePath(), file2.getAbsolutePath());
            }
            catch (NumberFormatException numberFormatException) {
                throw FilesystemProperties.a(numberFormatException);
            }
        }
        try {
            bl = file.getAbsolutePath().toLowerCase().charAt(0) == file2.getAbsolutePath().toLowerCase().charAt(0);
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
        return bl;
    }

    public static boolean isSamePartition(File file, File file2) throws IOException {
        block10: {
            try {
                if (OSVersion.isWindows()) {
                    return theInstance.winOS_isSamePartition(file, file2);
                }
            }
            catch (IOException iOException) {
                throw FilesystemProperties.a(iOException);
            }
            try {
                block9: {
                    try {
                        try {
                            if (OSVersion.isApple() || OSVersion.isLinux()) break block9;
                        }
                        catch (IOException iOException) {
                            throw FilesystemProperties.a(iOException);
                        }
                        if (!OSVersion.isSolaris()) break block10;
                    }
                    catch (IOException iOException) {
                        throw FilesystemProperties.a(iOException);
                    }
                }
                return FilesystemProperties.linux_isSamePartition(file, file2);
            }
            catch (IOException iOException) {
                throw FilesystemProperties.a(iOException);
            }
        }
        return false;
    }

    public static File detectDefaultImportDir() {
        return FilesystemProperties.detectDefaultImportDir(false);
    }

    public static File detectDefaultImportDirAllowEmpty() {
        return FilesystemProperties.detectDefaultImportDir(true);
    }

    private static File detectDefaultImportDir(boolean bl) {
        File file = null;
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        File[] fileArray = File.listRoots();
        for (int i = 0; i != fileArray.length; ++i) {
            File file2;
            block20: {
                block23: {
                    int n;
                    block21: {
                        block22: {
                            file2 = fileArray[i];
                            try {
                                try {
                                    try {
                                        try {
                                            if (!fileSystemView.isDrive(file2) || fileSystemView.isFloppyDrive(file2)) continue;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            throw FilesystemProperties.a(numberFormatException);
                                        }
                                        if (fileSystemView.isComputerNode(file2)) continue;
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw FilesystemProperties.a(numberFormatException);
                                    }
                                    if (!fileSystemView.isTraversable(file2).booleanValue()) continue;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw FilesystemProperties.a(numberFormatException);
                                }
                                if (!OSVersion.isWindows()) break block20;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                            String string = file2.getAbsolutePath();
                            if (string.charAt(1) != ':') continue;
                            char c = string.charAt(0);
                            n = FilesystemProperties.winOS_getDriveType(c);
                            try {
                                try {
                                    if (n != 4) break block21;
                                    if (bl) break block22;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw FilesystemProperties.a(numberFormatException);
                                }
                                if (FilesystemProperties.getDiskSize(file2) == 0L) break block21;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                        }
                        file = file2;
                        break;
                    }
                    try {
                        try {
                            try {
                                if (file != null || n != 1) continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                            if (bl) break block23;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw FilesystemProperties.a(numberFormatException);
                        }
                        if (FilesystemProperties.getDiskSize(file2) == 0L) continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                }
                file = file2;
                continue;
            }
            file = file2;
            break;
        }
        if (file == null) {
            file = fileSystemView.getDefaultDirectory();
        }
        return file;
    }

    public static long getDiskFree(File file) {
        return FilesystemProperties.getDiskFree_(file, false);
    }

    private static long getDiskFree_(File file, boolean bl) {
        long l;
        block12: {
            block10: {
                l = 0L;
                try {
                    try {
                        if (file != null && file.exists()) break block10;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    throw FilesystemProperties.a(numberFormatException);
                }
            }
            if (OSVersion.isWindows()) {
                l = FilesystemProperties.winOS_getDriveFree(file.getAbsolutePath());
            } else {
                block11: {
                    try {
                        try {
                            if (OSVersion.isApple() || OSVersion.isLinux()) break block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw FilesystemProperties.a(numberFormatException);
                        }
                        if (!OSVersion.isSolaris()) break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                }
                l = FilesystemProperties.linux_getDriveFree(file, bl);
            }
        }
        return l;
    }

    public static long getDiskFreeFromAWTEDT(File file) {
        return FilesystemProperties.getDiskFree_(file, true);
    }

    public static long getDiskSize(File file) {
        long l;
        block12: {
            block10: {
                l = 0L;
                try {
                    try {
                        if (file != null && file.exists()) break block10;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    throw FilesystemProperties.a(numberFormatException);
                }
            }
            if (OSVersion.isWindows()) {
                l = FilesystemProperties.winOS_getDriveSize(file.getAbsolutePath());
            } else {
                block11: {
                    try {
                        try {
                            if (OSVersion.isApple() || OSVersion.isLinux()) break block11;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw FilesystemProperties.a(numberFormatException);
                        }
                        if (!OSVersion.isSolaris()) break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                }
                l = FilesystemProperties.linux_getDriveSize(file, false);
            }
        }
        return l;
    }

    public static final long getFolderSize(File file, boolean bl) {
        return FilesystemProperties.getFolderSize(file, bl, null);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final long getFolderSize(File file, boolean bl, FilenameFilter filenameFilter) {
        long l;
        block13: {
            l = 0L;
            if (file == null) return l;
            try {
                if (file.isDirectory()) break block13;
                return l;
                catch (IOException iOException) {
                    throw FilesystemProperties.a(iOException);
                }
            }
            catch (IOException iOException) {
                throw FilesystemProperties.a(iOException);
            }
        }
        try {
            aa aa10;
            block18: {
                boolean bl2;
                boolean bl3;
                File file2;
                com.visustt.tools.io.FileIterator.ab ab5;
                com.visustt.tools.io.FileIterator.ab ab6;
                block14: {
                    boolean bl4;
                    boolean bl5;
                    File file3;
                    aa aa11;
                    aa aa12;
                    block16: {
                        block15: {
                            aa10 = null;
                            if (filenameFilter != null) break block14;
                            try {
                                block17: {
                                    aa aa13;
                                    aa12 = aa13;
                                    aa11 = aa13;
                                    file3 = file;
                                    bl5 = true;
                                    if (bl) break block15;
                                    break block17;
                                    catch (IOException iOException) {
                                        throw FilesystemProperties.a(iOException);
                                    }
                                }
                                bl4 = true;
                                break block16;
                            }
                            catch (IOException iOException) {
                                throw FilesystemProperties.a(iOException);
                            }
                        }
                        bl4 = false;
                    }
                    aa12(file3, bl5, bl4);
                    aa10 = aa11;
                    break block18;
                }
                try {
                    com.visustt.tools.io.FileIterator.ab ab7;
                    ab6 = ab7;
                    ab5 = ab7;
                    file2 = file;
                    bl3 = true;
                    bl2 = !bl;
                }
                catch (IOException iOException) {
                    throw FilesystemProperties.a(iOException);
                }
                ab6(file2, bl3, bl2, filenameFilter, false);
                aa10 = ab5;
            }
            while (aa10.hasNext()) {
                l += aa10.ab().length();
            }
            return l;
        }
        catch (IOException iOException) {
            logger.error((Object)("getFolderSize failed:" + iOException), iOException);
        }
        return l;
    }

    public static final long getFolderSize(File file) {
        return FilesystemProperties.getFolderSize(file, true);
    }

    private static long winOS_getDriveFree(String string) {
        long l;
        block5: {
            block6: {
                l = 0L;
                if (libraryLoaded) {
                    try {
                        l = theInstance.getWindowsDriveFreeUNC(string);
                    }
                    catch (Exception exception) {
                        l = -1L;
                        logger.error((Object)("winOS_getDriveFree failed:" + exception), exception);
                    }
                }
                try {
                    if (l >= 0L) break block5;
                    if (string.startsWith("\\\\")) break block6;
                }
                catch (Exception exception) {
                    throw FilesystemProperties.a(exception);
                }
                l = FilesystemProperties.winOS_getDriveFreeNoLibrary(string);
                break block5;
            }
            l = 0L;
        }
        return l;
    }

    /*
     * Loose catch block
     */
    private static long winOS_getDriveFreeNoLibrary(String string) {
        long l;
        block15: {
            l = 0L;
            Object object = string;
            if (((String)object).length() == 1) {
                object = (String)object + ":\\";
            }
            if (!((String)object).endsWith("\\")) {
                object = (String)object + "\\";
            }
            String string2 = "cmd.exe";
            if (OSVersion.isWindows9x()) {
                string2 = "command.com";
            }
            ad ad2 = new ad(string2, "/q/c " + string2 + "/q/c dir " + (String)object + "*.");
            String string3 = "byte";
            try {
                ad2.ab(30000L);
                ad2.ac();
                ad2.af();
                String[] stringArray = ad2.aa(0);
                try {
                    if (ad2.ae() != 0 || stringArray == null) break block15;
                }
                catch (Exception exception) {
                    throw FilesystemProperties.a(exception);
                }
                int n = stringArray.length - 1;
                while (true) {
                    block16: {
                        try {
                            if (n < 0) break block15;
                            if (stringArray[n].toLowerCase().indexOf(string3) <= 0) break block16;
                        }
                        catch (Exception exception) {
                            throw FilesystemProperties.a(exception);
                        }
                        String[] stringArray2 = StringTool.createStringArray(stringArray[n].trim(), " ");
                        int n2 = 0;
                        while (true) {
                            block17: {
                                if (n2 >= stringArray2.length) break block15;
                                try {
                                    block18: {
                                        if (!stringArray2[n2].toLowerCase().startsWith(string3)) break block17;
                                        break block18;
                                        catch (Exception exception) {
                                            throw FilesystemProperties.a(exception);
                                        }
                                    }
                                    if (n2 <= 0) break block17;
                                }
                                catch (Exception exception) {
                                    throw FilesystemProperties.a(exception);
                                }
                                l = Long.parseLong(StringTool.replaceString(stringArray2[n2 - 1].trim(), ".", ""));
                                break block15;
                            }
                            ++n2;
                        }
                    }
                    --n;
                }
            }
            catch (Exception exception) {
                FilesystemProperties.handleProcessException(ad2, exception, "winOS_getDriveFreeNoLibrary");
            }
        }
        return l;
    }

    private static long linux_getDriveFree(File file, boolean bl) {
        return FilesystemProperties.linux_getDFResult(file, DF_FREE_POS, bl);
    }

    private static long linux_getDriveSize(File file, boolean bl) {
        return FilesystemProperties.linux_getDFResult(file, DF_SIZE_POS, bl);
    }

    private static long linux_getDFResult(File file, int n, boolean bl) {
        long l;
        block11: {
            l = 0L;
            String string = StringTool.replaceString(file.getAbsolutePath(), " ", "\\ ");
            ad ad2 = new ad("df", "-k " + string, file.getAbsolutePath());
            String string2 = "/";
            try {
                block10: {
                    ad2.ab(30000L);
                    ad2.aa(bl);
                    ad2.ac();
                    ad2.af();
                    String[] stringArray = ad2.aa(0);
                    try {
                        if (ad2.ae() != 0 || stringArray == null) break block10;
                    }
                    catch (Exception exception) {
                        throw FilesystemProperties.a(exception);
                    }
                    int n2 = stringArray.length - 1;
                    while (true) {
                        block12: {
                            try {
                                if (n2 < 0) break block11;
                                if (stringArray[n2].toLowerCase().indexOf(string2) < 0) break block12;
                            }
                            catch (Exception exception) {
                                throw FilesystemProperties.a(exception);
                            }
                            String[] stringArray2 = StringTool.createStringArray(stringArray[n2].trim(), " ");
                            try {
                                if (Character.isDigit(stringArray2[0].charAt(0))) {
                                    --n;
                                }
                            }
                            catch (Exception exception) {
                                throw FilesystemProperties.a(exception);
                            }
                            l = Long.parseLong(StringTool.replaceString(stringArray2[n].trim(), ".", ""));
                            l *= 1024L;
                            break block11;
                        }
                        --n2;
                    }
                }
                logger.error(ad2 + " failed.");
            }
            catch (Exception exception) {
                FilesystemProperties.handleProcessException(ad2, exception, "linux_getDFResult");
            }
        }
        return l;
    }

    private static boolean linux_isSamePartition(File file, File file2) {
        return FilesystemProperties.linux_getPartition(file).equals(FilesystemProperties.linux_getPartition(file2));
    }

    private static String linux_getPartition(File file) {
        String string;
        block12: {
            string = null;
            try {
                if (!file.exists()) {
                    return string;
                }
            }
            catch (Exception exception) {
                throw FilesystemProperties.a(exception);
            }
            ad ad2 = new ad("df", "-k " + StringTool.replaceString(file.getAbsolutePath(), " ", "\\ "), file.getAbsolutePath());
            try {
                block11: {
                    ad2.ab(30000L);
                    ad2.aa(true);
                    ad2.ac();
                    ad2.af();
                    String[] stringArray = ad2.aa(0);
                    try {
                        if (ad2.ae() != 0 || stringArray == null) break block11;
                    }
                    catch (Exception exception) {
                        throw FilesystemProperties.a(exception);
                    }
                    String string2 = null;
                    for (int i = stringArray.length - 1; i >= 0; --i) {
                        int n = stringArray[i].lastIndexOf(37);
                        if (n == -1) continue;
                        String string3 = stringArray[i].substring(n + 1).trim();
                        if (string3.equals("/")) {
                            string2 = stringArray[i].substring(0, stringArray[i].indexOf("  "));
                            continue;
                        }
                        if (!file.getAbsolutePath().startsWith(string3)) continue;
                        string = stringArray[i].substring(0, stringArray[i].indexOf("  "));
                    }
                    try {
                        if (string != null || string2 == null) break block12;
                    }
                    catch (Exception exception) {
                        throw FilesystemProperties.a(exception);
                    }
                    string = string2;
                    break block12;
                }
                logger.error("linux_getPartition() '" + ad2.ab() + "' failed: exitcode=" + ad2.ae());
            }
            catch (Exception exception) {
                FilesystemProperties.handleProcessException(ad2, exception, "linux_getPartition");
            }
        }
        return string;
    }

    private static void handleProcessException(ad ad2, Exception exception, String string) {
        block5: {
            if (ad2.ak()) {
                StringBuilder stringBuilder = new StringBuilder(2024);
                stringBuilder.append(string);
                stringBuilder.append(" '");
                stringBuilder.append(ad2.ab());
                stringBuilder.append("' ");
                stringBuilder.append(ad2.as());
                stringBuilder.append("' timed out after ");
                stringBuilder.append(ad2.ai() / 1000L);
                stringBuilder.append("s");
                logger.warn((Object)stringBuilder.toString(), exception);
            } else {
                block4: {
                    try {
                        if (!(exception instanceof InterruptedException)) break block4;
                        logger.warn((Object)(string + ": " + exception + " for process " + ad2), exception);
                        break block5;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                }
                String[] stringArray = ad2.aa(0);
                String[] stringArray2 = ad2.aa(1);
                String string2 = StringTool.createString(stringArray, "\n");
                String string3 = StringTool.createString(stringArray2, "\n");
                logger.error((Object)(string + " failed:" + ad2 + ".\nstdout:\n" + string2 + "\nstderr:\n" + string3), exception);
            }
        }
    }

    public static boolean winOS_setDriveName(File file, String string) {
        return FilesystemProperties.winOS_setDriveName(file, string, true);
    }

    /*
     * Loose catch block
     */
    public static boolean winOS_setDriveName(File file, String string, boolean bl) {
        block14: {
            if (!OSVersion.isWindows()) break block14;
            try {
                block15: {
                    if (!file.exists()) break block14;
                    break block15;
                    catch (IOException iOException) {
                        throw FilesystemProperties.a(iOException);
                    }
                }
                if (file.getAbsolutePath().charAt(1) != ':') break block14;
            }
            catch (IOException iOException) {
                throw FilesystemProperties.a(iOException);
            }
            ad ad2 = new ad("label", file.getAbsolutePath().substring(0, 2) + " " + string);
            try {
                String[] stringArray;
                ad2.ab(30000L);
                ad2.ac();
                if (string.equals("")) {
                    Thread.sleep(2000L);
                    stringArray = ad2.ar();
                    stringArray.write("\r\n".getBytes());
                    stringArray.flush();
                    Thread.sleep(100L);
                    try {
                        stringArray.write("y\r\n".getBytes());
                        stringArray.flush();
                        Thread.sleep(100L);
                        stringArray.write("j\r\n".getBytes());
                        stringArray.flush();
                        Thread.sleep(100L);
                        stringArray.write("o\r\n".getBytes());
                        stringArray.flush();
                        Thread.sleep(100L);
                        stringArray.write("s\r\n".getBytes());
                        stringArray.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                ad2.af();
                stringArray = ad2.aa(1);
                if (ad2.ae() == 0) {
                    return true;
                }
                if (bl) {
                    logger.error("winOS_setDriveName() '" + ad2.ab() + "' failed: exitcode=" + ad2.ae() + "\n" + StringTool.createString(stringArray, "\n"));
                }
            }
            catch (Exception exception) {
                try {
                    if (bl) {
                        FilesystemProperties.handleProcessException(ad2, exception, "winOS_setDriveName");
                    }
                }
                catch (IOException iOException) {
                    throw FilesystemProperties.a(iOException);
                }
            }
        }
        return false;
    }

    public static boolean winOS_libraryAvailable() {
        return libraryLoaded;
    }

    public static boolean isFSCaseSensitive() {
        return isFSCaseSensitive;
    }

    public static final File getWritableTempFolder() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        try {
            if (FilesystemProperties.testFolder(file)) {
                return file;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
        file = new File(System.getProperty("user.home"));
        try {
            if (FilesystemProperties.testFolder(file)) {
                return file;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
        return null;
    }

    private static final boolean testFolder(File file) {
        block5: {
            if (file.isDirectory()) {
                try {
                    File file2 = new File(file, "test");
                    try {
                        if (!file2.createNewFile() || !file2.delete()) break block5;
                    }
                    catch (Exception exception) {
                        throw FilesystemProperties.a(exception);
                    }
                    return true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public static final int winOS_getLatestMSVCR80DLLVersionNo() {
        int n = 0;
        if (libraryLoaded) {
            block40: {
                block41: {
                    File[] fileArray;
                    String string;
                    String string2;
                    block34: {
                        block35: {
                            String string3;
                            String string4 = System.getenv("SystemRoot");
                            string2 = string4 + "\\winsxs\\";
                            try {
                                string3 = ac.aa() ? "amd64" : "x86";
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                            String string5 = string3;
                            string = string5 + "_microsoft.vc80.crt_1fc8b3b9a1e18e3b_8.0.50727.";
                            fileArray = new File(string2).listFiles(new FilenameFilter(){

                                @Override
                                public boolean accept(File file, String string2) {
                                    return string2.startsWith(string);
                                }
                            });
                            try {
                                try {
                                    if (fileArray.length != 0) break block34;
                                    if (!logger.debugIsEnabled()) break block35;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw FilesystemProperties.a(numberFormatException);
                                }
                                logger.debug("No MSVCR80 folder found. Search paths: " + string2 + string + "*");
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                        }
                        return 0;
                    }
                    for (File file : fileArray) {
                        String string6;
                        block36: {
                            int n2;
                            String string7;
                            block38: {
                                String string8;
                                block39: {
                                    block37: {
                                        string7 = file.getName();
                                        string6 = string2 + string7 + "\\msvcr80.dll";
                                        try {
                                            try {
                                                if (!new File(string6).exists()) break block36;
                                                if (!logger.debugIsEnabled()) break block37;
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                throw FilesystemProperties.a(numberFormatException);
                                            }
                                            logger.debug("File exists: " + string6);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            throw FilesystemProperties.a(numberFormatException);
                                        }
                                    }
                                    string8 = SystemProperties.winOS_getDLLVersion(string6);
                                    try {
                                        try {
                                            if (!StringTool.isDefined(string8)) break block38;
                                            if (!logger.debugIsEnabled()) break block39;
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            throw FilesystemProperties.a(numberFormatException);
                                        }
                                        logger.debug("DLL version is: " + string8);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        throw FilesystemProperties.a(numberFormatException);
                                    }
                                }
                                int n3 = string8.lastIndexOf(46);
                                n2 = Integer.valueOf(string8.substring(n3 + 1));
                                try {
                                    if (logger.debugIsEnabled()) {
                                        logger.debug("Short version is: " + n2);
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw FilesystemProperties.a(numberFormatException);
                                }
                                n = Math.max(n, n2);
                                continue;
                            }
                            try {
                                if (logger.debugIsEnabled()) {
                                    logger.debug("Could not determine DLL version. Parsing pathname.");
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                            String string9 = string7.substring(52);
                            n2 = string9.indexOf("_");
                            if (n2 <= 0) continue;
                            String string10 = string9.substring(0, n2);
                            int n4 = Integer.valueOf(string10);
                            try {
                                if (logger.debugIsEnabled()) {
                                    logger.debug("Short version is: " + n4);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw FilesystemProperties.a(numberFormatException);
                            }
                            n = Math.max(n, n4);
                            continue;
                        }
                        try {
                            if (!logger.debugIsEnabled()) continue;
                            logger.debug("File does not exist: " + string6);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw FilesystemProperties.a(numberFormatException);
                        }
                    }
                    try {
                        try {
                            if (n != 0) break block40;
                            if (!logger.debugIsEnabled()) break block41;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw FilesystemProperties.a(numberFormatException);
                        }
                        logger.debug("Could not find a version number for 'MSVCR80.DLL's in folders: " + string2 + string + "*");
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw FilesystemProperties.a(numberFormatException);
                    }
                }
                return 0;
            }
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("Detected max. version number: " + n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw FilesystemProperties.a(numberFormatException);
            }
        }
        return n;
    }

    static {
        boolean bl;
        try {
            theInstance = null;
            DISABLE_NATIVE_SAME_PARTITION_CHECK = Boolean.getBoolean("jx.util.filesystem.disableNativeSamePartitionCheck");
            libraryLoaded = false;
            isFSCaseSensitive = false;
            libraryLoaded = LibLoader.loadLibrary("VisusClient");
            if (!libraryLoaded) {
                libraryLoaded = LibLoader.loadLibrary("VisusServer");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
        try {
            theInstance = new FilesystemProperties();
            bl = !new File("aaa").equals(new File("AAA"));
        }
        catch (NumberFormatException numberFormatException) {
            throw FilesystemProperties.a(numberFormatException);
        }
        isFSCaseSensitive = bl;
        logger = LoggerFactory.getInstance("jx.util.filesystem");
        DF_FREE_POS = 3;
        DF_SIZE_POS = 1;
        String string = null;
        try {
            string = System.getProperty("jx.df.free.position");
            try {
                if (string != null) {
                    DF_FREE_POS = Integer.parseInt(string) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw FilesystemProperties.a(numberFormatException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Illegal value for property jx.df.free.position: " + string);
        }
        String string2 = null;
        try {
            string2 = System.getProperty("jx.df.size.position");
            try {
                if (string2 != null) {
                    DF_SIZE_POS = Integer.parseInt(string2) - 1;
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw FilesystemProperties.a(numberFormatException);
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Illegal value for property jx.df.size.position: " + string2);
        }
        FILE_ATTRIBUTE_READONLY = 1L;
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    class ab
    extends Thread {
        private long aa;

        public ab(long l) {
            super("FilesystemProperties WindowsAutorunSuppressorThread");
            this.aa = l;
            this.start();
        }

        @Override
        public void run() {
            try {
                boolean bl = FilesystemProperties.this.suppressWindowsNextAutorun(this.aa);
                logger.debug("autorun suppressed: " + bl);
            }
            catch (Throwable throwable) {
                try {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                }
                catch (Throwable throwable2) {
                    throw ab.a(throwable2);
                }
                logger.error((Object)("autorun suppressed failed:" + throwable), throwable);
            }
        }

        private static Throwable a(Throwable throwable) {
            return throwable;
        }
    }
}

