/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.net;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.net.aa.aa;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class Localhost {
    static final String PROPERTY_OLD_HOST_ADDRESSES = "jx.net.oldHostAddresses";
    static final String PROPERTY_SKIP_V6_HOST_ADDRESSES = "jx.net.skipIPv6HostAddresses";
    public static final String IP_PART = "(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])";
    public static final Pattern IP_ADDRESS_V4 = Pattern.compile("\\[?+(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\]?");
    private static InetAddress[] hostAddresses = null;
    private static String localHostName = null;
    private static String localHostIP = null;
    private static Logger logger = LoggerFactory.getInstance("jx.net.localhost");
    private static final Map<String, String> canonicalHostNames = new ConcurrentHashMap<String, String>(3);
    protected static final Map<String, Boolean> LOOP_BACK_ADDRESS = new ConcurrentHashMap<String, Boolean>();
    protected static final Map<String, Long> LOOP_BACK_ADDRESS_TIME = new ConcurrentHashMap<String, Long>();

    /*
     * Unable to fully structure code
     */
    public static final String getLocalHostIP() {
        block5: {
            if (Localhost.localHostIP != null) break block5;
            Localhost.localHostIP = "127.0.0.1";
            try {
                block4: {
                    if (System.getProperty("os.name", "error").toLowerCase().startsWith("linux")) ** GOTO lbl7
                    try {
                        if (!System.getProperty("os.name", "error").toLowerCase().startsWith("mac")) break block4;
lbl7:
                        // 2 sources

                        Localhost.localHostIP = Localhost.getLinuxLocalHost().getHostAddress();
                        break block5;
                    }
                    catch (Exception v0) {
                        throw Localhost.a(v0);
                    }
                }
                Localhost.localHostIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception var0) {
                Localhost.logger.debug((Object)("getLocalHostIP failed:" + var0), var0);
            }
        }
        return Localhost.localHostIP;
    }

    public static final String getFirstNonLoopbackIP4() {
        return Localhost.getFirstNonLoopbackIP4(false);
    }

    public static final String getFirstNonLoopbackIP4(boolean bl) {
        block6: {
            try {
                InetAddress[] inetAddressArray = Localhost.getHostAddresses(bl);
                int n = 0;
                while (true) {
                    block7: {
                        try {
                            if (n >= inetAddressArray.length) break block6;
                            if (!(inetAddressArray[n] instanceof Inet4Address)) break block7;
                        }
                        catch (Exception exception) {
                            throw Localhost.a(exception);
                        }
                        String string = inetAddressArray[n].getHostAddress();
                        if (!Localhost.isLoopbackAdapter(string)) {
                            return string;
                        }
                    }
                    ++n;
                }
            }
            catch (Exception exception) {
                logger.error((Object)"Error resolving non-loopback ip-address.", exception);
            }
        }
        return null;
    }

    protected static boolean isLoopbackAdapter(String string) throws IOException {
        Boolean bl;
        block4: {
            long l;
            bl = LOOP_BACK_ADDRESS.get(string);
            Long l2 = LOOP_BACK_ADDRESS_TIME.get(string);
            try {
                l = l2 == null ? 0L : l2;
            }
            catch (IOException iOException) {
                throw Localhost.a(iOException);
            }
            l2 = l;
            Long l3 = System.currentTimeMillis();
            try {
                if (bl != null && Math.abs(TimeUnit.MILLISECONDS.toSeconds(l3 - l2)) <= 60L) break block4;
            }
            catch (IOException iOException) {
                throw Localhost.a(iOException);
            }
            bl = aa.aa(string);
            LOOP_BACK_ADDRESS.put(string, bl);
            LOOP_BACK_ADDRESS_TIME.put(string, l3);
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    private static InetAddress getLinuxLocalHost() throws UnknownHostException {
        InetAddress inetAddress;
        block11: {
            block10: {
                inetAddress = InetAddress.getLocalHost();
                if (!(inetAddress instanceof Inet4Address)) break block10;
                try {
                    block12: {
                        if (inetAddress.isLoopbackAddress()) break block10;
                        break block12;
                        catch (Exception exception) {
                            throw Localhost.a(exception);
                        }
                    }
                    if (!inetAddress.getHostAddress().startsWith("127.0.0.")) break block11;
                }
                catch (Exception exception) {
                    throw Localhost.a(exception);
                }
            }
            try {
                Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
                block8: while (enumeration.hasMoreElements()) {
                    Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                    while (enumeration2.hasMoreElements()) {
                        InetAddress inetAddress2 = enumeration2.nextElement();
                        try {
                            if (inetAddress2.isLoopbackAddress() || !(inetAddress2 instanceof Inet4Address)) continue;
                        }
                        catch (Exception exception) {
                            throw Localhost.a(exception);
                        }
                        inetAddress = inetAddress2;
                        continue block8;
                    }
                }
            }
            catch (Exception exception) {
                logger.debug((Object)("getLocalHostIP failed:" + exception), exception);
            }
        }
        return inetAddress;
    }

    public static InetAddress[] getHostAddresses() {
        return Localhost.getHostAddresses(false);
    }

    /*
     * Unable to fully structure code
     */
    public static InetAddress[] getHostAddresses(boolean var0) {
        block10: {
            block11: {
                if (Localhost.hostAddresses == null) ** GOTO lbl8
                try {
                    block12: {
                        if (!var0) break block10;
                        break block12;
                        catch (UnknownHostException v0) {
                            throw Localhost.a(v0);
                        }
                    }
                    if (!Boolean.getBoolean("jx.net.oldHostAddresses")) break block11;
                }
                catch (UnknownHostException v1) {
                    throw Localhost.a(v1);
                }
                try {
                    var1_1 = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                    Localhost.hostAddresses = var1_1;
                }
                catch (UnknownHostException var1_2) {
                    Localhost.logger.error((Object)("getHostAddresses failed:" + var1_2), var1_2);
                }
                break block10;
            }
            try {
                var1_3 = Localhost.getHostAddressesFromNetworkInterface();
                Localhost.hostAddresses = var1_3.toArray(new InetAddress[var1_3.size()]);
            }
            catch (Exception var1_4) {
                Localhost.logger.error((Object)("getHostAddresses failed:" + var1_4), var1_4);
                Localhost.hostAddresses = new InetAddress[1];
                try {
                    Localhost.hostAddresses[0] = InetAddress.getLocalHost();
                }
                catch (Exception var2_5) {
                    Localhost.logger.error((Object)("getHostAddresses failed:" + var2_5), var2_5);
                    Localhost.hostAddresses = new InetAddress[0];
                }
            }
        }
        return Localhost.hostAddresses;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    protected static List<InetAddress> getHostAddressesFromNetworkInterface() throws SocketException {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        LinkedList<InetAddress> linkedList = new LinkedList<InetAddress>();
        boolean bl = Boolean.getBoolean(PROPERTY_SKIP_V6_HOST_ADDRESSES);
        try {
            if (enumeration == null) return linkedList;
        }
        catch (SocketException socketException) {
            throw Localhost.a(socketException);
        }
        block10: while (enumeration.hasMoreElements()) {
            NetworkInterface networkInterface = enumeration.nextElement();
            Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
            while (true) {
                if (!enumeration2.hasMoreElements()) continue block10;
                InetAddress inetAddress = enumeration2.nextElement();
                try {
                    try {
                        if (bl && inetAddress instanceof Inet6Address) {
                            continue;
                        }
                    }
                    catch (SocketException socketException) {
                        throw Localhost.a(socketException);
                    }
                }
                catch (SocketException socketException) {
                    throw Localhost.a(socketException);
                }
                try {
                    try {
                        if (inetAddress instanceof Inet4Address && Localhost.isLocalOnly(inetAddress.getHostAddress())) {
                            continue;
                        }
                    }
                    catch (SocketException socketException) {
                        throw Localhost.a(socketException);
                    }
                }
                catch (SocketException socketException) {
                    throw Localhost.a(socketException);
                }
                linkedList.add(inetAddress);
            }
            break;
        }
        return linkedList;
    }

    public static boolean isLocalHost(String string) throws UnknownHostException {
        return Localhost.isLocalHost(string, false);
    }

    public static boolean isLocalHost(String string, boolean bl) throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getByName(string);
        try {
            if (inetAddress.equals(InetAddress.getByName("localhost"))) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw Localhost.a(unknownHostException);
        }
        InetAddress[] inetAddressArray = Localhost.getHostAddresses(bl);
        int n = 0;
        while (true) {
            block8: {
                try {
                    try {
                        if (n >= inetAddressArray.length) break;
                        if (!inetAddress.equals(inetAddressArray[n])) break block8;
                    }
                    catch (UnknownHostException unknownHostException) {
                        throw Localhost.a(unknownHostException);
                    }
                    return true;
                }
                catch (UnknownHostException unknownHostException) {
                    throw Localhost.a(unknownHostException);
                }
            }
            ++n;
        }
        return false;
    }

    public static boolean isLocalOnly(String string) {
        String string2 = string.toLowerCase();
        return string2.equals("localhost") || string2.startsWith("127.0.0.") && IP_ADDRESS_V4.matcher(string).matches();
    }

    public static boolean hasMoreThanOneNIC() {
        return Localhost.getNumOfNICs() > 1;
    }

    private static int getNumOfNICs() {
        InetAddress[] inetAddressArray = Localhost.getHostAddresses();
        int n = 0;
        for (int i = 0; i < inetAddressArray.length; ++i) {
            if (inetAddressArray[i].isLoopbackAddress()) continue;
            ++n;
        }
        return n;
    }

    public static final String getLocalHostName() {
        if (localHostName == null) {
            localHostName = "localhost";
            try {
                localHostName = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                logger.debug((Object)("getLocalHostName failed:" + exception), exception);
            }
        }
        return localHostName;
    }

    public static String getIPString(boolean bl) {
        String string = Localhost.getFirstNonLoopbackIP4();
        if (string == null) {
            return bl ? "127.000.000.001" : "127000000001";
        }
        String[] stringArray = string.split("\\.");
        StringBuilder stringBuilder = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            int n = Integer.parseInt(stringArray[i]) & 0xFF;
            if (bl && i > 0) {
                stringBuilder.append(".");
            }
            if (n < 10) {
                stringBuilder.append("00" + n);
                continue;
            }
            if (n < 100) {
                stringBuilder.append("0" + n);
                continue;
            }
            stringBuilder.append("" + n);
        }
        return stringBuilder.toString();
    }

    public static String getCanonicalHostName(String string) throws UnknownHostException {
        String string2 = null;
        if (StringTool.isDefined(string) && (string2 = canonicalHostNames.get(string)) == null) {
            InetAddress inetAddress = InetAddress.getByName(string);
            string2 = inetAddress.getCanonicalHostName();
            canonicalHostNames.put(string, string2);
        }
        return string2;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

