/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.control.log;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.ac;
import com.visustt.tools.control.log.ad;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class LoggerFactory {
    private static boolean log4jAvailable = false;
    private static Logger logger;
    private static final Map<String, Logger> instances;
    private static final String[] LEVEL_NAMES;
    public static final String PROP_LOGGERLEVEL_CONFIG = "loggerlevel.configuration";

    private LoggerFactory() {
    }

    private static void initLog4jAvailable() {
        try {
            log4jAvailable = false;
            Class.forName("org.apache.logging.log4j.core.Logger");
            log4jAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception exception) {
            System.err.println("Failed to initialize log4j:" + exception);
            exception.printStackTrace();
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            System.err.println("Failed to initialize log4j:" + exceptionInInitializerError);
            exceptionInInitializerError.printStackTrace();
        }
        catch (LinkageError linkageError) {
            System.err.println("Failed to initialize log4j:" + linkageError);
            linkageError.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initLoggerLevelConfig() throws IOException {
        InputStream inputStream;
        Serializable serializable;
        boolean bl;
        String string;
        block21: {
            string = LoggerFactory.getProperty(PROP_LOGGERLEVEL_CONFIG, "loggerlevel.properties");
            Enumeration<URL> enumeration = LoggerFactory.class.getClassLoader().getResources(string);
            bl = false;
            while (enumeration.hasMoreElements()) {
                serializable = enumeration.nextElement();
                inputStream = com.visustt.tools.net.ac.aa((URL)serializable);
                try {
                    LoggerFactory.configure(inputStream);
                    bl = true;
                }
                finally {
                    inputStream.close();
                }
            }
            if (!bl) {
                serializable = new File(string);
                try {
                    if (!((File)serializable).exists() || !((File)serializable).isFile()) break block21;
                }
                catch (Throwable throwable) {
                    throw LoggerFactory.a(throwable);
                }
                inputStream = new FileInputStream((File)serializable);
                try {
                    LoggerFactory.configure(inputStream);
                    bl = true;
                }
                finally {
                    inputStream.close();
                }
            }
        }
        if (!bl) {
            try {
                serializable = new URL(string);
                inputStream = com.visustt.tools.net.ac.aa((URL)serializable);
                try {
                    LoggerFactory.configure(inputStream);
                    bl = true;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Throwable throwable) {
                    throw LoggerFactory.a(throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LoggerFactory.configureLevelFromSystemProperties();
    }

    private static void configureLevelFromSystemProperties() {
        try {
            if (!Boolean.getBoolean("LOGPROP")) {
                return;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        LoggerFactory.configureLevel(System.getProperties());
    }

    private static String getProperty(String string, String string2) {
        try {
            return System.getProperty(string, string2);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }

    private static void configure(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        Properties properties = new Properties();
        properties.load(bufferedInputStream);
        LoggerFactory.configureLevel(properties);
    }

    private static void configureLevel(Properties properties) {
        ArrayList<Object> arrayList = new ArrayList<Object>(properties.keySet());
        Collections.sort(arrayList);
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string = null;
            try {
                string = (String)listIterator.next();
                if (!string.toLowerCase().endsWith(".level") || string.endsWith("os.patch.level")) continue;
                String string2 = properties.getProperty(string, null);
                try {
                    if (string2 == null) {
                        throw new Exception("failed to read property value for key=" + string);
                    }
                }
                catch (Exception exception) {
                    throw LoggerFactory.a(exception);
                }
                String string3 = string.substring(0, string.length() - 6);
                LoggerFactory.getInstance(string3).setLevel(LoggerFactory.getLevel(string2));
            }
            catch (Exception exception) {
                System.err.println("error configuring logger " + string + ": " + exception);
                exception.printStackTrace();
            }
        }
    }

    public static int getLevel(String string) {
        block25: {
            try {
                try {
                    if (string != null && string.trim().length() != 0) break block25;
                }
                catch (SecurityException securityException) {
                    throw LoggerFactory.a(securityException);
                }
                return 0;
            }
            catch (SecurityException securityException) {
                throw LoggerFactory.a(securityException);
            }
        }
        string = string.trim().toUpperCase();
        try {
            if ("DEFAULT".equals(string)) {
                return 0;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        try {
            if ("DEBUG".equals(string)) {
                return 1;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        try {
            if ("INFO".equals(string)) {
                return 2;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        try {
            if ("WARN".equals(string)) {
                return 3;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        try {
            if ("ERROR".equals(string)) {
                return 4;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        try {
            if ("FATAL".equals(string)) {
                return 5;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        try {
            if ("OFF".equals(string)) {
                return 6;
            }
        }
        catch (SecurityException securityException) {
            throw LoggerFactory.a(securityException);
        }
        throw new IllegalArgumentException("Unknown logging level:" + string);
    }

    static String getLevelName(int n) {
        block4: {
            try {
                try {
                    if (n < 0 || n >= LEVEL_NAMES.length) break block4;
                }
                catch (SecurityException securityException) {
                    throw LoggerFactory.a(securityException);
                }
                return LEVEL_NAMES[n];
            }
            catch (SecurityException securityException) {
                throw LoggerFactory.a(securityException);
            }
        }
        return "UnknownLevelName(" + n + ")";
    }

    static boolean isLog4JAvailable() {
        return log4jAvailable;
    }

    private static void dumpConfig() {
        if (logger.infoIsEnabled()) {
            StringBuilder stringBuilder = new StringBuilder(1024);
            stringBuilder.append("LoggerFactory\n");
            stringBuilder.append("\n\tconfigured Logger instances:");
            ArrayList<String> arrayList = new ArrayList<String>(instances.keySet());
            Collections.sort(arrayList);
            ListIterator listIterator = arrayList.listIterator();
            while (listIterator.hasNext()) {
                String string = (String)listIterator.next();
                Logger logger = LoggerFactory.getInstance(string);
                if (string.length() == 0) {
                    string = "<Root>";
                }
                stringBuilder.append("\n\t\t").append(string).append("=").append(LoggerFactory.getLevelName(logger.getLevel()));
            }
            stringBuilder.append("\n\tisLog4jAvailable:").append(LoggerFactory.isLog4JAvailable()).append("\n");
            logger.info(stringBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getRegisteredLoggerNames() {
        Map<String, Logger> map = instances;
        synchronized (map) {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : instances.keySet()) {
                int n;
                do {
                    hashSet.add(string);
                } while ((string = (n = string.lastIndexOf(46)) == -1 ? null : string.substring(0, n)) != null);
            }
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getInstance(String string) {
        Logger logger = null;
        Map<String, Logger> map = instances;
        synchronized (map) {
            block5: {
                block7: {
                    block6: {
                        logger = instances.get(string);
                        try {
                            if (logger != null) break block5;
                            if (!log4jAvailable) break block6;
                        }
                        catch (SecurityException securityException) {
                            throw LoggerFactory.a(securityException);
                        }
                        logger = new ad(string);
                        break block7;
                    }
                    logger = new ac(string);
                }
                instances.put(string, logger);
            }
        }
        return logger;
    }

    public static String[] getAllPossiblePriorities() {
        return LEVEL_NAMES;
    }

    static {
        LEVEL_NAMES = new String[]{"DEFAULT", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "OFF"};
        instances = new HashMap<String, Logger>();
        if (!Boolean.getBoolean("jx.log4j.disabled")) {
            LoggerFactory.initLog4jAvailable();
            try {
                LoggerFactory.initLoggerLevelConfig();
            }
            catch (Exception exception) {
                System.err.println("FAILED to initialize logging framework:" + exception);
                exception.printStackTrace();
            }
            try {
                logger = LoggerFactory.getInstance("jx.util.log");
                LoggerFactory.dumpConfig();
            }
            catch (Exception exception) {
                System.err.println("dumpConfig failed:" + exception);
                exception.printStackTrace();
            }
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

