/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.control.license.keys;

import com.visustt.tools.control.license.keys.LicenseKeyUID;
import com.visustt.tools.control.license.keys.ProductKey;
import com.visustt.tools.control.license.keys.ab;
import com.visustt.tools.control.license.keys.ac;
import com.visustt.tools.control.license.util.LicenseException;
import com.visustt.tools.control.license.util.NoVISUSLicenseException;
import com.visustt.tools.control.license.util.VisusVersionString;
import com.visustt.tools.lang.StringTool;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class VisusLicenseKey
implements Serializable {
    private static final long serialVersionUID = 373950510801968598L;
    private static final int ENC_LIC_KEY_BUFFER_SIZE = 262144;
    private VisusVersionString licenseKeyVersion;
    private LicenseKeyUID keyUID;
    private String licenseName;
    private String salesName;
    private int licenseModel;
    private Date validDate;
    private LicenseKeyUID parentKey;
    private String hardwareID;
    private final int MAX_PRODUCT_KEYS = 256;
    private final ProductKey[] products;
    private int productCount;
    private boolean trial;
    private String licenseCreator;
    private Date licenseCreationTimestamp;
    private String customerEmail;
    private String customInformation;
    private int checksum;
    private byte[] signatureBytes;
    private byte[] keyData;

    public VisusLicenseKey(String string, int n, LicenseKeyUID licenseKeyUID) {
        this(string, n, null, licenseKeyUID, null);
        this.trial = false;
    }

    public VisusLicenseKey(String string, int n, LicenseKeyUID licenseKeyUID, String string2, String string3) {
        this(string, n, null, licenseKeyUID, string2, string3, null, null, null, null);
        this.trial = false;
    }

    public VisusLicenseKey(String string, int n, LicenseKeyUID licenseKeyUID, String string2, String string3, String string4, String string5, String string6, Date date) {
        this(string, n, null, licenseKeyUID, string2, string3, string4, string5, string6, date);
        this.trial = false;
    }

    public VisusLicenseKey(String string, int n, Date date, LicenseKeyUID licenseKeyUID) {
        this(string, n, date, licenseKeyUID, null);
    }

    public VisusLicenseKey(String string, int n, Date date, LicenseKeyUID licenseKeyUID, String string2) {
        this(string, n, date, licenseKeyUID, string2, null, null, null, null, null);
    }

    public VisusLicenseKey(String string, int n, Date date, LicenseKeyUID licenseKeyUID, String string2, String string3, String string4, String string5, String string6, Date date2) {
        this.licenseKeyVersion = new VisusVersionString(2, 5, 0);
        this.keyUID = null;
        this.licenseName = null;
        this.salesName = null;
        this.licenseModel = 0;
        this.validDate = null;
        this.parentKey = null;
        this.hardwareID = null;
        this.MAX_PRODUCT_KEYS = 256;
        this.products = new ProductKey[256];
        this.productCount = 0;
        this.trial = true;
        this.licenseCreator = null;
        this.licenseCreationTimestamp = null;
        this.customerEmail = null;
        this.customInformation = null;
        this.checksum = 0;
        this.keyUID = new LicenseKeyUID();
        this.salesName = string3;
        this.licenseName = string;
        this.licenseModel = n;
        this.validDate = date;
        this.parentKey = licenseKeyUID;
        this.hardwareID = string2;
        this.trial = date != null;
        this.customerEmail = StringTool.emptyToNull(string4);
        this.customInformation = StringTool.emptyToNull(string5);
        this.licenseCreator = StringTool.emptyToNull(string6);
        this.licenseCreationTimestamp = date2;
    }

    /*
     * Exception decompiling
     */
    public VisusLicenseKey(InputStream var1_1) throws LicenseException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 25[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] getByteArray(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
        byte[] byArray = new byte[16384];
        int n = 0;
        while (true) {
            n = inputStream.read(byArray);
            try {
                if (n == -1) break;
                byteArrayOutputStream.write(byArray, 0, n);
            }
            catch (IOException iOException) {
                throw VisusLicenseKey.a(iOException);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] descrambleArray(byte[] byArray, int n, byte[] byArray2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(262144);
        byte[] byArray3 = new byte[8];
        int n2 = 0;
        int n3 = n;
        while (n3 < byArray.length) {
            int n4 = 0;
            while (true) {
                block9: {
                    try {
                        block8: {
                            try {
                                try {
                                    if (n4 >= 8) break;
                                    if (byArray[n3] == 48) break block8;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw VisusLicenseKey.a(illegalArgumentException);
                                }
                                if (byArray[n3] != 49) break block9;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw VisusLicenseKey.a(illegalArgumentException);
                            }
                        }
                        byArray3[n4++] = byArray[n3];
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw VisusLicenseKey.a(illegalArgumentException);
                    }
                }
                ++n3;
            }
            byteArrayOutputStream.write((byte)(Byte.parseByte(new String(byArray3), 2) ^ byArray2[n2++ % byArray2.length]));
        }
        return byteArrayOutputStream.toByteArray();
    }

    private byte[] decryptStream(InputStream inputStream) throws IOException, LicenseException {
        byte[] byArray;
        byte[] byArray2;
        int n;
        block18: {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n2;
            n = 0;
            byArray2 = this.getByteArray(inputStream);
            String string = new String(byArray2);
            int n3 = 0;
            if (StringTool.countStr(string, "@VLK@") > 1) {
                int n4;
                n = n4 = StringTool.indexOf(string, "@VLK@", 2);
                if (new String(byArray2, 0, 5).equals("@VLK@")) {
                    n3 = StringTool.indexOf(string, "@", 3) + 1;
                }
            }
            try {
                if (!new String(byArray2, n, 5).equals("@VLK@")) {
                    throw new NoVISUSLicenseException("not a valid VISUS-Licence in inputstream.");
                }
            }
            catch (IOException iOException) {
                throw VisusLicenseKey.a(iOException);
            }
            n += 5;
            byte[] byArray3 = new byte[12];
            int n5 = 0;
            do {
                byArray3[n5] = byArray2[n + n5];
                if (n5 == 12) {
                    throw new LicenseException("Error! The License Key's version information is corrupt!");
                }
                n2 = n5;
                n5 = (byte)(n5 + 1);
            } while (byArray3[n2] != 64);
            this.licenseKeyVersion = new VisusVersionString(new String(byArray3, 0, n5 - 1));
            n += n5;
            try {
                bl3 = this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 2, 2)) <= 0;
            }
            catch (IOException iOException) {
                throw VisusLicenseKey.a(iOException);
            }
            boolean bl4 = bl3;
            try {
                bl2 = this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 5, 0)) <= 0;
            }
            catch (IOException iOException) {
                throw VisusLicenseKey.a(iOException);
            }
            boolean bl5 = bl2;
            try {
                bl = this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 5, 0)) >= 0;
            }
            catch (IOException iOException) {
                throw VisusLicenseKey.a(iOException);
            }
            boolean bl6 = bl;
            byArray = null;
            if (bl4) {
                byArray = new byte[]{35, 54, 84, 100, 42, 76, 3, 11, 112, 83, 123, 42, 55, 1, 79, 29, 29, 73, 111, 17, 47, 22, 38, 96, 118, 104, 7, 31, 1, 79, 78, 94, 41, 43};
            } else if (bl5) {
                byArray = new byte[]{27, 12, 49, 10, 112, 76, 3, 11, 72, 81, 23, 33, 9, 11, 42, 47, 11, 11, 111, 61, 74, 65, 96, 101, 98, 81, 6, 125, 87, 2, 4, 6, 19, 27};
            }
            try {
                Objects.requireNonNull(byArray);
                if (!bl6 || n3 == 0) break block18;
            }
            catch (IOException iOException) {
                throw VisusLicenseKey.a(iOException);
            }
            int n6 = n - n5 - 5 - n3;
            byte[] byArray4 = new byte[n6];
            System.arraycopy(byArray2, n3, byArray4, 0, n6);
            Base64.Decoder decoder = Base64.getDecoder();
            this.signatureBytes = decoder.decode(this.descrambleArray(byArray4, 0, byArray));
        }
        this.keyData = new byte[byArray2.length - n];
        System.arraycopy(byArray2, n, this.keyData, 0, byArray2.length - n);
        return this.descrambleArray(byArray2, n, byArray);
    }

    private String getNextValue(byte[] byArray, int n) {
        byte[] byArray2 = new byte[1024];
        byte[] byArray3 = new byte[]{byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]};
        int n2 = Integer.parseInt(new String(byArray3));
        try {
            for (int i = 0; i < n2; ++i) {
                byArray2[i] = byArray[n + i + 4];
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return new String(byArray2).substring(0, n2);
    }

    private ac getNextTag(byte[] byArray, int n) {
        byte[] byArray2 = new byte[4096];
        byte[] byArray3 = new byte[]{byArray[n], byArray[n + 1], byArray[n + 2], byArray[n + 3]};
        byte[] byArray4 = new byte[]{byArray[n + 4], byArray[n + 5]};
        int n2 = Integer.parseInt(new String(byArray3));
        int n3 = Integer.parseInt(new String(byArray4));
        try {
            for (int i = 0; i < n2; ++i) {
                byArray2[i] = byArray[n + i + 6];
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return new ac(n3, new String(byArray2, 0, n2));
    }

    public boolean isBaseKey() {
        boolean bl;
        try {
            bl = this.parentKey == null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return bl;
    }

    public boolean isTrialKey() {
        return this.trial;
    }

    public void switchToTrial(Date date) {
        this.trial = true;
        this.validDate = date;
    }

    public LicenseKeyUID getKeyUID() {
        return this.keyUID;
    }

    public String getLicenseName() {
        return this.licenseName;
    }

    public String getSalesName() {
        return this.salesName;
    }

    public String getLicenseCreator() {
        return this.licenseCreator;
    }

    public Date getLicenseCreationTimestamp() {
        return this.licenseCreationTimestamp;
    }

    public String getCustomerEmail() {
        return this.customerEmail;
    }

    public String getCustomInformation() {
        return this.customInformation;
    }

    public int getLicenseModel() {
        return this.licenseModel;
    }

    public Date getExpirationDate() {
        return this.validDate;
    }

    public String getHardwareID() {
        return this.hardwareID;
    }

    public LicenseKeyUID getParentKey() {
        return this.parentKey;
    }

    public Collection<ProductKey> getProductList() {
        ArrayList<ProductKey> arrayList = new ArrayList<ProductKey>(this.productCount);
        int n = 0;
        while (true) {
            block5: {
                try {
                    try {
                        if (n >= this.productCount) break;
                        if (this.products[n] == null) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw VisusLicenseKey.a(illegalArgumentException);
                    }
                    arrayList.add(this.products[n]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw VisusLicenseKey.a(illegalArgumentException);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public ProductKey getFirstProduct() {
        try {
            if (this.productCount < 1) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return this.products[0];
    }

    public boolean isValidKey() {
        boolean bl;
        int n = this.createCS();
        try {
            bl = n == this.checksum;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return bl;
    }

    public void addProduct(ProductKey productKey) {
        this.products[this.productCount++] = productKey;
        this.checksum = this.createCS();
    }

    public int getProductCount() {
        return this.productCount;
    }

    private int createCS() {
        int n;
        block4: {
            n = 0;
            n += this.keyUID.getCS();
            n += VisusLicenseKey.createCS(this.licenseName);
            n += VisusLicenseKey.createCS(Integer.toString(this.licenseModel));
            n += VisusLicenseKey.createCS(this.validDate);
            if (!this.isBaseKey()) {
                n += this.parentKey.getCS();
            }
            try {
                if (this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 2, 2)) < 0 || this.hardwareID == null) break block4;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            n += VisusLicenseKey.createCS(this.hardwareID);
        }
        for (int i = 0; i < this.productCount; ++i) {
            n += this.products[i].getCS(this.licenseKeyVersion);
        }
        return n;
    }

    private static int createCS(Date date) {
        String string;
        try {
            string = date == null ? "" : Long.toString(date.getTime());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return VisusLicenseKey.createCS(string);
    }

    private static int createCS(String string) {
        try {
            if (string == null) {
                return 0;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i);
        }
        return n;
    }

    public VisusVersionString getLicenseKeyVersion() {
        return this.licenseKeyVersion;
    }

    private void setLicenseKeyVersion(VisusVersionString visusVersionString) {
        this.licenseKeyVersion = visusVersionString;
        this.checksum = this.createCS();
    }

    private byte[] createKeyDataByteArray() {
        StringBuilder stringBuilder;
        block36: {
            String string;
            VisusLicenseKey visusLicenseKey;
            StringBuilder stringBuilder2;
            String string2;
            VisusLicenseKey visusLicenseKey2;
            StringBuilder stringBuilder3;
            String string3;
            VisusLicenseKey visusLicenseKey3;
            StringBuilder stringBuilder4;
            String string4;
            VisusLicenseKey visusLicenseKey4;
            StringBuilder stringBuilder5;
            String string5;
            VisusLicenseKey visusLicenseKey5;
            StringBuilder stringBuilder6;
            String string6;
            VisusLicenseKey visusLicenseKey6;
            StringBuilder stringBuilder7;
            String string7;
            VisusLicenseKey visusLicenseKey7;
            StringBuilder stringBuilder8;
            String string8;
            VisusLicenseKey visusLicenseKey8;
            StringBuilder stringBuilder9;
            block38: {
                block37: {
                    stringBuilder = new StringBuilder(32768);
                    if (this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 2, 2)) <= 0) {
                        String string9;
                        VisusLicenseKey visusLicenseKey9;
                        StringBuilder stringBuilder10;
                        String string10;
                        VisusLicenseKey visusLicenseKey10;
                        StringBuilder stringBuilder11;
                        VisusVersionString visusVersionString = this.licenseKeyVersion;
                        try {
                            this.setLicenseKeyVersion(new VisusVersionString(1, 0, 0));
                            stringBuilder.append(this.createDataString(this.keyUID.toString(), -1));
                            stringBuilder.append(this.createDataString(this.licenseName, -1));
                            stringBuilder.append(this.createDataString(this.licenseModel, -1));
                            stringBuilder11 = stringBuilder;
                            visusLicenseKey10 = this;
                            string10 = this.validDate == null ? "NULL" : Long.toString(this.validDate.getTime());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw VisusLicenseKey.a(illegalArgumentException);
                        }
                        try {
                            stringBuilder11.append(visusLicenseKey10.createDataString(string10, -1));
                            stringBuilder10 = stringBuilder;
                            visusLicenseKey9 = this;
                            string9 = this.parentKey == null ? "NULL" : this.parentKey.toString();
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw VisusLicenseKey.a(illegalArgumentException);
                        }
                        stringBuilder10.append(visusLicenseKey9.createDataString(string9, -1));
                        stringBuilder.append(this.createDataString(this.checksum, -1));
                        try {
                            for (int i = 0; i < this.productCount; ++i) {
                                stringBuilder.append(this.createDataString(this.products[i].getProductID(), -1));
                                stringBuilder.append(this.createDataString(this.products[i].getExpirationVersion().toString(), -1));
                                stringBuilder.append(this.createDataString(this.products[i].getLicenseCount(), -1));
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw VisusLicenseKey.a(illegalArgumentException);
                        }
                        stringBuilder.append(this.createDataString(-1, -1));
                        this.setLicenseKeyVersion(visusVersionString);
                    }
                    try {
                        if (this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 2, 2)) == 0) {
                            stringBuilder.append(this.createDataString("", 15));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw VisusLicenseKey.a(illegalArgumentException);
                    }
                    try {
                        try {
                            if (this.licenseKeyVersion.compareVersion(new VisusVersionString(2, 2, 2)) < 0) break block36;
                            stringBuilder.append(this.createDataString(this.keyUID.toString(), 0));
                            stringBuilder.append(this.createDataString(this.licenseName, 1));
                            stringBuilder.append(this.createDataString(this.licenseModel, 2));
                            stringBuilder9 = stringBuilder;
                            visusLicenseKey8 = this;
                            if (this.validDate != null) break block37;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw VisusLicenseKey.a(illegalArgumentException);
                        }
                        string8 = "NULL";
                        break block38;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw VisusLicenseKey.a(illegalArgumentException);
                    }
                }
                string8 = Long.toString(this.validDate.getTime());
            }
            try {
                stringBuilder9.append(visusLicenseKey8.createDataString(string8, 3));
                stringBuilder8 = stringBuilder;
                visusLicenseKey7 = this;
                string7 = this.parentKey == null ? "NULL" : this.parentKey.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            try {
                stringBuilder8.append(visusLicenseKey7.createDataString(string7, 4));
                stringBuilder7 = stringBuilder;
                visusLicenseKey6 = this;
                string6 = StringTool.isNullOrEmpty(this.hardwareID) ? "NULL" : this.hardwareID;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            try {
                stringBuilder7.append(visusLicenseKey6.createDataString(string6, 9));
                stringBuilder6 = stringBuilder;
                visusLicenseKey5 = this;
                string5 = StringTool.isNullOrEmpty(this.salesName) ? "NULL" : this.salesName;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            try {
                stringBuilder6.append(visusLicenseKey5.createDataString(string5, 16));
                stringBuilder5 = stringBuilder;
                visusLicenseKey4 = this;
                string4 = StringTool.isNullOrEmpty(this.licenseCreator) ? "NULL" : this.licenseCreator;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            try {
                stringBuilder5.append(visusLicenseKey4.createDataString(string4, 17));
                stringBuilder4 = stringBuilder;
                visusLicenseKey3 = this;
                string3 = this.licenseCreationTimestamp == null ? "NULL" : Long.toString(this.licenseCreationTimestamp.getTime());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            try {
                stringBuilder4.append(visusLicenseKey3.createDataString(string3, 18));
                stringBuilder3 = stringBuilder;
                visusLicenseKey2 = this;
                string2 = StringTool.isNullOrEmpty(this.customerEmail) ? "NULL" : this.customerEmail;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            try {
                stringBuilder3.append(visusLicenseKey2.createDataString(string2, 19));
                stringBuilder2 = stringBuilder;
                visusLicenseKey = this;
                string = StringTool.isNullOrEmpty(this.customInformation) ? "NULL" : this.customInformation;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw VisusLicenseKey.a(illegalArgumentException);
            }
            stringBuilder2.append(visusLicenseKey.createDataString(string, 20));
            stringBuilder.append(this.createDataString(this.checksum, 5));
            int n = 0;
            while (true) {
                String string11;
                VisusLicenseKey visusLicenseKey11;
                StringBuilder stringBuilder12;
                String string12;
                VisusLicenseKey visusLicenseKey12;
                StringBuilder stringBuilder13;
                block40: {
                    block39: {
                        try {
                            try {
                                if (n >= this.productCount) break;
                                stringBuilder.append(this.createDataString("", 12));
                                stringBuilder.append(this.createDataString(this.products[n].getProductID(), 6));
                                stringBuilder.append(this.createDataString(this.products[n].getExpirationVersion().toString(), 7));
                                stringBuilder.append(this.createDataString(this.products[n].getLicenseCount(), 8));
                                stringBuilder13 = stringBuilder;
                                visusLicenseKey12 = this;
                                if (this.products[n].getExpirationDate() != null) break block39;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw VisusLicenseKey.a(illegalArgumentException);
                            }
                            string12 = "NULL";
                            break block40;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw VisusLicenseKey.a(illegalArgumentException);
                        }
                    }
                    string12 = Long.toString(this.products[n].getExpirationDate().getTime());
                }
                try {
                    stringBuilder13.append(visusLicenseKey12.createDataString(string12, 10));
                    stringBuilder12 = stringBuilder;
                    visusLicenseKey11 = this;
                    string11 = this.products[n].getHardwareID() == null ? "NULL" : this.products[n].getHardwareID();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw VisusLicenseKey.a(illegalArgumentException);
                }
                stringBuilder12.append(visusLicenseKey11.createDataString(string11, 11));
                stringBuilder.append(this.createDataString("", 13));
                ++n;
            }
            stringBuilder.append(this.createDataString("", 14));
        }
        return stringBuilder.toString().getBytes();
    }

    private String createDataString(String string, int n) {
        Object object = Integer.toString(string.length());
        Object object2 = "";
        if (n != -1 && ((String)(object2 = Integer.toString(n))).length() < 2) {
            object2 = "0" + (String)object2;
        }
        while (((String)object).length() < 4) {
            object = "0" + (String)object;
        }
        return (String)object + (String)object2 + string;
    }

    private String createDataString(int n, int n2) {
        return this.createDataString(Integer.toString(n), n2);
    }

    public void writeKey(ab ab5) throws IOException, UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SignatureException, CertificateException {
        VisusVersionString visusVersionString = this.licenseKeyVersion;
        this.setLicenseKeyVersion(ab5.aa());
        ab5.ab(this.getLatestExpirationVersion());
        ab5.aa(this.createKeyDataByteArray());
        this.setLicenseKeyVersion(visusVersionString);
    }

    private VisusVersionString getLatestExpirationVersion() {
        Optional<VisusVersionString> optional = this.getProductList().stream().map(ProductKey::getExpirationVersion).max(VisusVersionString::compareVersion);
        return optional.orElse(null);
    }

    public int hashCode() {
        return this.keyUID.hashCode();
    }

    public boolean equals(Object object) {
        try {
            if (!(object instanceof VisusLicenseKey)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw VisusLicenseKey.a(illegalArgumentException);
        }
        return ((VisusLicenseKey)object).getKeyUID().equals(this.keyUID);
    }

    public byte[] getSignatureBytes() {
        return this.signatureBytes;
    }

    public byte[] getKeyData() {
        return this.keyData;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

