/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.control.license.keys;

import com.visustt.tools.control.license.util.VisusLicenseConstants;
import com.visustt.tools.control.license.util.VisusVersionString;
import java.io.Serializable;
import java.util.Date;

public class ProductKey
implements Serializable {
    private static final long serialVersionUID = -222878382070011625L;
    private int productID;
    private int licenseCount;
    private VisusVersionString expVer;
    private Date expirationDate;
    private String hardwareID;

    public ProductKey(int n, int n2) throws IllegalArgumentException {
        this(n, n2, new VisusVersionString(-1, -1, -1));
    }

    public ProductKey(int n, int n2, VisusVersionString visusVersionString) throws IllegalArgumentException {
        this(n, n2, visusVersionString, null, null);
    }

    public ProductKey(int n, int n2, VisusVersionString visusVersionString, String string) throws IllegalArgumentException {
        this(n, n2, visusVersionString, null, string);
    }

    public ProductKey(ProductKey productKey) {
        this(productKey.getProductID(), productKey.getLicenseCount(), productKey.getExpirationVersion(), productKey.getExpirationDate(), productKey.getHardwareID());
    }

    public ProductKey(int n, int n2, VisusVersionString visusVersionString, Date date, String string) throws IllegalArgumentException {
        this.productID = n;
        this.expVer = visusVersionString;
        this.licenseCount = n2;
        this.expirationDate = date;
        this.hardwareID = string;
    }

    public int getLicenseCount() {
        return this.licenseCount;
    }

    public void increaseLicenseCount(int n) {
        this.licenseCount += n;
    }

    public int getProductID() {
        return this.productID;
    }

    public VisusVersionString getExpirationVersion() {
        return this.expVer;
    }

    public void setExpirationVersion(VisusVersionString visusVersionString) {
        this.expVer = visusVersionString;
    }

    public int getCS(VisusVersionString visusVersionString) {
        int n;
        int n2;
        block17: {
            block16: {
                int n3;
                int n4;
                boolean bl;
                block15: {
                    block14: {
                        boolean bl2;
                        block13: {
                            block12: {
                                try {
                                    try {
                                        if (visusVersionString == null || visusVersionString.compareVersion(new VisusVersionString(2, 2, 2)) >= 0) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw ProductKey.a(illegalArgumentException);
                                    }
                                    bl2 = true;
                                    break block13;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw ProductKey.a(illegalArgumentException);
                                }
                            }
                            bl2 = false;
                        }
                        bl = bl2;
                        try {
                            try {
                                n4 = this.licenseCount * this.productID * (this.expVer.getMajorVersion() + 1) * (this.expVer.getMinorVersion() + 1) * (this.expVer.getMicroVersion() + 1);
                                if (this.expirationDate != null && !bl) break block14;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw ProductKey.a(illegalArgumentException);
                            }
                            n3 = 1;
                            break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ProductKey.a(illegalArgumentException);
                        }
                    }
                    n3 = (int)(this.expirationDate.getTime() / 100000L);
                }
                try {
                    try {
                        n2 = n4 * n3;
                        if (this.hardwareID != null && !bl) break block16;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ProductKey.a(illegalArgumentException);
                    }
                    n = 1;
                    break block17;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ProductKey.a(illegalArgumentException);
                }
            }
            n = this.hardwareID.hashCode();
        }
        return n2 * n;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date date) {
        this.expirationDate = date;
    }

    public boolean isExpired() {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (this.expirationDate == null || this.expirationDate.getTime() >= System.currentTimeMillis()) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ProductKey.a(illegalArgumentException);
                    }
                    bl = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ProductKey.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public String getHardwareID() {
        return this.hardwareID;
    }

    public void setHardwareID(String string) {
        this.hardwareID = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ProductKey [productID=");
        stringBuilder.append(this.productID);
        stringBuilder.append(", productName=");
        stringBuilder.append(VisusLicenseConstants.getProductName(this.productID));
        stringBuilder.append(", licenseCount=");
        stringBuilder.append(this.licenseCount);
        stringBuilder.append(", expVer=");
        stringBuilder.append(this.expVer);
        stringBuilder.append(", expirationDate=");
        stringBuilder.append(this.expirationDate);
        stringBuilder.append(", hardwareID=");
        stringBuilder.append(this.hardwareID);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getCS(null);
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ProductKey.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof ProductKey)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ProductKey.a(illegalArgumentException);
        }
        ProductKey productKey = (ProductKey)object;
        try {
            if (this.getCS(null) != productKey.getCS(null)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ProductKey.a(illegalArgumentException);
        }
        return true;
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

