/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.awt.screen;

import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import com.visustt.tools.awt.event.MousePositionHandler;
import com.visustt.tools.awt.screen.Monitor;
import com.visustt.tools.awt.screen.aa.ac;
import com.visustt.tools.awt.screen.aa.ae;
import com.visustt.tools.awt.screen.ab;
import com.visustt.tools.awt.screen.aj;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.system.LibLoader;
import com.visustt.tools.system.OSVersion;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.ColorModel;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ScreenProperties {
    private static final Logger LOGGER;
    private static final boolean IS_HEADLESS;
    public static final String PROP_SPANNED_ALLOWED = "spanned.allowed";
    public static final String PROP_MONITORS_WITHOUT_GFXBOARD_ALLOWED = "nogfxboard.allowed";
    public static final String PROP_USER_DEFINED_MONITOR = "userdef.screen";
    public static final String PROP_XPTOFRONTCLICK_ENABLED = "com.visustt.xptofront.enabled";
    public static final String PROP_FORCE_MULTIMONITOR = "com.visustt.multimonitor.force";
    public static final int MAX_SCREEN_WIDTH_HEURISTIC = 1600;
    public static final int MAX_SCREEN_HEIGHT_HEURISTIC = 1200;
    public static final int MID_SCREEN_WIDTH_HEURISTIC = 1152;
    public static final int MID_SCREEN_HEIGHT_HEURISTIC = 864;
    private static final String LOCK_TIMEOUT_REG_PATH = "Control Panel\\Desktop";
    public static final int DEFAULT_WINDOWS_TASKBAR_HEIGHT = 27;
    private static final double DUAL_MON_SPAN_FACTOR = 0.75;
    private static final double DUAL_MON_SPAN_TRESHOLD = 0.5;
    private static boolean lockTimeout0;
    private static ScreenProperties theInstance;
    private static boolean libraryLoaded;
    private static List loggedBeforeList;
    private static Boolean isGrayScaleMonitor;

    @Deprecated
    private native void setWindowAlwaysOnTop(String var1, boolean var2);

    private native Rectangle getWindowsTaskbarProperties();

    private native boolean bringToFront(String var1, boolean var2);

    private native boolean existsWindow(String var1);

    private native void killWindow(String var1);

    private native void setWindowsTaskbarZOrder(boolean var1);

    private native boolean isWindowsTaskbarAlwaysOnTop();

    private native boolean isWindowsPrimaryMonitor(int var1, int var2, int var3, int var4);

    private native String getWindowsMonitorGFXBoard(int var1, int var2, int var3, int var4);

    private native String getWindowsMonitorDriverID(int var1, int var2, int var3, int var4);

    private native String getAllWindowsMonitorDriverIDs();

    public static String getSystemProperty(String string, String string2) {
        String string3 = null;
        try {
            string3 = System.getProperty(string, string2);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            ScreenProperties.logOnce("getSystemProperty", "getSystemProperty", exceptionInInitializerError);
        }
        catch (AccessControlException accessControlException) {
            ScreenProperties.logOnce("getSystemProperty", "getSystemProperty", accessControlException);
        }
        return string3;
    }

    public static boolean supportsResolution(Dimension dimension) {
        return ScreenProperties.supportsResolution(dimension.width, dimension.height);
    }

    public static boolean isGrayscaleMonitor() {
        try {
            if (ScreenProperties.isMonitorGrayscaleSupressed()) {
                return false;
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        try {
            if (isGrayScaleMonitor != null) {
                return isGrayScaleMonitor;
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        try {
            isGrayScaleMonitor = false;
            if (!ScreenProperties.isHeadless()) {
                isGrayScaleMonitor = "GRAY".equalsIgnoreCase(ScreenProperties.getColorSpaceType());
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        if (OSVersion.isWindows()) {
            Monitor[] monitorArray;
            for (Monitor monitor : monitorArray = ScreenProperties.getMonitors()) {
                for (Object e : monitor.getEDIDs()) {
                    if (e == null) continue;
                    ac ac2 = (ac)e;
                    isGrayScaleMonitor = isGrayScaleMonitor | ScreenProperties.isGrayscaleMonitorFromEDID(ac2);
                }
            }
        }
        return isGrayScaleMonitor;
    }

    public static boolean isGrayscaleMonitorFromBounds(int n, int n2) {
        Monitor monitor;
        try {
            if (ScreenProperties.isMonitorGrayscaleSupressed()) {
                return false;
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        boolean bl = false;
        if (!ScreenProperties.isHeadless()) {
            bl = ScreenProperties.getColorSpaceType().equalsIgnoreCase("GRAY");
        }
        if (OSVersion.isWindows() && (monitor = ScreenProperties.getMonitorAtScreenPosition(n, n2)) != null) {
            for (Object e : monitor.getEDIDs()) {
                if (e == null) continue;
                ac ac2 = (ac)e;
                bl |= ScreenProperties.isGrayscaleMonitorFromEDID(ac2);
            }
        }
        return bl;
    }

    public static boolean isGrayscaleMonitor(Monitor monitor) {
        boolean bl;
        block7: {
            try {
                if (ScreenProperties.isMonitorGrayscaleSupressed()) {
                    return false;
                }
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            bl = false;
            if (!ScreenProperties.isHeadless()) {
                bl = ScreenProperties.getColorSpaceType().equalsIgnoreCase("GRAY");
            }
            try {
                if (!OSVersion.isWindows() || monitor == null) break block7;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            for (Object e : monitor.getEDIDs()) {
                if (e == null) continue;
                ac ac2 = (ac)e;
                bl |= ScreenProperties.isGrayscaleMonitorFromEDID(ac2);
            }
        }
        return bl;
    }

    private static boolean isGrayscaleMonitorFromEDID(ac ac2) {
        block11: {
            block12: {
                int n;
                int n2;
                block10: {
                    n2 = ac2.ai();
                    n = ac2.aj();
                    try {
                        try {
                            if (n2 != 1 || n != 3) break block10;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        return "Monochrome".equals(ac2.ao().ad());
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                }
                try {
                    try {
                        try {
                            if (n2 != 1 || n != 4) break block11;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        if (!ac2.ak().aa()) break block12;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    return ac2.ap().ai();
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
            }
            return "Monochrome".equals(ac2.ao().ad());
        }
        return false;
    }

    private static boolean isMonitorGrayscaleSupressed() {
        return Boolean.getBoolean("rv.monitor.grayscale.supressed");
    }

    public static boolean toFront(Window window) {
        String string = null;
        if (window instanceof Frame) {
            string = ((Frame)window).getTitle();
        } else if (window instanceof Dialog) {
            string = ((Dialog)window).getTitle();
        }
        return ScreenProperties.toFront(window, string, true);
    }

    public static boolean toFront(Window window, boolean bl) {
        String string = null;
        if (window instanceof Frame) {
            string = ((Frame)window).getTitle();
        } else if (window instanceof Dialog) {
            string = ((Dialog)window).getTitle();
        }
        return ScreenProperties.toFront(window, string, bl);
    }

    public static boolean toFront(String string) {
        return ScreenProperties.toFront(null, string, true);
    }

    /*
     * Loose catch block
     */
    public static boolean toFront(Window window, final String string, boolean bl) {
        boolean bl2;
        block29: {
            block24: {
                try {
                    if (string == null) {
                        return false;
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw ScreenProperties.a(unsatisfiedLinkError);
                }
                bl2 = false;
                try {
                    if (!OSVersion.isWindows() || !libraryLoaded) break block24;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw ScreenProperties.a(unsatisfiedLinkError);
                }
                try {
                    boolean bl3;
                    block32: {
                        String string2;
                        String string3;
                        Logger logger;
                        block28: {
                            block27: {
                                block26: {
                                    block25: {
                                        block30: {
                                            bl3 = true;
                                            String string4 = ScreenProperties.getSystemProperty(PROP_XPTOFRONTCLICK_ENABLED, "true");
                                            if (!OSVersion.isArchX86()) break block25;
                                            if (StringTool.isFalse(string4)) break block25;
                                            break block30;
                                            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                                throw ScreenProperties.a(unsatisfiedLinkError);
                                            }
                                        }
                                        try {
                                            block31: {
                                                if (!OSVersion.isWindowsXPOrLater()) break block25;
                                                break block31;
                                                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                                    throw ScreenProperties.a(unsatisfiedLinkError);
                                                }
                                            }
                                            if (!lockTimeout0) break block26;
                                        }
                                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                            throw ScreenProperties.a(unsatisfiedLinkError);
                                        }
                                    }
                                    bl3 = false;
                                }
                                if (!LOGGER.debugIsEnabled()) break block32;
                                try {
                                    block33: {
                                        logger = LOGGER;
                                        string3 = string;
                                        if (!bl3) break block27;
                                        break block33;
                                        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                            throw ScreenProperties.a(unsatisfiedLinkError);
                                        }
                                    }
                                    string2 = "true";
                                    break block28;
                                }
                                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                                    throw ScreenProperties.a(unsatisfiedLinkError);
                                }
                            }
                            string2 = "false";
                        }
                        logger.debug("JNI call toFront with title " + string3 + " and override set to " + string2);
                    }
                    final boolean bl4 = bl3;
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                boolean bl = theInstance.bringToFront(string, bl4);
                                if (!bl && LOGGER.debugIsEnabled()) {
                                    LOGGER.debug("JNI call toFront failed!!!");
                                }
                            }
                        });
                        if (LOGGER.debugIsEnabled()) {
                            LOGGER.debug("JNI call returned");
                        }
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        throw ScreenProperties.a(unsatisfiedLinkError);
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    ScreenProperties.logOnce("toFront", "toFront failed", unsatisfiedLinkError);
                    bl2 = false;
                }
            }
            try {
                try {
                    if (!bl || window == null) break block29;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    throw ScreenProperties.a(unsatisfiedLinkError);
                }
                window.toFront();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw ScreenProperties.a(unsatisfiedLinkError);
            }
        }
        return bl2;
    }

    public static boolean windowExists(Window window) {
        String string = null;
        if (window instanceof Frame) {
            string = ((Frame)window).getTitle();
        } else if (window instanceof Dialog) {
            string = ((Dialog)window).getTitle();
        }
        return ScreenProperties.windowExists(string);
    }

    public static boolean windowExists(String string) {
        boolean bl;
        block7: {
            try {
                if (string == null) {
                    return false;
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw ScreenProperties.a(unsatisfiedLinkError);
            }
            bl = false;
            try {
                if (!OSVersion.isWindows() || !libraryLoaded) break block7;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                throw ScreenProperties.a(unsatisfiedLinkError);
            }
            try {
                bl = theInstance.existsWindow(string);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                ScreenProperties.logOnce("windowExists", "windowExists failed", unsatisfiedLinkError);
                bl = false;
            }
        }
        return bl;
    }

    public static void winos_KillWindow(Window window) {
        String string = null;
        if (window instanceof Frame) {
            string = ((Frame)window).getTitle();
        } else if (window instanceof Dialog) {
            string = ((Dialog)window).getTitle();
        }
        ScreenProperties.winos_KillWindow(string);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void winos_KillWindow(String var0) {
        try {
            if (var0 == null) {
                return;
            }
        }
        catch (UnsatisfiedLinkError v0) {
            throw ScreenProperties.a(v0);
        }
        try {
            if (OSVersion.isWindows() == false) return;
            ** GOTO lbl14
        }
        catch (UnsatisfiedLinkError v1) {
            try {
                throw ScreenProperties.a(v1);
lbl14:
                // 2 sources

                if (ScreenProperties.libraryLoaded == false) return;
            }
            catch (AccessControlException v2) {
                throw ScreenProperties.a(v2);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var1_1) {
                    ScreenProperties.logOnce("winos_KillWindow", "winos_KillWindow failed", var1_1);
                    return;
                }
            }
        }
        ScreenProperties.theInstance.killWindow(var0);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static void winos_makeWindowAlwaysOnTop(String var0) {
        try {
            if (var0 == null) {
                return;
            }
        }
        catch (UnsatisfiedLinkError v0) {
            throw ScreenProperties.a(v0);
        }
        try {
            if (OSVersion.isWindows() == false) return;
            ** GOTO lbl14
        }
        catch (UnsatisfiedLinkError v1) {
            try {
                throw ScreenProperties.a(v1);
lbl14:
                // 2 sources

                if (ScreenProperties.libraryLoaded == false) return;
            }
            catch (AccessControlException v2) {
                throw ScreenProperties.a(v2);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var1_1) {
                    ScreenProperties.logOnce("winos_makeWindowAlwaysOnTop", "winos_makeWindowAlwaysOnTop failed", var1_1);
                    return;
                }
            }
        }
        ScreenProperties.theInstance.setWindowAlwaysOnTop(var0, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean winos_isPrimaryMonitor(Monitor var0) {
        try {
            if (!OSVersion.isWindows()) ** GOTO lbl7
            ** GOTO lbl10
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                throw ScreenProperties.a(v0);
lbl7:
                // 2 sources

                return false;
lbl10:
                // 2 sources

                if (!ScreenProperties.libraryLoaded) ** GOTO lbl7
            }
            catch (AccessControlException v1) {
                throw ScreenProperties.a(v1);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var1_1) {
                    ScreenProperties.logOnce("winos_isPrimaryMonitor", "winos_isPrimaryMonitor failed", var1_1);
                    return false;
                }
                return ScreenProperties.theInstance.isWindowsPrimaryMonitor(var0.getX(), var0.getY(), var0.getWidth(), var0.getHeight());
            }
        }
    }

    public static String winos_getGraphicsBoardForMonitor(Monitor monitor) {
        return ScreenProperties.winos_getGraphicsBoardForMonitor(monitor.getScreenRect());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String winos_getGraphicsBoardForMonitor(Rectangle var0) {
        try {
            if (!OSVersion.isWindows()) ** GOTO lbl7
            ** GOTO lbl10
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                throw ScreenProperties.a(v0);
lbl7:
                // 2 sources

                return null;
lbl10:
                // 2 sources

                if (!ScreenProperties.libraryLoaded) ** GOTO lbl7
            }
            catch (AccessControlException v1) {
                throw ScreenProperties.a(v1);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var1_1) {
                    ScreenProperties.logOnce("winos_getGraphicsBoardForMonitor", "winos_getGraphicsBoardForMonitor failed", var1_1);
                    return null;
                }
                return ScreenProperties.theInstance.getWindowsMonitorGFXBoard(var0.x, var0.y, var0.width, var0.height);
            }
        }
    }

    public static String winos_getDriverIDForMonitor(Monitor monitor) {
        return ScreenProperties.winos_getDriverIDForMonitor(monitor.getScreenRect());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String winos_getDriverIDForMonitor(Rectangle var0) {
        try {
            if (!OSVersion.isWindows()) ** GOTO lbl7
            ** GOTO lbl10
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                throw ScreenProperties.a(v0);
lbl7:
                // 2 sources

                return null;
lbl10:
                // 2 sources

                if (!ScreenProperties.libraryLoaded) ** GOTO lbl7
            }
            catch (AccessControlException v1) {
                throw ScreenProperties.a(v1);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var1_1) {
                    ScreenProperties.logOnce("winos_getDriverIDForMonitor", "winos_getDriverIDForMonitor failed", var1_1);
                    return null;
                }
                return ScreenProperties.theInstance.getWindowsMonitorDriverID(var0.x, var0.y, var0.width, var0.height);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String winos_getAllMonitorDriverIDs() {
        try {
            if (!OSVersion.isWindows()) ** GOTO lbl7
            ** GOTO lbl10
        }
        catch (UnsatisfiedLinkError v0) {
            try {
                throw ScreenProperties.a(v0);
lbl7:
                // 2 sources

                return null;
lbl10:
                // 2 sources

                if (!ScreenProperties.libraryLoaded) ** GOTO lbl7
            }
            catch (AccessControlException v1) {
                throw ScreenProperties.a(v1);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var0) {
                    ScreenProperties.logOnce("getAllWindowsMonitorDriverIDs", "getAllWindowsMonitorDriverIDs failed", var0);
                    return null;
                }
                return ScreenProperties.theInstance.getAllWindowsMonitorDriverIDs();
            }
        }
    }

    static ab[] getAllMonitorDriverIDs() {
        block6: {
            String string = ScreenProperties.winos_getAllMonitorDriverIDs();
            try {
                if (string == null || string.trim().length() <= 0) break block6;
            }
            catch (Throwable throwable) {
                throw ScreenProperties.a(throwable);
            }
            String[] stringArray = string.split(";");
            if (stringArray.length > 0) {
                ab[] abArray = new ab[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        String[] stringArray2 = stringArray[i].split(",");
                        ab ab5 = new ab();
                        ab5.x = Integer.parseInt(stringArray2[0]);
                        ab5.y = Integer.parseInt(stringArray2[1]);
                        ab5.width = Integer.parseInt(stringArray2[2]);
                        ab5.height = Integer.parseInt(stringArray2[3]);
                        ab5.aa = stringArray2[4];
                        abArray[i] = ab5;
                        continue;
                    }
                    catch (Throwable throwable) {
                        LOGGER.error((Object)("Failed to read monitor information! Index = " + i + " Value = " + string), throwable);
                    }
                }
                return abArray;
            }
        }
        return null;
    }

    static final List getDriverIDsForRect(Rectangle rectangle, ab[] abArray) {
        block15: {
            try {
                if (rectangle == null || abArray == null) break block15;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            ArrayList<ab> arrayList = new ArrayList<ab>(2);
            int n = 0;
            while (true) {
                block16: {
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        try {
                                            if (n >= abArray.length) break;
                                            if (abArray[n] == null) break block16;
                                        }
                                        catch (AccessControlException accessControlException) {
                                            throw ScreenProperties.a(accessControlException);
                                        }
                                        if (rectangle.x != abArray[n].x) break block16;
                                    }
                                    catch (AccessControlException accessControlException) {
                                        throw ScreenProperties.a(accessControlException);
                                    }
                                    if (rectangle.y != abArray[n].y) break block16;
                                }
                                catch (AccessControlException accessControlException) {
                                    throw ScreenProperties.a(accessControlException);
                                }
                                if (rectangle.width != abArray[n].width) break block16;
                            }
                            catch (AccessControlException accessControlException) {
                                throw ScreenProperties.a(accessControlException);
                            }
                            if (rectangle.height != abArray[n].height) break block16;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        arrayList.add(abArray[n]);
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                }
                ++n;
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    static final List<ac> getEDIDs(List list) {
        if (!list.isEmpty()) {
            ArrayList<ac> arrayList = new ArrayList<ac>(2);
            for (ab ab5 : list) {
                if (ab5.aa == null) continue;
                ac ac2 = ae.aa().ab(ab5.aa);
                try {
                    if (ac2 != null) {
                        arrayList.add(ac2);
                        continue;
                    }
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                LOGGER.debug("No EDID information found for monitor " + ab5.aa + "!");
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    @Deprecated
    public static void setAlwaysOnTop(Window window, boolean bl) {
        try {
            window.setAlwaysOnTop(bl);
        }
        catch (Exception exception) {
            ScreenProperties.winos_setWindowAlwaysOnTop(window, bl);
        }
    }

    @Deprecated
    private static void winos_setWindowAlwaysOnTop(Window window, boolean bl) {
        String string = null;
        if (window instanceof Frame) {
            string = ((Frame)window).getTitle();
        } else if (window instanceof Dialog) {
            string = ((Dialog)window).getTitle();
        }
        ScreenProperties.winos_setWindowAlwaysOnTop(string, bl);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Deprecated
    public static void winos_setWindowAlwaysOnTop(String var0, boolean var1_1) {
        try {
            if (var0 == null) {
                return;
            }
        }
        catch (UnsatisfiedLinkError v0) {
            throw ScreenProperties.a(v0);
        }
        try {
            if (OSVersion.isWindows() == false) return;
            ** GOTO lbl14
        }
        catch (UnsatisfiedLinkError v1) {
            try {
                throw ScreenProperties.a(v1);
lbl14:
                // 2 sources

                if (ScreenProperties.libraryLoaded == false) return;
            }
            catch (AccessControlException v2) {
                throw ScreenProperties.a(v2);
            }
            {
                try {}
                catch (UnsatisfiedLinkError var2_2) {
                    ScreenProperties.logOnce("winos_makeWindowAlwaysOnTop", "winos_makeWindowAlwaysOnTop failed", var2_2);
                    return;
                }
            }
        }
        ScreenProperties.theInstance.setWindowAlwaysOnTop(var0, var1_1);
    }

    public static boolean supportsResolution(int n, int n2) {
        block4: {
            try {
                try {
                    if (n > ScreenProperties.getCurrentScreenWidth() || n2 > ScreenProperties.getCurrentScreenHeight()) break block4;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                return true;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
        }
        return false;
    }

    public static int getMonitorRows() {
        return aj.aa().an();
    }

    public static int getMonitorColumns() {
        return aj.aa().am();
    }

    public static Monitor getMonitor(int n) {
        aj aj2;
        block7: {
            aj2 = aj.aa();
            try {
                if (!aj2.al()) {
                    aj2.ac();
                }
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            try {
                try {
                    if (n >= 0 && n <= aj2.ak().size() - 1) break block7;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                return null;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
        }
        return aj2.ak().get(n);
    }

    public static Monitor getMonitorAtPositon(Point point) {
        return ScreenProperties.getMonitorAtPosition(point.x, point.y);
    }

    public static Monitor getMonitorAtPosition(int n, int n2) {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        for (int i = 0; i < aj2.ak().size(); ++i) {
            Monitor monitor = aj2.ak().get(i);
            try {
                try {
                    if (monitor.matrixPosition.x != n || monitor.matrixPosition.y != n2) continue;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                return monitor;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
        }
        return null;
    }

    public Monitor getMonitorAtScreenPoint(Point point) {
        return ScreenProperties.getMonitorAtScreenPosition(point.x, point.y);
    }

    public static Monitor getMonitorAtScreenPosition(Point point) {
        return ScreenProperties.getMonitorAtScreenPosition(point.x, point.y);
    }

    public static Monitor getMonitorAtScreenPosition(int n, int n2) {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        for (int i = 0; i < aj2.ak().size(); ++i) {
            Monitor monitor = aj2.ak().get(i);
            try {
                if (!monitor.getScreenRect().contains(n, n2)) continue;
                return monitor;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
        }
        return null;
    }

    public static Monitor[] getMonitors() {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        return aj2.ak().toArray(new Monitor[0]);
    }

    public Monitor[] getAllMonitors() {
        return ScreenProperties.getMonitors();
    }

    public static List<Monitor> getMonitorsSortedByLocation() {
        Monitor[] monitorArray = ScreenProperties.getMonitors();
        ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
        try {
            for (int i = 0; i < monitorArray.length; ++i) {
                arrayList.add(monitorArray[i]);
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<Monitor> getAllMonitorsSortedByLocation() {
        return ScreenProperties.getMonitorsSortedByLocation();
    }

    public static Monitor getBiggestMonitor() {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        Monitor monitor = aj2.ak().get(0);
        for (int i = 1; i < aj2.ak().size(); ++i) {
            Monitor monitor2 = aj2.ak().get(i);
            if (monitor2.getWidth() + monitor2.getHeight() <= monitor.getWidth() + monitor.getHeight()) continue;
            monitor = monitor2;
        }
        return monitor;
    }

    public static Monitor getSmallestMonitor() {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        Monitor monitor = aj2.ak().get(0);
        for (int i = 1; i < aj2.ak().size(); ++i) {
            Monitor monitor2 = aj2.ak().get(i);
            if (monitor2.getWidth() + monitor2.getHeight() >= monitor.getWidth() + monitor.getHeight()) continue;
            monitor = monitor2;
        }
        return monitor;
    }

    public static float getScalingFactorForComponent(JComponent jComponent) {
        if (!jComponent.isShowing()) {
            return 1.0f;
        }
        Point point = jComponent.getLocationOnScreen();
        Monitor monitor = ScreenProperties.getMonitorAtScreenPosition(point);
        if (monitor != null) {
            Monitor monitor2 = monitor;
            return monitor2.getScalingFactor();
        }
        if (!ScreenProperties.getAllMonitorsShowingApplication(jComponent, 80).isEmpty()) {
            Monitor monitor3 = ScreenProperties.getAllMonitorsShowingApplication(jComponent, 80).firstElement();
            return monitor3.getScalingFactor();
        }
        return 1.0f;
    }

    public Vector<Monitor> getAllMonitorsShowingComponent(Component component, int n) {
        return ScreenProperties.getAllMonitorsShowingApplication(component, n);
    }

    public Vector<Monitor> getAllMonitorsShowingComponent(Component component, int n, boolean bl) {
        return ScreenProperties.getAllMonitorsShowingApplication(component, n, bl);
    }

    public static Vector<Monitor> getAllMonitorsShowingApplication(Component component, int n) {
        return ScreenProperties.getAllMonitorsShowingApplication(component, n, false);
    }

    public static Vector<Monitor> getAllMonitorsShowingApplication(Component component, int n, boolean bl) {
        Point point = ScreenProperties.getLocationOnScreen(component);
        try {
            if (point == null) {
                return new Vector<Monitor>();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        Rectangle rectangle = new Rectangle();
        rectangle.x = point.x;
        rectangle.y = point.y;
        rectangle.height = component.getSize().height;
        rectangle.width = component.getSize().width;
        return ScreenProperties.getAllMonitorsShowingApplication(rectangle, n, bl);
    }

    private static Point getLocationOnScreen(Component component) {
        try {
            if (component.isShowing()) {
                return component.getLocationOnScreen();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        LOGGER.debug("Component must be visible to get its location" + component.getClass().getName());
        return null;
    }

    public Vector<Monitor> getAllMonitorsShowingComponent(Rectangle rectangle, int n) {
        return ScreenProperties.getAllMonitorsShowingApplication(rectangle, n, false);
    }

    public Vector<Monitor> getMonitorsShowingApplication(Rectangle rectangle, int n, boolean bl) {
        return ScreenProperties.getAllMonitorsShowingApplication(rectangle, n, bl, this.getAllMonitors());
    }

    public static Vector<Monitor> getAllMonitorsShowingApplication(Rectangle rectangle, int n) {
        return ScreenProperties.getAllMonitorsShowingApplication(rectangle, n, false);
    }

    public static Vector<Monitor> getAllMonitorsShowingApplication(Rectangle rectangle, int n, boolean bl) {
        return ScreenProperties.getAllMonitorsShowingApplication(rectangle, n, bl, ScreenProperties.getMonitors());
    }

    public static Vector<Monitor> getAllMonitorsShowingApplication(Rectangle rectangle, int n, boolean bl, Monitor[] monitorArray) {
        Vector<Monitor> vector;
        block7: {
            vector = new Vector<Monitor>();
            class Aa
            implements Comparable<Aa> {
                private Monitor aa;
                private double ab;

                public Aa(Monitor monitor, double d) {
                    this.aa = monitor;
                    this.ab = d;
                }

                public int aa(Aa aa10) {
                    return (int)(this.ab - aa10.aa());
                }

                public double aa() {
                    return this.ab;
                }

                public Monitor ab() {
                    return this.aa;
                }
            }
            ArrayList<Aa> arrayList = new ArrayList<Aa>();
            for (Monitor monitor : monitorArray) {
                block6: {
                    try {
                        if (!monitor.coversGivenPercentOrMore(rectangle, n)) continue;
                        if (!bl) break block6;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    double d = monitor.getPercentageOfIntersectionWithRectangle(rectangle);
                    arrayList.add(new Aa(monitor, d));
                    continue;
                }
                vector.add(monitor);
            }
            try {
                if (!bl || arrayList.isEmpty()) break block7;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            Collections.sort(arrayList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Monitor monitor = ((Aa)arrayList.get(i)).ab();
                vector.add(monitor);
            }
        }
        return vector;
    }

    public static Rectangle getDefaultFrameSize(Component component) {
        Rectangle rectangle;
        if (component == null) {
            rectangle = ScreenProperties.getSmallestMonitor().getScreenRect();
        } else {
            Rectangle rectangle2 = component.getBounds();
            rectangle = ScreenProperties.getMonitorAtScreenPosition((int)rectangle2.getCenterX(), (int)rectangle2.getCenterY()).getScreenRect();
        }
        rectangle = ScreenProperties.applyDefaultScalingToRectangle(rectangle);
        return rectangle;
    }

    private static Rectangle applyDefaultScalingToRectangle(Rectangle rectangle) {
        int n = rectangle.width * 65 / 80;
        int n2 = rectangle.height * 65 / 80;
        int n3 = (rectangle.width - n) / 2;
        int n4 = (rectangle.height - n2) / 2;
        return new Rectangle(n3, n4, n, n2);
    }

    public static boolean isForcedMultiMonitor() {
        return System.getProperty(PROP_FORCE_MULTIMONITOR, "false").equalsIgnoreCase("true");
    }

    public static boolean hasMultiMonitor() {
        boolean bl;
        block8: {
            block7: {
                aj aj2 = aj.aa();
                try {
                    if (!aj2.al()) {
                        aj2.ac();
                    }
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                try {
                    try {
                        if (aj2.ak() == null || aj2.ak().size() <= 1) break block7;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    bl = true;
                    break block8;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isMultiMonitor() {
        boolean bl;
        block8: {
            block7: {
                aj aj2 = aj.aa();
                try {
                    if (!aj2.al()) {
                        aj2.ac();
                    }
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                try {
                    try {
                        if (!ScreenProperties.isForcedMultiMonitor() && !aj.aa().ao()) break block7;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    bl = true;
                    break block8;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
            }
            bl = false;
        }
        return bl;
    }

    static boolean isPseudoGrayscale(ColorModel colorModel) {
        boolean bl = true;
        int n = colorModel.getPixelSize();
        if (n < 16) {
            try {
                int n2 = -1;
                int n3 = 2 << n - 1;
                while (++n2 < n3) {
                    int n4 = colorModel.getRed(n2);
                    int n5 = colorModel.getGreen(n2);
                    int n6 = colorModel.getBlue(n2);
                    try {
                        if (n4 == n5 && n5 == n6) continue;
                    }
                    catch (Exception exception) {
                        throw ScreenProperties.a(exception);
                    }
                    bl = false;
                }
            }
            catch (Exception exception) {
                ScreenProperties.logOnce("isPseudoGrayscale", "isPseudoGrayscale failed", exception);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isHeadless() {
        return IS_HEADLESS;
    }

    /*
     * Loose catch block
     */
    static int getColorBitDepth(GraphicsDevice graphicsDevice) {
        int n;
        block10: {
            n = 16;
            try {
                block11: {
                    block9: {
                        DisplayMode displayMode = graphicsDevice.getDisplayMode();
                        if (displayMode == null) break block11;
                        n = displayMode.getBitDepth();
                        if (!StringTool.isTrue(System.getProperty("sun.java2d.noddraw", "false"))) break block9;
                        try {
                            block12: {
                                if (!OSVersion.isWindows()) break block9;
                                break block12;
                                catch (NullPointerException nullPointerException) {
                                    throw ScreenProperties.a(nullPointerException);
                                }
                            }
                            if (com.visustt.tools.system.ac.ac()) break block9;
                        }
                        catch (NullPointerException nullPointerException) {
                            throw ScreenProperties.a(nullPointerException);
                        }
                        int n2 = graphicsDevice.getDefaultConfiguration().getColorModel().getPixelSize();
                        if (n2 != n) {
                            n = n2;
                        }
                    }
                    if (n <= 0) {
                        n = graphicsDevice.getDefaultConfiguration().getColorModel().getPixelSize();
                    }
                    break block10;
                }
                n = graphicsDevice.getDefaultConfiguration().getColorModel().getPixelSize();
            }
            catch (NullPointerException nullPointerException) {
                LOGGER.warn((Object)("Failed to detect bitdepth - using default (" + n + ") " + nullPointerException), nullPointerException);
            }
            catch (InternalError internalError) {
                LOGGER.warn((Object)("Failed to detect bitdepth - using default (" + n + ") " + internalError), internalError);
            }
        }
        return n;
    }

    /*
     * Exception decompiling
     */
    static Rectangle[] getSpannedRects(Rectangle var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Rectangle[] getSpannedRectsForPortrait(Rectangle rectangle) {
        Rectangle[] rectangleArray = new Rectangle[]{new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height / 2), new Rectangle(rectangle.x, rectangle.y + rectangle.height / 2, rectangle.width, rectangle.height / 2)};
        return rectangleArray;
    }

    /*
     * Exception decompiling
     */
    private static Rectangle[] getSpannedRectsForLandscape(Rectangle var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static int isSpannedScreen(Rectangle rectangle) {
        return ScreenProperties.isSpannedScreen(rectangle, false);
    }

    private static int isSpannedScreen(Rectangle rectangle, boolean bl) {
        block27: {
            block31: {
                double d;
                block29: {
                    block28: {
                        try {
                            try {
                                if (rectangle.width <= rectangle.height) break block27;
                                if (!bl) break block28;
                            }
                            catch (AccessControlException accessControlException) {
                                throw ScreenProperties.a(accessControlException);
                            }
                            d = 0.6;
                            break block29;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                    }
                    d = 0.5;
                }
                double d2 = d;
                try {
                    if ((double)rectangle.height / (double)rectangle.width < d2) {
                        return 1;
                    }
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                if ((double)rectangle.height / (double)rectangle.width < 0.75) {
                    int n;
                    int[] nArray;
                    block30: {
                        int[] nArray2 = new int[]{1280, 1600, 1800, 2560};
                        nArray = new int[nArray2.length + 1];
                        nArray[0] = 1024;
                        try {
                            for (n = 1; n < nArray2.length; ++n) {
                                nArray[n] = nArray2[n];
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        n = (int)((double)rectangle.width * 50.0 / (double)rectangle.height);
                        try {
                            if (n == 75) {
                                return 1;
                            }
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        try {
                            try {
                                if (n != 80 || Arrays.binarySearch(nArray2, rectangle.height) < 0) break block30;
                            }
                            catch (AccessControlException accessControlException) {
                                throw ScreenProperties.a(accessControlException);
                            }
                            return 1;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                    }
                    try {
                        try {
                            try {
                                if (!bl || n <= 80) break block31;
                            }
                            catch (AccessControlException accessControlException) {
                                throw ScreenProperties.a(accessControlException);
                            }
                            if (Arrays.binarySearch(nArray, rectangle.height) < 0) break block31;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        return 1;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                }
            }
            return 0;
        }
        try {
            if ((double)rectangle.width / (double)rectangle.height < 0.75) {
                return 2;
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        return 0;
    }

    public static boolean isTaskbarAlwaysOnTop() {
        boolean bl = false;
        if (libraryLoaded) {
            try {
                bl = theInstance.isWindowsTaskbarAlwaysOnTop();
            }
            catch (Exception exception) {
                ScreenProperties.logOnce("isTaskbarAlwaysOnTop", "isTaskbarAlwaysOnTop failed", exception);
            }
        }
        return bl;
    }

    public static void setTaskbarZOrder(boolean bl) {
        if (libraryLoaded) {
            try {
                theInstance.setWindowsTaskbarZOrder(bl);
            }
            catch (Exception exception) {
                ScreenProperties.logOnce("setTaskbarZOrder", "setTaskbarZOrder failed", exception);
            }
        }
    }

    public static Rectangle getTaskbarBounds(boolean bl) {
        Rectangle rectangle = null;
        try {
            if (!OSVersion.isWindows()) {
                return rectangle;
            }
        }
        catch (Exception exception) {
            throw ScreenProperties.a(exception);
        }
        if (libraryLoaded) {
            try {
                rectangle = theInstance.getWindowsTaskbarProperties();
            }
            catch (Exception exception) {
                ScreenProperties.logOnce("getTaskbarBounds", "getTaskbarBounds failed", exception);
            }
        }
        try {
            if (bl) {
                return rectangle;
            }
        }
        catch (Exception exception) {
            throw ScreenProperties.a(exception);
        }
        if (rectangle == null) {
            int n = ScreenProperties.getCurrentScreenHeight() - 27;
            rectangle = new Rectangle(0, n, ScreenProperties.getCurrentScreenWidth(), 27);
        }
        return rectangle;
    }

    public Rectangle calculateTaskbarBounds(boolean bl) {
        return ScreenProperties.getTaskbarBounds(bl);
    }

    public static Rectangle getTaskbarBounds() {
        return ScreenProperties.getTaskbarBounds(false);
    }

    public static boolean supports256Gray() {
        boolean bl = true;
        String string = ScreenProperties.getColorSpaceType();
        if (string.equals("GRAY")) {
            boolean bl2;
            int n = Toolkit.getDefaultToolkit().getColorModel().getComponentSize(0);
            try {
                bl2 = n >= 8;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            bl = bl2;
        }
        return bl;
    }

    public static boolean supportsColorDepth(int n) {
        boolean bl;
        try {
            bl = n <= ScreenProperties.getCurrentColorDepth();
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        return bl;
    }

    public static Dimension getCurrentResolution() {
        Object object;
        Object object2;
        Dimension dimension = null;
        if (libraryLoaded) {
            try {
                object2 = MousePositionHandler.getMousePosition();
                object = ScreenProperties.getMonitorAtScreenPosition((Point)object2);
                if (object != null) {
                    Rectangle rectangle = ((Monitor)object).getScreenRect();
                    dimension = rectangle.getSize();
                } else {
                    ScreenProperties.logOnce("getCurrentResolutionNoMoni", "failed to detect monitor for mouseposition " + (Point)object2, null);
                }
            }
            catch (Exception exception) {
                ScreenProperties.logOnce("getCurrentResolutionLIB", "getCurrentResolution failed", exception);
            }
        }
        if (dimension == null) {
            try {
                object2 = ScreenProperties.getBiggestMonitor();
                object = ((Monitor)object2).getScreenRect();
                dimension = ((Rectangle)object).getSize();
            }
            catch (Exception exception) {
                ScreenProperties.logOnce("getCurrentResolutionBiggest", "getCurrentResolution failed " + exception, exception);
                dimension = Toolkit.getDefaultToolkit().getScreenSize();
            }
        }
        return dimension;
    }

    public static int getCurrentScreenWidth() {
        return ScreenProperties.getCurrentResolution().width;
    }

    public static int getCurrentScreenHeight() {
        return ScreenProperties.getCurrentResolution().height;
    }

    public static int getCurrentColorDepth() {
        return Toolkit.getDefaultToolkit().getColorModel().getPixelSize();
    }

    public static String getColorSpaceType() {
        int n = Toolkit.getDefaultToolkit().getColorModel().getColorSpace().getType();
        return switch (n) {
            case 0 -> "XYZ";
            case 1 -> "Lab";
            case 2 -> "Luv";
            case 3 -> "YCbCr";
            case 4 -> "Yxy";
            case 5 -> "RGB";
            case 6 -> "GRAY";
            case 7 -> "HSV";
            case 8 -> "HLS";
            case 9 -> "CMYK";
            case 11 -> "CMY";
            case 12 -> "2CLR";
            case 13 -> "3CLR";
            case 14 -> "4CLR";
            case 15 -> "5CLR";
            case 16 -> "6CLR";
            case 17 -> "7CLR";
            case 18 -> "8CLR";
            case 19 -> "9CLR";
            case 20 -> "ACLR";
            case 21 -> "BCLR";
            case 22 -> "CCLR";
            case 23 -> "DCLR";
            case 24 -> "ECLR";
            case 25 -> "FCLR";
            default -> "Unknown color space";
        };
    }

    public static Point calculateInScreenPos(Component component) {
        Point point = component.getLocation();
        Dimension dimension = component.getPreferredSize();
        int n = point.x + dimension.width;
        int n2 = point.y + dimension.height;
        Point[] pointArray = new Point[]{component.getLocation(), new Point(n, point.y), new Point(n, n2), new Point(point.x, n2)};
        Rectangle rectangle = ScreenProperties.getTaskbarBounds();
        boolean bl = false;
        Monitor[] monitorArray = ScreenProperties.getMonitors();
        int n3 = 0;
        while (true) {
            try {
                if (n3 >= pointArray.length || bl) break;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
            int n4 = 0;
            while (true) {
                block21: {
                    Rectangle rectangle2;
                    try {
                        try {
                            if (bl || n4 >= monitorArray.length) break;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        if (!monitorArray[n4].contains(pointArray[n3])) break block21;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    bl = true;
                    Rectangle rectangle3 = monitorArray[n4].getScreenRect();
                    if (n > rectangle3.x + rectangle3.width) {
                        point.x = rectangle3.x + rectangle3.width - dimension.width;
                        n = point.x + dimension.width;
                    }
                    if (n2 > rectangle3.y + rectangle3.height) {
                        point.y = rectangle3.y + rectangle3.height - dimension.height;
                        n2 = point.y + dimension.height;
                    }
                    try {
                        if (point.x < rectangle3.x) {
                            point.x = rectangle3.x;
                        }
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    try {
                        if (point.y < rectangle3.y) {
                            point.y = rectangle3.y;
                        }
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    if (rectangle != null && (rectangle2 = new Rectangle(point, dimension)).intersects(rectangle)) {
                        Rectangle rectangle4 = rectangle2.intersection(rectangle);
                        if (rectangle.intersectsLine(point.x, n2, n, n2)) {
                            point.y -= rectangle4.height + 1;
                            n2 = point.y + dimension.height;
                        }
                        if (rectangle.intersectsLine(n, point.y, n, n2)) {
                            point.x -= rectangle4.width + 1;
                            n = point.x + dimension.width;
                        }
                        if (rectangle.intersectsLine(point.x, point.y, n, point.y)) {
                            point.y += rectangle4.height + 1;
                            n2 = point.y + dimension.height;
                        }
                        if (rectangle.intersectsLine(point.x, point.y, point.x, n2)) {
                            point.x += rectangle4.width + 1;
                            n = point.x + dimension.width;
                        }
                    }
                }
                ++n4;
            }
            ++n3;
        }
        return point;
    }

    private static void logOnce(Object object, String string, Throwable throwable) {
        try {
            if (!loggedBeforeList.contains(object)) {
                loggedBeforeList.add(object);
                LOGGER.error((Object)(string + ":" + throwable), throwable);
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
    }

    private static boolean isValidRatio(Rectangle rectangle) {
        boolean bl;
        block5: {
            block4: {
                int n = Math.max(rectangle.width, rectangle.height);
                int n2 = Math.min(rectangle.width, rectangle.height);
                int n3 = (int)((double)n2 / (double)n * 100.0);
                try {
                    try {
                        if (n3 != 75 && n3 != 80) break block4;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    bl = true;
                    break block5;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static Monitor getMostCompatibleMonitor(boolean bl) {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        Monitor monitor = aj2.ak().get(0);
        for (int i = 1; i < aj2.ak().size(); ++i) {
            Monitor monitor2;
            block12: {
                block11: {
                    block10: {
                        monitor2 = aj2.ak().get(i);
                        try {
                            if (!monitor.isColor() || monitor2.isColor()) break block10;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        monitor = monitor2;
                        continue;
                    }
                    try {
                        if (!monitor.isPseudoGrayscale() || !monitor2.isStaticGrayscale()) break block11;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    monitor = monitor2;
                    continue;
                }
                try {
                    if (!bl) break block12;
                    if (monitor.getColorDepth() >= monitor2.getColorDepth()) continue;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                monitor = monitor2;
                continue;
            }
            if (monitor.getColorDepth() <= monitor2.getColorDepth()) continue;
            monitor = monitor2;
        }
        return monitor;
    }

    public static Rectangle getFrameBounds(Frame frame) {
        Rectangle rectangle = frame.getBounds();
        if (ScreenProperties.isFrameMaximized(frame)) {
            Vector<Monitor> vector = new Vector<Monitor>();
            Monitor[] monitorArray = ScreenProperties.getMonitors();
            int n = 0;
            while (true) {
                block13: {
                    try {
                        try {
                            if (n >= monitorArray.length) break;
                            if (!monitorArray[n].coversGivenPercentOrMore(rectangle, 33.0)) break block13;
                        }
                        catch (AccessControlException accessControlException) {
                            throw ScreenProperties.a(accessControlException);
                        }
                        vector.add(monitorArray[n]);
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                }
                ++n;
            }
            Rectangle rectangle2 = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, 0);
            for (int i = 0; i < vector.size(); ++i) {
                Monitor monitor = (Monitor)vector.get(i);
                try {
                    if (monitor.getX() < rectangle2.x) {
                        rectangle2.x = monitor.getX();
                    }
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                try {
                    if (monitor.getY() < rectangle2.y) {
                        rectangle2.y = monitor.getY();
                    }
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
                rectangle2.height += monitor.getHeight();
                rectangle2.width += monitor.getWidth();
            }
            rectangle = rectangle2;
        }
        return rectangle;
    }

    public static Insets getMonitorInsets(Monitor monitor) {
        Insets insets = monitor != null ? monitor.getInsets() : ScreenProperties.simulateMonitorInsets();
        return insets;
    }

    private static Insets simulateMonitorInsets() {
        return new Insets(0, 0, 40, 0);
    }

    public static Rectangle calculateDefaultScreensizeWithoutTaskbar() {
        return ScreenProperties.calculateScreensizeWithoutTaskbar(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration());
    }

    public static Rectangle calculateScreensizeWithoutTaskbar(GraphicsConfiguration graphicsConfiguration) {
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        return ScreenProperties.calculateEffectiveAreaOfScreen(rectangle, insets);
    }

    public static Rectangle calculateEffectiveAreaOfScreen(Rectangle rectangle, Insets insets) {
        Rectangle rectangle2 = new Rectangle();
        rectangle2.x = rectangle.x + insets.left;
        rectangle2.y = rectangle.y + insets.top;
        rectangle2.height = rectangle.height - insets.top - insets.bottom;
        rectangle2.width = rectangle.width - insets.left - insets.right;
        return rectangle2;
    }

    public static boolean isFrameMaximized(Frame frame) {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (frame == null || frame.getExtendedState() != 6) break block4;
                    }
                    catch (AccessControlException accessControlException) {
                        throw ScreenProperties.a(accessControlException);
                    }
                    bl = true;
                    break block5;
                }
                catch (AccessControlException accessControlException) {
                    throw ScreenProperties.a(accessControlException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static Monitor getMonitorByID(String string) {
        aj aj2 = aj.aa();
        try {
            if (!aj2.al()) {
                aj2.ac();
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        try {
            if (!StringTool.isDefined(string)) {
                return null;
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        for (Monitor monitor : aj2.ak()) {
            try {
                if (!monitor.getMonitorID().equals(string)) continue;
                return monitor;
            }
            catch (AccessControlException accessControlException) {
                throw ScreenProperties.a(accessControlException);
            }
        }
        return null;
    }

    public static void checkDualMonitorJava14Workarounds() {
        String string = System.getProperty("dualmonitor.swing.workaround.enabled", "true");
        try {
            if (StringTool.isFalse(string)) {
                return;
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
        try {
            if (ScreenProperties.getMonitors().length > 1) {
                System.setProperty("swing.volatileImageBufferEnabled", "false");
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
    }

    public static Rectangle getDefaultFrameSizeForMonitor(Monitor monitor) {
        return ScreenProperties.applyDefaultScalingToRectangle(monitor.getScreenRect());
    }

    static void reset() {
        isGrayScaleMonitor = null;
    }

    public static void main(String[] stringArray) {
        aj.aa().ad();
        try {
            for (int i = 0; i < ScreenProperties.getMonitors().length; ++i) {
                System.out.println(ScreenProperties.getMonitors()[i].toString());
                System.out.println(ScreenProperties.getMonitorColumns());
            }
        }
        catch (AccessControlException accessControlException) {
            throw ScreenProperties.a(accessControlException);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        RegistryKey registryKey;
        block15: {
            boolean bl;
            block17: {
                block16: {
                    try {
                        LOGGER = LoggerFactory.getInstance("jx.util.screen.properties");
                        IS_HEADLESS = Boolean.getBoolean("java.awt.headless");
                        lockTimeout0 = false;
                        theInstance = new ScreenProperties();
                        libraryLoaded = false;
                        loggedBeforeList = new Vector();
                        if (!IS_HEADLESS) {
                            libraryLoaded = LibLoader.loadLibrary("VisusClient");
                        }
                    }
                    catch (Exception exception) {
                        throw ScreenProperties.a(exception);
                    }
                    if (IS_HEADLESS) return;
                    registryKey = null;
                    registryKey = Registry.HKEY_CURRENT_USER.openSubKey(LOCK_TIMEOUT_REG_PATH);
                    if (registryKey == null) break block15;
                    RegistryValue registryValue = registryKey.getValue("ForegroundLockTimeout");
                    if (!(registryValue instanceof RegDWordValue)) break block15;
                    try {
                        block18: {
                            if (((RegDWordValue)registryValue).getData() != 0) break block16;
                            break block18;
                            catch (Exception exception) {
                                throw ScreenProperties.a(exception);
                            }
                        }
                        bl = true;
                        break block17;
                    }
                    catch (Exception exception) {
                        throw ScreenProperties.a(exception);
                    }
                }
                bl = false;
            }
            lockTimeout0 = bl;
        }
        try {
            if (registryKey == null) return;
            registryKey.closeKeyFinalize();
            return;
        }
        catch (Exception exception) {
            throw ScreenProperties.a(exception);
        }
        catch (Exception exception) {
            try {
                LOGGER.debug(exception);
                if (registryKey == null) return;
                registryKey.closeKeyFinalize();
                return;
            }
            catch (Throwable throwable) {
                try {
                    if (registryKey == null) throw throwable;
                    registryKey.closeKeyFinalize();
                    throw throwable;
                }
                catch (Exception exception2) {
                    throw ScreenProperties.a(exception2);
                }
            }
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

