/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.awt.event;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.system.LibLoader;
import com.visustt.tools.system.OSVersion;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;

public class MousePositionHandler {
    private static Logger logger;
    private static boolean libraryLoaded;
    private static boolean noMouseWarningLogged;
    private static boolean noNativeMouseCoordLogged;
    public static final int INVALID_MOUSECOORD_VALUE = -99999;
    static Point mousePosition;
    private static final MousePositionHandler theInstance;

    private native Point getWindowsMousePosition();

    public static Point getMousePosition() {
        Object object;
        if (libraryLoaded) {
            try {
                object = theInstance.getWindowsMousePosition();
                if (MousePositionHandler.isValidMousePosition((Point)object)) {
                    MousePositionHandler.mousePosition.x = ((Point)object).x;
                    MousePositionHandler.mousePosition.y = ((Point)object).y;
                    return mousePosition;
                }
                if (!noNativeMouseCoordLogged) {
                    logger.warn("could not detect pointer device (mouse) position using native library.");
                    noNativeMouseCoordLogged = true;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (throwable instanceof ThreadDeath) {
                        throw (ThreadDeath)throwable;
                    }
                }
                catch (Throwable throwable2) {
                    throw MousePositionHandler.a(throwable2);
                }
                logger.error((Object)("getMousePosition() failed in native Windows Library: " + throwable), throwable);
            }
        }
        if ((object = MouseInfo.getPointerInfo()) != null) {
            Point point = ((PointerInfo)object).getLocation();
            MousePositionHandler.mousePosition.x = point.x;
            MousePositionHandler.mousePosition.y = point.y;
        } else if (!noMouseWarningLogged) {
            noMouseWarningLogged = true;
            RuntimeException runtimeException = new RuntimeException("no pointer device (mouse) detected");
            runtimeException.fillInStackTrace();
            logger.warn(runtimeException);
        }
        return mousePosition;
    }

    private static boolean isValidMousePosition(Point point) {
        boolean bl;
        block7: {
            block6: {
                try {
                    try {
                        try {
                            if (point == null || point.x <= -99999) break block6;
                        }
                        catch (RuntimeException runtimeException) {
                            throw MousePositionHandler.a(runtimeException);
                        }
                        if (point.y <= -99999) break block6;
                    }
                    catch (RuntimeException runtimeException) {
                        throw MousePositionHandler.a(runtimeException);
                    }
                    bl = true;
                    break block7;
                }
                catch (RuntimeException runtimeException) {
                    throw MousePositionHandler.a(runtimeException);
                }
            }
            bl = false;
        }
        return bl;
    }

    static {
        block4: {
            try {
                try {
                    logger = LoggerFactory.getInstance("jx.util.mouse.poshandler");
                    libraryLoaded = false;
                    if (!OSVersion.isWindows() || (libraryLoaded = LibLoader.loadLibrary("VisusClient"))) break block4;
                }
                catch (RuntimeException runtimeException) {
                    throw MousePositionHandler.a(runtimeException);
                }
                logger.error("failed to load VisusClient");
            }
            catch (RuntimeException runtimeException) {
                throw MousePositionHandler.a(runtimeException);
            }
        }
        noMouseWarningLogged = false;
        noNativeMouseCoordLogged = false;
        mousePosition = new Point(-99999, -99999);
        theInstance = new MousePositionHandler();
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

