/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.log.appender;

import com.visustt.jiveX.tools.log.aa.ad;
import com.visustt.log.Log4JLoggerConfiguration;
import com.visustt.tools.lang.thread.ae;
import java.io.PrintStream;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;

public class TextAreaAppender
extends AbstractAppender
implements ad {
    private JTextArea outputTextArea;

    public TextAreaAppender(JTextArea jTextArea) {
        super("CombinedAppender", null, null, false, null);
        this.outputTextArea = jTextArea;
    }

    @Override
    public void handleRedirected(String string, PrintStream printStream) {
        this.printMessage(string);
        if (printStream != null) {
            printStream.println(string);
        }
    }

    public void append(LogEvent logEvent) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        StringBuilder stringBuilder = new StringBuilder(dateFormat.format(new Date(logEvent.getTimeMillis())));
        stringBuilder.append(" [" + logEvent.getThreadName() + "] " + logEvent.getLevel());
        stringBuilder.append(" " + logEvent.getLoggerName() + " - " + logEvent.getMessage());
        Throwable throwable = logEvent.getThrown();
        if (throwable != null) {
            stringBuilder.append("\n");
            stringBuilder.append(ae.aa(throwable));
        }
        this.printMessage(stringBuilder.toString());
    }

    protected void printMessage(String string) {
        SwingUtilities.invokeLater(() -> {
            Document document = this.outputTextArea.getDocument();
            this.outputTextArea.append(string + "\n");
            if (document != null) {
                this.outputTextArea.setCaretPosition(document.getLength());
            }
        });
    }

    public void registerAppender() {
        Log4JLoggerConfiguration.registerAppender((Appender)this);
    }

    public void clearAppender() {
        Log4JLoggerConfiguration.removeAppender((Appender)this);
    }
}

