/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.log;

import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.jTools.configManager.main.RootElement;
import com.visustt.tools.io.aw;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.util.jar.ManifestLocater;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilderFactory;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.RootLoggerComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfigurationFactory;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;

public class Log4JLoggerConfiguration {
    static final String PRODUCT_INFO = "product.info";

    private Log4JLoggerConfiguration() {
    }

    static Log4JLoggerConfiguration of() {
        return new Log4JLoggerConfiguration();
    }

    private static RootLoggerComponentBuilder creatreRootLogger(Level level, ConfigurationBuilder<BuiltConfiguration> configurationBuilder, String ... stringArray) {
        RootLoggerComponentBuilder rootLoggerComponentBuilder = configurationBuilder.newRootLogger(level);
        for (String string : stringArray) {
            rootLoggerComponentBuilder.add(configurationBuilder.newAppenderRef(string));
        }
        return rootLoggerComponentBuilder;
    }

    protected static LayoutComponentBuilder creatrePatternLayout(ConfigurationBuilder<BuiltConfiguration> configurationBuilder) {
        LayoutComponentBuilder layoutComponentBuilder = configurationBuilder.newLayout("PatternLayout");
        layoutComponentBuilder.addAttribute("pattern", "%d{yyyy-MM-dd HH:mm:ss.SSS} [%t] %p %c - %m%n");
        return layoutComponentBuilder;
    }

    private static AppenderComponentBuilder creatreConsoleAppender(String string, ConfigurationBuilder<BuiltConfiguration> configurationBuilder) {
        AppenderComponentBuilder appenderComponentBuilder = configurationBuilder.newAppender(string, "Console");
        appenderComponentBuilder.add(Log4JLoggerConfiguration.creatrePatternLayout(configurationBuilder));
        return appenderComponentBuilder;
    }

    private static AppenderComponentBuilder creatreRollingFileAppender(String string, String string2, ConfigurationBuilder<BuiltConfiguration> configurationBuilder) {
        AppenderComponentBuilder appenderComponentBuilder = configurationBuilder.newAppender(string, "RollingFile");
        appenderComponentBuilder.addAttribute("fileName", string2 + ".log");
        appenderComponentBuilder.addAttribute("filePattern", string2 + "-%i.log");
        appenderComponentBuilder.addAttribute("ignoreExceptions", "false");
        appenderComponentBuilder.add(Log4JLoggerConfiguration.creatrePatternLayout(configurationBuilder));
        ComponentBuilder componentBuilder = configurationBuilder.newComponent("SizeBasedTriggeringPolicy").addAttribute("size", "5M");
        ComponentBuilder componentBuilder2 = configurationBuilder.newComponent("Policies").addComponent(componentBuilder);
        appenderComponentBuilder.addComponent(componentBuilder2);
        ComponentBuilder componentBuilder3 = configurationBuilder.newComponent("DefaultRolloverStrategy").addAttribute("max", "20");
        appenderComponentBuilder.addComponent(componentBuilder3);
        return appenderComponentBuilder;
    }

    protected BuiltConfiguration newDefaultConsoleConfiguration(Level level) {
        ConfigurationBuilder configurationBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
        configurationBuilder.setConfigurationName("DefaultConsole");
        configurationBuilder.add(Log4JLoggerConfiguration.creatreConsoleAppender("stdout", (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder));
        configurationBuilder.add(Log4JLoggerConfiguration.creatreRootLogger(level, (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder, "stdout"));
        return (BuiltConfiguration)configurationBuilder.build();
    }

    protected BuiltConfiguration newDefaultFileConfiguration(Level level, String string) {
        ConfigurationBuilder configurationBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
        configurationBuilder.setConfigurationName("DefaultFile");
        configurationBuilder.add(Log4JLoggerConfiguration.creatreRollingFileAppender("rolling", string, (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder));
        configurationBuilder.add(Log4JLoggerConfiguration.creatreRootLogger(level, (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder, "rolling"));
        return (BuiltConfiguration)configurationBuilder.build();
    }

    protected BuiltConfiguration newDefaultFileAndConsoleConfiguration(Level level, String string) {
        ConfigurationBuilder configurationBuilder = ConfigurationBuilderFactory.newConfigurationBuilder();
        configurationBuilder.setConfigurationName("DefaultFileAndConsole");
        configurationBuilder.add(Log4JLoggerConfiguration.creatreConsoleAppender("stdout", (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder));
        configurationBuilder.add(Log4JLoggerConfiguration.creatreRollingFileAppender("rolling", string, (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder));
        configurationBuilder.add(Log4JLoggerConfiguration.creatreRootLogger(level, (ConfigurationBuilder<BuiltConfiguration>)configurationBuilder, "stdout", "rolling"));
        return (BuiltConfiguration)configurationBuilder.build();
    }

    protected void configure(Configuration configuration) {
        if (configuration != null) {
            this.initProductInfo();
            Configurator.reconfigure((Configuration)configuration);
            this.printProductInfo();
        }
    }

    protected void printProductInfo() {
        Logger logger = this.getInitLogger();
        String string = System.getProperty(PRODUCT_INFO);
        if (string != null) {
            logger.always().log(string);
        }
        if (logger.isInfoEnabled()) {
            StringBuilder stringBuilder = new StringBuilder();
            Log4JLoggerConfiguration.dumpAppenders(stringBuilder);
            Log4JLoggerConfiguration.dumpLoggers(stringBuilder);
            logger.info(stringBuilder.toString());
        }
    }

    protected Logger getInitLogger() {
        return LogManager.getLogger((String)"Init");
    }

    public static void configureDefaultConsole(Level level) {
        Log4JLoggerConfiguration.of().defaultConsole(level);
    }

    protected void defaultConsole(Level level) {
        this.configure((Configuration)this.newDefaultConsoleConfiguration(level));
    }

    public static void configureDefaultFile(Level level, String string) {
        Log4JLoggerConfiguration.of().defaultFile(level, string);
    }

    protected void defaultFile(Level level, String string) {
        this.configure((Configuration)this.newDefaultFileConfiguration(level, string));
    }

    public static void configureDefaultFileAndConsole(Level level, String string) {
        Log4JLoggerConfiguration.of().defaultFileAndConsole(level, string);
    }

    protected void defaultFileAndConsole(Level level, String string) {
        this.configure((Configuration)this.newDefaultFileAndConsoleConfiguration(level, string));
    }

    public static void configurePropertyFile(String string) throws IOException {
        Log4JLoggerConfiguration.of().propertyFile(string);
    }

    protected void propertyFile(String string) throws IOException {
        File file = new File(string);
        try (InputStream inputStream = Files.newInputStream(file.toPath(), StandardOpenOption.READ);){
            ConfigurationSource configurationSource = new ConfigurationSource(inputStream, file);
            this.propertySource(configurationSource);
        }
    }

    public static void configureProperties(Properties properties) throws IOException {
        Log4JLoggerConfiguration.of().properties(properties);
    }

    protected void properties(Properties properties) throws IOException {
        byte[] byArray = aw.aa(properties);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            ConfigurationSource configurationSource = new ConfigurationSource((InputStream)byteArrayInputStream);
            this.propertySource(configurationSource);
        }
    }

    public static void configurePropertySource(ConfigurationSource configurationSource) {
        Log4JLoggerConfiguration.of().propertySource(configurationSource);
    }

    protected void propertySource(ConfigurationSource configurationSource) {
        Configuration configuration = PropertiesConfigurationFactory.getInstance().getConfiguration(null, configurationSource);
        this.configure(configuration);
    }

    public static void configureXML(ConfigurationElement configurationElement, String string) throws IOException {
        Log4JLoggerConfiguration.of().xml(configurationElement, string);
    }

    protected void xml(ConfigurationElement configurationElement, String string) throws IOException {
        byte[] byArray = RootElement.getXMLBytes(configurationElement, true, false, false, false);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            ConfigurationSource configurationSource = new ConfigurationSource((InputStream)byteArrayInputStream, new File(string));
            Configuration configuration = XmlConfigurationFactory.getInstance().getConfiguration(null, configurationSource);
            this.configure(configuration);
        }
    }

    public static void dumpLoggers(StringBuilder stringBuilder) {
        Logger logger = LogManager.getRootLogger();
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            LoggerContext loggerContext = ((org.apache.logging.log4j.core.Logger)logger).getContext();
            Collection collection = loggerContext.getLoggers();
            for (org.apache.logging.log4j.core.Logger logger2 : collection) {
                stringBuilder.append("\n\tName: " + logger2.getName() + "; Level: " + logger2.getLevel() + "; Additive: " + logger2.isAdditive());
                Map map = logger2.getAppenders();
                Log4JLoggerConfiguration.dumpAppenders(map, stringBuilder);
            }
        }
    }

    private static void dumpAppenders(Map<String, Appender> map, StringBuilder stringBuilder) {
        Set<Map.Entry<String, Appender>> set = map.entrySet();
        for (Map.Entry<String, Appender> entry : set) {
            stringBuilder.append("\n\t\tAppender: " + entry.getKey() + " " + entry.toString());
        }
    }

    public static void dumpAppenders(StringBuilder stringBuilder) {
        Log4JLoggerConfiguration.dumpAppenders(Log4JLoggerConfiguration.getAppenders(), stringBuilder);
    }

    void initProductInfo() {
        if (StringTool.isDefined(System.getProperty(PRODUCT_INFO))) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendManifestInfo(stringBuilder);
        Log4JLoggerConfiguration.appendHostInfo(stringBuilder);
        stringBuilder.append(", jvm=");
        stringBuilder.append(System.getProperty("java.version", ""));
        stringBuilder.append(System.getProperty("java.vm.name", ""));
        stringBuilder.append(System.getProperty("java.vm.version", ""));
        stringBuilder.append(", os=");
        stringBuilder.append(System.getProperty("os.name", ""));
        stringBuilder.append(System.getProperty("os.version", ""));
        stringBuilder.append(System.getProperty("os.arch", ""));
        stringBuilder.append(", current_dir=");
        stringBuilder.append(StringTool.replaceAllString(new File("").getAbsolutePath(), "\\", "\\\\"));
        String string = System.getProperty("jx.cs.sharedConfigurationFolder", "");
        if (StringTool.isDefined(string)) {
            stringBuilder.append(", shared configuration folder=");
            stringBuilder.append(string);
        }
        stringBuilder.append(" *\n");
        System.setProperty(PRODUCT_INFO, stringBuilder.toString());
    }

    protected void appendManifestInfo(StringBuilder stringBuilder) {
        try {
            Manifest manifest = this.locateManifestThatContainsMainValue();
            if (manifest != null) {
                Attributes attributes = manifest.getMainAttributes();
                stringBuilder.append("* product=");
                Log4JLoggerConfiguration.appendValue(stringBuilder, "PROP_PRODUCT_NAME", attributes);
                Log4JLoggerConfiguration.appendValue(stringBuilder, "PROP_PRODUCT_VERSION", attributes);
                Log4JLoggerConfiguration.appendValue(stringBuilder, "PROP_PRODUCT_RC", attributes);
                Log4JLoggerConfiguration.appendValue(stringBuilder, "PROP_RELEASE_DATE", attributes);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Manifest locateManifestThatContainsMainValue() {
        try {
            return ManifestLocater.locateManifestThatContainsMainValue(Log4JLoggerConfiguration.class.getClassLoader(), "com.visustt.");
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void appendValue(StringBuilder stringBuilder, String string, Attributes attributes) {
        String string2 = attributes.getValue(string);
        if (string2 != null) {
            stringBuilder.append((Object)string2);
            stringBuilder.append(" ");
        }
    }

    protected static void appendHostInfo(StringBuilder stringBuilder) {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            try {
                if (inetAddress != null) {
                    stringBuilder.append(", host=");
                    stringBuilder.append(inetAddress.getHostAddress());
                    stringBuilder.append(" (");
                    stringBuilder.append(inetAddress.getHostName());
                    stringBuilder.append(")");
                }
            }
            catch (Exception exception) {
                throw Log4JLoggerConfiguration.a(exception);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static boolean hasAppender() {
        Map<String, Appender> map = Log4JLoggerConfiguration.getAppenders();
        return !map.isEmpty();
    }

    public static Map<String, Appender> getAppenders() {
        Logger logger = LogManager.getRootLogger();
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            return ((org.apache.logging.log4j.core.Logger)logger).getAppenders();
        }
        return Collections.emptyMap();
    }

    public static void registerAppender(Appender appender) {
        if (appender == null) {
            return;
        }
        Logger logger = LogManager.getRootLogger();
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            appender.start();
            ((org.apache.logging.log4j.core.Logger)logger).addAppender(appender);
        }
    }

    public static void removeAppender(Appender appender) {
        if (appender == null) {
            return;
        }
        Logger logger = LogManager.getRootLogger();
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            ((org.apache.logging.log4j.core.Logger)logger).removeAppender(appender);
        }
    }

    public static boolean istDefaultConfiguration() {
        Logger logger = LogManager.getRootLogger();
        if (logger instanceof org.apache.logging.log4j.core.Logger) {
            LoggerContext loggerContext = ((org.apache.logging.log4j.core.Logger)logger).getContext();
            return loggerContext.getConfiguration() instanceof DefaultConfiguration;
        }
        return false;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

