/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.viewer.components.volumerendering;

import com.visustt.dicomTk.imageplane.ImagePlane;
import com.visustt.dicomTk.model.ag;
import com.visustt.dicomTk.model.ao;
import com.visustt.jiveX.viewer.ae.ae;
import com.visustt.jiveX.viewer.components.af.aa.af;
import com.visustt.jiveX.viewer.components.af.aj;
import com.visustt.jiveX.viewer.components.af.al;
import com.visustt.jiveX.viewer.components.ap;
import com.visustt.jiveX.viewer.components.aq;
import com.visustt.jiveX.viewer.components.function.am;
import com.visustt.jiveX.viewer.components.viewer3d.utility.MPRUtilities;
import com.visustt.jiveX.viewer.components.volumerendering.VolumeRenderingException;
import com.visustt.jiveX.viewer.components.volumerendering.aa;
import com.visustt.jiveX.viewer.components.volumerendering.ab;
import com.visustt.jiveX.viewer.components.volumerendering.ac;
import com.visustt.jiveX.viewer.components.volumerendering.ad;
import com.visustt.jiveX.viewer.components.volumerendering.ae;
import com.visustt.jiveX.viewer.components.volumerendering.ai;
import com.visustt.tools.awt.screen.GraphicCardProperties;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import vtk.vtkAbstractPicker;
import vtk.vtkAbstractVolumeMapper;
import vtk.vtkActor;
import vtk.vtkBMPWriter;
import vtk.vtkBoxWidget;
import vtk.vtkCamera;
import vtk.vtkCellArray;
import vtk.vtkCleanPolyData;
import vtk.vtkColorTransferFunction;
import vtk.vtkContourItem;
import vtk.vtkContourListMaskGenerationFilter;
import vtk.vtkContourSegmentationFilter;
import vtk.vtkCursor3D;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkFocalPlanePointPlacer;
import vtk.vtkIdList;
import vtk.vtkImageData;
import vtk.vtkJPEGWriter;
import vtk.vtkLight;
import vtk.vtkMapper;
import vtk.vtkMath;
import vtk.vtkMatrix4x4;
import vtk.vtkPNGWriter;
import vtk.vtkPiecewiseFunction;
import vtk.vtkPlanes;
import vtk.vtkPointPicker;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkRenderLargeImage;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkSmartVolumeMapper;
import vtk.vtkTransform;
import vtk.vtkUnsignedCharArray;
import vtk.vtkVolume;
import vtk.vtkVolumeMapper;
import vtk.vtkVolumeProperty;

public class VolumeRenderer
extends aj
implements PropertyChangeListener {
    private static final Logger loggerError = LoggerFactory.getInstance("jx.client.vtkerror");
    private static final Logger loggerRenderMode = LoggerFactory.getInstance("jx.client.vtkrendermode");
    private static final Logger loggerInit = LoggerFactory.getInstance("jx.client.vtkinit");
    private static final Logger loggerGPUSupport = LoggerFactory.getInstance("jx.client.vtkgpusupport");
    private static final Logger loggerSystemMemory = LoggerFactory.getInstance("jx.client.vtkmemory");
    private static final Logger loggerFPS = LoggerFactory.getInstance("jx.client.vtkfps");
    private static final double[] CROSSHAIRS_COLOR = new double[]{(double)com.visustt.tools.awt.af.am.getRed() / 255.0, (double)com.visustt.tools.awt.af.am.getGreen() / 255.0, (double)com.visustt.tools.awt.af.am.getBlue() / 255.0};
    private static final Object syncObject = new Object();
    private vtkRenderWindow renderWindow;
    private vtkRenderer renderer;
    private vtkLight light;
    private vtkActor crosshairsMarkerActor3D;
    private vtkSmartVolumeMapper mapperSmart;
    private vtkImageData imageData;
    private vtkImageData mask;
    private vtkPointPicker picker;
    private vtkVolume volume;
    private vtkPiecewiseFunction opacityTransferFunction;
    private vtkColorTransferFunction colorTransferFunction;
    private vtkVolumeProperty volumeProperty;
    private vtkBoxWidget boxWidget;
    private vtkPlanes planes;
    private vtkRenderWindowInteractor iren;
    private vtkMatrix4x4 volumeTransformationMatrix;
    private vtkUnsignedCharArray bufferedImageVtkPixelData;
    private vtkContourListMaskGenerationFilter contourListMaskGenerationFilter;
    private vtkContourSegmentationFilter contourSegmentationFilter;
    private vtkTransform initialBoxWidgetTransform;
    private double[] originalPixelSpacing;
    private boolean hasChanged;
    private boolean softwareRenderingInUse;
    private boolean downsamplingActive;
    private boolean abort = false;
    private ao originalImageCollection;
    private ap modelAccessor;
    private BufferedImage bufferedVTKImage;
    private GraphicsConfiguration graphicsConfiguration;
    private ad volumeRenderingModel;
    private ae volumeRenderingMouseHandler;
    private double[] volumeBounds;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VolumeRenderer(ad ad2, af af2) throws VolumeRenderingException {
        super(com.visustt.jiveX.viewer.components.af.al.aa(af2));
        Object object = syncObject;
        synchronized (object) {
            this.volumeRenderingModel = ad2;
            if (loggerGPUSupport.debugIsEnabled()) {
                loggerGPUSupport.debug(this.getDirectXGPUInfos());
                loggerGPUSupport.debug(this.getWMIGPUInfos());
            }
            try {
                if (loggerSystemMemory.debugIsEnabled()) {
                    loggerSystemMemory.debug(this.getSystemMemoryInfos());
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
            try {
                if (this.abort) {
                    throw new VolumeRenderingException("Volume Rendering aborted");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
            long l = System.currentTimeMillis();
            try {
                this.initialize();
                if (this.abort) {
                    throw new VolumeRenderingException("Volume Rendering aborted");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
            try {
                this.acquireSeriesInformations();
                if (this.abort) {
                    throw new VolumeRenderingException("Volume Rendering aborted");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
            long l2 = 0L;
            if (loggerInit.debugIsEnabled()) {
                l2 = System.currentTimeMillis() - l;
            }
            try {
                this.initVTKImageData();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.delete();
                loggerError.debug(outOfMemoryError + ": Allocation of native bytebuffer failed!");
                throw new VolumeRenderingException("Allocation of native bytebuffer failed!");
            }
            catch (VolumeRenderingException volumeRenderingException) {
                this.delete();
                loggerError.debug(volumeRenderingException + ": Could not get native ByteBuffer from MemoryManager!");
                throw new VolumeRenderingException("Could not get native ByteBuffer from MemoryManager!");
            }
            try {
                if (this.abort) {
                    throw new VolumeRenderingException("Volume Rendering aborted");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
            try {
                this.initVTKRenderPanel();
                if (this.abort) {
                    throw new VolumeRenderingException("Volume Rendering aborted");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
            try {
                this.initVTKVolumeMapper();
                this.initVTKVolumeProperty();
                this.initVTKClippingBox();
                this.setPreset();
                this.initBoxCaptureClip();
                this.initCameraOrientationAndPosition();
                this.setAutoAdjustSamplingDistanceToOff();
                if (loggerInit.debugIsEnabled()) {
                    loggerInit.debug("Time for initializing series-data and pixelbuffer: " + l2 + " ms");
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw VolumeRenderer.a(outOfMemoryError);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        Object object = syncObject;
        synchronized (object) {
            this.setHasChanged(false);
            this.setSoftwareRenderingInUse(false);
            this.setVolumeRenderingMouseHandler(new ae(this.getModel(), this));
            this.getModel().aa(this);
            this.setOriginalImageCollection(this.getModel().ag());
            this.setModelAccessor(this.getModel().aK());
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            this.graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            this.originalPixelSpacing = new double[3];
            this.renderWindow = this.createRenderWindow();
            this.renderer = this.createRenderer();
            this.renderWindow.AddRenderer(this.renderer);
            this.light = this.createLight();
            this.renderer.AddLight(this.light);
            this.mapperSmart = this.createSmartVolumeMapper();
            this.volumeProperty = this.createVolumeProperty();
            this.mask = this.createImageData();
            this.opacityTransferFunction = this.createPiecewiseFunction();
            this.colorTransferFunction = this.createColorTransferFunction();
            this.volume = this.createVolume();
            this.planes = this.createPlanes();
            this.crosshairsMarkerActor3D = this.createActor();
            this.boxWidget = this.createBoxWidget();
            this.picker = this.createPointPicker();
            this.iren = this.createRenderWindowInteractor();
            this.setVolumeTransformationMatrix(this.createMatrix4x4());
            this.bufferedImageVtkPixelData = this.createUnsignedCharArray();
            this.setContourListMaskGenerationFilter(this.createContourListMaskGeneratorFilter());
            this.initialBoxWidgetTransform = this.createTransform();
        }
    }

    protected vtkTransform createTransform() {
        return new vtkTransform();
    }

    protected vtkContourListMaskGenerationFilter createContourListMaskGeneratorFilter() {
        return new vtkContourListMaskGenerationFilter();
    }

    protected vtkUnsignedCharArray createUnsignedCharArray() {
        return new vtkUnsignedCharArray();
    }

    protected vtkMatrix4x4 createMatrix4x4() {
        return new vtkMatrix4x4();
    }

    protected vtkRenderWindowInteractor createRenderWindowInteractor() {
        return new vtkRenderWindowInteractor();
    }

    protected vtkPointPicker createPointPicker() {
        return new vtkPointPicker();
    }

    protected vtkBoxWidget createBoxWidget() {
        return new vtkBoxWidget();
    }

    protected vtkActor createActor() {
        return new vtkActor();
    }

    protected vtkPlanes createPlanes() {
        return new vtkPlanes();
    }

    protected vtkVolume createVolume() {
        return new vtkVolume();
    }

    protected vtkColorTransferFunction createColorTransferFunction() {
        return new vtkColorTransferFunction();
    }

    protected vtkPiecewiseFunction createPiecewiseFunction() {
        return new vtkPiecewiseFunction();
    }

    protected vtkImageData createImageData() {
        return new vtkImageData();
    }

    protected vtkVolumeProperty createVolumeProperty() {
        return new vtkVolumeProperty();
    }

    protected vtkSmartVolumeMapper createSmartVolumeMapper() {
        return new vtkSmartVolumeMapper();
    }

    protected vtkLight createLight() {
        return new vtkLight();
    }

    protected vtkRenderer createRenderer() {
        return new vtkRenderer();
    }

    protected vtkRenderWindow createRenderWindow() {
        return new vtkRenderWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void acquireSeriesInformations() {
        Object object = syncObject;
        synchronized (object) {
            if (this.getOriginalImageCollection() != null && this.getOriginalImageCollection().al()) {
                ag ag2 = this.getOriginalImageCollection().ae();
                this.originalPixelSpacing = this.getPixelSpacing();
                this.getVolumeTransformationMatrix().DeepCopy(this.getInitialOrientationTransformationMatrix(ag2));
                this.getModel().ar(this.getOriginalImageCollection().ae().ax);
                this.getModel().av(this.getOriginalPixelSpacing());
            }
        }
    }

    protected double[] getInitialOrientationTransformationMatrix(ag ag2) {
        return MPRUtilities.getInitialOrientationTransformationMatrix(ag2);
    }

    protected double[] getPixelSpacing() {
        return MPRUtilities.getPixelSpacing(this.getOriginalImageCollection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVTKImageData() throws OutOfMemoryError, VolumeRenderingException {
        Object object = syncObject;
        synchronized (object) {
            this.imageData = this.getVolumeRenderingMemoryManager().aa(this.getOriginalImageCollection(), this.getModel());
        }
    }

    protected ac getVolumeRenderingMemoryManager() {
        return com.visustt.jiveX.viewer.components.volumerendering.ac.aa();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVTKRenderPanel() {
        Object object = syncObject;
        synchronized (object) {
            this.renderer.AddViewProp((vtkProp)this.getVolume());
            this.renderer.ResetCameraClippingRange();
            this.renderer.GetActiveCamera().ParallelProjectionOn();
            this.renderer.SetBackground(0.0, 0.0, 0.0);
            this.renderWindow.SetOffScreenRendering(1);
            this.renderWindow.Render();
            if (loggerGPUSupport.debugIsEnabled()) {
                loggerGPUSupport.debug("\nInfo about current Render Window: \n" + this.renderWindow.ReportCapabilities());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVTKVolumeMapper() {
        Object object = syncObject;
        synchronized (object) {
            this.getMapperSmart().SetInput(this.getImageData());
            this.getMapperSmart().SetMaxMemoryFraction(GraphicCardProperties.aa().aj());
            this.getMapperSmart().SetMaxMemoryInBytes(this.getModel().aaE());
            this.getMapperSmart().setForbidDownsampling(true);
            this.getMapperSmart().setLockSampleDistanceToInputSpacing(1);
            this.getMapperSmart().setRayCastMapperAutoAdjustSampleDistance(1);
            this.getMapperSmart().setMaskTypeToBinary();
            this.getMapperSmart().SetInterpolationModeToLinear();
            if (this.isSoftwareRenderingForcedByExternalInfluence()) {
                this.getMapperSmart().SetRequestedRenderModeToRayCast();
                this.setSoftwareRenderingInUse(true);
                if (loggerGPUSupport.debugIsEnabled()) {
                    loggerGPUSupport.debug("Software Rendering used!");
                }
            }
            this.getVolume().SetMapper((vtkAbstractVolumeMapper)this.getMapperSmart());
        }
    }

    protected boolean isSoftwareRenderingForcedByExternalInfluence() {
        return ai.ak();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVTKVolumeProperty() {
        Object object = syncObject;
        synchronized (object) {
            this.volumeProperty.SetInterpolationTypeToLinear();
            this.getVolume().SetProperty(this.volumeProperty);
            this.getVolume().PickableOn();
            this.volumeBounds = this.getVolume().GetBounds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVTKClippingBox() {
        Object object = syncObject;
        synchronized (object) {
            int n = com.visustt.dicomTk.model.ab.ag.aa(this.getModel().aE());
            this.iren.SetRenderWindow(this.renderWindow);
            this.iren.SetPicker((vtkAbstractPicker)this.picker);
            this.boxWidget.SetInput((vtkDataSet)this.getImageData());
            this.boxWidget.SetInteractor(this.iren);
            this.boxWidget.SetCurrentRenderer(this.renderer);
            this.boxWidget.SetPlaceFactor(1.0);
            this.boxWidget.SetInsideOut(1);
            this.boxWidget.SetScalingEnabled(1);
            this.boxWidget.SetRotationEnabled(0);
            this.boxWidget.SetOutlineCursorWires(0);
            this.boxWidget.PlaceWidget();
            this.boxWidget.AddObserver("InteractionEvent", (Object)this, "updateClippingBox");
            this.boxWidget.setHandleResizeFactor((double)n);
            this.boxWidget.GetTransform(this.initialBoxWidgetTransform);
        }
    }

    protected void restoreBoxWidget() {
        this.boxWidget.PlaceWidget(this.getModel().ab());
        this.updateClippingBox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPreset() {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = this.getModel().ad();
            double[] dArray2 = this.getModel().ar();
            double[] dArray3 = this.getModel().as();
            double[] dArray4 = this.getModel().at();
            double[] dArray5 = this.getModel().ae();
            double[] dArray6 = this.getModel().ai();
            this.colorTransferFunction.AllowDuplicateScalarsOn();
            this.opacityTransferFunction.AllowDuplicateScalarsOn();
            this.colorTransferFunction.RemoveAllPoints();
            this.opacityTransferFunction.RemoveAllPoints();
            for (int i = 0; i < dArray.length; ++i) {
                this.colorTransferFunction.AddRGBPoint(dArray[i], dArray2[i], dArray3[i], dArray4[i], 0.0, dArray6[i]);
                this.opacityTransferFunction.AddPoint(dArray[i], dArray5[i], 0.0, dArray6[i]);
            }
            if (this.getModel().aac().equals("MIP")) {
                this.colorTransferFunction.ClampingOn();
                this.opacityTransferFunction.ClampingOn();
                this.getMapperSmart().SetBlendModeToMaximumIntensity();
                this.volumeProperty.ShadeOff();
            } else {
                this.getMapperSmart().SetBlendModeToComposite();
                this.colorTransferFunction.ClampingOff();
                this.opacityTransferFunction.ClampingOff();
                this.volumeProperty.SetAmbient(this.getModel().aY());
                this.volumeProperty.SetDiffuse(this.getModel().aX());
                this.volumeProperty.SetSpecular(this.getModel().aW());
                this.volumeProperty.SetSpecularPower(this.getModel().aV());
                this.volumeProperty.SetScalarOpacityUnitDistance(1.0);
                this.volumeProperty.ShadeOn();
            }
            this.volumeProperty.SetColor(this.colorTransferFunction);
            this.volumeProperty.SetScalarOpacity(this.opacityTransferFunction);
            this.getVolume().Update();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initBoxCaptureClip() {
        Object object = syncObject;
        synchronized (object) {
            if (this.getModel().a_() != null) {
                vtkTransform vtkTransform2 = this.createTransform();
                vtkTransform2.SetMatrix(this.getModel().a_());
                this.boxWidget.SetTransform(vtkTransform2);
                this.updateClippingBox();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCameraOrientationAndPosition() {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = this.getModel().aC();
            double[] dArray2 = this.getModel().aD();
            double[] dArray3 = this.getModel().aL();
            double[] dArray4 = this.getModel().aag();
            double[] dArray5 = this.getModel().aaf();
            Dimension dimension = this.getModel().aE();
            double d = this.getModel().aZ();
            double d2 = this.getModel().aah();
            if (dArray4 == null || dArray5 == null) {
                this.getModel().ao(this.getImageData().GetSpacing());
                this.getModel().an(this.getVolume().GetBounds());
            }
            if (dArray == null || dArray2 == null || dArray3 == null) {
                this.setCameraAxisOrientation("A");
                return;
            }
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkCamera2.SetPosition(dArray);
            vtkCamera2.SetViewUp(dArray3);
            vtkCamera2.SetFocalPoint(dArray2);
            vtkCamera2.SetRoll(d);
            double d3 = d2 != -1.0 ? ai.aa(d2, dimension, this.getModel()) : ai.aa(dimension, this.getModel());
            vtkCamera2.SetParallelScale(d3);
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMarker() {
        Object object = syncObject;
        synchronized (object) {
            if (this.renderWindow != null) {
                this.renderer.RemoveActor((vtkProp)this.crosshairsMarkerActor3D);
                this.setAutoAdjustSamplingDistanceToOff();
                this.setHasChanged(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public BufferedImage createBufferedVTKImage(Dimension var1_1) throws VolumeRenderingException {
        var2_2 = VolumeRenderer.syncObject;
        synchronized (var2_2) {
            block33: {
                var3_3 = 0L;
                if (VolumeRenderer.loggerFPS.debugIsEnabled()) {
                    var3_3 = System.currentTimeMillis();
                }
                if (this.getModel() == null) {
                    return new BufferedImage(var1_1.width, var1_1.height, 1);
                }
                this.getModel().ab(var1_1);
                try {
                    block34: {
                        block35: {
                            block32: {
                                block31: {
                                    if (this.renderWindow == null) {
                                        return this.getGraphicsConfiguration().createCompatibleImage(var1_1.width, var1_1.height, 1);
                                    }
                                    var5_4 = this.renderWindow.GetSize();
                                    if (var1_1.width != var5_4[0]) ** GOTO lbl21
                                    try {
                                        block36: {
                                            if (var1_1.height == var5_4[1]) break block31;
                                            break block36;
                                            catch (OutOfMemoryError v0) {
                                                throw VolumeRenderer.a(v0);
                                            }
                                        }
                                        v1 = true;
                                        break block32;
                                    }
                                    catch (OutOfMemoryError v2) {
                                        throw VolumeRenderer.a(v2);
                                    }
                                }
                                v1 = false;
                            }
                            var6_7 = v1;
                            try {
                                if (!this.isHasChanged() && !var6_7) break block33;
                            }
                            catch (OutOfMemoryError v3) {
                                throw VolumeRenderer.a(v3);
                            }
                            var7_8 = null;
                            try {
                                if (this.bufferedVTKImage != null) {
                                    this.bufferedVTKImage.flush();
                                    this.bufferedVTKImage.getGraphics().dispose();
                                }
                            }
                            catch (OutOfMemoryError v4) {
                                throw VolumeRenderer.a(v4);
                            }
                            if (!var6_7) break block34;
                            try {
                                block37: {
                                    if (this.isHasChanged()) break block35;
                                    break block37;
                                    catch (OutOfMemoryError v5) {
                                        throw VolumeRenderer.a(v5);
                                    }
                                }
                                this.renderWindow.setJustResize(1);
                            }
                            catch (OutOfMemoryError v6) {
                                throw VolumeRenderer.a(v6);
                            }
                        }
                        try {
                            this.renderWindow.SetSize(var1_1.width, var1_1.height);
                            if (VolumeRenderer.loggerError.debugIsEnabled()) {
                                VolumeRenderer.loggerError.debug("Gew\u00fcnschte ImageSize: " + var1_1.toString());
                                VolumeRenderer.loggerError.debug("Tats\u00e4chlich gesetzte RenderWindowSize: " + this.renderWindow.GetSize()[0] + ", " + this.renderWindow.GetSize()[1]);
                            }
                        }
                        catch (OutOfMemoryError v7) {
                            throw VolumeRenderer.a(v7);
                        }
                    }
                    this.renderWindow.Render();
                    this.renderWindow.GetPixelData(0, 0, var1_1.width - 1, var1_1.height - 1, 1, this.bufferedImageVtkPixelData);
                    this.bufferedVTKImage = this.getGraphicsConfiguration().createCompatibleImage(var1_1.width, var1_1.height, 1);
                    var7_8 = this.bufferedImageVtkPixelData.GetJavaArrayInt(var1_1.width, var1_1.height);
                    try {
                        for (var8_10 = 0; var8_10 < var7_8.length; ++var8_10) {
                            ((DataBufferInt)this.bufferedVTKImage.getRaster().getDataBuffer()).setElem(var8_10, var7_8[var8_10]);
                        }
                    }
                    catch (OutOfMemoryError v8) {
                        throw VolumeRenderer.a(v8);
                    }
                    try {
                        this.setHasChanged(false);
                        ai.aa((vtkVolumeMapper)this.getMapperSmart());
                        if (VolumeRenderer.loggerRenderMode.debugIsEnabled()) {
                            VolumeRenderer.loggerRenderMode.debug("Render Mode: " + ai.aj());
                        }
                    }
                    catch (OutOfMemoryError v9) {
                        throw VolumeRenderer.a(v9);
                    }
                }
                catch (OutOfMemoryError var5_5) {
                    VolumeRenderer.loggerError.debug("Not enough memory to get pixel array!");
                    throw new VolumeRenderingException("Not enough memory to get pixel array!");
                }
            }
            if (VolumeRenderer.loggerFPS.debugIsEnabled() && (var5_6 = (double)(System.currentTimeMillis() - var3_3) / 1000.0) != 0.0) {
                var7_9 = 1.0 / var5_6;
                VolumeRenderer.loggerFPS.debug("FPS: " + var7_9);
            }
            return this.bufferedVTKImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage createBufferedImagefromSubVolume(Dimension dimension, Point point, double d) throws VolumeRenderingException {
        Object object = syncObject;
        synchronized (object) {
            try {
                if (this.bufferedVTKImage != null) {
                    this.bufferedVTKImage.flush();
                    this.bufferedVTKImage.getGraphics().dispose();
                }
                int[] nArray = null;
                Point point2 = this.getViewportCenterDelta(point);
                this.translate(point2.x, point2.y);
                double d2 = this.renderer.GetActiveCamera().GetParallelScale();
                double d3 = ai.aa(d, new Dimension(this.getRenderWindowWidth(), this.getRenderWindowHeight()), this.getModel());
                this.renderer.GetActiveCamera().SetParallelScale(d3);
                this.renderWindow.Render();
                int n = this.renderWindow.GetSize()[0] / 2;
                int n2 = this.renderWindow.GetSize()[1] / 2;
                int n3 = dimension.width / 2;
                int n4 = dimension.height / 2;
                int n5 = n - n3;
                int n6 = n + n3;
                int n7 = n2 - n4;
                int n8 = n2 + n4;
                n6 += dimension.width - (n6 - n5);
                n8 += dimension.height - (n8 - n7);
                this.renderWindow.GetPixelData(n5, n7, n6 - 1, n8 - 1, 1, this.bufferedImageVtkPixelData);
                this.bufferedVTKImage = this.getGraphicsConfiguration().createCompatibleImage(dimension.width, dimension.height, 1);
                nArray = this.bufferedImageVtkPixelData.GetJavaArrayInt(dimension.width, dimension.height);
                try {
                    for (int i = 0; i < nArray.length; ++i) {
                        ((DataBufferInt)this.bufferedVTKImage.getRaster().getDataBuffer()).setElem(i, nArray[i]);
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw VolumeRenderer.a(outOfMemoryError);
                }
                this.setHasChanged(false);
                this.renderer.GetActiveCamera().SetParallelScale(d2);
                this.translate(-point2.x, -point2.y);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                loggerError.debug("Not enough memory to get pixel array!");
                throw new VolumeRenderingException("Not enough memory to get pixel array!");
            }
            return this.bufferedVTKImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getVolumeDiagonalLength() {
        Object object = syncObject;
        synchronized (object) {
            return (int)this.getVolume().GetLength();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Object object = syncObject;
        synchronized (object) {
            this.abort = true;
            if (this.renderWindow != null) {
                this.renderWindow.setJustResize(0);
            }
            if (this.getImageData() != null) {
                this.getImageData().Delete();
                this.imageData = null;
            }
            if (this.getModel() != null) {
                this.getModel().ab(this);
                this.volumeRenderingModel = null;
            }
            if (this.getMapperSmart() != null) {
                this.getMapperSmart().deleteAll();
                this.getMapperSmart().Delete();
                this.mapperSmart = null;
            }
            if (this.bufferedImageVtkPixelData != null) {
                this.bufferedImageVtkPixelData.Delete();
                this.bufferedImageVtkPixelData = null;
            }
            if (this.mask != null) {
                this.mask.ReleaseData();
                this.mask.Register(null);
                this.mask.RemoveAllObservers();
                this.mask.Delete();
                this.mask = null;
            }
            if (this.renderer != null) {
                this.renderer.Delete();
                this.renderer = null;
            }
            if (this.light != null) {
                this.light.Delete();
                this.light = null;
            }
            if (this.bufferedVTKImage != null) {
                this.bufferedVTKImage.flush();
                this.bufferedVTKImage.getGraphics().dispose();
                this.bufferedVTKImage = null;
            }
            this.setOriginalImageCollection(null);
            this.originalPixelSpacing = null;
            this.graphicsConfiguration = null;
            if (this.getVolume() != null) {
                this.getVolume().Delete();
                this.volume = null;
            }
            if (this.volumeProperty != null) {
                this.volumeProperty.Delete();
                this.volumeProperty = null;
            }
            if (this.opacityTransferFunction != null) {
                this.opacityTransferFunction.Delete();
                this.opacityTransferFunction = null;
            }
            if (this.colorTransferFunction != null) {
                this.colorTransferFunction.Delete();
                this.colorTransferFunction = null;
            }
            if (this.planes != null) {
                this.planes.Delete();
                this.planes = null;
            }
            if (this.crosshairsMarkerActor3D != null) {
                this.crosshairsMarkerActor3D.Delete();
                this.crosshairsMarkerActor3D = null;
            }
            if (this.boxWidget != null) {
                this.boxWidget.RemoveAllObservers();
                this.boxWidget.Delete();
                this.boxWidget = null;
            }
            if (this.picker != null) {
                this.picker.Delete();
                this.picker = null;
            }
            if (this.iren != null) {
                this.iren.Delete();
                this.iren = null;
            }
            if (this.getVolumeTransformationMatrix() != null) {
                this.getVolumeTransformationMatrix().Delete();
                this.setVolumeTransformationMatrix(null);
            }
            if (this.getContourListMaskGenerationFilter() != null) {
                this.getContourListMaskGenerationFilter().Delete();
                this.setContourListMaskGenerationFilter(null);
            }
            if (this.contourSegmentationFilter != null) {
                this.contourSegmentationFilter.Delete();
                this.contourSegmentationFilter = null;
            }
            if (this.initialBoxWidgetTransform != null) {
                this.initialBoxWidgetTransform.Delete();
                this.initialBoxWidgetTransform = null;
            }
            this.setVolumeRenderingMouseHandler(null);
            if (this.renderWindow != null) {
                this.renderWindow.Finalize();
                this.renderWindow = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateClippingBox() {
        Object object = syncObject;
        synchronized (object) {
            this.boxWidget.GetPlanes(this.planes);
            this.getVolume().GetMapper().SetClippingPlanes(this.planes);
            this.getVolume().Update();
            double[] dArray = this.planes.GetPoints().GetBounds();
            if (dArray[1] < this.volumeBounds[1] || dArray[3] < this.volumeBounds[3] || dArray[5] < this.volumeBounds[5] || dArray[0] > this.volumeBounds[0] || dArray[2] > this.volumeBounds[2] || dArray[4] > this.volumeBounds[4]) {
                this.getModel().af(true);
            } else if (dArray[1] >= this.volumeBounds[1] && dArray[3] >= this.volumeBounds[3] && dArray[5] >= this.volumeBounds[5] && dArray[0] <= this.volumeBounds[0] && dArray[2] <= this.volumeBounds[2] && dArray[4] <= this.volumeBounds[4]) {
                this.getModel().af(false);
            }
            this.getModel().ac(dArray);
            this.setHasChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freehandClip() {
        Object object = syncObject;
        synchronized (object) {
            Polygon polygon = this.getModel().ah();
            if (polygon != null && polygon.npoints > 2) {
                double[] dArray;
                Object object2;
                vtkFocalPlanePointPlacer vtkFocalPlanePointPlacer2 = new vtkFocalPlanePointPlacer();
                vtkPolyData vtkPolyData2 = new vtkPolyData();
                vtkPoints vtkPoints2 = new vtkPoints();
                vtkCellArray vtkCellArray2 = new vtkCellArray();
                vtkPoints2.SetNumberOfPoints((long)polygon.npoints);
                vtkIdList vtkIdList2 = new vtkIdList();
                vtkIdList2.SetNumberOfIds((long)polygon.npoints);
                for (int i = 0; i < polygon.npoints; ++i) {
                    object2 = new double[]{polygon.xpoints[i], this.renderWindow.GetSize()[1] - polygon.ypoints[i]};
                    dArray = new double[3];
                    double[] dArray2 = new double[9];
                    vtkFocalPlanePointPlacer2.ComputeWorldPosition(this.renderer, (double[])object2, dArray, dArray2);
                    vtkPoints2.SetPoint((long)i, dArray);
                    vtkIdList2.SetId((long)i, (long)i);
                }
                vtkCellArray2.InsertNextCell(vtkIdList2);
                vtkPolyData2.SetPoints(vtkPoints2);
                vtkPolyData2.SetLines(vtkCellArray2);
                vtkCleanPolyData vtkCleanPolyData2 = new vtkCleanPolyData();
                vtkCleanPolyData2.SetInput((vtkDataObject)vtkPolyData2);
                vtkCleanPolyData2.Update();
                object2 = vtkCleanPolyData2.GetOutput();
                dArray = new double[(int)(object2.GetNumberOfPoints() * 3L)];
                int n = 0;
                int n2 = 0;
                while ((long)n2 < object2.GetNumberOfPoints()) {
                    dArray[n++] = object2.GetPoint((long)n2)[0];
                    dArray[n++] = object2.GetPoint((long)n2)[1];
                    dArray[n++] = object2.GetPoint((long)n2)[2];
                    ++n2;
                }
                if (this.isSoftwareRenderingInUse()) {
                    this.contourSegmentationFilter = new vtkContourSegmentationFilter();
                    this.contourSegmentationFilter.SetImage(this.getMapperSmart().GetInput());
                    this.contourSegmentationFilter.SetInput((vtkDataObject)this.getMapperSmart().GetInput());
                    this.contourSegmentationFilter.ObtainOrientationFromContourPolyDataOff();
                    this.contourSegmentationFilter.VolumetricProjectionOn();
                    this.contourSegmentationFilter.SetRenderer(this.renderer);
                    this.contourSegmentationFilter.SetSegmentationExtentToImageExtent();
                    this.contourSegmentationFilter.SetReplaceValue(-1000.0);
                    this.contourSegmentationFilter.SetSegmentInside(this.getModel().ao() ? 0 : 1);
                    this.contourSegmentationFilter.SetContourPolyData(object2);
                    vtkImageData vtkImageData2 = this.contourSegmentationFilter.GetImage();
                    int n3 = vtkImageData2.GetReleaseDataFlag();
                    vtkImageData2.ReleaseDataFlagOn();
                    this.contourSegmentationFilter.Update();
                    vtkImageData vtkImageData3 = this.contourSegmentationFilter.GetOutput();
                    vtkImageData2.ShallowCopy((vtkDataObject)vtkImageData3);
                    vtkImageData2.SetReleaseDataFlag(n3);
                    this.updateVTKPanel();
                } else {
                    vtkVolumeMapper vtkVolumeMapper2 = this.getMapperSmart().GetLastUsedMapper();
                    vtkImageData vtkImageData4 = this.createImageData();
                    vtkImageData4 = vtkVolumeMapper2 == this.getMapperSmart().GetGPULowResMapper() ? this.getMapperSmart().GetGPUResampleFilter().GetOutput() : this.getMapperSmart().GetInput();
                    this.getContourListMaskGenerationFilter().SetImage(vtkImageData4);
                    this.getContourListMaskGenerationFilter().SetInput((vtkDataObject)vtkImageData4);
                    this.getContourListMaskGenerationFilter().ObtainOrientationFromContourPolyDataOff();
                    this.getContourListMaskGenerationFilter().SetSegmentationExtentToImageExtent();
                    this.getContourListMaskGenerationFilter().SetReplaceValue(1.0);
                    vtkContourItem vtkContourItem2 = new vtkContourItem();
                    vtkContourItem2.SetContourPolyData(object2);
                    vtkContourItem2.SetImage(vtkImageData4);
                    vtkContourItem2.VolumetricProjectionOn();
                    vtkContourItem2.SetSegmentInside(this.getModel().ao() ? 0 : 1);
                    vtkContourItem2.InitializeCameraParametersFromRenderer(this.renderer);
                    this.getContourListMaskGenerationFilter().GetContourItems().AddItem(vtkContourItem2);
                    vtkMatrix4x4 vtkMatrix4x42 = vtkContourItem2.GetDirectionCosineMatrix();
                    double[] dArray3 = new double[]{vtkMatrix4x42.GetElement(0, 0), vtkMatrix4x42.GetElement(0, 1), vtkMatrix4x42.GetElement(0, 2), vtkMatrix4x42.GetElement(0, 3), vtkMatrix4x42.GetElement(1, 0), vtkMatrix4x42.GetElement(1, 1), vtkMatrix4x42.GetElement(1, 2), vtkMatrix4x42.GetElement(1, 3), vtkMatrix4x42.GetElement(2, 0), vtkMatrix4x42.GetElement(2, 1), vtkMatrix4x42.GetElement(2, 2), vtkMatrix4x42.GetElement(2, 3), vtkMatrix4x42.GetElement(3, 0), vtkMatrix4x42.GetElement(3, 1), vtkMatrix4x42.GetElement(3, 2), vtkMatrix4x42.GetElement(3, 3)};
                    vtkMatrix4x4 vtkMatrix4x43 = vtkContourItem2.GetProjectionMatrix();
                    double[] dArray4 = new double[]{vtkMatrix4x43.GetElement(0, 0), vtkMatrix4x43.GetElement(0, 1), vtkMatrix4x43.GetElement(0, 2), vtkMatrix4x43.GetElement(0, 3), vtkMatrix4x43.GetElement(1, 0), vtkMatrix4x43.GetElement(1, 1), vtkMatrix4x43.GetElement(1, 2), vtkMatrix4x43.GetElement(1, 3), vtkMatrix4x43.GetElement(2, 0), vtkMatrix4x43.GetElement(2, 1), vtkMatrix4x43.GetElement(2, 2), vtkMatrix4x43.GetElement(2, 3), vtkMatrix4x43.GetElement(3, 0), vtkMatrix4x43.GetElement(3, 1), vtkMatrix4x43.GetElement(3, 2), vtkMatrix4x43.GetElement(3, 3)};
                    this.getModel().aS().add(dArray3);
                    this.getModel().aT().add(dArray4);
                    this.getModel().aO().add(vtkContourItem2.GetFocalPoint());
                    this.getModel().aU().add(vtkContourItem2.GetParallelProjection());
                    this.getModel().aP().add(vtkContourItem2.GetSegmentInside());
                    this.updateContourFilter();
                }
                this.getModel().aab().add(dArray);
                polygon.reset();
                this.getModel().aa(polygon);
                this.getModel().ac(true);
                this.getModel().aa(this.getContourListMaskGenerationFilter().GetContourItems().GetNumberOfItems());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateContourFilter() {
        Object object = syncObject;
        synchronized (object) {
            this.getContourListMaskGenerationFilter().Modified();
            this.getContourListMaskGenerationFilter().Update();
            this.mask.ShallowCopy((vtkDataObject)this.getContourListMaskGenerationFilter().GetOutput());
            this.getMapperSmart().setMaskInput(this.mask);
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void freehandCaptureClip() {
        Object object = syncObject;
        synchronized (object) {
            List<double[]> list = this.getModel().aab();
            List<double[]> list2 = this.getModel().aS();
            List<double[]> list3 = this.getModel().aO();
            List<double[]> list4 = this.getModel().aT();
            List<Integer> list5 = this.getModel().aU();
            List<Integer> list6 = this.getModel().aP();
            int n = this.getModel().aaA();
            if (n != 0) {
                for (int i = 0; i < n; ++i) {
                    double[] dArray = list.get(i);
                    vtkPolyData vtkPolyData2 = new vtkPolyData();
                    vtkPoints vtkPoints2 = new vtkPoints();
                    vtkCellArray vtkCellArray2 = new vtkCellArray();
                    vtkPoints2.SetNumberOfPoints((long)(dArray.length / 3));
                    vtkIdList vtkIdList2 = new vtkIdList();
                    vtkIdList2.SetNumberOfIds(vtkPoints2.GetNumberOfPoints());
                    int n2 = 0;
                    for (int j = 0; j < dArray.length; j += 3) {
                        vtkPoints2.SetPoint((long)n2, new double[]{dArray[j], dArray[j + 1], dArray[j + 2]});
                        vtkIdList2.SetId((long)n2, (long)n2);
                        ++n2;
                    }
                    vtkCellArray2.InsertNextCell(vtkIdList2);
                    vtkPolyData2.SetPoints(vtkPoints2);
                    vtkPolyData2.SetLines(vtkCellArray2);
                    vtkMatrix4x4 vtkMatrix4x42 = this.createMatrix4x4();
                    vtkMatrix4x42.DeepCopy(list2.get(i));
                    vtkMatrix4x4 vtkMatrix4x43 = this.createMatrix4x4();
                    vtkMatrix4x43.DeepCopy(list4.get(i));
                    vtkVolumeMapper vtkVolumeMapper2 = this.getMapperSmart().GetLastUsedMapper();
                    vtkImageData vtkImageData2 = vtkVolumeMapper2 == this.getMapperSmart().GetGPULowResMapper() ? this.getMapperSmart().GetGPUResampleFilter().GetOutput() : this.getMapperSmart().GetInput();
                    this.getContourListMaskGenerationFilter().SetImage(vtkImageData2);
                    this.getContourListMaskGenerationFilter().SetInput((vtkDataObject)vtkImageData2);
                    this.getContourListMaskGenerationFilter().ObtainOrientationFromContourPolyDataOff();
                    this.getContourListMaskGenerationFilter().SetSegmentationExtentToImageExtent();
                    this.getContourListMaskGenerationFilter().SetReplaceValue(1.0);
                    vtkContourItem vtkContourItem2 = new vtkContourItem();
                    vtkContourItem2.SetImage(vtkImageData2);
                    vtkContourItem2.VolumetricProjectionOn();
                    vtkContourItem2.SetContourPolyData(vtkPolyData2);
                    vtkContourItem2.SetDirectionCosineMatrix(vtkMatrix4x42);
                    vtkContourItem2.SetProjectionMatrix(vtkMatrix4x43);
                    vtkContourItem2.SetFocalPoint(list3.get(i));
                    vtkContourItem2.SetParallelProjection(list5.get(i).intValue());
                    vtkContourItem2.SetSegmentInside(list6.get(i).intValue());
                    this.getContourListMaskGenerationFilter().GetContourItems().AddItem(vtkContourItem2);
                    this.getModel().aa(this.getContourListMaskGenerationFilter().GetContourItems().GetNumberOfItems());
                    this.getModel().ac(true);
                }
                this.updateContourFilter();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undoFreehandClip() {
        Object object = syncObject;
        synchronized (object) {
            if (!ai.ak()) {
                this.getContourListMaskGenerationFilter().GetContourItems().Undo();
                this.updateContourFilter();
                int n = this.getModel().aaA();
                if (--n < 0) {
                    n = 0;
                }
                if (n == 0) {
                    this.getModel().ac(false);
                }
                this.getModel().aa(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void redoFreehandClip() {
        Object object = syncObject;
        synchronized (object) {
            if (!ai.ak()) {
                this.getContourListMaskGenerationFilter().GetContourItems().Redo();
                this.updateContourFilter();
                int n = this.getModel().aaA();
                int n2 = this.getContourListMaskGenerationFilter().GetContourItems().GetNumberOfItems();
                if (++n > n2) {
                    n = n2;
                }
                this.getModel().ac(true);
                this.getModel().aa(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getPickPosition(Point point) {
        Object object = syncObject;
        synchronized (object) {
            this.picker.SetTolerance(0.001);
            this.picker.SetOpacityReference(com.visustt.jiveX.viewer.components.volumerendering.ab.ac);
            double[] dArray = this.getModel().ab();
            if (dArray == null) {
                dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            }
            this.picker.Pick((double)point.x, (double)(this.renderWindow.GetSize()[1] - point.y), 0.0, this.renderer, dArray, this.getMapperSmart().getMaskInput());
            if (this.picker.GetPointId() == -1L) {
                return null;
            }
            double[] dArray2 = this.picker.GetPickPosition();
            for (int i = 0; i < 3; ++i) {
                int n = i;
                dArray2[n] = dArray2[n] / this.getOriginalPixelSpacing()[i];
            }
            if (dArray2[2] < 0.0) {
                dArray2[2] = 0.0;
            }
            if ((int)dArray2[2] < this.getOriginalImageCollection().aa() && dArray2[2] >= 0.0) {
                ag ag2 = this.getOriginalImageCollection().aa((int)dArray2[2]);
                return ag2.ax().getWorldCoordinatesFromSubpixel(dArray2[0], dArray2[1]);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoAdjustSamplingDistanceToOff() {
        Object object = syncObject;
        synchronized (object) {
            if (this.renderWindow != null) {
                this.renderWindow.SetDesiredUpdateRate(0.05);
            }
            this.downsamplingActive = false;
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoAdjustSamplingDistanceToOn() {
        Object object = syncObject;
        synchronized (object) {
            double d = ai.aa();
            if (this.renderWindow != null) {
                this.renderWindow.SetDesiredUpdateRate(d);
                this.renderer.setGPUDownsamplingFactor(5.0 / d);
            }
            this.downsamplingActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDesiredInteractorUpdateRateToZero() {
        Object object = syncObject;
        synchronized (object) {
            this.iren.SetDesiredUpdateRate(0.0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set3DCrosshairsMarker(double[] dArray, boolean bl) {
        Object object = syncObject;
        synchronized (object) {
            double d;
            if (dArray == null) {
                this.removeMarker();
                return;
            }
            int n = am.aa(this.getOriginalImageCollection(), dArray);
            if (n == -1) {
                this.removeMarker();
                return;
            }
            af af2 = this.getModelAccessor().af().aq();
            if (af2.aK() == this) {
                return;
            }
            ImagePlane imagePlane = this.getOriginalImageCollection().aa(n).ax();
            Point2D.Double double_ = imagePlane.getProjectionWithDistanceCheck(dArray);
            if (double_ == null) {
                this.removeMarker();
                return;
            }
            double[] dArray2 = new double[]{double_.x * this.getOriginalPixelSpacing()[0], double_.y * this.getOriginalPixelSpacing()[1], (double)n * this.getOriginalPixelSpacing()[2]};
            double[] dArray3 = this.getVolumeDimensions();
            double d2 = Math.min(dArray3[2], Math.min(dArray3[1], dArray3[0]));
            int[] nArray = this.renderWindow.GetSize();
            int n2 = Math.min(nArray[0], nArray[1]);
            double d3 = 4.0 / (double)n2 * d2;
            if (d3 < 0.5) {
                d3 = 0.5;
            }
            if ((d = d3 * 10.0) > 10.0) {
                d = 10.0;
            }
            vtkCursor3D vtkCursor3D2 = new vtkCursor3D();
            vtkCursor3D2.SetModelBounds(this.getVolume().GetBounds());
            vtkCursor3D2.SetFocalPoint(dArray2);
            vtkCursor3D2.SetGap(d);
            vtkCursor3D2.AllOff();
            vtkCursor3D2.AxesOn();
            vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
            vtkPolyDataMapper2.SetInputConnection(vtkCursor3D2.GetOutputPort());
            this.crosshairsMarkerActor3D.SetMapper((vtkMapper)vtkPolyDataMapper2);
            this.crosshairsMarkerActor3D.GetProperty().SetColor(CROSSHAIRS_COLOR);
            this.crosshairsMarkerActor3D.GetProperty().SetLineWidth(d3);
            com.visustt.dicomTk.model.ap ap2 = this.getModel().af();
            if ((ap2.aN() || ap2.aO()) && !bl) {
                this.crosshairsMarkerActor3D.GetProperty().SetLineStipplePattern(21845);
                this.crosshairsMarkerActor3D.GetProperty().SetLineStippleRepeatFactor(5);
            } else {
                this.crosshairsMarkerActor3D.GetProperty().SetLineStipplePattern(65535);
                this.crosshairsMarkerActor3D.GetProperty().SetLineStippleRepeatFactor(1);
            }
            this.crosshairsMarkerActor3D.PickableOff();
            this.renderer.RemoveActor((vtkProp)this.crosshairsMarkerActor3D);
            this.renderer.AddActor((vtkProp)this.crosshairsMarkerActor3D);
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCameraAxisOrientation(String string) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            double[] dArray = vtkCamera2.GetFocalPoint();
            double[] dArray2 = vtkCamera2.GetPosition();
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[3];
            double d = Math.sqrt((dArray[0] - dArray2[0]) * (dArray[0] - dArray2[0]) + (dArray[1] - dArray2[1]) * (dArray[1] - dArray2[1]) + (dArray[2] - dArray2[2]) * (dArray[2] - dArray2[2]));
            if (string.equals("A")) {
                dArray3[0] = dArray[0];
                dArray3[1] = dArray[1] - d;
                dArray3[2] = dArray[2];
                dArray4[0] = 0.0;
                dArray4[1] = 0.0;
                dArray4[2] = 1.0;
            } else if (string.equals("P")) {
                dArray3[0] = dArray[0];
                dArray3[1] = dArray[1] + d;
                dArray3[2] = dArray[2];
                dArray4[0] = 0.0;
                dArray4[1] = 0.0;
                dArray4[2] = 1.0;
            } else if (string.equals("L")) {
                dArray3[0] = dArray[0] + d;
                dArray3[1] = dArray[1];
                dArray3[2] = dArray[2];
                dArray4[0] = 0.0;
                dArray4[1] = 0.0;
                dArray4[2] = 1.0;
            } else if (string.equals("R")) {
                dArray3[0] = dArray[0] - d;
                dArray3[1] = dArray[1];
                dArray3[2] = dArray[2];
                dArray4[0] = 0.0;
                dArray4[1] = 0.0;
                dArray4[2] = 1.0;
            } else if (string.equals("H")) {
                dArray3[0] = dArray[0];
                dArray3[1] = dArray[1];
                dArray3[2] = dArray[2] + d;
                dArray4[0] = 0.0;
                dArray4[1] = 1.0;
                dArray4[2] = 0.0;
            } else if (string.equals("F")) {
                dArray3[0] = dArray[0];
                dArray3[1] = dArray[1];
                dArray3[2] = dArray[2] - d;
                dArray4[0] = 0.0;
                dArray4[1] = -1.0;
                dArray4[2] = 0.0;
            }
            vtkTransform vtkTransform2 = this.createTransform();
            vtkTransform2.SetMatrix(this.getVolumeTransformationMatrix());
            vtkCamera2.SetPosition(dArray3);
            vtkCamera2.SetViewUp(dArray4);
            vtkCamera2.ApplyTransform(vtkTransform2);
            this.renderer.ResetCamera();
            double d2 = ai.aa(this.getModel().aE(), this.getModel());
            vtkCamera2.SetParallelScale(d2);
            this.updateCameraParametersInModel();
            this.setAutoAdjustSamplingDistanceToOff();
            this.updateVTKPanel();
        }
        aq.aa(this.getModelAccessor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyRelativeRotation(Matrix3d matrix3d) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            double d = this.getModel().aF();
            Point3d point3d = new Point3d(vtkCamera2.GetFocalPoint());
            Point3d point3d2 = new Point3d(vtkCamera2.GetPosition());
            Vector3d vector3d = new Vector3d(vtkCamera2.GetViewUp());
            point3d2.sub((Tuple3d)point3d);
            matrix3d.transform((Tuple3d)point3d2);
            point3d2.add((Tuple3d)point3d);
            matrix3d.transform((Tuple3d)vector3d);
            vtkTransform vtkTransform2 = this.createTransform();
            vtkTransform2.SetMatrix(this.getVolumeTransformationMatrix());
            vtkCamera2.SetPosition(new double[]{point3d2.x, point3d2.y, point3d2.z});
            vtkCamera2.SetViewUp(new double[]{vector3d.x, vector3d.y, vector3d.z});
            vtkCamera2.ApplyTransform(vtkTransform2);
            this.renderer.ResetCamera();
            this.setParallelScale(d);
            this.updateCameraParametersInModel();
            this.setAutoAdjustSamplingDistanceToOff();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setParallelScale(double d) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            if (d != -1.0) {
                vtkCamera2.SetParallelScale(d);
            } else {
                double d2 = ai.aa(this.getModel().aE(), this.getModel());
                vtkCamera2.SetParallelScale(d2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyAbsoluteRotation(Matrix3d matrix3d) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkMatrix4x4 vtkMatrix4x42 = vtkCamera2.GetViewTransformMatrix();
            Matrix3d matrix3d2 = new Matrix3d();
            matrix3d2.m00 = vtkMatrix4x42.GetElement(0, 0);
            matrix3d2.m01 = vtkMatrix4x42.GetElement(0, 1);
            matrix3d2.m02 = vtkMatrix4x42.GetElement(0, 2);
            matrix3d2.m10 = vtkMatrix4x42.GetElement(1, 0);
            matrix3d2.m11 = vtkMatrix4x42.GetElement(1, 1);
            matrix3d2.m12 = vtkMatrix4x42.GetElement(1, 2);
            matrix3d2.m20 = vtkMatrix4x42.GetElement(2, 0);
            matrix3d2.m21 = vtkMatrix4x42.GetElement(2, 1);
            matrix3d2.m22 = vtkMatrix4x42.GetElement(2, 2);
            matrix3d2.mul(-1.0);
            matrix3d2.mul(matrix3d, matrix3d2);
            this.applyRelativeRotation(matrix3d2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void equalizeCameraRotation(ad ad2) {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = ad2.aC();
            double[] dArray2 = ad2.aD();
            double[] dArray3 = ad2.aL();
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            double d = this.getModel().aF();
            vtkCamera2.SetPosition(dArray);
            vtkCamera2.SetViewUp(dArray3);
            vtkCamera2.SetFocalPoint(dArray2);
            this.setParallelScale(d);
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableClippingBox() {
        Object object = syncObject;
        synchronized (object) {
            if (this.boxWidget.GetEnabled() == 0) {
                this.boxWidget.On();
                this.getVolume().GetMapper().SetClippingPlanes(this.planes);
                this.getVolume().Update();
                this.setHasChanged(true);
            }
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableClippingBox() {
        Object object = syncObject;
        synchronized (object) {
            if (this.boxWidget.GetEnabled() == 1) {
                this.boxWidget.Off();
                this.getModel().ab(false);
                this.setHasChanged(true);
            }
            this.updateVTKPanel();
        }
    }

    protected void enableFreehandClipping() {
        this.getModel().aa(new Polygon());
    }

    protected void disableFreehandClipping() {
        if (this.getModel().ah() != null) {
            this.getModel().ah().reset();
        }
        this.setHasChanged(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateVTKPanel() {
        Object object = syncObject;
        synchronized (object) {
            this.renderer.ResetCameraClippingRange();
            this.light.SetPosition(this.renderer.GetActiveCamera().GetPosition());
            this.light.SetFocalPoint(this.renderer.GetActiveCamera().GetFocalPoint());
            this.setHasChanged(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCameraRotationAngle() {
        Object object = syncObject;
        synchronized (object) {
            double d = this.getModel().aA();
            int n = this.getModel().aB();
            vtkTransform vtkTransform2 = this.createTransform();
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkMath vtkMath2 = new vtkMath();
            double d2 = vtkMath2.Norm(vtkCamera2.GetPosition());
            if (d2 <= 0.0 && (d2 = vtkMath2.Norm(vtkCamera2.GetFocalPoint())) <= 0.0) {
                d2 = 1.0;
            }
            double[] dArray = vtkCamera2.GetFocalPoint();
            vtkCamera2.SetFocalPoint(dArray[0] / d2, dArray[1] / d2, dArray[2] / d2);
            dArray = vtkCamera2.GetPosition();
            vtkCamera2.SetPosition(dArray[0] / d2, dArray[1] / d2, dArray[2] / d2);
            double[] dArray2 = new double[3];
            double[] dArray3 = this.getVolume().GetCenter();
            vtkTransform2.Identity();
            vtkTransform2.Translate(dArray3[0] / d2, dArray3[1] / d2, dArray3[2] / d2);
            double[] dArray4 = vtkCamera2.GetViewUp();
            if (n == 12) {
                vtkCamera2.OrthogonalizeViewUp();
                vtkTransform2.RotateWXYZ(-d, dArray4[0], dArray4[1], dArray4[2]);
            } else if (n == 11) {
                vtkMath2.Cross(vtkCamera2.GetDirectionOfProjection(), dArray4, dArray2);
                vtkTransform2.RotateWXYZ(-d, dArray2[0], dArray2[1], dArray2[2]);
            }
            vtkTransform2.Translate(-dArray3[0] / d2, -dArray3[1] / d2, -dArray3[2] / d2);
            vtkCamera2.ApplyTransform(vtkTransform2);
            vtkCamera2.OrthogonalizeViewUp();
            dArray = vtkCamera2.GetFocalPoint();
            vtkCamera2.SetFocalPoint(dArray[0] * d2, dArray[1] * d2, dArray[2] * d2);
            dArray = vtkCamera2.GetPosition();
            vtkCamera2.SetPosition(dArray[0] * d2, dArray[1] * d2, dArray[2] * d2);
            this.renderer.ResetCameraClippingRange();
            vtkTransform2.Delete();
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Matrix3d getRotationMatrix() {
        Object object = syncObject;
        synchronized (object) {
            Matrix3d matrix3d = new Matrix3d();
            if (this.renderWindow == null) {
                return matrix3d;
            }
            vtkMatrix4x4 vtkMatrix4x42 = this.renderer.GetActiveCamera().GetViewTransformMatrix();
            vtkMatrix4x4 vtkMatrix4x43 = this.createMatrix4x4();
            vtkMatrix4x42.Multiply4x4(vtkMatrix4x42, this.getVolumeTransformationMatrix(), vtkMatrix4x43);
            matrix3d.m00 = vtkMatrix4x43.GetElement(0, 0);
            matrix3d.m01 = vtkMatrix4x43.GetElement(0, 1);
            matrix3d.m02 = vtkMatrix4x43.GetElement(0, 2);
            matrix3d.m10 = -vtkMatrix4x43.GetElement(1, 0);
            matrix3d.m11 = -vtkMatrix4x43.GetElement(1, 1);
            matrix3d.m12 = -vtkMatrix4x43.GetElement(1, 2);
            matrix3d.m20 = vtkMatrix4x43.GetElement(2, 0);
            matrix3d.m21 = vtkMatrix4x43.GetElement(2, 1);
            matrix3d.m22 = vtkMatrix4x43.GetElement(2, 2);
            return matrix3d;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetCameraPan() {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            double d = vtkCamera2.GetParallelScale();
            this.renderer.ResetCamera();
            vtkCamera2.SetParallelScale(d);
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    protected void resetCameraRotation(Matrix3d matrix3d) {
        if (!(matrix3d.equals(com.visustt.jiveX.viewer.components.viewer3d.ao.aaN) || matrix3d.equals(com.visustt.jiveX.viewer.components.viewer3d.ao.aaO) || matrix3d.equals(com.visustt.jiveX.viewer.components.viewer3d.ao.aaM))) {
            this.applyAbsoluteRotation(matrix3d);
            return;
        }
        vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
        double[] dArray = vtkCamera2.GetPosition();
        double[] dArray2 = vtkCamera2.GetFocalPoint();
        double[] dArray3 = vtkCamera2.GetViewUp();
        double[] dArray4 = this.getModel().aaG();
        double[] dArray5 = new double[]{dArray2[0] - dArray4[0], dArray2[1] - dArray4[1], dArray2[2] - dArray4[2]};
        double[] dArray6 = new double[]{dArray2[0] - dArray[0], dArray2[1] - dArray[1], dArray2[2] - dArray[2]};
        double[] dArray7 = new double[]{dArray4[0] - dArray[0], dArray4[1] - dArray[1], dArray4[2] - dArray[2]};
        double[] dArray8 = new double[3];
        vtkMath vtkMath2 = new vtkMath();
        vtkMath2.Cross(dArray6, dArray3, dArray8);
        vtkMath2.Normalize(dArray8);
        vtkMath2.Normalize(dArray6);
        double[] dArray9 = new double[3];
        double[] dArray10 = new double[3];
        double[] dArray11 = new double[3];
        if (matrix3d.equals(com.visustt.jiveX.viewer.components.viewer3d.ao.aaN)) {
            dArray9[0] = vtkMath2.Dot(dArray5, dArray8);
            dArray9[1] = -vtkMath2.Dot(dArray7, dArray6);
            dArray9[2] = vtkMath2.Dot(dArray5, dArray3);
            dArray10[0] = dArray9[0];
            dArray10[1] = 0.0;
            dArray10[2] = dArray9[2];
            dArray11[0] = 0.0;
            dArray11[1] = 0.0;
            dArray11[2] = 1.0;
        } else if (matrix3d.equals(com.visustt.jiveX.viewer.components.viewer3d.ao.aaM)) {
            dArray9[0] = vtkMath2.Dot(dArray5, dArray8);
            dArray9[1] = -vtkMath2.Dot(dArray5, dArray3);
            dArray9[2] = -vtkMath2.Dot(dArray7, dArray6);
            dArray10[0] = dArray9[0];
            dArray10[1] = dArray9[1];
            dArray10[2] = 0.0;
            dArray11[0] = 0.0;
            dArray11[1] = -1.0;
            dArray11[2] = 0.0;
        } else if (matrix3d.equals(com.visustt.jiveX.viewer.components.viewer3d.ao.aaO)) {
            dArray9[0] = vtkMath2.Dot(dArray7, dArray6);
            dArray9[1] = vtkMath2.Dot(dArray5, dArray8);
            dArray9[2] = vtkMath2.Dot(dArray5, dArray3);
            dArray10[0] = 0.0;
            dArray10[1] = dArray9[1];
            dArray10[2] = dArray9[2];
            dArray11[0] = 0.0;
            dArray11[1] = 0.0;
            dArray11[2] = 1.0;
        }
        vtkCamera2.SetPosition(dArray9);
        vtkCamera2.SetFocalPoint(dArray10);
        vtkCamera2.SetViewUp(dArray11);
        vtkMatrix4x4 vtkMatrix4x42 = this.createMatrix4x4();
        vtkMatrix4x42.Zero();
        vtkMatrix4x42.SetElement(0, 0, this.getVolumeTransformationMatrix().GetElement(0, 0));
        vtkMatrix4x42.SetElement(0, 1, this.getVolumeTransformationMatrix().GetElement(0, 1));
        vtkMatrix4x42.SetElement(0, 2, this.getVolumeTransformationMatrix().GetElement(0, 2));
        vtkMatrix4x42.SetElement(1, 0, this.getVolumeTransformationMatrix().GetElement(1, 0));
        vtkMatrix4x42.SetElement(1, 1, this.getVolumeTransformationMatrix().GetElement(1, 1));
        vtkMatrix4x42.SetElement(1, 2, this.getVolumeTransformationMatrix().GetElement(1, 2));
        vtkMatrix4x42.SetElement(2, 0, this.getVolumeTransformationMatrix().GetElement(2, 0));
        vtkMatrix4x42.SetElement(2, 1, this.getVolumeTransformationMatrix().GetElement(2, 1));
        vtkMatrix4x42.SetElement(2, 2, this.getVolumeTransformationMatrix().GetElement(2, 2));
        vtkMatrix4x42.SetElement(3, 3, this.getVolumeTransformationMatrix().GetElement(3, 3));
        vtkMatrix4x42.SetElement(0, 3, dArray4[0]);
        vtkMatrix4x42.SetElement(1, 3, dArray4[1]);
        vtkMatrix4x42.SetElement(2, 3, dArray4[2]);
        vtkTransform vtkTransform2 = this.createTransform();
        vtkTransform2.SetMatrix(vtkMatrix4x42);
        vtkCamera2.ApplyTransform(vtkTransform2);
        this.renderer.ResetCameraClippingRange();
        vtkMatrix4x42.Delete();
        this.updateCameraParametersInModel();
        this.setAutoAdjustSamplingDistanceToOff();
        this.updateVTKPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetFreehandClipping() {
        Object object = syncObject;
        synchronized (object) {
            if (this.getModel().aab() != null) {
                for (int i = 0; i < this.getContourListMaskGenerationFilter().GetContourItems().GetNumberOfItems(); ++i) {
                    this.undoFreehandClip();
                }
            }
            this.getModel().aa(0);
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetClippingBox() {
        Object object = syncObject;
        synchronized (object) {
            this.getVolume().GetMapper().RemoveAllClippingPlanes();
            if (this.planes.GetPoints() != null) {
                this.planes.GetPoints().Reset();
            }
            this.boxWidget.SetTransform(this.initialBoxWidgetTransform);
            this.getModel().al(this.getBoxWidgetTransformMatrix());
            this.getModel().af(false);
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCameraParametersInModel() {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            this.getModel().aa(vtkCamera2.GetParallelScale());
            this.getModel().aj(vtkCamera2.GetFocalPoint());
            this.getModel().ai(vtkCamera2.GetPosition());
            this.getModel().ac(vtkCamera2.GetRoll());
            this.getModel().ak(vtkCamera2.GetViewUp());
            this.getModel().aa(this.getRotationMatrix());
            this.getModel().ao(this.getImageData().GetSpacing());
            this.getModel().an(this.getVolume().GetBounds());
            if (this.getModel().aaG() == null) {
                this.getModel().aw(vtkCamera2.GetFocalPoint());
            }
        }
    }

    public ad getModel() {
        return this.volumeRenderingModel;
    }

    public vtkPiecewiseFunction getOpacityTransferFunction() {
        return this.opacityTransferFunction;
    }

    public vtkColorTransferFunction getColorTransferFunction() {
        return this.colorTransferFunction;
    }

    public ae getVolumeRenderingMouseHandler() {
        return this.volumeRenderingMouseHandler;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.renderWindow != null) {
            if (propertyChangeEvent.getPropertyName() == "PRESET_CHANGED") {
                this.setPreset();
            } else if (propertyChangeEvent.getPropertyName() == "VOLUME_CHANGED") {
                this.updateVTKPanel();
            } else if (propertyChangeEvent.getPropertyName() == "ZOOM_CHANGED") {
                this.changeZoom((Double)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "POINT_ZOOM_CHANGED") {
                this.changeZoom((Double)propertyChangeEvent.getNewValue(), (Integer)propertyChangeEvent.getOldValue());
            } else if (propertyChangeEvent.getPropertyName() == "CAMERA_ROTATION_ANGLE_CHANGED") {
                this.updateCameraRotationAngle();
            } else if (propertyChangeEvent.getPropertyName() == "CLICKPOINT_SYNCHRO_FINISHED") {
                this.removeMarker();
            } else if (propertyChangeEvent.getPropertyName() == "CAMERA_AXIS_ORIENTATION_CHANGED") {
                this.setCameraAxisOrientation((String)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "CLIPPING_BOX_RESTORE") {
                this.restoreBoxWidget();
            } else if (propertyChangeEvent.getPropertyName() == "ENABLE_CLIPPING_BOX") {
                this.enableClippingBox();
            } else if (propertyChangeEvent.getPropertyName() == "DISABLE_CLIPPING_BOX") {
                this.disableClippingBox();
            } else if (propertyChangeEvent.getPropertyName() == "ENABLE_FREEHAND_CLIPPING") {
                this.enableFreehandClipping();
            } else if (propertyChangeEvent.getPropertyName() == "DISABLE_FREEHAND_CLIPPING") {
                this.disableFreehandClipping();
            } else if (propertyChangeEvent.getPropertyName() == "CAMERA_ROTATION_CHANGED") {
                this.applyCameraRotationChange((Matrix3d)propertyChangeEvent.getNewValue(), (Double)propertyChangeEvent.getOldValue());
            } else if (propertyChangeEvent.getPropertyName() == "UNDO_FREEHAND_CLIPPING") {
                this.undoFreehandClip();
            } else if (propertyChangeEvent.getPropertyName() == "REDO_FREEHAND_CLIPPING") {
                this.redoFreehandClip();
            } else if (propertyChangeEvent.getPropertyName() == "SET_3D_CROSSHAIRS_MARKER") {
                this.set3DCrosshairsMarker((double[])propertyChangeEvent.getNewValue(), (Boolean)propertyChangeEvent.getOldValue());
            } else if (propertyChangeEvent.getPropertyName() == "EQUALIZE_VOLUME_ROTATION") {
                this.equalizeCameraRotation((ad)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "APPLY_ABSOLUTE_ROTATION") {
                this.applyAbsoluteRotation((Matrix3d)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "APPLY_RELATIVE_ROTATION") {
                this.applyRelativeRotation((Matrix3d)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "DELETE_VIEW") {
                this.delete();
            } else if (propertyChangeEvent.getPropertyName() == "RESET_CLIPPING_BOX") {
                this.resetClippingBox();
            } else if (propertyChangeEvent.getPropertyName() == "RESET_FREEHAND_CLIPPING") {
                this.resetFreehandClipping();
            } else if (propertyChangeEvent.getPropertyName() == "RESET_CAMERA_ROTATION") {
                this.resetCameraRotation((Matrix3d)propertyChangeEvent.getNewValue());
            } else if (propertyChangeEvent.getPropertyName() == "RESET_CAMERA_PAN") {
                this.resetCameraPan();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCameraRotationChange(Matrix3d matrix3d, double d) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkMatrix4x4 vtkMatrix4x42 = vtkCamera2.GetViewTransformMatrix();
            Matrix3d matrix3d2 = new Matrix3d();
            matrix3d2.m00 = vtkMatrix4x42.GetElement(0, 0);
            matrix3d2.m01 = vtkMatrix4x42.GetElement(0, 1);
            matrix3d2.m02 = vtkMatrix4x42.GetElement(0, 2);
            matrix3d2.m10 = -vtkMatrix4x42.GetElement(1, 0);
            matrix3d2.m11 = -vtkMatrix4x42.GetElement(1, 1);
            matrix3d2.m12 = -vtkMatrix4x42.GetElement(1, 2);
            matrix3d2.m20 = vtkMatrix4x42.GetElement(2, 0);
            matrix3d2.m21 = vtkMatrix4x42.GetElement(2, 1);
            matrix3d2.m22 = vtkMatrix4x42.GetElement(2, 2);
            Matrix3d matrix3d3 = new Matrix3d(matrix3d);
            matrix3d3.transpose();
            matrix3d3.mulTransposeLeft(matrix3d2, matrix3d3);
            matrix3d3.mul(matrix3d3, matrix3d2);
            Matrix4d matrix4d = new Matrix4d();
            matrix4d.set(matrix3d3);
            double[] dArray = vtkCamera2.GetFocalPoint();
            Matrix4d matrix4d2 = new Matrix4d();
            matrix4d2.setIdentity();
            matrix4d2.setTranslation(new Vector3d(dArray));
            matrix4d.mul(matrix4d2, matrix4d);
            matrix4d2.setTranslation(new Vector3d(-dArray[0], -dArray[1], -dArray[2]));
            matrix4d.mul(matrix4d, matrix4d2);
            vtkTransform vtkTransform2 = this.createTransform();
            vtkTransform2.SetMatrix(new double[]{matrix4d.m00, matrix4d.m01, matrix4d.m02, matrix4d.m03, matrix4d.m10, matrix4d.m11, matrix4d.m12, matrix4d.m13, matrix4d.m20, matrix4d.m21, matrix4d.m22, matrix4d.m23, matrix4d.m30, matrix4d.m31, matrix4d.m32, matrix4d.m33});
            double[] dArray2 = this.getModel().aC();
            double[] dArray3 = new double[3];
            vtkTransform2.TransformPoint(dArray2, dArray3);
            vtkCamera2.SetPosition(dArray3);
            vtkCamera2.Roll(d * 180.0 / Math.PI);
            vtkCamera2.OrthogonalizeViewUp();
            this.updateCameraParametersInModel();
        }
    }

    public boolean isDownsamplingActive() {
        return this.downsamplingActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getBoxWidgetTransformMatrix() {
        Object object = syncObject;
        synchronized (object) {
            vtkTransform vtkTransform2 = this.createTransform();
            this.boxWidget.GetTransform(vtkTransform2);
            double[] dArray = new double[]{vtkTransform2.GetMatrix().GetElement(0, 0), vtkTransform2.GetMatrix().GetElement(0, 1), vtkTransform2.GetMatrix().GetElement(0, 2), vtkTransform2.GetMatrix().GetElement(0, 3), vtkTransform2.GetMatrix().GetElement(1, 0), vtkTransform2.GetMatrix().GetElement(1, 1), vtkTransform2.GetMatrix().GetElement(1, 2), vtkTransform2.GetMatrix().GetElement(1, 3), vtkTransform2.GetMatrix().GetElement(2, 0), vtkTransform2.GetMatrix().GetElement(2, 1), vtkTransform2.GetMatrix().GetElement(2, 2), vtkTransform2.GetMatrix().GetElement(2, 3), vtkTransform2.GetMatrix().GetElement(3, 0), vtkTransform2.GetMatrix().GetElement(3, 1), vtkTransform2.GetMatrix().GetElement(3, 2), vtkTransform2.GetMatrix().GetElement(3, 3)};
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeZoom(double d) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkCamera2.SetParallelScale(d);
            vtkCamera2.OrthogonalizeViewUp();
            this.updateCameraParametersInModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraPosition(double d, double d2) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkCamera2.Azimuth(d);
            vtkCamera2.Elevation(d2);
            vtkCamera2.OrthogonalizeViewUp();
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraRoll(double d) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkCamera2.Roll(d);
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraPosition(double[] dArray, double[] dArray2) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkCamera2.SetFocalPoint(dArray);
            vtkCamera2.SetPosition(dArray2);
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCameraPosition(double[] dArray, double[] dArray2, double[] dArray3) {
        Object object = syncObject;
        synchronized (object) {
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkCamera2.SetPosition(dArray2);
            vtkCamera2.SetFocalPoint(dArray);
            vtkCamera2.SetViewUp(dArray3);
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getViewportCenter() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderer.GetCenter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCameraFocalPoint() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderer.GetActiveCamera().GetFocalPoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCameraPosition() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderer.GetActiveCamera().GetPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getCameraViewUp() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderer.GetActiveCamera().GetViewUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateZ(double d) {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = this.getVolume().GetCenter();
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            double[] dArray2 = vtkCamera2.GetPosition();
            double[] dArray3 = vtkCamera2.GetFocalPoint();
            double[] dArray4 = new double[]{dArray3[0] - dArray2[0], dArray3[1] - dArray2[1], dArray3[2] - dArray2[2]};
            vtkTransform vtkTransform2 = this.createTransform();
            vtkTransform2.Identity();
            vtkTransform2.Translate(dArray[0], dArray[1], dArray[2]);
            vtkTransform2.RotateWXYZ(-d, dArray4[0], dArray4[1], dArray4[2]);
            vtkTransform2.Translate(-dArray[0], -dArray[1], -dArray[2]);
            vtkCamera2.ApplyTransform(vtkTransform2);
            vtkCamera2.OrthogonalizeViewUp();
            this.updateCameraParametersInModel();
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rotateXYZ(int n, int n2, double d) {
        Object object = syncObject;
        synchronized (object) {
            vtkTransform vtkTransform2 = this.createTransform();
            vtkCamera vtkCamera2 = this.renderer.GetActiveCamera();
            vtkMath vtkMath2 = new vtkMath();
            double d2 = vtkMath2.Norm(vtkCamera2.GetPosition());
            if (d2 <= 0.0 && (d2 = vtkMath2.Norm(vtkCamera2.GetFocalPoint())) <= 0.0) {
                d2 = 1.0;
            }
            double[] dArray = vtkCamera2.GetFocalPoint();
            vtkCamera2.SetFocalPoint(dArray[0] / d2, dArray[1] / d2, dArray[2] / d2);
            dArray = vtkCamera2.GetPosition();
            vtkCamera2.SetPosition(dArray[0] / d2, dArray[1] / d2, dArray[2] / d2);
            double[] dArray2 = new double[3];
            double[] dArray3 = this.getVolume().GetCenter();
            vtkTransform2.Identity();
            vtkTransform2.Translate(dArray3[0] / d2, dArray3[1] / d2, dArray3[2] / d2);
            vtkCamera2.OrthogonalizeViewUp();
            double[] dArray4 = vtkCamera2.GetViewUp();
            int[] nArray = this.renderer.GetSize();
            vtkTransform2.RotateWXYZ(360.0 * (double)n / (double)nArray[0], dArray4[0], dArray4[1], dArray4[2]);
            vtkMath2.Cross(vtkCamera2.GetDirectionOfProjection(), dArray4, dArray2);
            vtkTransform2.RotateWXYZ(-360.0 * (double)n2 / (double)nArray[1], dArray2[0], dArray2[1], dArray2[2]);
            double[] dArray5 = new double[3];
            double[] dArray6 = vtkCamera2.GetFocalPoint();
            double[] dArray7 = vtkCamera2.GetPosition();
            dArray5[0] = dArray6[0] - dArray7[0];
            dArray5[1] = dArray6[1] - dArray7[1];
            dArray5[2] = dArray6[2] - dArray7[2];
            vtkTransform2.RotateWXYZ(-d, dArray5[0], dArray5[1], dArray5[2]);
            vtkTransform2.Translate(-dArray3[0] / d2, -dArray3[1] / d2, -dArray3[2] / d2);
            vtkCamera2.ApplyTransform(vtkTransform2);
            vtkCamera2.OrthogonalizeViewUp();
            dArray = vtkCamera2.GetFocalPoint();
            vtkCamera2.SetFocalPoint(dArray[0] * d2, dArray[1] * d2, dArray[2] * d2);
            dArray = vtkCamera2.GetPosition();
            vtkCamera2.SetPosition(dArray[0] * d2, dArray[1] * d2, dArray[2] * d2);
            this.renderer.ResetCameraClippingRange();
            vtkTransform2.Delete();
            this.updateCameraParametersInModel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getOpacity() {
        Object object = syncObject;
        synchronized (object) {
            int n = this.getModel().ad().length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[4];
            for (int i = 0; i < n; ++i) {
                this.opacityTransferFunction.GetNodeValue(i, dArray2);
                dArray[i] = dArray2[0];
            }
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getColor() {
        Object object = syncObject;
        synchronized (object) {
            int n = this.getModel().ad().length;
            double[] dArray = new double[n];
            double[] dArray2 = new double[6];
            for (int i = 0; i < n; ++i) {
                this.colorTransferFunction.GetNodeValue(i, dArray2);
                dArray[i] = dArray2[0];
            }
            return dArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColorOpacity(double[] dArray, double[] dArray2) {
        Object object = syncObject;
        synchronized (object) {
            int n = this.getModel().ad().length;
            double[] dArray3 = new double[4];
            double[] dArray4 = new double[6];
            for (int i = 0; i < n; ++i) {
                this.colorTransferFunction.GetNodeValue(i, dArray4);
                this.opacityTransferFunction.GetNodeValue(i, dArray3);
                dArray4[0] = dArray[i];
                dArray3[0] = dArray2[i];
                this.colorTransferFunction.SetNodeValue(i, dArray4);
                this.opacityTransferFunction.SetNodeValue(i, dArray3);
            }
            this.getModel().ab(dArray);
            this.updateVTKPanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRenderWindowWidth() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderWindow.GetSize()[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRenderWindowHeight() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderWindow.GetSize()[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMousePressedEvent(int n, int n2) {
        Object object = syncObject;
        synchronized (object) {
            this.iren.SetEventInformationFlipY(n, n2, 0, 0, '0', 0, "0");
            this.iren.LeftButtonPressEvent();
            return this.boxWidget.isHandlePicked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseReleasedEvent(int n, int n2) {
        Object object = syncObject;
        synchronized (object) {
            this.iren.SetEventInformationFlipY(n, n2, 0, 0, '0', 0, "0");
            this.iren.LeftButtonReleaseEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMouseMovedEvent(int n, int n2) {
        Object object = syncObject;
        synchronized (object) {
            this.iren.SetEventInformationFlipY(n, n2, 0, 0, '0', 0, "0");
            this.iren.MouseMoveEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean highlightBoxWidgetHandle(int n, int n2) {
        Object object = syncObject;
        synchronized (object) {
            boolean bl = this.boxWidget.highlightHandleOnMouseOver(n, this.getRenderWindowHeight() - n2);
            this.updateVTKPanel();
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getZoomPoint(int n, int n2) {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = this.getModel().ab();
            if (dArray == null) {
                dArray = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            }
            this.picker.Pick((double)n, (double)(this.getRenderWindowHeight() - n2), 0.0, this.renderer, dArray, this.getMapperSmart().getMaskInput());
            return this.picker.GetPickPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getZoomPoint(Point point) {
        Object object = syncObject;
        synchronized (object) {
            return this.getZoomPoint(point.x, point.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void translate(int n, int n2) {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = this.getCameraFocalPoint();
            double[] dArray2 = this.getCameraPosition();
            this.renderer.SetWorldPoint(dArray[0], dArray[1], dArray[2], 1.0);
            this.renderer.WorldToDisplay();
            double d = this.renderer.GetDisplayPoint()[2];
            double[] dArray3 = new double[]{(double)this.getRenderWindowWidth() / 2.0 + (double)(n * 2), (double)this.getRenderWindowHeight() / 2.0 - (double)(n2 * 2), d};
            this.renderer.SetDisplayPoint(dArray3);
            this.renderer.DisplayToWorld();
            double[] dArray4 = this.renderer.GetWorldPoint();
            if (dArray4[3] != 0.0) {
                dArray4[0] = dArray4[0] / dArray4[3];
                dArray4[1] = dArray4[1] / dArray4[3];
                dArray4[2] = dArray4[2] / dArray4[3];
            }
            double[] dArray5 = new double[]{(dArray[0] - dArray4[0]) / 2.0 + dArray[0], (dArray[1] - dArray4[1]) / 2.0 + dArray[1], (dArray[2] - dArray4[2]) / 2.0 + dArray[2]};
            double[] dArray6 = new double[]{(dArray[0] - dArray4[0]) / 2.0 + dArray2[0], (dArray[1] - dArray4[1]) / 2.0 + dArray2[1], (dArray[2] - dArray4[2]) / 2.0 + dArray2[2]};
            this.setCameraPosition(dArray5, dArray6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected double[] getVolumeDimensions() {
        Object object = syncObject;
        synchronized (object) {
            double[] dArray = this.getVolume().GetBounds();
            double d = dArray[1] - dArray[0];
            double d2 = dArray[3] - dArray[2];
            double d3 = dArray[5] - dArray[4];
            return new double[]{d, d2, d3};
        }
    }

    public void setChanged() {
        this.setHasChanged(true);
    }

    public Matrix3d getCubeOrientation() {
        Matrix3d matrix3d = new Matrix3d(this.getModel().ap());
        matrix3d.normalizeCP();
        return matrix3d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getImageSpacingX() {
        Object object = syncObject;
        synchronized (object) {
            return this.getImageData().GetSpacing()[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getImageSpacingY() {
        Object object = syncObject;
        synchronized (object) {
            return this.getImageData().GetSpacing()[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getImageSpacingZ() {
        Object object = syncObject;
        synchronized (object) {
            return this.getImageData().GetSpacing()[2];
        }
    }

    public Point getViewportCenterDelta(Point point) {
        Point point2 = new Point();
        point2.x = this.getRenderWindowWidth() / 2 - point.x;
        point2.y = this.getRenderWindowHeight() / 2 - point.y;
        return point2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeZoom(double d, int n) {
        Object object = syncObject;
        synchronized (object) {
            Point point = this.getVolumeRenderingMouseHandler().an();
            double[] dArray = this.getVolumeRenderingMouseHandler().am();
            if (point.y == -1) {
                point.y = n;
            }
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            double[] dArray4 = this.getCameraFocalPoint();
            double[] dArray5 = this.getCameraPosition();
            double[] dArray6 = new double[3];
            for (int i = 0; i < 3; ++i) {
                dArray6[i] = dArray[i] - dArray4[i];
            }
            Vector3d vector3d = new Vector3d(dArray6);
            double d2 = vector3d.length();
            vector3d.normalize();
            if (d2 != 0.0) {
                dArray6[0] = dArray6[0] / d2;
                dArray6[1] = dArray6[1] / d2;
                dArray6[2] = dArray6[2] / d2;
            }
            double d3 = 1.0;
            if (point.y != 0) {
                d3 = d2 / (double)point.y;
            }
            double d4 = 80.0;
            for (int i = 0; i < 3; ++i) {
                dArray2[i] = dArray4[i] + dArray6[i] * 80.0 * d3;
                dArray3[i] = dArray5[i] + dArray6[i] * 80.0 * d3;
            }
            if (n < 0) {
                n *= -1;
            }
            this.setCameraPosition(dArray2, dArray3);
            this.changeZoom(d);
            point.y = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJustResiceFlag(boolean bl) {
        Object object = syncObject;
        synchronized (object) {
            int n = 0;
            if (bl) {
                n = 1;
            }
            this.renderWindow.setJustResize(n);
        }
    }

    public void writeScreenshotFromRenderer(int n, String string, String string2) {
        vtkRenderLargeImage vtkRenderLargeImage2 = new vtkRenderLargeImage();
        vtkRenderLargeImage2.SetInput(this.renderer);
        vtkRenderLargeImage2.SetMagnification(n);
        String string3 = string + "_" + System.currentTimeMillis() + "." + string2;
        if (string2.equalsIgnoreCase("PNG")) {
            vtkPNGWriter vtkPNGWriter2 = new vtkPNGWriter();
            vtkPNGWriter2.SetInput((vtkDataObject)vtkRenderLargeImage2.GetOutput());
            vtkPNGWriter2.SetFileName(string3);
            vtkPNGWriter2.Write();
            vtkPNGWriter2 = null;
        } else if (string2.equalsIgnoreCase("JPG")) {
            vtkJPEGWriter vtkJPEGWriter2 = new vtkJPEGWriter();
            vtkJPEGWriter2.SetInput((vtkDataObject)vtkRenderLargeImage2.GetOutput());
            vtkJPEGWriter2.SetQuality(75);
            vtkJPEGWriter2.SetFileName(string3);
            vtkJPEGWriter2.Write();
            vtkJPEGWriter2 = null;
        } else if (string2.equalsIgnoreCase("BMP")) {
            vtkBMPWriter vtkBMPWriter2 = new vtkBMPWriter();
            vtkBMPWriter2.SetInput((vtkDataObject)vtkRenderLargeImage2.GetOutput());
            vtkBMPWriter2.SetFileName(string3);
            vtkBMPWriter2.Write();
            vtkBMPWriter2 = null;
        }
        vtkRenderLargeImage2 = null;
    }

    public ao getOriginalImageCollection() {
        return this.originalImageCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMouseButtonDown(boolean bl) {
        Object object = syncObject;
        synchronized (object) {
            this.renderer.setMouseButtonDown(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClickPointActionActive(boolean bl) {
        Object object = syncObject;
        synchronized (object) {
            this.renderer.setClickPointActionActive(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClickPointActionActive() {
        Object object = syncObject;
        synchronized (object) {
            return this.renderer.isClickPointActionActive();
        }
    }

    protected vtkSmartVolumeMapper getMapperSmart() {
        return this.mapperSmart;
    }

    protected vtkVolume getVolume() {
        return this.volume;
    }

    protected vtkImageData getImageData() {
        return this.imageData;
    }

    protected boolean isSoftwareRenderingInUse() {
        return this.softwareRenderingInUse;
    }

    protected String getSystemMemoryInfos() {
        return new aa().ae();
    }

    protected String getWMIGPUInfos() {
        return new aa().ab();
    }

    protected String getDirectXGPUInfos() {
        return new aa().aa();
    }

    protected boolean isHasChanged() {
        return this.hasChanged;
    }

    protected void setHasChanged(boolean bl) {
        this.hasChanged = bl;
    }

    protected void setSoftwareRenderingInUse(boolean bl) {
        this.softwareRenderingInUse = bl;
    }

    protected void setVolumeRenderingMouseHandler(ae ae2) {
        this.volumeRenderingMouseHandler = ae2;
    }

    protected void setOriginalImageCollection(ao ao2) {
        this.originalImageCollection = ao2;
    }

    protected ap getModelAccessor() {
        return this.modelAccessor;
    }

    protected void setModelAccessor(ap ap2) {
        this.modelAccessor = ap2;
    }

    protected GraphicsConfiguration getGraphicsConfiguration() {
        return this.graphicsConfiguration;
    }

    protected double[] getOriginalPixelSpacing() {
        return this.originalPixelSpacing;
    }

    protected vtkMatrix4x4 getVolumeTransformationMatrix() {
        return this.volumeTransformationMatrix;
    }

    protected void setVolumeTransformationMatrix(vtkMatrix4x4 vtkMatrix4x42) {
        this.volumeTransformationMatrix = vtkMatrix4x42;
    }

    protected vtkContourListMaskGenerationFilter getContourListMaskGenerationFilter() {
        return this.contourListMaskGenerationFilter;
    }

    protected void setContourListMaskGenerationFilter(vtkContourListMaskGenerationFilter vtkContourListMaskGenerationFilter2) {
        this.contourListMaskGenerationFilter = vtkContourListMaskGenerationFilter2;
    }

    static {
        com.visustt.jiveX.viewer.ae.ae.aa().aa(ae.aa.VTK);
    }

    private static OutOfMemoryError a(OutOfMemoryError outOfMemoryError) {
        return outOfMemoryError;
    }
}

