/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.viewer.components.viewer3d.utility;

import com.visustt.dicomTk.BaseDicomTagNames;
import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomObject;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.SeriesModule;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.imageplane.ImagePlane;
import com.visustt.dicomTk.imageplane.ab;
import com.visustt.dicomTk.imaging.ac.ah;
import com.visustt.dicomTk.imaging.ac.an;
import com.visustt.jiveX.viewer.components.viewer3d.ac;
import com.visustt.jiveX.viewer.components.viewer3d.ad;
import com.visustt.jiveX.viewer.components.viewer3d.ae;
import com.visustt.jiveX.viewer.components.viewer3d.af;
import com.visustt.jiveX.viewer.components.viewer3d.ag;
import com.visustt.jiveX.viewer.components.viewer3d.ak;
import com.visustt.jiveX.viewer.components.viewer3d.am;
import com.visustt.jiveX.viewer.components.viewer3d.ao;
import com.visustt.jiveX.viewer.components.viewer3d.ap;
import com.visustt.jiveX.viewer.components.viewer3d.at;
import com.visustt.jiveX.viewer.components.viewer3d.au;
import com.visustt.jiveX.viewer.components.viewer3d.exceptions.InvalidOrientationException;
import com.visustt.jiveX.viewer.components.viewer3d.utility.DecubitusOrientation;
import com.visustt.jiveX.viewer.components.viewer3d.utility.ImageCollectionValidity;
import com.visustt.jiveX.viewer.components.viewer3d.utility.ToolBox;
import com.visustt.jiveX.viewer.model.ac.aa;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Arrays;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MPRUtilities {
    private static Logger logger = LoggerFactory.getInstance("jx.client.mprUtilities");
    private static Logger loggerDump = LoggerFactory.getInstance("jx.client.mprUtilities.dump");

    public static double[] getPixelSpacing(com.visustt.dicomTk.model.ao ao2) {
        if (ao2.al()) {
            double d;
            double d2;
            double d3;
            block5: {
                com.visustt.dicomTk.model.aa.ac ac2 = ao2.ae().au();
                d3 = ac2.af().aq();
                d2 = ac2.af().ar();
                d = 1.0;
                try {
                    try {
                        if (ao2.aa() <= 1 || d3 == -1.0) break block5;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MPRUtilities.a(illegalArgumentException);
                    }
                    if (d2 == -1.0) break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                com.visustt.dicomTk.model.ag ag2 = ao2.aa(0);
                com.visustt.dicomTk.model.ag ag3 = ao2.aa(1);
                d = Math.abs(ag2.ax().getDistance(ag3.ax()));
            }
            return new double[]{d3, d2, d};
        }
        return new double[]{1.0, 1.0, 1.0};
    }

    public static at getVolumeRenderState(com.visustt.dicomTk.model.ao ao2) {
        return MPRUtilities.getVolumeRenderState(ao2.ae());
    }

    public static at getVolumeRenderState(com.visustt.dicomTk.model.ag ag2) {
        String string = ag2.ax;
        try {
            if (aa.ab().ae(string)) {
                return aa.ab().ad(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        return null;
    }

    public static au getObliqueRendererState(com.visustt.dicomTk.model.ao ao2) {
        try {
            if (MPRUtilities.isObliqueRenderState(ao2)) {
                return MPRUtilities.getObliqueRendererState(ao2.ae());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        return null;
    }

    public static au getObliqueRendererState(com.visustt.dicomTk.model.ag ag2) {
        block4: {
            at at2 = MPRUtilities.getVolumeRenderState(ag2);
            try {
                try {
                    if (at2 == null || !at2.ae()) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return (au)at2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        return null;
    }

    public static boolean isObliqueRenderState(com.visustt.dicomTk.model.ao ao2) {
        block4: {
            try {
                try {
                    if (ao2 == null || !ao2.al()) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return MPRUtilities.isObliqueRenderState(ao2.ae());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        return false;
    }

    public static boolean isObliqueRenderState(com.visustt.dicomTk.model.ag ag2) {
        at at2 = MPRUtilities.getVolumeRenderState(ag2);
        try {
            if (at2 != null) {
                return at2.ae();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        return false;
    }

    public static boolean isVolumeRenderState(com.visustt.dicomTk.model.ao ao2) {
        block4: {
            try {
                try {
                    if (ao2 == null || !ao2.al()) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return ao2.ae().af();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        return false;
    }

    public static ae getDynamicImageState(com.visustt.dicomTk.model.ag ag2) {
        block10: {
            try {
                try {
                    if (ag2 != null && ag2.af()) break block10;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        com.visustt.dicomTk.model.aa.ac ac2 = ag2.as();
        an an2 = ac2.af();
        try {
            if (an2 == null) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        try {
            if (an2.ah() instanceof ak) {
                return ((ak)an2.ah()).ao();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        return null;
    }

    public static void setDynamicImageState(com.visustt.dicomTk.model.ag ag2, ae ae2) {
        block10: {
            try {
                try {
                    if (ag2 != null && ae2 != null) break block10;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        com.visustt.dicomTk.model.aa.ac ac2 = ag2.as();
        an an2 = ac2.af();
        try {
            if (an2 == null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        if (an2.ah() instanceof ad) {
            ad ad2 = new ad(ae2);
            an2.aa(ad2);
        } else if (an2.ah() instanceof ac) {
            ac ac3 = new ac(ae2);
            an2.aa((com.visustt.dicomTk.imaging.ac.ak)ac3);
        }
    }

    public static com.visustt.dicomTk.model.ap getOriginalSeries(com.visustt.dicomTk.model.ao ao2) {
        return MPRUtilities.getOriginalSeries(ao2.ae());
    }

    public static com.visustt.dicomTk.model.ap getOriginalSeries(com.visustt.dicomTk.model.ag ag2) {
        ap ap2;
        at at2 = MPRUtilities.getVolumeRenderState(ag2);
        if (at2 != null && (ap2 = at2.aq()) != null) {
            String string = ap2.aa();
            return ag2.aC.az().ad(string);
        }
        return ag2.aC;
    }

    public static void recalculateImageOrientation(com.visustt.dicomTk.model.ao ao2) {
        block5: {
            com.visustt.dicomTk.model.ag ag2 = ao2.ae();
            au au2 = MPRUtilities.getObliqueRendererState(ag2);
            try {
                if (au2 == null || !au2.aR()) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
            for (int i = 0; i < ao2.aa(); ++i) {
                com.visustt.dicomTk.model.ag ag3 = ao2.aa(i);
                ae ae2 = MPRUtilities.getDynamicImageState(ag3);
                try {
                    MPRUtilities.updateImagePosition(ae2);
                    MPRUtilities.updateDicomImageOrientation(ae2);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            au2.ac(false);
        }
    }

    public static void updateImagePosition(ae ae2) throws IllegalArgumentException {
        try {
            if (ae2 == null) {
                throw new IllegalArgumentException("ObliqueSlabRenderer::updateImagePosition() : no image state");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        try {
            if (!MPRUtilities.isObliqueRenderState(ae2.as())) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        au au2 = (au)ae2.au();
        Point3d point3d = new Point3d((Tuple3d)ae2.at().aq());
        au2.aad().transform(point3d);
        ae2.ab(new am(point3d));
    }

    public static void updateDicomImageOrientation(ae ae2) throws IllegalArgumentException {
        try {
            if (ae2 == null) {
                throw new IllegalArgumentException("ObliqueSlabRenderer::updateImagePosition() : no image state");
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw MPRUtilities.a(invalidDataException);
        }
        at at2 = ae2.au();
        double[] dArray = at2.aJ();
        com.visustt.dicomTk.imageplane.aa aa10 = ae2.ar().getImagePlaneModule();
        ImagePlane imagePlane = ae2.as().ax();
        try {
            aa10.ab(dArray);
            imagePlane.setImageOrientation(dArray);
        }
        catch (InvalidDataException invalidDataException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("ObliqueRenderer::updateDicomImageOrientation() : unable to set image orientation due to internal error: " + invalidDataException);
            illegalArgumentException.initCause(invalidDataException);
            throw illegalArgumentException;
        }
        imagePlane.setImageWidth(at2.as());
        imagePlane.setImageHeight(at2.at());
    }

    public static void modifyMPRCoordinateSystem(com.visustt.dicomTk.model.ao ao2, double[] dArray) {
        com.visustt.dicomTk.model.ag ag2 = ao2.ae();
        if (MPRUtilities.isObliqueRenderState(ag2)) {
            Matrix4d matrix4d = new Matrix4d(dArray);
            au au2 = MPRUtilities.getObliqueRendererState(ag2);
            ap ap2 = au2.aq();
            ap2.aa(matrix4d);
            Point3d point3d = new Point3d(ap2.aM().as());
            au2.aa(new am(point3d));
            au2.aU();
            for (int i = 0; i < ao2.aa(); ++i) {
                ag2 = ao2.aa(i);
                ae ae2 = MPRUtilities.getDynamicImageState(ag2);
                ae2.aa(ag2);
                ae2.aa(ag2.an);
                ae2.ac(null);
                ae2.ap();
            }
            Matrix3d matrix3d = new Matrix3d();
            au2.aad().getRotationScale(matrix3d);
            au2.ac(matrix3d);
        }
    }

    public static void changeImageDistance(au au2, com.visustt.dicomTk.model.ap ap2) {
        MPRUtilities.formatSeries(au2, ap2);
        for (int i = 0; i < ap2.aa(); ++i) {
            com.visustt.dicomTk.model.ag ag2 = ap2.aa(i);
            ae ae2 = MPRUtilities.getDynamicImageState(ag2);
            ae2.ac(null);
            ae2.ap();
            MPRUtilities.updateImagePosition(ae2);
            MPRUtilities.updateDicomImageOrientation(ae2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void formatSeries(au au2, com.visustt.dicomTk.model.ap ap2) {
        ap2.ac().clear();
        int n = Math.round(au2.aq().ay() / au2.an());
        int i = 0;
        while (true) {
            block6: {
                if (i >= n) {
                    return;
                }
                com.visustt.dicomTk.model.ag ag2 = au2.an(i);
                try {
                    if (ag2 == null) break block6;
                    try {
                        ag2.an.getImagePlaneModule().ab(au2.am());
                    }
                    catch (InvalidDataException invalidDataException) {
                        logger.error((Object)invalidDataException, invalidDataException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                ap2.ab(ag2);
            }
            ++i;
        }
    }

    public static void resetMPRCoordinateSystem(com.visustt.dicomTk.model.ao ao2) {
        Object object;
        at at2 = MPRUtilities.getVolumeRenderState(ao2);
        ap ap2 = at2.aq();
        Matrix3d matrix3d = new Matrix3d();
        if (MPRUtilities.isObliqueRenderState(ao2)) {
            object = (au)at2;
            ((au)object).aad().getRotationScale(matrix3d);
        }
        try {
            ap2.aG();
            if (at2.ae()) {
                ((au)at2).aa(ap2.aN());
                ((au)at2).aU();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        for (int i = 0; i < ao2.aa(); ++i) {
            object = ao2.aa(i);
            ae ae2 = MPRUtilities.getDynamicImageState((com.visustt.dicomTk.model.ag)object);
            ae2.aa((com.visustt.dicomTk.model.ag)object);
            ae2.aa(((com.visustt.dicomTk.model.ag)object).an);
            ae2.ac(null);
            ae2.ap();
        }
        if (at2.ae()) {
            au au2 = (au)at2;
            au2.ac(matrix3d);
            au2.ac(true);
        }
    }

    public static void alignObliqueImageOrientation(com.visustt.dicomTk.model.ag ag2, com.visustt.dicomTk.model.ao ao2) {
        com.visustt.dicomTk.model.ag ag3 = ao2.ae();
        MPRUtilities.alignObliqueImageOrientation(ag2, ag3);
    }

    public static void alignObliqueImageOrientation(com.visustt.dicomTk.model.ag ag2, com.visustt.dicomTk.model.ag ag3) {
        au au2 = MPRUtilities.getObliqueRendererState(ag3);
        if (au2 != null) {
            try {
                Matrix3d matrix3d = ag2.ax().getOrientationMatrix();
                Matrix3d matrix3d2 = ag3.ax().getOrientationMatrix();
                if (!matrix3d.epsilonEquals(matrix3d2, 1.0E-5)) {
                    Matrix3d matrix3d3 = au2.aq().aK();
                    matrix3d3.invert();
                    matrix3d.mul(matrix3d3);
                    au2.ac(matrix3d);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.error((Object)("align ImagePlanes failed!" + illegalArgumentException), illegalArgumentException);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static com.visustt.dicomTk.model.ao correctGantryTilt(com.visustt.dicomTk.model.ao ao2) throws IllegalArgumentException {
        com.visustt.dicomTk.model.ao ao3 = new com.visustt.dicomTk.model.ao();
        try {
            if (!ao2.al()) {
                throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: image collection is empty!");
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw MPRUtilities.a(invalidDataException);
        }
        com.visustt.dicomTk.model.ag ag2 = ao2.ae();
        ImagePlane imagePlane = ag2.ax();
        Vector3d vector3d = new Vector3d(imagePlane.getAnchor());
        Vector3d vector3d2 = new Vector3d(imagePlane.getRowOrient());
        Vector3d vector3d3 = new Vector3d(imagePlane.getColOrient());
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i < ao2.aa(); ++i) {
            Vector3d vector3d4;
            block30: {
                com.visustt.dicomTk.model.ag ag3 = ao2.aa(i);
                ImagePlane imagePlane2 = ag3.ax();
                vector3d4 = new Vector3d(imagePlane2.getAnchor());
                Vector3d vector3d5 = new Vector3d(imagePlane.getRowOrient());
                Vector3d vector3d6 = new Vector3d(imagePlane.getColOrient());
                if (!vector3d2.equals((Tuple3d)vector3d5)) throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: image orientation of all images must be the same!");
                try {
                    if (vector3d3.equals((Tuple3d)vector3d6)) break block30;
                    throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: image orientation of all images must be the same!");
                    catch (InvalidDataException invalidDataException) {
                        throw MPRUtilities.a(invalidDataException);
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw MPRUtilities.a(invalidDataException);
                }
            }
            vector3d4.sub((Tuple3d)vector3d);
            double d3 = vector3d4.dot(vector3d2);
            double d4 = vector3d4.dot(vector3d3);
            if (Math.abs(d3) > Math.abs(d)) {
                d = d3;
            }
            if (!(Math.abs(d4) > Math.abs(d2))) continue;
            d2 = d4;
        }
        if (d < 0.0) {
            Vector3d vector3d7 = new Vector3d(vector3d2);
            vector3d7.scale(d);
            vector3d.add((Tuple3d)vector3d7);
        }
        if (d2 < 0.0) {
            Vector3d vector3d8 = new Vector3d(vector3d3);
            vector3d8.scale(d2);
            vector3d.add((Tuple3d)vector3d8);
        }
        double[] dArray = new double[3];
        vector3d.get(dArray);
        int n = (int)(Math.abs(d) / imagePlane.getPixelSpacingX()) + 1;
        int n2 = (int)(Math.abs(d2) / imagePlane.getPixelSpacingY()) + 1;
        int n3 = ag2.au().af().ae();
        int n4 = ag2.au().af().ad();
        int n5 = n3 + n;
        int n6 = n4 + n2;
        for (int i = 0; i < ao2.aa(); ++i) {
            int n7;
            Object object;
            int n8;
            int n9;
            an an2;
            com.visustt.dicomTk.model.ag ag4;
            int n10;
            int n11;
            block35: {
                com.visustt.dicomTk.imaging.ab.ac ac2;
                block34: {
                    com.visustt.dicomTk.imaging.ab.ah ah2;
                    block32: {
                        block33: {
                            Vector3d vector3d9;
                            Vector3d vector3d10;
                            Vector3d vector3d11;
                            ImagePlane imagePlane3;
                            com.visustt.dicomTk.model.ag ag5;
                            block31: {
                                ag5 = ao2.aa(i);
                                imagePlane3 = ag5.ax();
                                vector3d11 = new Vector3d(imagePlane3.getAnchor());
                                vector3d10 = new Vector3d(imagePlane3.getRowOrient());
                                vector3d9 = new Vector3d(imagePlane3.getColOrient());
                                n11 = ag5.au().af().ae();
                                n10 = ag5.au().af().ad();
                                if (n11 != n3) throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: images must all have same image dimensions!");
                                try {
                                    if (n10 == n4) break block31;
                                    throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: images must all have same image dimensions!");
                                    catch (InvalidDataException invalidDataException) {
                                        throw MPRUtilities.a(invalidDataException);
                                    }
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw MPRUtilities.a(invalidDataException);
                                }
                            }
                            ag4 = (com.visustt.dicomTk.model.ag)ag5.clone();
                            ag4.ac(new com.visustt.dicomTk.model.aa.ac(ag5.au()));
                            an2 = new an(ag4.au().af());
                            ag4.au().aa(an2);
                            ag4.aa((com.visustt.dicomTk.model.aa.ac)null);
                            double[] dArray2 = imagePlane3.getProjectionInWorldCoordinates(dArray);
                            try {
                                ag4.an.getImagePlaneModule().aa(dArray2);
                                ag4.ax().setImagePosition(dArray2);
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: invalid corrected image position!" + invalidDataException.getMessage());
                            }
                            Vector3d vector3d12 = new Vector3d(dArray2);
                            vector3d12.sub((Tuple3d)vector3d11);
                            n9 = -((int)Math.round(vector3d12.dot(vector3d10) / imagePlane3.getPixelSpacingX()));
                            n8 = -((int)Math.round(vector3d12.dot(vector3d9) / imagePlane3.getPixelSpacingY()));
                            try {
                                ag4.an.getImageModule().setImageWidth(n5);
                                ag4.an.getImageModule().setImageHeight(n6);
                                ag4.ax().setImageWidth((double)n5 * imagePlane3.getPixelSpacingX());
                                ag4.ax().setImageHeight((double)n6 * imagePlane3.getPixelSpacingY());
                                an2.ab(n5);
                                an2.aa(n6);
                                object = ag4.au().ae();
                                ((com.visustt.dicomTk.imaging.ad.ad)object).ab(n5);
                                ((com.visustt.dicomTk.imaging.ad.ad)object).ac(n6);
                                ((com.visustt.dicomTk.imaging.ad.ad)object).ad(new Point2D.Double(0.0, 0.0), new Point2D.Double(n5, n6));
                                ((com.visustt.dicomTk.imaging.ad.ad)object).ad(false);
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: invalid corrected image size!" + invalidDataException.getMessage());
                            }
                            object = ag5.au().af().ah().ab();
                            ac2 = ag5.au().ac();
                            ah2 = ac2.ap();
                            try {
                                try {
                                    if (!ac2.af()) break block32;
                                    if (ah2 == null) break block33;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw MPRUtilities.a(invalidDataException);
                                }
                                if (ah2.aa()) break block33;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw MPRUtilities.a(invalidDataException);
                            }
                            n7 = ah2.ad();
                            break block35;
                        }
                        n7 = ac2.aK().ac();
                        break block35;
                    }
                    try {
                        if (ah2 == null || ah2.aa()) break block34;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw MPRUtilities.a(invalidDataException);
                    }
                    n7 = ah2.ac();
                    break block35;
                }
                n7 = ac2.aK().ab();
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                byte[] byArray2 = new byte[n5 * n6];
                Arrays.fill(byArray2, (byte)(n7 & 0xFF));
                var38_52 = n8 * n5 + n9;
                for (var39_53 = 0; var39_53 < n10; ++var39_53) {
                    var40_54 = var39_53 * n5 + var38_52;
                    var41_55 = var39_53 * n11;
                    System.arraycopy(byArray, var41_55, byArray2, var40_54, n11);
                }
                an2.aa(new com.visustt.dicomTk.imaging.ac.af(byArray2));
                ag4.an.getImageModule().setPixelDataBytes(byArray2);
            } else {
                if (!(object instanceof short[])) throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: pixel data must be byte[] or short[]!");
                short[] sArray = (short[])object;
                short[] sArray2 = new short[n5 * n6];
                Arrays.fill(sArray2, (short)(n7 & 0xFFFF));
                var38_52 = n8 * n5 + n9;
                for (var39_53 = 0; var39_53 < n10; ++var39_53) {
                    var40_54 = var39_53 * n5 + var38_52;
                    var41_55 = var39_53 * n11;
                    System.arraycopy(sArray, var41_55, sArray2, var40_54, n11);
                }
                an2.aa(new ah(sArray2));
                ag4.an.getImageModule().setPixelDataWords(sArray2);
            }
            ao3.ab(ag4);
        }
        return ao3;
    }

    public static com.visustt.dicomTk.model.ao getOrderedImageCollection(com.visustt.dicomTk.model.ao ao2) {
        com.visustt.dicomTk.model.ao ao3;
        block8: {
            block9: {
                ao3 = new com.visustt.dicomTk.model.ao(ao2);
                DicomObject dicomObject = ao3.ae().an;
                DicomObject dicomObject2 = ao3.af().an;
                try {
                    try {
                        try {
                            try {
                                if (dicomObject == null || dicomObject2 == null) break block8;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw MPRUtilities.a(illegalArgumentException);
                            }
                            if (!MPRUtilities.isCorrectionOfSortOrderNecessary(dicomObject, dicomObject2)) break block8;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw MPRUtilities.a(illegalArgumentException);
                        }
                        if (ao3.ak() != 1) break block9;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MPRUtilities.a(illegalArgumentException);
                    }
                    ao3.ae(2);
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
            }
            ao3.ae(1);
        }
        return ao3;
    }

    public static boolean isCorrectionOfSortOrderNecessary(DicomObject dicomObject, DicomObject dicomObject2) {
        block6: {
            try {
                boolean bl;
                try {
                    if (dicomObject.getImagePlaneModule() == null || dicomObject2.getImagePlaneModule() == null) break block6;
                }
                catch (InvalidDataException invalidDataException) {
                    throw MPRUtilities.a(invalidDataException);
                }
                ImagePlane imagePlane = ab.aa(dicomObject);
                ImagePlane imagePlane2 = ab.aa(dicomObject2);
                try {
                    bl = imagePlane2.getDistance(imagePlane) < 0.0;
                }
                catch (InvalidDataException invalidDataException) {
                    throw MPRUtilities.a(invalidDataException);
                }
                return bl;
            }
            catch (InvalidDataException invalidDataException) {
                logger.error((Object)invalidDataException, invalidDataException);
            }
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static com.visustt.dicomTk.model.ao checkAndReformatImageCollection(com.visustt.dicomTk.model.ao var0) throws InvalidOrientationException, CommonDicomException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static com.visustt.dicomTk.model.ao checkAndReformatImageCollectionDoReformat(com.visustt.dicomTk.model.ao ao2, com.visustt.dicomTk.model.ao ao3, int[] nArray, am[] amArray, int n) throws CommonDicomException {
        if (ao2.ae().au().af().ah() instanceof com.visustt.dicomTk.imaging.ac.ag) {
            ao3 = af.aa(ao3, n, nArray, amArray);
            MPRUtilities.dumpSeriesForDebuggingPurposes(ao3, "series_real_reformatted");
        } else {
            ao3 = ag.aa(ao3, n, nArray, amArray);
            MPRUtilities.dumpSeriesForDebuggingPurposes(ao3, "series_real_reformatted");
        }
        return ao3;
    }

    private static void dumpSeriesForDebuggingPurposes(com.visustt.dicomTk.model.ao ao2, String string) {
        try {
            String string2 = MPRUtilities.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
            com.visustt.jiveX.tools.af.aa.aa(ao2, string2 + "\\" + string, loggerDump.debugIsEnabled(), true, -1);
        }
        catch (IOException | URISyntaxException exception) {
            logger.debug("Could not dump image collection to " + string + ": " + exception.toString());
        }
    }

    public static void correctSortOrder(com.visustt.dicomTk.model.ao ao2) {
        block6: {
            block7: {
                try {
                    try {
                        try {
                            if (ao2.aa(0).ax() == null || !(ao2.aa(0).ax().getDistance(ao2.aa(1).ax()) < 0.0)) break block6;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw MPRUtilities.a(illegalArgumentException);
                        }
                        if (ao2.ak() != 1) break block7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MPRUtilities.a(illegalArgumentException);
                    }
                    ao2.ae(2);
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
            }
            ao2.ae(1);
        }
    }

    public static boolean isDecubitusOrUndeterminablePosition(com.visustt.dicomTk.model.ao ao2) throws InvalidDataException, InvalidOrientationException {
        boolean bl;
        try {
            bl = MPRUtilities.getDecubitusOrUndeterminablePosition(ao2) != null;
        }
        catch (InvalidDataException invalidDataException) {
            throw MPRUtilities.a(invalidDataException);
        }
        return bl;
    }

    public static void resetTargetOrientationInPixelDataStateOf(com.visustt.dicomTk.model.ao ao2, boolean bl) {
        ao2.ac().forEach(ag2 -> {
            try {
                ag2.au().af().ab(com.visustt.dicomTk.model.aa.ah.aa());
                if (bl) {
                    ag2.au().af().af();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        });
    }

    /*
     * Unable to fully structure code
     */
    public static DecubitusOrientation getDecubitusOrUndeterminablePosition(com.visustt.dicomTk.model.ao var0) throws InvalidDataException, InvalidOrientationException {
        block19: {
            block20: {
                var1_1 = var0.ae();
                try {
                    if (var1_1 == null || var1_1.an == null) break block19;
                }
                catch (InvalidDataException v0) {
                    throw MPRUtilities.a(v0);
                }
                var2_2 = var1_1.an.getSeriesModule();
                if (var2_2 == null) break block19;
                try {
                    block23: {
                        if (!MPRUtilities.isPatientOrientationCodeSequencePresent(var2_2)) break block20;
                        break block23;
                        catch (InvalidDataException v1) {
                            throw MPRUtilities.a(v1);
                        }
                    }
                    MPRUtilities.logger.warn("MPR creation: found Image Orientation Code Sequence.");
                }
                catch (InvalidDataException v2) {
                    throw MPRUtilities.a(v2);
                }
            }
            try {
                if (!var2_2.existsDicomElement(DicomTagNames.TAG_imageOrientationPatient)) {
                    MPRUtilities.logger.warn("Cannot compute an MPR: no valid Image Orientation Patient DICOM tag (0020,0037) found.");
                    throw new InvalidOrientationException("FunctionPanelModelMPRActions::isDecubitusOrUndeterminablePosition() : Cannot reformat image collection, as no ImageOrientationPatient information is available.");
                }
            }
            catch (InvalidDataException v3) {
                throw MPRUtilities.a(v3);
            }
            var3_3 = var1_1.an.getImagePlaneModule();
            try {
                block25: {
                    block22: {
                        block21: {
                            var4_4 = var3_3.ao();
                            var5_6 = var3_3.ap();
                            var6_7 = var2_2.getString(BaseDicomTagNames.TAG_patientPosition);
                            if (var6_7 == null) ** GOTO lbl40
                            try {
                                block24: {
                                    if (!var6_7.trim().isEmpty()) break block21;
                                    break block24;
                                    catch (InvalidDataException v4) {
                                        throw MPRUtilities.a(v4);
                                    }
                                }
                                MPRUtilities.logger.warn("MPR creation: found no patient position.");
                            }
                            catch (InvalidDataException v5) {
                                throw MPRUtilities.a(v5);
                            }
                        }
                        var7_8 = MPRUtilities.getDecubitusImageOrientation(var4_4, var5_6);
                        if (var7_8 == null) break block25;
                        MPRUtilities.logger.debug("Found decubitus Image Orientation vectors.");
                        var8_9 = MPRUtilities.getDecubitusPatientPosition(var6_7);
                        if (var8_9 == null) break block22;
                        try {
                            block26: {
                                if (var7_8 == var8_9) break block22;
                                break block26;
                                catch (InvalidDataException v6) {
                                    throw MPRUtilities.a(v6);
                                }
                            }
                            MPRUtilities.logger.warn("Inconsistent decubitus orientations: " + var7_8.name() + " in image orientation patient vs. " + var8_9.name() + " in PatientPosition!");
                            MPRUtilities.logger.warn("In this case, " + var7_8.name() + " will be used.");
                        }
                        catch (InvalidDataException v7) {
                            throw MPRUtilities.a(v7);
                        }
                    }
                    return var7_8;
                }
                var7_8 = MPRUtilities.getDecubitusPatientPosition(var6_7);
                MPRUtilities.logger.debug("Found decubitus Patient Position.");
                return var7_8;
            }
            catch (InvalidDataException var4_5) {
                MPRUtilities.logger.debug("Cannot compute an MPR: error access image orientation (patient) vectors.");
                throw new InvalidOrientationException("FunctionPanelModelMPRActions::isDecubitusOrUndeterminablePosition() : Cannot reformat image collection: missing ImageOrientation(Patient) information.");
            }
        }
        return null;
    }

    public static boolean isPatientOrientationCodeSequencePresent(SeriesModule seriesModule) {
        block6: {
            try {
                if (seriesModule == null || !seriesModule.existsSequence(BaseDicomTagNames.TAG_patientOrientationCodeSequence)) break block6;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
            av av2 = seriesModule.getSequence(BaseDicomTagNames.TAG_patientOrientationCodeSequence);
            try {
                try {
                    if (av2 == null || av2.af() <= 0) break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        return false;
    }

    public static DecubitusOrientation getDecubitusPatientPosition(String string) {
        block5: {
            try {
                if (string == null || !string.contains("D")) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
            for (int i = 0; i < DecubitusOrientation.getSize(); ++i) {
                DecubitusOrientation decubitusOrientation = DecubitusOrientation.getOrientation(i);
                try {
                    if (!decubitusOrientation.name().equals(string)) continue;
                    return decubitusOrientation;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
            }
        }
        return null;
    }

    public static boolean isDecubitusPatientPosition(String string) {
        boolean bl;
        try {
            bl = MPRUtilities.getDecubitusPatientPosition(string) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        return bl;
    }

    public static boolean isDecubitusImageOrienation(double[] dArray, double[] dArray2) {
        boolean bl;
        try {
            bl = MPRUtilities.getDecubitusImageOrientation(dArray, dArray2) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw MPRUtilities.a(illegalArgumentException);
        }
        return bl;
    }

    public static DecubitusOrientation getDecubitusImageOrientation(double[] dArray, double[] dArray2) {
        block8: {
            block7: {
                try {
                    if (dArray == null || dArray2 == null) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                for (int i = 0; i < DecubitusOrientation.getSize(); ++i) {
                    DecubitusOrientation decubitusOrientation = DecubitusOrientation.getOrientation(i);
                    try {
                        try {
                            if (!Arrays.equals(dArray, decubitusOrientation.getRowValues()) || !Arrays.equals(dArray2, decubitusOrientation.getColumnValues())) continue;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw MPRUtilities.a(illegalArgumentException);
                        }
                        return decubitusOrientation;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MPRUtilities.a(illegalArgumentException);
                    }
                }
                break block8;
            }
            logger.warn("Could test decubitus orientation as row and column vectors are invalid.");
        }
        return null;
    }

    public static boolean isImageInVolume(com.visustt.dicomTk.model.ap ap2, com.visustt.dicomTk.model.ag ag2) {
        block4: {
            com.visustt.dicomTk.model.ag ag3 = ap2.ae();
            com.visustt.dicomTk.model.ag ag4 = ap2.af();
            double d = ag3.ax().getDistance(ag2.ax());
            double d2 = ag4.ax().getDistance(ag2.ax());
            try {
                try {
                    if (!(d > 0.0) || !(d2 <= 0.0)) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
        return false;
    }

    public static double[] getInitialOrientationTransformationMatrix(com.visustt.dicomTk.model.ag ag2) {
        ImagePlane imagePlane = ag2.ax();
        double[] dArray = imagePlane.getColOrient();
        double[] dArray2 = imagePlane.getRowOrient();
        double[] dArray3 = imagePlane.getNormalVector();
        return new double[]{dArray2[0], dArray2[1], dArray2[2], 0.0, dArray[0], dArray[1], dArray[2], 0.0, dArray3[0], dArray3[1], dArray3[2], 0.0, 0.0, 0.0, 0.0, 1.0};
    }

    public static void setInitialMPROrientation(com.visustt.dicomTk.model.ag ag2) {
        block8: {
            au au2;
            block9: {
                block7: {
                    au2 = MPRUtilities.getObliqueRendererState(ag2);
                    try {
                        if (ag2.aa0 != 16) break block7;
                        au2.ad(ao.aaN);
                        break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MPRUtilities.a(illegalArgumentException);
                    }
                }
                try {
                    if (ag2.aa0 != 24) break block9;
                    au2.ad(ao.aaO);
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw MPRUtilities.a(illegalArgumentException);
                }
            }
            try {
                if (ag2.aa0 == 8) {
                    au2.ad(ao.aaM);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw MPRUtilities.a(illegalArgumentException);
            }
        }
    }

    public static boolean canReconstructMPR(com.visustt.dicomTk.model.ao ao2) {
        int[] nArray = ImageCollectionValidity.calculateVolumeSize(ao2);
        long l = nArray[0] * nArray[1] * nArray[2];
        int n = MPRUtilities.getSeriesOrientation(ao2.ae().an);
        double d = ao2.ae().ah() ? 2.5 : 1.0;
        if (n != 7) {
            d += 0.5;
        }
        l = (long)((double)l * d);
        System.gc();
        try {
            Thread.sleep(25L);
        }
        catch (InterruptedException interruptedException) {
            logger.error((Object)interruptedException, interruptedException);
        }
        return com.visustt.dicomTk.aj.ac.ab(l / 1024L / 1024L);
    }

    /*
     * Exception decompiling
     */
    public static Matrix3d getSeriesOrientationAsMatrix(DicomObject var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int getSeriesOrientation(DicomObject dicomObject) {
        block24: {
            int n;
            int n2;
            int n3;
            block23: {
                block22: {
                    double[] dArray = null;
                    double[] dArray2 = null;
                    try {
                        dArray = dicomObject.getImagePlaneModule().ap();
                        dArray2 = dicomObject.getImagePlaneModule().ao();
                    }
                    catch (InvalidDataException invalidDataException) {
                        logger.error((Object)invalidDataException, invalidDataException);
                        return -1;
                    }
                    Vector3d vector3d = new Vector3d(dArray2);
                    Vector3d vector3d2 = new Vector3d(dArray);
                    Vector3d vector3d3 = new Vector3d();
                    vector3d3.cross(vector3d, vector3d2);
                    try {
                        n3 = ToolBox.getPrincipalComponent(vector3d);
                        n2 = ToolBox.getPrincipalComponent(vector3d2);
                        n = ToolBox.getPrincipalComponent(vector3d3);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.error((Object)illegalArgumentException, illegalArgumentException);
                        return -1;
                    }
                    try {
                        try {
                            try {
                                if (n3 != 0x2000000 || n2 != 0x8000000) break block22;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw MPRUtilities.a(invalidDataException);
                            }
                            if (n != 0x4000000) break block22;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw MPRUtilities.a(invalidDataException);
                        }
                        return 5;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw MPRUtilities.a(invalidDataException);
                    }
                }
                try {
                    try {
                        try {
                            if (n3 != 0x4000000 || n2 != 0x8000000) break block23;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw MPRUtilities.a(invalidDataException);
                        }
                        if (n != 0x2000000) break block23;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw MPRUtilities.a(invalidDataException);
                    }
                    return 6;
                }
                catch (InvalidDataException invalidDataException) {
                    throw MPRUtilities.a(invalidDataException);
                }
            }
            try {
                try {
                    try {
                        if (n3 != 0x2000000 || n2 != 0x4000000) break block24;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw MPRUtilities.a(invalidDataException);
                    }
                    if (n != 0x8000000) break block24;
                }
                catch (InvalidDataException invalidDataException) {
                    throw MPRUtilities.a(invalidDataException);
                }
                return 7;
            }
            catch (InvalidDataException invalidDataException) {
                throw MPRUtilities.a(invalidDataException);
            }
        }
        return -1;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

