/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.issue.issues;

import com.visustt.jiveX.tools.issue.issues.StartupIssueChecker;
import com.visustt.tools.ae.ad;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.util.resource.locale.LocaleSelector;
import com.visustt.tools.util.resource.locale.localization_plugin.ApplicationLocaleInitializer;
import com.visustt.tools.util.resource.locale.localization_plugin.LocalizationPlugin;
import java.util.Locale;

public class LocalePluginStartupIssueChecker
extends StartupIssueChecker {
    private static final Logger logger = LoggerFactory.getInstance("jx.startup.issues");
    private static final String LANGUAGE_MISCONFIGURE_WARNING = "LANGUAGE_MISCONFIGURE_WARNING";
    private static final String LANGUAGE_REMOVED_WARNING = "LANGUAGE_REMOVED_WARNING";
    private final int type = 3;

    @Override
    public boolean checkForIssue(ad ad2) {
        if (logger.debugIsEnabled()) {
            logger.debug("Check for localization issues ...");
        }
        if (ApplicationLocaleInitializer.isAlreadyInitialized()) {
            LocalizationPlugin localizationPlugin = ApplicationLocaleInitializer.getLocalizationPlugin();
            Locale locale = LocaleSelector.getLocaleSelector().getSelectedLocale();
            if (localizationPlugin != null) {
                String string;
                boolean bl = this.checkLanguageMisconfiguration(ad2, localizationPlugin, locale);
                Locale locale2 = LocaleSelector.getLocaleSelector().getUserDefinedLocale();
                if (locale2 == null) {
                    locale2 = LocaleSelector.getLocaleSelector().getPreferedLocale();
                }
                if (StringTool.isDefined(string = localizationPlugin.getLanguageRemovedError(locale2)) && ad.aa().ab(LANGUAGE_REMOVED_WARNING) == null) {
                    this.addIssue(ad2, LANGUAGE_REMOVED_WARNING, LANGUAGE_MISCONFIGURE_WARNING, 3, new Object[]{string}, false, false);
                    bl = true;
                }
                return bl;
            }
            logger.warn("Localization Plugin is null!");
        }
        return false;
    }

    public boolean checkLanguageMisconfiguration(ad ad2, LocalizationPlugin localizationPlugin, Locale locale) {
        String string = localizationPlugin.getLanguageMisconfigureWarning(locale);
        if (StringTool.isDefined(string) && ad.aa().ab(LANGUAGE_MISCONFIGURE_WARNING) == null) {
            this.addIssue(ad2, LANGUAGE_MISCONFIGURE_WARNING, LANGUAGE_MISCONFIGURE_WARNING, 3, new Object[]{string}, true, false);
            return true;
        }
        return false;
    }
}

