/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.dateformat;

import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.tools.config.main.ConfigurationException;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.text.DateUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JiveXFormatMap {
    private static final Logger logger = LoggerFactory.getInstance("jx.client.formatMap");
    public static final String FORMAT_DATE = "dateFormat";
    public static final String FORMAT_DATE_LONG = "longDateFormat";
    public static final String FORMAT_TIME_SHORT = "timeFormat";
    public static final String FORMAT_TIME_LONG = "longTimeFormat";
    public static final String FORMAT_DATETIME = "dateTimeFormat";
    public static final String FORMAT_DATETIME_LONG = "longDateTimeFormat";
    private final Map<String, String> formatMap = new HashMap<String, String>();

    public JiveXFormatMap() {
        this.reset();
    }

    public Map<String, String> getFormatMap() {
        return this.formatMap;
    }

    public void setFormat(String string, String string2) {
        block8: {
            block7: {
                block6: {
                    try {
                        try {
                            if (string != null && !"".equals(string)) break block6;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw JiveXFormatMap.a(illegalArgumentException);
                        }
                        throw new IllegalArgumentException("Name of the format to set must be defined.");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw JiveXFormatMap.a(illegalArgumentException);
                    }
                }
                try {
                    if (string2 != null) break block7;
                    this.formatMap.remove(string);
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw JiveXFormatMap.a(illegalArgumentException);
                }
            }
            this.formatMap.put(string, string2);
        }
    }

    public boolean containsFormat(String string) {
        return this.formatMap.containsKey(string);
    }

    public String getFormat(String string) {
        try {
            if (this.formatMap.containsKey(string)) {
                return this.formatMap.get(string);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JiveXFormatMap.a(illegalArgumentException);
        }
        throw new IllegalArgumentException("Unknown format named '" + string + "'");
    }

    public void reset() {
        this.formatMap.clear();
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        this.formatMap.put(FORMAT_DATE, "yyyy-MM-dd");
        this.formatMap.put(FORMAT_DATE_LONG, "EEE, yyyy-MM-dd");
        this.formatMap.put(FORMAT_TIME_SHORT, "HH:mm");
        this.formatMap.put(FORMAT_TIME_LONG, "HH:mm:ss");
        this.formatMap.put(FORMAT_DATETIME, "yyyy-MM-dd HH:mm");
        this.formatMap.put(FORMAT_DATETIME_LONG, "yyyy-MM-dd HH:mm:ss");
    }

    public void reformatDateTime(Map<String, Object> map) {
        block5: {
            try {
                if (map == null || map.isEmpty()) break block5;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JiveXFormatMap.a(illegalArgumentException);
            }
            Set<String> set = map.keySet();
            for (String string : set) {
                try {
                    if (string == null || !(map.get(string) instanceof String)) continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw JiveXFormatMap.a(illegalArgumentException);
                }
                Object object = map.get(string);
                map.put(string, this.reformatDateTimeValue(string, (String)object));
            }
        }
    }

    public String reformatDateTimeValue(String string, String string2) {
        block7: {
            String string3 = null;
            String string4 = null;
            if (string.toLowerCase().endsWith("datetime")) {
                string3 = DateUtils.guessDateFormat(string2);
                string4 = this.getFormat(FORMAT_DATETIME);
            } else if (string.toLowerCase().endsWith("date")) {
                string3 = DateUtils.guessDateFormat(string2);
                string4 = this.getFormat(FORMAT_DATE);
            } else if (string.toLowerCase().endsWith("time")) {
                string3 = DateUtils.guessTimeFormat(string2);
                string4 = this.getFormat(FORMAT_TIME_LONG);
            }
            try {
                if (string3 == null || string4 == null) break block7;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JiveXFormatMap.a(illegalArgumentException);
            }
            string2 = DateUtils.reformatDate(string2, string3, string4);
        }
        return string2;
    }

    public void initFromConfig(ConfigurationElement configurationElement) {
        this.reset();
        if (configurationElement != null) {
            String[] stringArray;
            for (String string : stringArray = configurationElement.getAttributeNames()) {
                try {
                    String string2 = configurationElement.getAttributeAsString(string, ",");
                    this.setFormat(string, string2);
                }
                catch (ConfigurationException configurationException) {
                    logger.error((Object)"Could not read format value out of config.", configurationException);
                }
            }
        }
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

