/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.structure;

import com.visustt.dicomTk.DicomTag;
import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.jiveX.tools.database.converter.dicom.DicomDbTypeConverter;
import com.visustt.jiveX.tools.database.structure.CategoryColumnMetaData;
import com.visustt.jiveX.tools.database.structure.ColumnMetaData;
import com.visustt.jiveX.tools.database.structure.DicomColumnMetaData;
import com.visustt.jiveX.tools.database.structure.TransmitInfoColumnMetaData;
import com.visustt.jiveX.tools.database.structure.aa;
import com.visustt.tools.config.main.ConfigurationException;
import com.visustt.tools.lang.StringTool;
import java.util.Vector;

public class ColumnMetaDataFactory {
    private static final String CFG_SIZE = "size";
    private static final String CFG_MAX_SIZE = "maxSize";
    private static final String CFG_CHECK_DICOM_TAG = "checkDicomTag";
    private static final String CFG_ACTION = "action";
    private static final String CFG_CONVERTER = "converter";
    private static final String CFG_FLAG = "flag";
    private static final String CFG_VM_SENSITIVE = "vmSensitive";
    private static final String CFG_CASE_IN_SENSITIVE = "caseInSensitive";
    private static final String CFG_SEQUENCE_REFERENCE_TAG = "sqReferenceTag";
    private static final String CFG_TAG = "tag";
    private static final String CFG_TYPE = "type";
    private static final String CFG_NAME = "name";
    private static final String CFG_FIELD = "field";
    private static final String CFG_VALUE_SET_ID = "valueSetID";
    private static final String CFG_VALUE_SET_VERSION = "valueSetVersion";
    private static final String COLUMNTYPE_COLUMN = "Column";
    private static final String COLUMNTYPE_DICOM_COLUMN = "DicomColumn";
    private static final String COLUMNTYPE_TRANSMITINFO_COLUMN = "TransmitInfoColumn";
    private static final String COLUMNTYPE_CATEGORY_COLUMN = "CategoryColumn";

    private ColumnMetaDataFactory() {
    }

    public static ConfigurationElement getConfigForColumn(ColumnMetaData columnMetaData) {
        ConfigurationElement configurationElement = new ConfigurationElement();
        configurationElement.addAttribute(CFG_NAME, columnMetaData.getColumnName());
        configurationElement.addAttribute(CFG_CASE_IN_SENSITIVE, Boolean.toString(columnMetaData.isCaseInSensitive()));
        if (StringTool.isDefined(columnMetaData.getColumnFlag())) {
            configurationElement.addAttribute(CFG_FLAG, columnMetaData.getColumnFlag());
        }
        if (columnMetaData instanceof DicomColumnMetaData) {
            ColumnMetaDataFactory.buildConfigForDicomColumnMetaData(columnMetaData, configurationElement);
        } else {
            configurationElement.addAttribute(CFG_TYPE, aa.aa(columnMetaData.getColumnType()));
            if (columnMetaData.getColumnSize() != 0) {
                configurationElement.addAttribute(CFG_SIZE, Integer.toString(columnMetaData.getColumnSize()));
            }
            if (columnMetaData instanceof TransmitInfoColumnMetaData) {
                configurationElement.setName(COLUMNTYPE_TRANSMITINFO_COLUMN);
                configurationElement.addAttribute(CFG_FIELD, ((TransmitInfoColumnMetaData)columnMetaData).getTransmitInfoField());
            } else if (columnMetaData instanceof CategoryColumnMetaData) {
                configurationElement.setName(COLUMNTYPE_CATEGORY_COLUMN);
                configurationElement.addAttribute(CFG_VALUE_SET_ID, ((CategoryColumnMetaData)columnMetaData).getValueSetID());
                configurationElement.addAttribute(CFG_VALUE_SET_VERSION, ((CategoryColumnMetaData)columnMetaData).getValueSetVersion());
            } else {
                configurationElement.setName(COLUMNTYPE_COLUMN);
            }
        }
        return configurationElement;
    }

    private static void buildConfigForDicomColumnMetaData(ColumnMetaData columnMetaData, ConfigurationElement configurationElement) {
        DicomDbTypeConverter dicomDbTypeConverter;
        DicomColumnMetaData dicomColumnMetaData = (DicomColumnMetaData)columnMetaData;
        configurationElement.setName(COLUMNTYPE_DICOM_COLUMN);
        configurationElement.addAttribute(CFG_TAG, ColumnMetaDataFactory.getTag(dicomColumnMetaData.getDicomTag().toString()));
        configurationElement.addAttribute(CFG_VM_SENSITIVE, Boolean.toString(dicomColumnMetaData.isVmSensitive()));
        if (dicomColumnMetaData.getSqReferenceTag() != null) {
            configurationElement.addAttribute(CFG_SEQUENCE_REFERENCE_TAG, ColumnMetaDataFactory.getTag(dicomColumnMetaData.getSqReferenceTag().toString()));
        }
        if ((dicomDbTypeConverter = dicomColumnMetaData.getConverter()) != null) {
            configurationElement.addAttribute(CFG_CONVERTER, dicomDbTypeConverter.getClass().getName());
            configurationElement.addAttribute(CFG_CHECK_DICOM_TAG, Boolean.toString(dicomDbTypeConverter.isCheckDicomTag()));
        }
    }

    private static Vector<String> getTag(String string) {
        Vector<String> vector = new Vector<String>(2, 1);
        String[] stringArray = string.split(",");
        vector.add(stringArray[0]);
        vector.add(stringArray[1]);
        return vector;
    }

    public static ColumnMetaData getColumnFromConfig(ConfigurationElement configurationElement) throws ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigurationException {
        block10: {
            try {
                try {
                    if (!configurationElement.getName().equals(COLUMNTYPE_DICOM_COLUMN) && !configurationElement.checkForAttribute(CFG_TAG)) break block10;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw ColumnMetaDataFactory.a(classNotFoundException);
                }
                return ColumnMetaDataFactory.createDicomColumnMetaData(configurationElement);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ColumnMetaDataFactory.a(classNotFoundException);
            }
        }
        try {
            if (configurationElement.getName().equals(COLUMNTYPE_TRANSMITINFO_COLUMN)) {
                return ColumnMetaDataFactory.createTransmitInfoColumnMetaData(configurationElement);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ColumnMetaDataFactory.a(classNotFoundException);
        }
        try {
            if (configurationElement.getName().equals(COLUMNTYPE_CATEGORY_COLUMN)) {
                return ColumnMetaDataFactory.createCategoryColumnMetaData(configurationElement);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw ColumnMetaDataFactory.a(classNotFoundException);
        }
        return ColumnMetaDataFactory.createColumnMetaData(configurationElement);
    }

    private static ColumnMetaData createCategoryColumnMetaData(ConfigurationElement configurationElement) throws ConfigurationException {
        String string = configurationElement.getStringValue(CFG_VALUE_SET_ID);
        String string2 = configurationElement.getStringValue(CFG_VALUE_SET_VERSION);
        return new CategoryColumnMetaData(ColumnMetaDataFactory.createColumnMetaData(configurationElement), string, string2);
    }

    private static ColumnMetaData createTransmitInfoColumnMetaData(ConfigurationElement configurationElement) throws ConfigurationException {
        String string = configurationElement.getStringValue(CFG_FIELD);
        return new TransmitInfoColumnMetaData(ColumnMetaDataFactory.createColumnMetaData(configurationElement), string);
    }

    private static ColumnMetaData createColumnMetaData(ConfigurationElement configurationElement) throws ConfigurationException {
        ColumnMetaDataFactory.checkFlagInTimeStampColums(configurationElement);
        String string = configurationElement.getStringValue(CFG_NAME);
        String string2 = configurationElement.getStringValue(CFG_FLAG, "");
        boolean bl = configurationElement.getBooleanValue(CFG_CASE_IN_SENSITIVE, false);
        int n = aa.aa(configurationElement.getStringValue(CFG_TYPE, "NOT DEFINED"));
        int n2 = configurationElement.getIntValue(CFG_SIZE, 0);
        return new ColumnMetaData(string, n, n2, string2, bl);
    }

    private static ColumnMetaData createDicomColumnMetaData(ConfigurationElement configurationElement) throws ConfigurationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        DicomTag dicomTag = new DicomTag(configurationElement.getAttributeAsString(CFG_TAG, ","));
        DicomTag dicomTag2 = configurationElement.checkForAttribute(CFG_SEQUENCE_REFERENCE_TAG) ? new DicomTag(configurationElement.getAttributeAsString(CFG_SEQUENCE_REFERENCE_TAG, ",")) : null;
        ColumnMetaDataFactory.checkFlagInTimeStampColums(configurationElement);
        String string = configurationElement.getStringValue(CFG_NAME);
        String string2 = configurationElement.getStringValue(CFG_FLAG, "");
        String string3 = configurationElement.getStringValue(CFG_CONVERTER, null);
        String string4 = configurationElement.getStringValue(CFG_ACTION, null);
        boolean bl = configurationElement.getBooleanValue(CFG_CHECK_DICOM_TAG, false);
        boolean bl2 = configurationElement.getBooleanValue(CFG_CASE_IN_SENSITIVE, false);
        boolean bl3 = configurationElement.getBooleanValue(CFG_VM_SENSITIVE, false);
        int n = configurationElement.getIntValue(CFG_MAX_SIZE, 0);
        return new DicomColumnMetaData(string, dicomTag, dicomTag2, string2, string3, string4, bl, bl2, bl3, n);
    }

    private static void checkFlagInTimeStampColums(ConfigurationElement configurationElement) throws ConfigurationException {
        block6: {
            String string;
            String string2;
            ConfigurationException configurationException;
            ConfigurationException configurationException2;
            block8: {
                block7: {
                    String string3 = configurationElement.getStringValue(CFG_FLAG, "");
                    int n = aa.aa(configurationElement.getStringValue(CFG_TYPE, "NOT DEFINED"));
                    try {
                        if (93 != n || StringTool.isDefined(string3)) break block6;
                    }
                    catch (ConfigurationException configurationException3) {
                        throw ColumnMetaDataFactory.a(configurationException3);
                    }
                    String string4 = configurationElement.getStringValue(CFG_NAME);
                    ConfigurationElement configurationElement2 = (ConfigurationElement)configurationElement.getParent();
                    try {
                        try {
                            ConfigurationException configurationException4;
                            if (Boolean.getBoolean("jx.cs.ignoreFlagInTimeStampColums")) break block6;
                            configurationException2 = configurationException4;
                            configurationException = configurationException4;
                            string2 = string4;
                            if (configurationElement2 == null) break block7;
                        }
                        catch (ConfigurationException configurationException5) {
                            throw ColumnMetaDataFactory.a(configurationException5);
                        }
                        string = configurationElement2.getStringValue(CFG_NAME);
                        break block8;
                    }
                    catch (ConfigurationException configurationException6) {
                        throw ColumnMetaDataFactory.a(configurationException6);
                    }
                }
                string = "<Unknown>";
            }
            configurationException2("The column '" + string2 + "' for the table configuration '" + string + "' has a invalid configuration for the type TIMESTAMP. The parameter flag must be set!\nSee for more information the MySQL documentation of the chapter \"Automatic Initialization and Updating for TIMESTAMP\"");
            throw configurationException;
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

