/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.structure;

import com.visustt.jiveX.tools.database.structure.aa;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ColumnMetaData {
    private static final Pattern DEFAULT_VALUE_PATTERN = Pattern.compile("DEFAULT '(.+?)'");
    protected String columnName;
    protected int columnType;
    protected int columnSize;
    protected String columnFlag;
    protected int indexLength;
    protected boolean caseInSensitive;

    public ColumnMetaData(String string, int n, int n2, String string2) {
        this(string, n, n2, string2, false);
    }

    public ColumnMetaData(String string, String string2) {
        this(string, 0, 0, string2, false);
    }

    public ColumnMetaData(String string, String string2, boolean bl) {
        this(string, 0, 0, string2, bl);
    }

    public ColumnMetaData(String string, int n, int n2, String string2, boolean bl) {
        this.columnName = string;
        this.columnType = n;
        this.columnSize = n2;
        this.columnFlag = string2;
        this.caseInSensitive = bl;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public int getColumnSize() {
        return this.columnSize;
    }

    public String getColumnFlag() {
        return this.columnFlag;
    }

    public String toJDBCString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.columnName + " ");
        stringBuffer.append(aa.aa(this.columnType));
        if (this.columnSize > 0) {
            stringBuffer.append("(" + this.columnSize + ")");
        } else {
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(200);
        stringBuilder.append("columnname='");
        stringBuilder.append(this.columnName);
        stringBuilder.append("' type='");
        stringBuilder.append(aa.aa(this.columnType));
        stringBuilder.append("'");
        if (this.columnSize != 0) {
            stringBuilder.append("(");
            stringBuilder.append(this.columnSize);
            stringBuilder.append(")'");
        }
        if (this.columnFlag != null) {
            stringBuilder.append(" flag='");
            stringBuilder.append(this.columnFlag);
            stringBuilder.append("'");
        }
        stringBuilder.append(" caseInSensitive='");
        stringBuilder.append(this.caseInSensitive);
        stringBuilder.append("'");
        if (this.indexLength != 0) {
            stringBuilder.append(" indexLength='");
            stringBuilder.append(this.indexLength);
            stringBuilder.append("'");
        }
        return stringBuilder.toString();
    }

    public boolean isCaseInSensitive() {
        return this.caseInSensitive;
    }

    public void setCaseInSensitive(boolean bl) {
        this.caseInSensitive = bl;
    }

    public int getIndexLength() {
        return this.indexLength;
    }

    public void setIndexLength(int n) {
        this.indexLength = n;
    }

    public boolean hasDefaultValue() {
        return this.columnFlag != null && (this.columnFlag.toUpperCase().indexOf("DEFAULT ''") != -1 || DEFAULT_VALUE_PATTERN.matcher(this.columnFlag).find());
    }

    public String getDefaultValue() {
        if (!this.hasDefaultValue()) {
            return null;
        }
        if (this.columnFlag.toUpperCase().indexOf("DEFAULT ''") != -1) {
            return "";
        }
        Matcher matcher = DEFAULT_VALUE_PATTERN.matcher(this.columnFlag);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.caseInSensitive ? 1231 : 1237);
        n2 = 31 * n2 + (this.columnFlag == null ? 0 : this.columnFlag.hashCode());
        n2 = 31 * n2 + (this.columnName == null ? 0 : this.columnName.hashCode());
        n2 = 31 * n2 + this.columnSize;
        n2 = 31 * n2 + this.columnType;
        n2 = 31 * n2 + this.indexLength;
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof ColumnMetaData)) {
            return false;
        }
        ColumnMetaData columnMetaData = (ColumnMetaData)object;
        if (this.caseInSensitive != columnMetaData.caseInSensitive) {
            return false;
        }
        if (this.columnFlag == null ? columnMetaData.columnFlag != null : !this.columnFlag.equals(columnMetaData.columnFlag)) {
            return false;
        }
        if (this.columnName == null ? columnMetaData.columnName != null : !this.columnName.equals(columnMetaData.columnName)) {
            return false;
        }
        if (this.columnSize != columnMetaData.columnSize) {
            return false;
        }
        if (this.columnType != columnMetaData.columnType) {
            return false;
        }
        return this.indexLength == columnMetaData.indexLength;
    }
}

