/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.general;

import com.visustt.tools.lang.LowerCaseKeyHashtable;
import com.visustt.tools.lang.StringTool;

public class JiveXTableDefinition {
    public static final String SR = "SR";
    public static final String KEY = "Key";
    public static final String PS = "PS";
    public static final String IMAGE = "Image";
    public static final String SERIES = "Series";
    public static final String STUDY = "Study";
    public static final String PATIENT = "Patient";
    public static final String DEMO = "Demo";
    public static final String SVS = "SVS";
    public static final String OTHER = "Other";
    public static final String VISIT = "Visit";
    public static final String MOVEMENT = "Movement";
    public static final String WORKLIST_PATIENT = "OrderPatient";
    public static final String WORKLIST_VISIT = "OrderVisit";
    public static final String WORKLIST_ORDER = "OrderData";
    public static final String WORKLIST_PROCEDURE = "Procedure";
    public static final String WORKLIST_PROC_STEP = "ProcedureStep";
    public static final String PATERN_STUDY_FREE = "^free[0-9]+";
    private static final String FIELD_FREE_PREFIX = "free";
    private static LowerCaseKeyHashtable<String, String> columnData = new LowerCaseKeyHashtable(210);
    private static LowerCaseKeyHashtable<String, String> worklistData = new LowerCaseKeyHashtable(210);
    private static LowerCaseKeyHashtable<String, String> dynamicColumnData = new LowerCaseKeyHashtable();

    public static final boolean isUnknownField(String string) {
        return !JiveXTableDefinition.isKnownField(string);
    }

    public static final boolean isKnownField(String string) {
        if (string != null) {
            return columnData.containsKey(string) || dynamicColumnData.containsKey(string);
        }
        return false;
    }

    public static final String getTypeFromField(String string) {
        if (string != null) {
            String string2 = columnData.get(string);
            if (string2 == null) {
                string2 = dynamicColumnData.get(string);
            }
            return string2;
        }
        return null;
    }

    public static final void addDynamicField(String string, String string2) {
        dynamicColumnData.put(string, string2);
    }

    public static final LowerCaseKeyHashtable<String, String> getDynamicColumnData() {
        return dynamicColumnData;
    }

    public static boolean isDynamicField(String string) {
        return dynamicColumnData != null && dynamicColumnData.containsKey(string);
    }

    public static final void setDynamicColumnData(LowerCaseKeyHashtable<String, String> lowerCaseKeyHashtable) {
        if (lowerCaseKeyHashtable != null) {
            dynamicColumnData = lowerCaseKeyHashtable;
        } else {
            dynamicColumnData.clear();
        }
    }

    public static final boolean matchesStudyFreeField(String string) {
        return string != null && string.matches(PATERN_STUDY_FREE);
    }

    public static boolean isDateTimeColumn(String string) {
        return StringTool.isDefined(string) && (string.toLowerCase().indexOf("date") != -1 || string.toLowerCase().indexOf("time") != -1);
    }

    public static boolean isWorklistField(String string) {
        return worklistData.containsKey(string);
    }

    public static final String getTypeFromWorklistField(String string) {
        return JiveXTableDefinition.isWorklistField(string) ? worklistData.get(string) : null;
    }

    public static boolean isFreeFieldColumn(String string) {
        return string != null && string.startsWith(FIELD_FREE_PREFIX);
    }

    static {
        columnData.put("jivePatientDataID", PATIENT);
        columnData.put("JivePatientData.jivePatientDataID", PATIENT);
        columnData.put("patientsName", PATIENT);
        columnData.put("patientsID", PATIENT);
        columnData.put("patientsBirthDate", PATIENT);
        columnData.put("patientsBirthTime", PATIENT);
        columnData.put("patientsSex", PATIENT);
        columnData.put("ethnicGroup", PATIENT);
        columnData.put("otherPatientsID", PATIENT);
        columnData.put("otherPatientsNames", PATIENT);
        columnData.put("patientsBirthName", PATIENT);
        columnData.put("patientComments", PATIENT);
        columnData.put("mergedJivePatientDataID", PATIENT);
        columnData.put("masterPatientsID", PATIENT);
        columnData.put("patientActionStatus", PATIENT);
        columnData.put("insuranceNumber", PATIENT);
        columnData.put("numberOfPatientRelatedStudies", PATIENT);
        columnData.put("patientsDeathIndicator", PATIENT);
        columnData.put("patientsDeathDate", PATIENT);
        columnData.put("patientsDeathTime", PATIENT);
        columnData.put("identityUnknownIndicator", PATIENT);
        columnData.put("identityReliabilityCode", PATIENT);
        columnData.put("lastUpdateDateTime", PATIENT);
        columnData.put("authorityNamespaceID", PATIENT);
        columnData.put("authorityDescription", PATIENT);
        columnData.put("authorityUniversalID", PATIENT);
        columnData.put("authorityUniversalIDType", PATIENT);
        columnData.put("jiveAssigningAuthorityID", PATIENT);
        columnData.put("patientVerificationFlag", PATIENT);
        columnData.put("jiveVisitDataID", VISIT);
        columnData.put("JiveVisitData.jiveVisitDataID", VISIT);
        columnData.put("JiveVisitData.jivePatientDataID", VISIT);
        columnData.put("visitNumber", VISIT);
        columnData.put("visitNumberAuthority", VISIT);
        columnData.put("admitDateTime", VISIT);
        columnData.put("dischargeDateTime", VISIT);
        columnData.put("currentPatientClass", VISIT);
        columnData.put("currentPatientLocation", VISIT);
        columnData.put("currentAttendingDoctor", VISIT);
        columnData.put("referringDoctor", VISIT);
        columnData.put("admittingDoctor", VISIT);
        columnData.put("visitStatus", VISIT);
        columnData.put("jiveMovementDataID", MOVEMENT);
        columnData.put("JiveMovementData.jiveVisitDataID", MOVEMENT);
        columnData.put("triggerEvent", MOVEMENT);
        columnData.put("movementID", MOVEMENT);
        columnData.put("movementDateTime", MOVEMENT);
        columnData.put("patientClass", MOVEMENT);
        columnData.put("assignedPatientLocation", MOVEMENT);
        columnData.put("attendingDoctor", MOVEMENT);
        columnData.put("movementStatus", MOVEMENT);
        columnData.put("originTriggerEvent", MOVEMENT);
        columnData.put("studyStatus", STUDY);
        columnData.put("studyErrorComment", STUDY);
        columnData.put("studyError", STUDY);
        columnData.put("studyReceiveDateStart", STUDY);
        columnData.put("studyReceiveDateEnd", STUDY);
        columnData.put("studyLastDisplayDate", STUDY);
        columnData.put("studyDate", STUDY);
        columnData.put("studyTime", STUDY);
        columnData.put("studyID", STUDY);
        columnData.put("referringPhysicianName", STUDY);
        columnData.put("accessionNumber", STUDY);
        columnData.put("studyDescription", STUDY);
        columnData.put("physiciansOfRecord", STUDY);
        columnData.put("nameOfPhysiciansReadingStudy", STUDY);
        columnData.put("studyInstanceUID", STUDY);
        columnData.put("numberOfStudyRelatedSeries", STUDY);
        columnData.put("numberOfStudyRelatedImages", STUDY);
        columnData.put("admittingDiagnosesDescription", STUDY);
        columnData.put("patientsAge", STUDY);
        columnData.put("patientsSize", STUDY);
        columnData.put("patientsWeight", STUDY);
        columnData.put("occupation", STUDY);
        columnData.put("additionalPatientsHistory", STUDY);
        columnData.put("archiveFlag", STUDY);
        columnData.put("remoteArchiveFlag", STUDY);
        columnData.put("actionStatus", STUDY);
        columnData.put("fixedFlag", STUDY);
        columnData.put("archiveDate", STUDY);
        columnData.put("bytes", STUDY);
        columnData.put("modalitiesInStudy", STUDY);
        columnData.put("modalityNames", STUDY);
        columnData.put("observerName", STUDY);
        columnData.put("numberOfStudyRevokedImages", STUDY);
        columnData.put("free1", STUDY);
        columnData.put("free2", STUDY);
        columnData.put("free3", STUDY);
        columnData.put("free4", STUDY);
        columnData.put("free5", STUDY);
        columnData.put("free6", STUDY);
        columnData.put("free7", STUDY);
        columnData.put("free8", STUDY);
        columnData.put("free9", STUDY);
        columnData.put("studyVerificationFlag", STUDY);
        columnData.put("studyVerificationDate", STUDY);
        columnData.put("studyVerificationName", STUDY);
        columnData.put("studyVerificationType", STUDY);
        columnData.put("replicationFlag", STUDY);
        columnData.put("replicationJobStatusStudy", STUDY);
        columnData.put("jiveStudyDataID", STUDY);
        columnData.put("JiveStudyData.jiveStudyDataID", STUDY);
        columnData.put("mailAddressesFrom", STUDY);
        columnData.put("mailAddressesTo", STUDY);
        columnData.put("mailParticipantsFrom", STUDY);
        columnData.put("mailParticipantsTo", STUDY);
        columnData.put("mailReceptionStatus", STUDY);
        columnData.put("hasCaptures", STUDY);
        columnData.put("retentionTime", STUDY);
        columnData.put("xdsRegistrationStatus", STUDY);
        columnData.put("studyHasKeyImages", STUDY);
        columnData.put("studyHasAnnotations", STUDY);
        columnData.put("resultStatus", STUDY);
        columnData.put("shortResultStatus", STUDY);
        columnData.put("studyCacheStatus", STUDY);
        columnData.put("jiveTenantID", STUDY);
        columnData.put("studyDeleted", STUDY);
        columnData.put("admissionID", STUDY);
        columnData.put("modality", SERIES);
        columnData.put("seriesInstanceUID", SERIES);
        columnData.put("seriesNumber", SERIES);
        columnData.put("laterality", SERIES);
        columnData.put("seriesDate", SERIES);
        columnData.put("seriesTime", SERIES);
        columnData.put("performingPhysiciansName", SERIES);
        columnData.put("operatorsName", SERIES);
        columnData.put("protocolName", SERIES);
        columnData.put("seriesDescription", SERIES);
        columnData.put("bodyPartExamined", SERIES);
        columnData.put("patientPosition", SERIES);
        columnData.put("jiveNumberOfImages", SERIES);
        columnData.put("imageCols", SERIES);
        columnData.put("imageRows", SERIES);
        columnData.put("seriesDeleted", SERIES);
        columnData.put("requestedProcedureID", SERIES);
        columnData.put("sceduledProcedureStepID", SERIES);
        columnData.put("perfProcedureStepStartDate", SERIES);
        columnData.put("perfProcedureStepStartTime", SERIES);
        columnData.put("manufacturer", SERIES);
        columnData.put("institutionName", SERIES);
        columnData.put("institutionAddress", SERIES);
        columnData.put("modalityName", SERIES);
        columnData.put("institutionalDepartmentName", SERIES);
        columnData.put("manufacturersModelName", SERIES);
        columnData.put("deviceSerialNumber", SERIES);
        columnData.put("mailAddressFrom", SERIES);
        columnData.put("mailAddressTo", SERIES);
        columnData.put("status", SERIES);
        columnData.put("error", SERIES);
        columnData.put("errorComment", SERIES);
        columnData.put("host", SERIES);
        columnData.put("port", SERIES);
        columnData.put("transferSyntax", SERIES);
        columnData.put("callingAE", SERIES);
        columnData.put("calledAE", SERIES);
        columnData.put("receiveDateStart", SERIES);
        columnData.put("receiveDateEnd", SERIES);
        columnData.put("lastDisplayDate", SERIES);
        columnData.put("softwareVersions", SERIES);
        columnData.put("spatialResolution", SERIES);
        columnData.put("pixelPaddingValue", SERIES);
        columnData.put("sopClassUID", SERIES);
        columnData.put("imagesInAquisition", SERIES);
        columnData.put("photometricInterpretation", SERIES);
        columnData.put("numberOfSeriesRelatedImages", SERIES);
        columnData.put("stationName", SERIES);
        columnData.put("archiveFlagSeries", SERIES);
        columnData.put("remoteArchiveFlagSeries", SERIES);
        columnData.put("archiveDateSeries", SERIES);
        columnData.put("actionStatusSeries", SERIES);
        columnData.put("archiveReferenceSeries", SERIES);
        columnData.put("bytesSeries", SERIES);
        columnData.put("numberOfSeriesRevokedImages", SERIES);
        columnData.put("freeSeries1", SERIES);
        columnData.put("freeSeries2", SERIES);
        columnData.put("freeSeries3", SERIES);
        columnData.put("replicationFlagSeries", SERIES);
        columnData.put("replicationJobStatus", SERIES);
        columnData.put("jiveSeriesDataID", SERIES);
        columnData.put("seriesHasKeyImages", SERIES);
        columnData.put("seriesHasAnnotations", SERIES);
        columnData.put("seriesCacheStatus", SERIES);
        columnData.put("jiveImageNumber", IMAGE);
        columnData.put("keyImage", IMAGE);
        columnData.put("bytesImage", IMAGE);
        columnData.put("imageOrderValue", IMAGE);
        columnData.put("imageDeleted", IMAGE);
        columnData.put("dicomWindow", IMAGE);
        columnData.put("pixelSpacing", IMAGE);
        columnData.put("orientation", IMAGE);
        columnData.put("pixelRange", IMAGE);
        columnData.put("rowsValue", IMAGE);
        columnData.put("colsValue", IMAGE);
        columnData.put("photometric", IMAGE);
        columnData.put("sopInstanceUID", IMAGE);
        columnData.put("imageNumber", IMAGE);
        columnData.put("numberOfFrames", IMAGE);
        columnData.put("bitsAllocated", IMAGE);
        columnData.put("imageDate", IMAGE);
        columnData.put("imageTime", IMAGE);
        columnData.put("imageType", IMAGE);
        columnData.put("acquisitionNumber", IMAGE);
        columnData.put("acquisitionDate", IMAGE);
        columnData.put("acquisitionTime", IMAGE);
        columnData.put("derivationDescription", IMAGE);
        columnData.put("patientOrientation", IMAGE);
        columnData.put("imageComments", IMAGE);
        columnData.put("sopClassUIDin", IMAGE);
        columnData.put("imageArchiveReference", IMAGE);
        columnData.put("psStatus", PS);
        columnData.put("referencedStudyInstanceUID", PS);
        columnData.put("presentationLabel", PS);
        columnData.put("presentationDescription", PS);
        columnData.put("presentationCreationsDate", PS);
        columnData.put("presentationCreationsTime", PS);
        columnData.put("presentationCreatorsName", PS);
        columnData.put("contentDate", KEY);
        columnData.put("contentTime", KEY);
        columnData.put("observationDateTime", KEY);
        columnData.put("conceptNameCodeValue", KEY);
        columnData.put("conceptNameDesignator", KEY);
        columnData.put("conceptNameCodeVersion", KEY);
        columnData.put("conceptNameCodeMeaning", KEY);
        columnData.put("instanceNumber", KEY);
        columnData.put("completionFlag", SR);
        columnData.put("verificationFlag", SR);
        columnData.put("verifyingOrganisation", SR);
        columnData.put("verificationDateTime", SR);
        columnData.put("verificationName", SR);
        columnData.put("templateIdentifier", SR);
        columnData.put("containerName", DEMO);
        columnData.put("containerOwner", DEMO);
        columnData.put("containerStartDateTime", DEMO);
        columnData.put("containerEndDateTime", DEMO);
        columnData.put("jiveContainerDataID", DEMO);
        columnData.put("JiveContainerData.jiveContainerDataID", DEMO);
        columnData.put("jiveContainerContentDataID", DEMO);
        columnData.put("sortOrder", DEMO);
        columnData.put("demoStatus", DEMO);
        columnData.put("demoPresenter", DEMO);
        columnData.put("presentationDateTime", DEMO);
        columnData.put("presentationDuration", DEMO);
        columnData.put("studyAddedBy", DEMO);
        columnData.put("studyAddedDateTime", DEMO);
        columnData.put("containerContentCaptureFlag", DEMO);
        columnData.put("containerContentCaptureIndex", DEMO);
        columnData.put("JiveContainerContentData.JiveSavedViewID", DEMO);
        columnData.put("JiveContainerContentData.studyInstanceUID", DEMO);
        columnData.put("jiveServer", OTHER);
        columnData.put("_EMPTY_COLUMN_", OTHER);
        columnData.put("valueSetID", SVS);
        columnData.put("valueSetVersion", SVS);
        columnData.put("vslResourceID", SVS);
        columnData.put("vslDefaultLanguage", SVS);
        columnData.put("valueSetSource", SVS);
        columnData.put("valueSetSourceURI", SVS);
        columnData.put("valueSetPurpose", SVS);
        columnData.put("valueSetDefinition", SVS);
        columnData.put("valueSetType", SVS);
        columnData.put("valueSetBinding", SVS);
        columnData.put("valueSetStatus", SVS);
        columnData.put("valueSetEffectiveDate", SVS);
        columnData.put("valueSetExpirationDate", SVS);
        columnData.put("valueSetCreationDate", SVS);
        columnData.put("valueSetRevisionDate", SVS);
        columnData.put("dynamicColumnName", SVS);
        columnData.put("valueSetConceptCode", SVS);
        columnData.put("valueSetConceptCodeSystem", SVS);
        columnData.put("valueSetConceptCodeSystemVersion", SVS);
        columnData.put("valueSetConceptCodeSystemName", SVS);
        columnData.put("vslResourceID", SVS);
        columnData.put("valueSetConceptExpirationDate", SVS);
        columnData.put("jiveValueSetConceptMappingID", SVS);
        columnData.put("valueSetID", SVS);
        columnData.put("valueSetVersion", SVS);
        columnData.put("valueSetConceptCode", SVS);
        columnData.put("valueSetConceptCodeSystem", SVS);
        columnData.put("valueSetConceptCodeSystemVersion", SVS);
        columnData.put("valueSetConceptExpirationDate", SVS);
        columnData.put("vscmPriority", SVS);
        columnData.put("vscmLastModified", SVS);
        columnData.put("vscmCriteria", SVS);
        columnData.put("vscmGroupResourceID", SVS);
        columnData.put("JiveStudyTag.valueset1", OTHER);
        columnData.put("JiveStudyTag.valueset2", OTHER);
        columnData.put("JiveStudyTag.valueset3", OTHER);
        columnData.put("JiveStudyTag.valueset4", OTHER);
        worklistData.put("jiveWorklistEntryID", WORKLIST_ORDER);
        worklistData.put("assignedFlag", WORKLIST_ORDER);
        worklistData.put("patientsName", WORKLIST_PATIENT);
        worklistData.put("patientsId", WORKLIST_PATIENT);
        worklistData.put("issuerOfPatientsId", WORKLIST_PATIENT);
        worklistData.put("patientsBirthDate", WORKLIST_PATIENT);
        worklistData.put("patientsSex", WORKLIST_PATIENT);
        worklistData.put("otherPatientIds", WORKLIST_PATIENT);
        worklistData.put("otherPatientNames", WORKLIST_PATIENT);
        worklistData.put("patientBirthName", WORKLIST_PATIENT);
        worklistData.put("patientsWeight", WORKLIST_PATIENT);
        worklistData.put("admissionID", WORKLIST_VISIT);
        worklistData.put("confidentialConstraintOnPatientData", WORKLIST_VISIT);
        worklistData.put("currentPatientLocation", WORKLIST_VISIT);
        worklistData.put("accessionNumber", WORKLIST_ORDER);
        worklistData.put("placerOrderNumber", WORKLIST_ORDER);
        worklistData.put("fillerOrderNumber", WORKLIST_ORDER);
        worklistData.put("requestedPhysician", WORKLIST_ORDER);
        worklistData.put("referringPhysiciansName", WORKLIST_ORDER);
        worklistData.put("studyDescription", WORKLIST_ORDER);
        worklistData.put("studyInstanceUID", WORKLIST_PROCEDURE);
        worklistData.put("requestedProcedureId", WORKLIST_PROCEDURE);
        worklistData.put("requestedProcedureDescription", WORKLIST_PROCEDURE);
        worklistData.put("requestedProcedurePriority", WORKLIST_PROCEDURE);
        worklistData.put("requestedProcedureComments", WORKLIST_PROCEDURE);
        worklistData.put("reasonForRequestedProcedure", WORKLIST_PROCEDURE);
        worklistData.put("scheduledProcedureStepID", WORKLIST_PROC_STEP);
        worklistData.put("modality", WORKLIST_PROC_STEP);
        worklistData.put("scheduledProcedureStepStationName", WORKLIST_PROC_STEP);
        worklistData.put("scheduledProcedureStepLocation", WORKLIST_PROC_STEP);
        worklistData.put("scheduledStationAETitle", WORKLIST_PROC_STEP);
        worklistData.put("scheduledProcedureStepStartDate", WORKLIST_PROC_STEP);
        worklistData.put("scheduledProcedureStepStartTime", WORKLIST_PROC_STEP);
        worklistData.put("scheduledPerformingPhysiciansName", WORKLIST_PROC_STEP);
        worklistData.put("scheduledProcedureStepDescription", WORKLIST_PROC_STEP);
        worklistData.put("scheduledProcedureStepStatus", WORKLIST_PROC_STEP);
        worklistData.put("requestedContrastAgent", WORKLIST_PROC_STEP);
        worklistData.put("patientState", WORKLIST_PROC_STEP);
        worklistData.put("patientTransportArrangements", WORKLIST_PROC_STEP);
        worklistData.put("preMedication", WORKLIST_PROC_STEP);
        worklistData.put("pregnancyStats", WORKLIST_PROC_STEP);
        worklistData.put("medicalAlerts", WORKLIST_PROC_STEP);
        worklistData.put("contrastAllergies", WORKLIST_PROC_STEP);
        worklistData.put("specialNeeds", WORKLIST_PROC_STEP);
        worklistData.put("requestingService", WORKLIST_PROC_STEP);
        worklistData.put("visusMessageOrginator", WORKLIST_PROC_STEP);
        worklistData.put("visusCreationDate", WORKLIST_PROC_STEP);
        worklistData.put("visusCreationTime", WORKLIST_PROC_STEP);
        worklistData.put("visusUpdateDate", WORKLIST_PROC_STEP);
        worklistData.put("visusUpdateTime", WORKLIST_PROC_STEP);
    }
}

