/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.dbms.derby;

import com.visustt.jiveX.tools.database.dbms.DbAccessor;
import com.visustt.jiveX.tools.database.dbms.FailedInitializationException;
import com.visustt.jiveX.tools.database.dbms.InvalidPropertyValueException;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.Vector;

public class DbAccessorImpl
extends DbAccessor {
    private static final String DRIVER_CLASS_NAME = "org.apache.derby.jdbc.EmbeddedDriver";

    @Override
    public final void initialize(String string, Properties properties) throws FailedInitializationException, InvalidPropertyValueException {
        this.jdbcUrl = string;
        try {
            Class.forName(DRIVER_CLASS_NAME);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FailedInitializationException("required driver class org.apache.derby.jdbc.EmbeddedDriver missing: " + classNotFoundException.getMessage());
        }
    }

    @Override
    public final void connect(Properties properties) throws SQLException {
        try {
            this.jdbcConnection = DriverManager.getConnection(this.jdbcUrl, properties);
        }
        catch (SQLException sQLException) {
            String string = this.jdbcUrl.substring(0, this.jdbcUrl.lastIndexOf(47) + 1);
            this.jdbcConnection = DriverManager.getConnection(string, properties);
        }
        super.initAutoCommit();
    }

    @Override
    public final void createDatabase(String string, Properties properties) throws SQLException {
        String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
        int n = string2.indexOf(63);
        String string3 = "";
        if (n > -1) {
            string3 = string2.substring(n);
            string2 = string2.substring(0, n);
        }
        String string4 = this.jdbcUrl;
        this.jdbcUrl = this.jdbcUrl.substring(0, string.lastIndexOf(47) + 1) + string3;
        this.logger.warn("\nCreating new database '" + string2 + "' on host: " + this.jdbcUrl);
        this.connect(properties);
        Statement statement = this.getJdbcConnection().createStatement();
        statement.execute("CREATE DATABASE IF NOT EXISTS " + string2);
        this.endOfTransaction(true);
        statement.close();
        this.disconnect();
        this.jdbcUrl = string4;
    }

    @Override
    public Vector<String> searchMissingTables(String[] stringArray, Properties properties) throws SQLException {
        Vector<String> vector = new Vector<String>(stringArray.length);
        this.connect(properties);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            try {
                if (this.existsTable(string.toUpperCase())) continue;
                vector.add(string);
                continue;
            }
            catch (SQLException sQLException) {
                throw DbAccessorImpl.a(sQLException);
            }
        }
        this.disconnect();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean existsTable(String string) throws SQLException {
        ResultSet resultSet;
        block22: {
            boolean bl;
            resultSet = null;
            try {
                block23: {
                    DatabaseMetaData databaseMetaData = this.jdbcConnection.getMetaData();
                    try {
                        if (this.logger.debugIsEnabled()) {
                            this.logger.info("Check for table: " + string);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw DbAccessorImpl.a(sQLException);
                    }
                    resultSet = databaseMetaData.getTables(null, null, string, new String[]{"TABLE"});
                    if (resultSet.next()) break block22;
                    try {
                        block24: {
                            if (!this.logger.debugIsEnabled()) break block23;
                            break block24;
                            catch (SQLException sQLException) {
                                throw DbAccessorImpl.a(sQLException);
                            }
                        }
                        this.logger.info("table: " + string + " NOT exists");
                    }
                    catch (SQLException sQLException) {
                        throw DbAccessorImpl.a(sQLException);
                    }
                }
                bl = false;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException sQLException) {
                    throw DbAccessorImpl.a(sQLException);
                }
                throw throwable;
            }
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException sQLException) {
                throw DbAccessorImpl.a(sQLException);
            }
            return bl;
        }
        try {
            if (this.logger.debugIsEnabled()) {
                this.logger.info("table: " + string + " exists");
            }
        }
        catch (SQLException sQLException) {
            throw DbAccessorImpl.a(sQLException);
        }
        boolean bl = true;
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            throw DbAccessorImpl.a(sQLException);
        }
        return bl;
    }

    @Override
    public final boolean supportsForeignKeys(String string) {
        return false;
    }

    @Override
    public String getCreateTableSuffix() {
        return "\n)\n";
    }

    @Override
    public String createAfter(String string) throws SQLException {
        return " AFTER " + this.getIdentifierQuoteCharacter() + string + this.getIdentifierQuoteCharacter();
    }

    @Override
    public String getIdentifierQuoteCharacter() {
        return "";
    }

    @Override
    public String getDbmsTypeName(int n, int n2, boolean bl) throws IllegalArgumentException, SQLException {
        try {
            if (n == -4) {
                return "BLOB";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DbAccessorImpl.a(illegalArgumentException);
        }
        try {
            if (n == 2004) {
                return "BLOB";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DbAccessorImpl.a(illegalArgumentException);
        }
        if (n == -1) {
            n = 12;
        }
        return super.getDbmsTypeName(n, n2, bl);
    }

    @Override
    public String createShowColumnsStatement(String string) {
        return "DESCRIBE " + string;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

