/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.dbms;

import com.visustt.jiveX.tools.database.dbms.DbAccessorInterface;
import com.visustt.jiveX.tools.database.dbms.FailedInitializationException;
import com.visustt.jiveX.tools.database.dbms.InvalidPropertyValueException;
import com.visustt.jiveX.tools.database.structure.ColumnMetaData;
import com.visustt.jiveX.tools.database.utils.ab;
import com.visustt.tools.aj.aa;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.net.ae;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Properties;
import java.util.Vector;

public abstract class DbAccessor
implements DbAccessorInterface {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getInstance("com.visustt.database.dbms");
    public static final String SILENCE_OLD_DB_ACCESSOR = "jx.junit.test.silence.old.dbaccessor";
    private static Boolean isSilenced = null;
    protected String jdbcUrl;
    protected Connection jdbcConnection;
    protected Logger logger = DEFAULT_LOGGER;
    protected String stacktrace;
    protected long callTimestamp;
    protected String poolName;

    public boolean isCaseInsensitive() {
        return true;
    }

    @Override
    public void setPoolName(String string) {
        this.poolName = string;
    }

    @Override
    public String getPoolName() {
        return this.poolName;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public static DbAccessor getAccessor(String string) throws FailedInitializationException {
        return DbAccessor.getAccessor(string, null);
    }

    public static DbAccessor getAccessor(String string, Properties properties) throws FailedInitializationException, InvalidPropertyValueException {
        DbAccessor dbAccessor;
        String string2;
        try {
            string2 = ae.ah(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new FailedInitializationException(illegalArgumentException.getMessage());
        }
        try {
            String string3 = "com.visustt.jiveX.tools.database.dbms." + string2 + ".DbAccessorImpl";
            Class<?> clazz = Class.forName(string3);
            dbAccessor = (DbAccessor)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new FailedInitializationException("unknown JDBC driver -- class does not exist or cannot be instantiated: " + exception.getMessage());
        }
        dbAccessor.initialize(string, properties);
        return dbAccessor;
    }

    public void displayDBInformations() throws SQLException {
        com.visustt.jiveX.tools.database.utils.aa.aa(this.logger, this.jdbcUrl, this.jdbcConnection);
    }

    private void openConnection(Properties properties) throws SQLException {
        try {
            if (!this.isConnected()) {
                this.connect(properties);
            }
        }
        catch (SQLException sQLException) {
            throw DbAccessor.a(sQLException);
        }
    }

    @Override
    public void disconnect() throws SQLException {
        try {
            if (this.jdbcConnection != null) {
                this.jdbcConnection.close();
                this.jdbcConnection = null;
            }
        }
        catch (SQLException sQLException) {
            throw DbAccessor.a(sQLException);
        }
    }

    @Override
    public boolean isConnected() throws SQLException {
        boolean bl;
        try {
            if (this.jdbcConnection == null) {
                return false;
            }
        }
        catch (SQLException sQLException) {
            throw DbAccessor.a(sQLException);
        }
        try {
            bl = !this.jdbcConnection.isClosed();
        }
        catch (SQLException sQLException) {
            throw DbAccessor.a(sQLException);
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getDbmsTypeName(int var1_1, int var2_2, boolean var3_3) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [26[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getDbmsColumnFlag(int n, int n2, String string) {
        return string;
    }

    @Override
    public String getDbmsColumnName(ColumnMetaData columnMetaData) {
        return columnMetaData.getColumnName();
    }

    public abstract void initialize(String var1, Properties var2) throws FailedInitializationException, InvalidPropertyValueException;

    @Override
    public Connection getJdbcConnection() {
        return this.jdbcConnection;
    }

    public void endOfTransaction(boolean bl) throws SQLException {
        block4: {
            block5: {
                try {
                    try {
                        if (this.getJdbcConnection().getAutoCommit()) break block4;
                        if (!bl) break block5;
                    }
                    catch (SQLException sQLException) {
                        throw DbAccessor.a(sQLException);
                    }
                    this.getJdbcConnection().commit();
                    break block4;
                }
                catch (SQLException sQLException) {
                    throw DbAccessor.a(sQLException);
                }
            }
            this.getJdbcConnection().rollback();
        }
    }

    public abstract void createDatabase(String var1, Properties var2) throws SQLException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean tableExists(Properties properties, String string) throws SQLException {
        this.openConnection(properties);
        boolean bl = false;
        DatabaseMetaData databaseMetaData = this.jdbcConnection.getMetaData();
        String string2 = this.jdbcConnection.getCatalog();
        ResultSet resultSet = databaseMetaData.getTables(string2, null, string, new String[]{"TABLE"});
        try {
            bl = resultSet.next();
        }
        catch (Throwable throwable) {
            if (resultSet == null) throw throwable;
            try {
                resultSet.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (Throwable throwable) {
            throw DbAccessor.a(throwable);
        }
        this.disconnect();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forcedLogInfo(String string) {
        block10: {
            try {
                if (string == null || string.length() == 0) break block10;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DbAccessor.a(illegalArgumentException);
            }
            DbAccessor dbAccessor = this;
            synchronized (dbAccessor) {
                if (isSilenced == null) {
                    isSilenced = Boolean.getBoolean(SILENCE_OLD_DB_ACCESSOR);
                }
                if (!isSilenced.booleanValue()) {
                    int n = this.logger.getLevel();
                    this.logger.setLevel(2);
                    try {
                        this.logger.info(string);
                    }
                    finally {
                        this.logger.setLevel(n);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void clearTable(String string, Properties properties) throws SQLException {
        block17: {
            this.openConnection(properties);
            Statement statement = null;
            boolean bl = false;
            statement = this.getJdbcConnection().createStatement();
            String string2 = "TRUNCATE TABLE " + string;
            statement.executeUpdate(string2);
            bl = true;
            try {
                try {
                    if (statement != null) {
                        this.endOfTransaction(bl);
                        statement.close();
                    }
                    break block17;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DbAccessor.a(illegalArgumentException);
                }
            }
            catch (SQLException sQLException) {
                this.logger.error((Object)("Error sending endOfTransaction(" + bl + "):" + sQLException), sQLException);
            }
            break block17;
            catch (SQLException sQLException) {
                try {
                    this.logger.error((Object)("Error while truncating Table:" + sQLException), sQLException);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (statement != null) {
                                this.endOfTransaction(bl);
                                statement.close();
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DbAccessor.a(illegalArgumentException);
                        }
                    }
                    catch (SQLException sQLException2) {
                        this.logger.error((Object)("Error sending endOfTransaction(" + bl + "):" + sQLException2), sQLException2);
                    }
                    throw throwable;
                }
                try {
                    if (statement != null) {
                        this.endOfTransaction(bl);
                        statement.close();
                    }
                }
                catch (SQLException sQLException3) {
                    this.logger.error((Object)("Error sending endOfTransaction(" + bl + "):" + sQLException3), sQLException3);
                }
            }
        }
        this.disconnect();
    }

    public void clearTables(Collection<String> collection, Properties properties) throws SQLException {
        this.openConnection(properties);
        String string = properties.getProperty("TruncateTableSQL", "TRUNCATE TABLE ${tablename}");
        Statement statement = null;
        try {
            statement = this.getJdbcConnection().createStatement();
            this.setForeignKeyChecksEnabled(false);
            for (String string2 : collection) {
                String string3 = StringTool.replaceAllString(string, "${tablename}", string2);
                try {
                    if (this.logger.debugIsEnabled()) {
                        this.logger.debug("clearing table...: " + string2 + " using SQL: " + string3);
                    }
                }
                catch (SQLException sQLException) {
                    throw DbAccessor.a(sQLException);
                }
                statement.executeUpdate(string3);
            }
            this.setForeignKeyChecksEnabled(true);
        }
        catch (SQLException sQLException) {
            this.logger.error((Object)"Error while truncating Tables", sQLException);
            throw sQLException;
        }
        finally {
            aa.aa(statement);
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Vector<String> searchMissingTables(String[] var1_1, Properties var2_2) throws SQLException {
        this.openConnection(var2_2);
        var3_3 = null;
        var3_3 = var2_2.containsKey("database") == false ? com.visustt.jiveX.tools.database.utils.aa.ae(this.jdbcUrl) : var2_2.getProperty("database");
        var4_4 = new Vector<String>();
        for (var5_5 = 0; var5_5 < var1_1.length; ++var5_5) {
            var6_6 = null;
            try {
                block25: {
                    block22: {
                        block23: {
                            block21: {
                                var7_7 = this.jdbcConnection.getMetaData();
                                var8_8 = this.jdbcConnection.getCatalog();
                                try {
                                    if (this.logger.debugIsEnabled()) {
                                        this.logger.info("Check for table: " + var1_1[var5_5]);
                                    }
                                }
                                catch (SQLException v0) {
                                    throw DbAccessor.a(v0);
                                }
                                var6_6 = var7_7.getTables(var8_8, null, var1_1[var5_5], new String[]{"TABLE"});
                                var9_9 = false;
                                try {
                                    if (!var6_6.next()) break block21;
                                    while (true) {
                                        if (!var3_3.equalsIgnoreCase(var6_6.getString(1))) continue;
                                        break;
                                    }
                                }
                                catch (SQLException v1) {
                                    throw DbAccessor.a(v1);
                                }
                                if (var1_1[var5_5].equalsIgnoreCase(var6_6.getString(3))) {
                                    var9_9 = true;
                                } else if (var6_6.next()) ** continue;
                            }
                            if (var9_9) break block22;
                            try {
                                block24: {
                                    if (!this.logger.debugIsEnabled()) break block23;
                                    break block24;
                                    catch (SQLException v2) {
                                        throw DbAccessor.a(v2);
                                    }
                                }
                                this.logger.info("table: " + var1_1[var5_5] + " does NOT exist");
                            }
                            catch (SQLException v3) {
                                throw DbAccessor.a(v3);
                            }
                        }
                        var4_4.add(var1_1[var5_5]);
                        break block25;
                    }
                    try {
                        if (this.logger.debugIsEnabled()) {
                            this.logger.info("table: " + var1_1[var5_5] + " exists");
                        }
                    }
                    catch (SQLException v4) {
                        throw DbAccessor.a(v4);
                    }
                }
                var6_6.close();
                if (var6_6 == null) continue;
            }
            catch (Throwable var10_10) {
                try {
                    if (var6_6 != null) {
                        var6_6.close();
                    }
                }
                catch (SQLException v5) {
                    throw DbAccessor.a(v5);
                }
                throw var10_10;
            }
            var6_6.close();
        }
        this.disconnect();
        return var4_4;
    }

    public abstract boolean supportsForeignKeys(String var1);

    public abstract String createAfter(String var1) throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void createField(com.visustt.jiveX.tools.database.structure.ae ae2, String string, Properties properties, boolean bl) throws SQLException {
        block24: {
            this.openConnection(properties);
            Statement statement = null;
            boolean bl2 = false;
            statement = this.getJdbcConnection().createStatement();
            ColumnMetaData columnMetaData = ae2.ac(string);
            try {
                if (columnMetaData == null) {
                    throw new SQLException("Column: " + string + " does not exist in Table: " + ae2.aa());
                }
            }
            catch (SQLException sQLException) {
                throw DbAccessor.a(sQLException);
            }
            ColumnMetaData columnMetaData2 = ae2.ad(string);
            String string2 = "ALTER TABLE " + ae2.aa() + " ADD " + com.visustt.jiveX.tools.database.utils.aa.aa((DbAccessorInterface)this, columnMetaData);
            if (columnMetaData2 != null) {
                string2 = string2 + this.createAfter(columnMetaData2.getColumnName());
            }
            try {
                if (bl) {
                    this.forcedLogInfo(string2);
                }
            }
            catch (SQLException sQLException) {
                throw DbAccessor.a(sQLException);
            }
            statement.executeUpdate(string2);
            bl2 = true;
            try {
                try {
                    if (statement != null) {
                        this.endOfTransaction(bl2);
                        statement.close();
                    }
                    break block24;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DbAccessor.a(illegalArgumentException);
                }
            }
            catch (SQLException sQLException) {
                this.logger.error((Object)("endOfTransaction(" + bl2 + ") failed: " + sQLException), sQLException);
            }
            break block24;
            catch (SQLException sQLException) {
                try {
                    this.logger.error((Object)("createField failed: " + sQLException), sQLException);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (statement != null) {
                                this.endOfTransaction(bl2);
                                statement.close();
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DbAccessor.a(illegalArgumentException);
                        }
                    }
                    catch (SQLException sQLException2) {
                        this.logger.error((Object)("endOfTransaction(" + bl2 + ") failed: " + sQLException2), sQLException2);
                    }
                    throw throwable;
                }
                try {
                    if (statement != null) {
                        this.endOfTransaction(bl2);
                        statement.close();
                    }
                }
                catch (SQLException sQLException3) {
                    this.logger.error((Object)("endOfTransaction(" + bl2 + ") failed: " + sQLException3), sQLException3);
                }
            }
        }
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dropField(com.visustt.jiveX.tools.database.structure.ae ae2, String string, Properties properties, boolean bl) throws SQLException {
        block20: {
            this.openConnection(properties);
            Statement statement = null;
            boolean bl2 = false;
            statement = this.getJdbcConnection().createStatement();
            String string2 = "ALTER " + ae2.aa() + " DROP " + string;
            try {
                if (bl) {
                    this.forcedLogInfo(string2);
                }
            }
            catch (SQLException sQLException) {
                throw DbAccessor.a(sQLException);
            }
            statement.executeUpdate(string2);
            bl2 = true;
            try {
                try {
                    if (statement != null) {
                        this.endOfTransaction(bl2);
                        statement.close();
                    }
                    break block20;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DbAccessor.a(illegalArgumentException);
                }
            }
            catch (SQLException sQLException) {
                this.logger.error((Object)("endOfTransaction(" + bl2 + ") failed: " + sQLException), sQLException);
            }
            break block20;
            catch (SQLException sQLException) {
                try {
                    this.logger.error((Object)("dropField failed: " + sQLException), sQLException);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            if (statement != null) {
                                this.endOfTransaction(bl2);
                                statement.close();
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DbAccessor.a(illegalArgumentException);
                        }
                    }
                    catch (SQLException sQLException2) {
                        this.logger.error((Object)("endOfTransaction(" + bl2 + ") failed: " + sQLException2), sQLException2);
                    }
                    throw throwable;
                }
                try {
                    if (statement != null) {
                        this.endOfTransaction(bl2);
                        statement.close();
                    }
                }
                catch (SQLException sQLException3) {
                    this.logger.error((Object)("endOfTransaction(" + bl2 + ") failed: " + sQLException3), sQLException3);
                }
            }
        }
        this.disconnect();
    }

    public void dropTable(String string, Properties properties) throws SQLException {
        String string2 = "DROP TABLE " + string;
        this.openConnection(properties);
        Statement statement = null;
        try {
            statement = this.getJdbcConnection().createStatement();
            statement.executeUpdate(string2);
            this.forcedLogInfo(string2 + " ok.");
        }
        catch (SQLException sQLException) {
            block7: {
                try {
                    if (!this.logger.debugIsEnabled()) break block7;
                    this.logger.error((Object)(string2 + " failed: " + sQLException), sQLException);
                }
                catch (SQLException sQLException2) {
                    throw DbAccessor.a(sQLException2);
                }
            }
            this.logger.error(string2 + " failed:");
        }
        try {
            if (statement != null) {
                this.endOfTransaction(true);
                statement.close();
                this.disconnect();
            }
        }
        catch (SQLException sQLException) {
            throw DbAccessor.a(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDatabase(String string, Properties properties) throws SQLException {
        String string2 = string.substring(string.lastIndexOf(47) + 1, string.length());
        int n = string2.indexOf(63);
        if (n > -1) {
            string2 = string2.substring(0, n);
        }
        this.openConnection(properties);
        try {
            Statement statement = this.getJdbcConnection().createStatement();
            statement.execute("DROP DATABASE " + string2);
            this.endOfTransaction(true);
            statement.close();
        }
        finally {
            this.disconnect();
        }
    }

    @Override
    public abstract String getCreateTableSuffix();

    @Override
    public abstract String getIdentifierQuoteCharacter();

    public void initAutoCommit() throws SQLException {
        this.jdbcConnection.setAutoCommit(true);
    }

    @Override
    public void setCallStack(String string) {
        this.stacktrace = string;
        this.callTimestamp = System.currentTimeMillis();
    }

    @Override
    public String getCallStack() {
        return this.stacktrace;
    }

    @Override
    public long getCallTimestamp() {
        return this.callTimestamp;
    }

    @Override
    public void cleanup() {
        this.callTimestamp = 0L;
        this.stacktrace = null;
    }

    @Override
    public void initLogger(Logger logger) {
        try {
            this.logger = logger == null ? DEFAULT_LOGGER : LoggerFactory.getInstance(logger.getName() + ".db");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DbAccessor.a(illegalArgumentException);
        }
    }

    @Override
    public void resetLogger() {
        this.logger = DEFAULT_LOGGER;
    }

    @Override
    public String createShowColumnsStatement(String string) {
        return "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='" + string + "'";
    }

    @Override
    public String createShowTablesStatement(String string) {
        return "SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = SCHEMA()";
    }

    @Override
    public void setForeignKeyChecksEnabled(boolean bl) throws SQLException {
        int n;
        Connection connection = this.getJdbcConnection();
        try {
            n = bl ? 1 : 0;
        }
        catch (Throwable throwable) {
            throw DbAccessor.a(throwable);
        }
        String string = "SET FOREIGN_KEY_CHECKS = " + n;
        try (Statement statement = connection.createStatement();){
            statement.executeUpdate(string);
        }
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }

    private class DataTypeInfo {
        final String literalSuffix;
        final boolean caseSensitive;
        final String createParams;
        final long nullable;
        final boolean unsignedAttribute;
        final long minimumScale;
        final int precision;
        final long sqlDatetimeSub;
        final long numPrecRadix;
        final boolean autoIncrement;
        final String localTypeName;
        final long maximumScale;
        final long searchable;
        final long sqlDataType;
        final String literalPrefix;
        final boolean fixedPrecScale;
        final String typeName;
        final long dataType;

        private DataTypeInfo(ResultSet resultSet) throws SQLException {
            this.literalSuffix = resultSet.getString("LITERAL_SUFFIX");
            this.caseSensitive = resultSet.getBoolean("CASE_SENSITIVE");
            this.createParams = resultSet.getString("CREATE_PARAMS");
            this.nullable = ab.aa("NULLABLE", resultSet);
            this.unsignedAttribute = resultSet.getBoolean("UNSIGNED_ATTRIBUTE");
            this.minimumScale = ab.aa("MINIMUM_SCALE", resultSet);
            this.precision = resultSet.getInt("PRECISION");
            this.sqlDatetimeSub = ab.aa("SQL_DATETIME_SUB", resultSet);
            this.numPrecRadix = ab.aa("NUM_PREC_RADIX", resultSet);
            this.autoIncrement = resultSet.getBoolean("AUTO_INCREMENT");
            this.localTypeName = resultSet.getString("LOCAL_TYPE_NAME");
            this.maximumScale = ab.aa("MAXIMUM_SCALE", resultSet);
            this.searchable = ab.aa("SEARCHABLE", resultSet);
            this.sqlDataType = ab.aa("SQL_DATA_TYPE", resultSet);
            this.literalPrefix = resultSet.getString("LITERAL_PREFIX");
            this.fixedPrecScale = resultSet.getBoolean("FIXED_PREC_SCALE");
            this.typeName = resultSet.getString("TYPE_NAME");
            this.dataType = ab.aa("DATA_TYPE", resultSet);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("DataTypeInfo [");
            stringBuilder.append("typeName=");
            stringBuilder.append(this.typeName);
            stringBuilder.append(", dataType=");
            stringBuilder.append(this.dataType);
            stringBuilder.append(", sqlDataType=");
            stringBuilder.append(this.sqlDataType);
            stringBuilder.append(", literalPrefix=");
            stringBuilder.append(this.literalPrefix);
            stringBuilder.append(", literalSuffix=");
            stringBuilder.append(this.literalSuffix);
            stringBuilder.append(", autoIncrement=");
            stringBuilder.append(this.autoIncrement);
            stringBuilder.append(", caseSensitive=");
            stringBuilder.append(this.caseSensitive);
            stringBuilder.append(", createParams=");
            stringBuilder.append(this.createParams);
            stringBuilder.append(", fixedPrecScale=");
            stringBuilder.append(this.fixedPrecScale);
            stringBuilder.append(", localTypeName=");
            stringBuilder.append(this.localTypeName);
            stringBuilder.append(", maximumScale=");
            stringBuilder.append(this.maximumScale);
            stringBuilder.append(", minimumScale=");
            stringBuilder.append(this.minimumScale);
            stringBuilder.append(", nullable=");
            stringBuilder.append(this.nullable);
            stringBuilder.append(", numPrecRadix=");
            stringBuilder.append(this.numPrecRadix);
            stringBuilder.append(", precision=");
            stringBuilder.append(this.precision);
            stringBuilder.append(", searchable=");
            stringBuilder.append(this.searchable);
            stringBuilder.append(", sqlDatetimeSub=");
            stringBuilder.append(this.sqlDatetimeSub);
            stringBuilder.append(", unsignedAttribute=");
            stringBuilder.append(this.unsignedAttribute);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }
}

