/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.converter.dicom;

import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.ax;
import com.visustt.jiveX.tools.database.converter.dicom.DicomDbTypeConverter;
import com.visustt.tools.lang.StringTool;

public abstract class DefaultDicomDbTypeConverter
implements DicomDbTypeConverter {
    private DicomTag dicomTag;
    protected boolean checkDicomTag;

    @Override
    public DicomTag getDicomTag() {
        return this.dicomTag;
    }

    @Override
    public void setDicomTag(DicomTag dicomTag) {
        this.dicomTag = dicomTag;
    }

    @Override
    public abstract int getDicomColumnMetaDataType();

    @Override
    public abstract int getDicomColumnMetaDataSize();

    @Override
    public Object getDbValue(DicomElement dicomElement) throws InvalidDataException {
        return this.getDbValue(dicomElement, 0);
    }

    @Override
    public Object getDbValue(DicomElement dicomElement, int n) throws InvalidDataException {
        block17: {
            try {
                if (dicomElement == null) {
                    return null;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw DefaultDicomDbTypeConverter.a(invalidDataException);
            }
            try {
                if (this.checkDicomTag || !(dicomElement instanceof ax)) break block17;
            }
            catch (InvalidDataException invalidDataException) {
                throw DefaultDicomDbTypeConverter.a(invalidDataException);
            }
            String[] stringArray = dicomElement.getValues();
            try {
                if (stringArray == null) {
                    return null;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw DefaultDicomDbTypeConverter.a(invalidDataException);
            }
            try {
                if (stringArray.length > n) {
                    return StringTool.deleteLastChars(stringArray[n], ' ');
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw DefaultDicomDbTypeConverter.a(invalidDataException);
            }
            return null;
        }
        Object[] objectArray = dicomElement.getElementObjects();
        try {
            if (objectArray == null) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DefaultDicomDbTypeConverter.a(invalidDataException);
        }
        try {
            if (objectArray.length > n) {
                return objectArray[n];
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DefaultDicomDbTypeConverter.a(invalidDataException);
        }
        return null;
    }

    @Override
    public boolean isCheckDicomTag() {
        return this.checkDicomTag;
    }

    public void setCheckDicomTag(boolean bl) {
        this.checkDicomTag = bl;
    }

    public String toString() {
        return this.getClass().getName() + ", DicomTag: " + this.dicomTag + ", check Dicom Tag: " + this.checkDicomTag;
    }

    private static InvalidDataException a(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

