/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.conditions;

import com.visustt.jiveX.tools.conditions.AttributeCondition;
import com.visustt.jiveX.tools.conditions.VisusCondition;
import com.visustt.tools.control.log.Logger;
import java.util.ArrayList;
import java.util.List;

public class VisusConditionsEvaluator {
    private final List<VisusCondition> conditionList;
    private final Logger logger;

    public VisusConditionsEvaluator(Logger logger, List<VisusCondition> list) {
        this.logger = logger;
        this.conditionList = new ArrayList<VisusCondition>();
        if (list != null) {
            this.conditionList.addAll(list);
        }
    }

    public boolean validateConditions(List<Object> list) {
        boolean bl = true;
        boolean bl2 = true;
        if (this.conditionList.isEmpty() || list.isEmpty()) {
            return true;
        }
        for (VisusCondition visusCondition : this.conditionList) {
            if (bl) {
                bl = false;
                bl2 = this.validateSingleConditon(visusCondition, list);
                continue;
            }
            String string = visusCondition.getConditionsOperator();
            if (string.equalsIgnoreCase("AND")) {
                bl2 = bl2 && this.validateSingleConditon(visusCondition, list);
                continue;
            }
            bl2 = bl2 || this.validateSingleConditon(visusCondition, list);
        }
        this.logValidationResult(list, bl2);
        return bl2;
    }

    private void logValidationResult(List<Object> list, boolean bl) {
        if (this.logger.debugIsEnabled()) {
            this.logger.debug("Result of Condition Evaluation: " + bl);
            this.logger.debug("--------------------------------------------");
            for (Object object : list) {
                this.logger.debug(object.toString());
            }
            for (VisusCondition visusCondition : this.conditionList) {
                this.logger.debug(visusCondition.toString());
            }
            this.logger.debug("-------------------------------------------");
        }
    }

    public String getConditionLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (VisusCondition visusCondition : this.conditionList) {
            stringBuilder.append(visusCondition.toString());
        }
        return stringBuilder.toString();
    }

    private boolean validateSingleConditon(VisusCondition visusCondition, List<Object> list) {
        String string = visusCondition.getRuleOperator();
        List<AttributeCondition> list2 = visusCondition.getAttributeConditions();
        for (AttributeCondition attributeCondition : list2) {
            if (string.equalsIgnoreCase("AND")) {
                if (this.checkAttributeCondition(list, attributeCondition)) continue;
                return false;
            }
            if (!this.checkAttributeCondition(list, attributeCondition)) continue;
            return true;
        }
        return string.equalsIgnoreCase("AND");
    }

    private boolean checkAttributeCondition(List<Object> list, AttributeCondition attributeCondition) {
        for (Object object : list) {
            if (!attributeCondition.checkCondition(object)) continue;
            return true;
        }
        return false;
    }

    public List<VisusCondition> getConditionList() {
        return this.conditionList;
    }
}

