/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.message;

import com.visustt.jiveX.general.message.JiveMessage;
import com.visustt.tools.control.license.util.VisusVersionString;
import com.visustt.tools.net.Localhost;
import java.util.UUID;

public class LoginMessage
implements JiveMessage {
    private static final long serialVersionUID = -4440867050063472344L;
    private String name;
    private String systemLoginName;
    private String password;
    private boolean forceUserCheck = true;
    private boolean requestProfile = false;
    private boolean sentThroughLoginConnection = false;
    private final String clientHostName;
    private String clientHostAddress;
    private final String clientVersion;
    private boolean impersonateUser;
    private boolean assertUserExists;
    private UUID sessionID;

    public LoginMessage(String string, String string2, String string3, boolean bl, VisusVersionString visusVersionString) {
        this(false, string, string2, string3, bl, visusVersionString);
    }

    public LoginMessage(boolean bl, String string, String string2, String string3, boolean bl2, VisusVersionString visusVersionString) {
        this.name = string;
        this.systemLoginName = string3;
        this.requestProfile = bl;
        this.setPassword(string2);
        this.forceUserCheck = bl2;
        this.clientHostName = Localhost.getLocalHostName();
        this.clientHostAddress = Localhost.getFirstNonLoopbackIP4();
        if (this.clientHostAddress == null) {
            this.clientHostAddress = Localhost.getLocalHostIP();
        }
        this.sentThroughLoginConnection = false;
        this.clientVersion = visusVersionString != null ? visusVersionString.toString() : null;
        this.impersonateUser = false;
        this.assertUserExists = false;
    }

    public boolean getForceUserCheck() {
        return this.forceUserCheck;
    }

    public void setForceUserCheck(boolean bl) {
        this.forceUserCheck = bl;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean getRequestProfile() {
        return this.requestProfile;
    }

    public void setRequestProfile(boolean bl) {
        this.requestProfile = bl;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("LoginMessage - Name: ").append(this.name);
        stringBuilder.append(", forceUserCheck: ").append(this.forceUserCheck);
        stringBuilder.append(", systemLoginName: ").append(this.systemLoginName);
        stringBuilder.append(", requestProfile: ").append(this.requestProfile);
        stringBuilder.append(", clientHostName: ").append(this.clientHostName);
        stringBuilder.append(", clientHostAddress: ").append(this.clientHostAddress);
        stringBuilder.append(", clientVersion: ").append(this.clientVersion);
        return stringBuilder.toString();
    }

    public boolean isSentThroughLoginConnection() {
        return this.sentThroughLoginConnection;
    }

    public void setSentThroughLoginConnection(boolean bl) {
        this.sentThroughLoginConnection = bl;
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public String getClientHostAddress() {
        return this.clientHostAddress;
    }

    public String getSystemLoginName() {
        return this.systemLoginName;
    }

    public void setAuthenticationUserName(String string) {
        this.systemLoginName = string;
    }

    public VisusVersionString getClientVersion() {
        return this.clientVersion != null ? new VisusVersionString(this.clientVersion) : null;
    }

    @Deprecated
    public void setClientHostAddress(String string) {
        this.clientHostAddress = string;
    }

    public boolean isImpersonateUser() {
        return this.impersonateUser;
    }

    public void setImpersonateUser(boolean bl) {
        this.impersonateUser = bl;
    }

    public boolean isAssertUserExists() {
        return this.assertUserExists;
    }

    public void setAssertUserExists(boolean bl) {
        this.assertUserExists = bl;
    }

    public UUID getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(UUID uUID) {
        this.sessionID = uUID;
    }
}

