/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.sql;

import com.visustt.jiveX.general.data.sql.SQLSingleValueField;
import com.visustt.tools.ab.ae;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.text.DateUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SQLTextValue
extends SQLSingleValueField {
    private static final long serialVersionUID = -7404197382171387218L;
    private String value;
    private boolean autoWildcard = true;
    private boolean addUpperCase = false;
    private boolean autoStartWildcard = false;
    private boolean suppressSpecialModalitiesInStudyHandling = false;
    protected boolean noValueQuotes;
    private boolean replaceWildcard = true;
    private boolean trimValue = true;
    private boolean binary = false;

    public SQLTextValue(String string, String string2) {
        this(string, string2, true);
    }

    public SQLTextValue(String string, String string2, boolean bl) {
        this(string, "=", string2, bl);
    }

    public SQLTextValue(String string, String string2, String string3) {
        this(string, string2, string3, true);
    }

    public SQLTextValue(String string, String string2, String string3, boolean bl) {
        this(string, string2, string3, bl, false);
    }

    public SQLTextValue(String string, String string2, String string3, boolean bl, boolean bl2) {
        super(string, string2);
        this.setValue(string3);
        this.autoWildcard = bl;
        this.noValueQuotes = bl2;
    }

    public static SQLTextValue createEqualsNoWildcard(String string, String string2) {
        SQLTextValue sQLTextValue = new SQLTextValue(string, "=", string2, false);
        sQLTextValue.setReplaceWildcard(false);
        return sQLTextValue;
    }

    public static SQLTextValue createEqualsNoWildcardNullToEmpty(String string, String string2) {
        SQLTextValue sQLTextValue = SQLTextValue.createEqualsNoWildcard(string, StringTool.getDefaultIfUndefined(string2, "<EMPTY>"));
        sQLTextValue.setReplaceWildcard(false);
        return sQLTextValue;
    }

    public boolean isAutoWildcard() {
        return this.autoWildcard;
    }

    public void setAutoWildcard(boolean bl) {
        this.autoWildcard = bl;
    }

    public void setReplaceWildcard(boolean bl) {
        this.replaceWildcard = bl;
    }

    public boolean isReplaceWildcard() {
        return this.replaceWildcard;
    }

    @Override
    public String getValue() {
        return this.getValue(null);
    }

    @Override
    public String getUnfilteredValue() {
        return this.value;
    }

    private String getValue(ae ae2) {
        String string;
        if (this.value == null || this.value.trim().equals("")) {
            return null;
        }
        String string2 = string = this.trimValue ? this.value.trim() : this.value;
        if ("NULL".equals(string)) {
            string = null;
        } else if (string.equals("<EMPTY>")) {
            string = "";
        } else if (string.startsWith("${now")) {
            string = DateUtils.replaceDate(string);
        } else if (ae2 != null && string.matches("\\(\\p{XDigit}{4},\\p{XDigit}{4}\\)") && (string = ae2.getAttributeValue(string)) == null) {
            return null;
        }
        return string;
    }

    @Override
    public String getSQLFragment() {
        return this.getFilteredSQLFragment(null);
    }

    @Override
    public String getFilteredSQLFragment(ae ae2) {
        String string = this.getValue(ae2);
        if (string != null) {
            string = this.fixWildcards(string);
        }
        String string2 = this.getOperatorWithWildcardCheck(string);
        if (!this.addUpperCase) {
            return this.getSQLFragmentString(string2, string);
        }
        return this.getUpperSQLFragmentString(string2, string);
    }

    private String fixWildcards(String object) {
        if (!this.suppressSpecialModalitiesInStudyHandling && this.isModalitiesInStudyField()) {
            this.autoWildcard = true;
            this.autoStartWildcard = true;
        }
        if (this.replaceWildcard) {
            object = ((String)object).replace('*', '%');
        }
        if (this.autoStartWildcard && ((String)object).indexOf(37) != 0) {
            object = "%" + (String)object;
        }
        if (this.autoWildcard && ((String)object).lastIndexOf(37) != ((String)object).length() - 1) {
            object = (String)object + "%";
        }
        return object;
    }

    private boolean isModalitiesInStudyField() {
        return "JiveStudyData.modalitiesInStudy".equals(this.dataFieldName) || "modalitiesInStudy".equals(this.dataFieldName);
    }

    protected String getOperatorWithWildcardCheck(String string) {
        if ("=".equals(this.operator)) {
            if (string == null) {
                return "IS NULL";
            }
            if (string.indexOf(37) != -1) {
                return "like";
            }
        }
        if ("!=".equals(this.operator)) {
            if (string == null) {
                return "IS NOT NULL";
            }
            if (string.indexOf(37) != -1) {
                return "not like";
            }
        }
        return this.operator;
    }

    private String getSQLFragmentString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.comment != null && !"".equals(this.comment)) {
            stringBuilder.append(" /* ").append(this.comment).append(" */ ");
        }
        stringBuilder.append(this.dataFieldName);
        stringBuilder.append(" ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        if (string2 != null) {
            if (this.binary) {
                stringBuilder.append("BINARY(");
            }
            stringBuilder.append((String)(this.noValueQuotes ? string2 : "'" + string2 + "'"));
            if (this.binary) {
                stringBuilder.append(")");
            }
        }
        return stringBuilder.toString().trim();
    }

    private String getUpperSQLFragmentString(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.comment != null && !"".equals(this.comment)) {
            stringBuilder.append(" /* ").append(this.comment).append(" */ ");
        }
        stringBuilder.append("upper(");
        stringBuilder.append(this.dataFieldName);
        stringBuilder.append(") ");
        stringBuilder.append(string);
        stringBuilder.append(" ");
        if (string2 != null) {
            stringBuilder.append((String)(this.noValueQuotes ? string2 : "upper('" + string2 + "')"));
        }
        return stringBuilder.toString().trim();
    }

    public String toString() {
        return "DataFieldName: " + this.dataFieldName + ", operator:  " + this.operator + ", value: " + this.value;
    }

    public boolean isAddUpperCase() {
        return this.addUpperCase;
    }

    public void setAddUpperCase(boolean bl) {
        this.addUpperCase = bl;
    }

    public boolean isAutoStartWildcard() {
        return this.autoStartWildcard;
    }

    public void setAutoStartWildcard(boolean bl) {
        this.autoStartWildcard = bl;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public boolean isSuppressSpecialModalitiesInStudyHandling() {
        return this.suppressSpecialModalitiesInStudyHandling;
    }

    public void setSuppressSpecialModalitiesInStudyHandling(boolean bl) {
        this.suppressSpecialModalitiesInStudyHandling = bl;
    }

    public void setNoValueQuotes(boolean bl) {
        this.noValueQuotes = bl;
    }

    @Override
    public List<String> getValuesAsList() {
        String string = this.getValue(null);
        if (string != null) {
            string = this.fixWildcards(string);
            return Arrays.asList(string);
        }
        return Collections.emptyList();
    }

    @Override
    public String getPreparedStatementSQLFragment() {
        String string = this.getValue(null);
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            string = this.fixWildcards(string);
        }
        if (this.comment != null && !"".equals(this.comment)) {
            stringBuilder.append(" /* ").append(this.comment).append(" */ ");
        }
        if (this.addUpperCase) {
            stringBuilder.append("upper(");
        }
        stringBuilder.append(this.dataFieldName);
        if (this.addUpperCase) {
            stringBuilder.append(")");
        }
        stringBuilder.append(" ");
        stringBuilder.append(this.getOperatorWithWildcardCheck(string));
        stringBuilder.append(" ");
        if (string != null) {
            this.appendWorkValue(stringBuilder);
        }
        return stringBuilder.toString().trim();
    }

    protected void appendWorkValue(StringBuilder stringBuilder) {
        if (this.binary) {
            stringBuilder.append("binary(");
        }
        if (this.addUpperCase && !this.noValueQuotes) {
            stringBuilder.append("upper(");
        }
        stringBuilder.append("?");
        if (this.addUpperCase && !this.noValueQuotes) {
            stringBuilder.append(")");
        }
        if (this.binary) {
            stringBuilder.append(")");
        }
    }

    public void setBinary(boolean bl) {
        this.binary = bl;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public boolean isTrimValue() {
        return this.trimValue;
    }

    public void setTrimValue(boolean bl) {
        this.trimValue = bl;
    }
}

