/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.priorstudies;

import com.visustt.jiveX.general.data.priorstudies.StudyDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class StudyDefinitionList
implements Serializable {
    private final List<StudyDefinition> allStudyDefinitions = new ArrayList<StudyDefinition>();
    private String precalculatedHashCode = null;

    public void addStudyDefinition(StudyDefinition studyDefinition) {
        this.allStudyDefinitions.add(studyDefinition);
        Collections.sort(this.allStudyDefinitions);
    }

    public void removeStudyDefinition(StudyDefinition studyDefinition) {
        this.allStudyDefinitions.remove(studyDefinition);
        Collections.sort(this.allStudyDefinitions);
    }

    public boolean hasStudyDefinitionWithAlias(String string) {
        return this.getStudyDefinitionByAlias(string) != null;
    }

    public StudyDefinition getStudyDefinitionByAlias(String string) {
        for (StudyDefinition studyDefinition : this.allStudyDefinitions) {
            if (!string.equals(studyDefinition.getAlias())) continue;
            return studyDefinition;
        }
        return null;
    }

    public List<StudyDefinition> getAllStartStudyDefinitions() {
        Vector<StudyDefinition> vector = new Vector<StudyDefinition>();
        List<StudyDefinition> list = this.getAllStudyDefinitions();
        for (int i = 0; i < list.size(); ++i) {
            StudyDefinition studyDefinition = list.get(i);
            if (!studyDefinition.isUseAutomatically()) continue;
            vector.add(studyDefinition);
        }
        return vector;
    }

    public List<StudyDefinition> getAllStudyDefinitions() {
        return Collections.unmodifiableList(this.allStudyDefinitions);
    }

    public int size() {
        return this.allStudyDefinitions.size();
    }

    public void setSourceDataHashCode(String string) {
        this.precalculatedHashCode = string;
    }

    public String getSourceDataHashCode() {
        return this.precalculatedHashCode;
    }

    public String dump() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("all study definitions (#" + this.allStudyDefinitions.size() + "):\n");
        int n = 0;
        for (StudyDefinition studyDefinition : this.allStudyDefinitions) {
            stringBuilder.append(n).append(": ");
            stringBuilder.append(studyDefinition.dump(1));
            stringBuilder.append("\n");
            ++n;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.dump();
    }

    public void removeAll() {
        this.allStudyDefinitions.clear();
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.allStudyDefinitions == null ? 0 : this.allStudyDefinitions.hashCode());
        n2 = 31 * n2 + (this.precalculatedHashCode == null ? 0 : this.precalculatedHashCode.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StudyDefinitionList studyDefinitionList = (StudyDefinitionList)object;
        if (this.allStudyDefinitions == null ? studyDefinitionList.allStudyDefinitions != null : !this.allStudyDefinitions.equals(studyDefinitionList.allStudyDefinitions)) {
            return false;
        }
        return !(this.precalculatedHashCode == null ? studyDefinitionList.precalculatedHashCode != null : !this.precalculatedHashCode.equals(studyDefinitionList.precalculatedHashCode));
    }
}

