/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.pojo;

import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DicomMailParticipant")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DicomMailParticipant
extends DatabaseBaseData {
    private static final long serialVersionUID = 6134516952225991319L;
    public static final String TABLE_NAME = "DicomMailParticipant";
    public static final String PARTICIPANT_ID = "participantID";
    public static final String PARENT_ID = "parentID";
    public static final String UNIT = "unit";
    public static final String TITLE = "title";
    public static final String GIVENNAME = "givenname";
    public static final String NAME = "name";
    public static final String SEX = "sex";
    public static final String SPECIALTY = "specialty";
    public static final String ROLES = "roles";
    public static final String ENABLED = "enabled";
    public static final String DELETED = "deleted";
    public static final String COMMENT = "comment";
    public static final String DICOM_MAIL_VERSION = "dicomMailVersion";
    public static final String AE_TITLE = "aeTitle";
    public static final String LAST_UPDATE_DATE = "lastUpdateDate";
    public static final String LAST_UPDATE_FROM = "lastUpdateFrom";
    public static final String LAST_UPDATE_REVISION_SYSTEM_ID = "lastUpdateRevisionSystemID";
    public static final String LAST_UPDATE_REVISION_NUMBER = "lastUpdateRevisionNumber";
    public static final String ANONYMIZE = "anonymize";
    public static final String ANONYMIZE_MAP_FILE = "anonymizeMapFile";
    public static final List<String> COLUMN_NAMES = new CopyOnWriteArrayList<String>();

    public DicomMailParticipant() {
        this.setEnabled(true);
        this.setDeleted(false);
        this.setAnonymize(false);
    }

    public DicomMailParticipant(DicomMailParticipant dicomMailParticipant) {
        super(dicomMailParticipant);
    }

    public void setParticipantID(String string) {
        this.setValue(PARTICIPANT_ID, string);
    }

    public void setParticipantIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 36) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field participantID; limit = 36");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null participantID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        this.setValue(PARTICIPANT_ID, string);
    }

    public String getParticipantID() {
        return this.getStringValue(PARTICIPANT_ID);
    }

    public void setParentID(String string) {
        this.setValue(PARENT_ID, string);
    }

    public void setParentIDWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 36) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field parentID; limit = 36");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(PARENT_ID, string);
    }

    public String getParentID() {
        return this.getStringValue(PARENT_ID);
    }

    public void setUnit(String string) {
        this.setValue(UNIT, string);
    }

    public void setUnitWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field unit; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null unit");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        this.setValue(UNIT, string);
    }

    public String getUnit() {
        return this.getStringValue(UNIT);
    }

    public void setTitle(String string) {
        this.setValue(TITLE, string);
    }

    public void setTitleWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field title; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(TITLE, string);
    }

    public String getTitle() {
        return this.getStringValue(TITLE);
    }

    public void setGivenname(String string) {
        this.setValue(GIVENNAME, string);
    }

    public void setGivennameWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field givenname; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(GIVENNAME, string);
    }

    public String getGivenname() {
        return this.getStringValue(GIVENNAME);
    }

    public void setName(String string) {
        this.setValue(NAME, string);
    }

    public void setNameWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field name; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null name");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        this.setValue(NAME, string);
    }

    public String getName() {
        return this.getStringValue(NAME);
    }

    public void setSex(String string) {
        this.setValue(SEX, string);
    }

    public void setSexWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field sex; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(SEX, string);
    }

    public String getSex() {
        return this.getStringValue(SEX);
    }

    public void setSpecialty(String string) {
        this.setValue(SPECIALTY, string);
    }

    public void setSpecialtyWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field specialty; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(SPECIALTY, string);
    }

    public String getSpecialty() {
        return this.getStringValue(SPECIALTY);
    }

    public void setRoles(String string) {
        this.setValue(ROLES, string);
    }

    public void setRolesWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field roles; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(ROLES, string);
    }

    public String getRoles() {
        return this.getStringValue(ROLES);
    }

    public void setEnabled(boolean bl) {
        this.setValue(ENABLED, bl);
    }

    public boolean isEnabled() {
        return this.getBooleanValue(ENABLED, true);
    }

    public void setDeleted(boolean bl) {
        this.setValue(DELETED, bl);
    }

    public boolean isDeleted() {
        return this.getBooleanValue(DELETED, false);
    }

    public void setComment(String string) {
        this.setValue(COMMENT, string);
    }

    public String getComment() {
        return this.getStringValue(COMMENT);
    }

    public void setDicomMailVersion(String string) {
        this.setValue(DICOM_MAIL_VERSION, string);
    }

    public void setDicomMailVersionWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field dicomMailVersion; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(DICOM_MAIL_VERSION, string);
    }

    public String getDicomMailVersion() {
        return this.getStringValue(DICOM_MAIL_VERSION);
    }

    public void setAeTitle(String string) {
        this.setValue(AE_TITLE, string);
    }

    public void setAeTitleWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 16) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field aeTitle; limit = 16");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(AE_TITLE, string);
    }

    public String getAeTitle() {
        return this.getStringValue(AE_TITLE);
    }

    public void setLastUpdateDate(long l) {
        this.setValue(LAST_UPDATE_DATE, l);
    }

    public void setLastUpdateDateAsDate(Date date) {
        this.setTimestampValueAsDate(LAST_UPDATE_DATE, date);
    }

    public long getLastUpdateDate() {
        return this.getTimestampValue(LAST_UPDATE_DATE);
    }

    public Date getLastUpdateDateAsDate() {
        return this.getTimestampValueAsDate(LAST_UPDATE_DATE);
    }

    public void setLastUpdateFrom(String string) {
        this.setValue(LAST_UPDATE_FROM, string);
    }

    public void setLastUpdateFromWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field lastUpdateFrom; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null lastUpdateFrom");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        this.setValue(LAST_UPDATE_FROM, string);
    }

    public String getLastUpdateFrom() {
        return this.getStringValue(LAST_UPDATE_FROM);
    }

    public void setLastUpdateRevisionSystemID(String string) {
        this.setValue(LAST_UPDATE_REVISION_SYSTEM_ID, string);
    }

    public void setLastUpdateRevisionSystemIDWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 64) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailParticipant.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field lastUpdateRevisionSystemID; limit = 64");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        this.setValue(LAST_UPDATE_REVISION_SYSTEM_ID, string);
    }

    public String getLastUpdateRevisionSystemID() {
        return this.getStringValue(LAST_UPDATE_REVISION_SYSTEM_ID);
    }

    public void setLastUpdateRevisionNumber(long l) {
        this.setValue(LAST_UPDATE_REVISION_NUMBER, l);
    }

    public long getLastUpdateRevisionNumber() {
        return this.getLongValue(LAST_UPDATE_REVISION_NUMBER);
    }

    public void setAnonymize(boolean bl) {
        this.setValue(ANONYMIZE, bl);
    }

    public boolean isAnonymize() {
        return this.getBooleanValue(ANONYMIZE, false);
    }

    public void setAnonymizeMapFile(String string) {
        this.setValue(ANONYMIZE_MAP_FILE, string);
    }

    public String getAnonymizeMapFile() {
        return this.getStringValue(ANONYMIZE_MAP_FILE);
    }

    public String getCaseSensitiveName(String string) {
        for (String string2 : COLUMN_NAMES) {
            try {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailParticipant.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean isModified(DicomMailParticipant dicomMailParticipant) {
        try {
            if (dicomMailParticipant == null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getParticipantID(), dicomMailParticipant.getParticipantID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getParentID(), dicomMailParticipant.getParentID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getUnit(), dicomMailParticipant.getUnit())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getTitle(), dicomMailParticipant.getTitle())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getGivenname(), dicomMailParticipant.getGivenname())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getName(), dicomMailParticipant.getName())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getSex(), dicomMailParticipant.getSex())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getSpecialty(), dicomMailParticipant.getSpecialty())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getRoles(), dicomMailParticipant.getRoles())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (this.isEnabled() != dicomMailParticipant.isEnabled()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (this.isDeleted() != dicomMailParticipant.isDeleted()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getComment(), dicomMailParticipant.getComment())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getDicomMailVersion(), dicomMailParticipant.getDicomMailVersion())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getAeTitle(), dicomMailParticipant.getAeTitle())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!DicomMailParticipant.timestampValueEquals(this.getLastUpdateDate(), dicomMailParticipant.getLastUpdateDate())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getLastUpdateFrom(), dicomMailParticipant.getLastUpdateFrom())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getLastUpdateRevisionSystemID(), dicomMailParticipant.getLastUpdateRevisionSystemID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (this.getLastUpdateRevisionNumber() != dicomMailParticipant.getLastUpdateRevisionNumber()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (this.isAnonymize() != dicomMailParticipant.isAnonymize()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getAnonymizeMapFile(), dicomMailParticipant.getAnonymizeMapFile())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3 = 31;
        int n4 = 1;
        String string = this.getParticipantID();
        try {
            n2 = 31 * n4;
            n = string == null ? 0 : string.hashCode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        n4 = n2 + n;
        return n4;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof DicomMailParticipant)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        DicomMailParticipant dicomMailParticipant = (DicomMailParticipant)object;
        try {
            if (this.getParticipantID() == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        try {
            if (!this.getParticipantID().equals(dicomMailParticipant.getParticipantID())) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailParticipant.a(illegalArgumentException);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DicomMailParticipant\n");
        for (String string : COLUMN_NAMES) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this.getValue(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        COLUMN_NAMES.add(PARTICIPANT_ID);
        COLUMN_NAMES.add(PARENT_ID);
        COLUMN_NAMES.add(UNIT);
        COLUMN_NAMES.add(TITLE);
        COLUMN_NAMES.add(GIVENNAME);
        COLUMN_NAMES.add(NAME);
        COLUMN_NAMES.add(SEX);
        COLUMN_NAMES.add(SPECIALTY);
        COLUMN_NAMES.add(ROLES);
        COLUMN_NAMES.add(ENABLED);
        COLUMN_NAMES.add(DELETED);
        COLUMN_NAMES.add(COMMENT);
        COLUMN_NAMES.add(DICOM_MAIL_VERSION);
        COLUMN_NAMES.add(AE_TITLE);
        COLUMN_NAMES.add(LAST_UPDATE_DATE);
        COLUMN_NAMES.add(LAST_UPDATE_FROM);
        COLUMN_NAMES.add(LAST_UPDATE_REVISION_SYSTEM_ID);
        COLUMN_NAMES.add(LAST_UPDATE_REVISION_NUMBER);
        COLUMN_NAMES.add(ANONYMIZE);
        COLUMN_NAMES.add(ANONYMIZE_MAP_FILE);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

