/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.pojo;

import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DicomMailPGPCertificateInformation")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DicomMailPGPCertificateInformation
extends DatabaseBaseData {
    private static final long serialVersionUID = 6380920097213832263L;
    public static final String TABLE_NAME = "DicomMailPGPCertificateInformation";
    public static final String CERTIFICATE_ID = "certificateID";
    public static final String MASTER_KEY = "masterKey";
    public static final String ENABLED = "enabled";
    public static final String DELETED = "deleted";
    public static final String LAST_UPDATE_DATE = "lastUpdateDate";
    public static final String LAST_UPDATE_FROM = "lastUpdateFrom";
    public static final String LAST_UPDATE_REVISION_SYSTEM_ID = "lastUpdateRevisionSystemID";
    public static final String LAST_UPDATE_REVISION_NUMBER = "lastUpdateRevisionNumber";
    public static final List<String> COLUMN_NAMES = new CopyOnWriteArrayList<String>();

    public DicomMailPGPCertificateInformation() {
        this.setMasterKey(false);
        this.setEnabled(true);
        this.setDeleted(false);
    }

    public DicomMailPGPCertificateInformation(DicomMailPGPCertificateInformation dicomMailPGPCertificateInformation) {
        super(dicomMailPGPCertificateInformation);
    }

    public void setCertificateID(String string) {
        this.setValue(CERTIFICATE_ID, string);
    }

    public void setCertificateIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 16) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field certificateID; limit = 16");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null certificateID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        this.setValue(CERTIFICATE_ID, string);
    }

    public String getCertificateID() {
        return this.getStringValue(CERTIFICATE_ID);
    }

    public void setMasterKey(boolean bl) {
        this.setValue(MASTER_KEY, bl);
    }

    public boolean isMasterKey() {
        return this.getBooleanValue(MASTER_KEY, false);
    }

    public void setEnabled(boolean bl) {
        this.setValue(ENABLED, bl);
    }

    public boolean isEnabled() {
        return this.getBooleanValue(ENABLED, true);
    }

    public void setDeleted(boolean bl) {
        this.setValue(DELETED, bl);
    }

    public boolean isDeleted() {
        return this.getBooleanValue(DELETED, false);
    }

    public void setLastUpdateDate(long l) {
        this.setValue(LAST_UPDATE_DATE, l);
    }

    public void setLastUpdateDateAsDate(Date date) {
        this.setTimestampValueAsDate(LAST_UPDATE_DATE, date);
    }

    public long getLastUpdateDate() {
        return this.getTimestampValue(LAST_UPDATE_DATE);
    }

    public Date getLastUpdateDateAsDate() {
        return this.getTimestampValueAsDate(LAST_UPDATE_DATE);
    }

    public void setLastUpdateFrom(String string) {
        this.setValue(LAST_UPDATE_FROM, string);
    }

    public void setLastUpdateFromWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field lastUpdateFrom; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null lastUpdateFrom");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        this.setValue(LAST_UPDATE_FROM, string);
    }

    public String getLastUpdateFrom() {
        return this.getStringValue(LAST_UPDATE_FROM);
    }

    public void setLastUpdateRevisionSystemID(String string) {
        this.setValue(LAST_UPDATE_REVISION_SYSTEM_ID, string);
    }

    public void setLastUpdateRevisionSystemIDWithCheck(String string) throws IllegalArgumentException {
        block4: {
            try {
                try {
                    if (string == null || string.length() <= 64) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field lastUpdateRevisionSystemID; limit = 64");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
            }
        }
        this.setValue(LAST_UPDATE_REVISION_SYSTEM_ID, string);
    }

    public String getLastUpdateRevisionSystemID() {
        return this.getStringValue(LAST_UPDATE_REVISION_SYSTEM_ID);
    }

    public void setLastUpdateRevisionNumber(long l) {
        this.setValue(LAST_UPDATE_REVISION_NUMBER, l);
    }

    public long getLastUpdateRevisionNumber() {
        return this.getLongValue(LAST_UPDATE_REVISION_NUMBER);
    }

    public String getCaseSensitiveName(String string) {
        for (String string2 : COLUMN_NAMES) {
            try {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean isModified(DicomMailPGPCertificateInformation dicomMailPGPCertificateInformation) {
        try {
            if (dicomMailPGPCertificateInformation == null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getCertificateID(), dicomMailPGPCertificateInformation.getCertificateID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (this.isMasterKey() != dicomMailPGPCertificateInformation.isMasterKey()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (this.isEnabled() != dicomMailPGPCertificateInformation.isEnabled()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (this.isDeleted() != dicomMailPGPCertificateInformation.isDeleted()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (!DicomMailPGPCertificateInformation.timestampValueEquals(this.getLastUpdateDate(), dicomMailPGPCertificateInformation.getLastUpdateDate())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getLastUpdateFrom(), dicomMailPGPCertificateInformation.getLastUpdateFrom())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getLastUpdateRevisionSystemID(), dicomMailPGPCertificateInformation.getLastUpdateRevisionSystemID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (this.getLastUpdateRevisionNumber() != dicomMailPGPCertificateInformation.getLastUpdateRevisionNumber()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        return false;
    }

    public int hashCode() {
        int n;
        int n2;
        int n3 = 31;
        int n4 = 1;
        String string = this.getCertificateID();
        try {
            n2 = 31 * n4;
            n = string == null ? 0 : string.hashCode();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        n4 = n2 + n;
        return n4;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof DicomMailPGPCertificateInformation)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        DicomMailPGPCertificateInformation dicomMailPGPCertificateInformation = (DicomMailPGPCertificateInformation)object;
        try {
            if (this.getCertificateID() == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        try {
            if (!this.getCertificateID().equals(dicomMailPGPCertificateInformation.getCertificateID())) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailPGPCertificateInformation.a(illegalArgumentException);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DicomMailPGPCertificateInformation\n");
        for (String string : COLUMN_NAMES) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this.getValue(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        COLUMN_NAMES.add(CERTIFICATE_ID);
        COLUMN_NAMES.add(MASTER_KEY);
        COLUMN_NAMES.add(ENABLED);
        COLUMN_NAMES.add(DELETED);
        COLUMN_NAMES.add(LAST_UPDATE_DATE);
        COLUMN_NAMES.add(LAST_UPDATE_FROM);
        COLUMN_NAMES.add(LAST_UPDATE_REVISION_SYSTEM_ID);
        COLUMN_NAMES.add(LAST_UPDATE_REVISION_NUMBER);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

