/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.pojo;

import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DicomMailNetwork")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DicomMailNetwork
extends DatabaseBaseData {
    private static final long serialVersionUID = -4959725046762175594L;
    public static final String TABLE_NAME = "DicomMailNetwork";
    public static final String JIVE_NETWORK_ID = "jiveNetworkID";
    public static final String NETWORK_UUID = "networkUUID";
    public static final String DISPLAY_NAME = "displayName";
    public static final String TYPE = "type";
    public static final String CHECK_CA_SIGNATURE = "checkCASignature";
    public static final String ACCEPT_REMOTE_UPDATE = "acceptRemoteUpdate";
    public static final String ACCEPT_REMOTE_UPDATE_WITH_SIGNATURE_LIST = "acceptRemoteUpdateWithSignatureList";
    public static final String CREATE_DUMMY_PARTICIPANTS = "createDummyParticipants";
    public static final List<String> COLUMN_NAMES = new CopyOnWriteArrayList<String>();

    public DicomMailNetwork() {
        this.setCheckCASignature(true);
        this.setAcceptRemoteUpdate(false);
        this.setAcceptRemoteUpdateWithSignatureList(false);
        this.setCreateDummyParticipants(false);
    }

    public DicomMailNetwork(DicomMailNetwork dicomMailNetwork) {
        super(dicomMailNetwork);
    }

    public void setJiveNetworkID(long l) {
        this.setValue(JIVE_NETWORK_ID, l);
    }

    public long getJiveNetworkID() {
        return this.getLongValue(JIVE_NETWORK_ID);
    }

    public void setNetworkUUID(String string) {
        this.setValue(NETWORK_UUID, string);
    }

    public void setNetworkUUIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 36) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailNetwork.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field networkUUID; limit = 36");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailNetwork.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null networkUUID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        this.setValue(NETWORK_UUID, string);
    }

    public String getNetworkUUID() {
        return this.getStringValue(NETWORK_UUID);
    }

    public void setDisplayName(String string) {
        this.setValue(DISPLAY_NAME, string);
    }

    public void setDisplayNameWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailNetwork.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field displayName; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailNetwork.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null displayName");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        this.setValue(DISPLAY_NAME, string);
    }

    public String getDisplayName() {
        return this.getStringValue(DISPLAY_NAME);
    }

    public void setType(String string) {
        this.setValue(TYPE, string);
    }

    public void setTypeWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 255) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailNetwork.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field type; limit = 255");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailNetwork.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null type");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        this.setValue(TYPE, string);
    }

    public String getType() {
        return this.getStringValue(TYPE);
    }

    public void setCheckCASignature(boolean bl) {
        this.setValue(CHECK_CA_SIGNATURE, bl);
    }

    public boolean isCheckCASignature() {
        return this.getBooleanValue(CHECK_CA_SIGNATURE, true);
    }

    public void setAcceptRemoteUpdate(boolean bl) {
        this.setValue(ACCEPT_REMOTE_UPDATE, bl);
    }

    public boolean isAcceptRemoteUpdate() {
        return this.getBooleanValue(ACCEPT_REMOTE_UPDATE, false);
    }

    public void setAcceptRemoteUpdateWithSignatureList(boolean bl) {
        this.setValue(ACCEPT_REMOTE_UPDATE_WITH_SIGNATURE_LIST, bl);
    }

    public boolean isAcceptRemoteUpdateWithSignatureList() {
        return this.getBooleanValue(ACCEPT_REMOTE_UPDATE_WITH_SIGNATURE_LIST, false);
    }

    public void setCreateDummyParticipants(boolean bl) {
        this.setValue(CREATE_DUMMY_PARTICIPANTS, bl);
    }

    public boolean isCreateDummyParticipants() {
        return this.getBooleanValue(CREATE_DUMMY_PARTICIPANTS, false);
    }

    public String getCaseSensitiveName(String string) {
        for (String string2 : COLUMN_NAMES) {
            try {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailNetwork.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean isModified(DicomMailNetwork dicomMailNetwork) {
        try {
            if (dicomMailNetwork == null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (this.getJiveNetworkID() != dicomMailNetwork.getJiveNetworkID()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getNetworkUUID(), dicomMailNetwork.getNetworkUUID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getDisplayName(), dicomMailNetwork.getDisplayName())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getType(), dicomMailNetwork.getType())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (this.isCheckCASignature() != dicomMailNetwork.isCheckCASignature()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (this.isAcceptRemoteUpdate() != dicomMailNetwork.isAcceptRemoteUpdate()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (this.isAcceptRemoteUpdateWithSignatureList() != dicomMailNetwork.isAcceptRemoteUpdateWithSignatureList()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (this.isCreateDummyParticipants() != dicomMailNetwork.isCreateDummyParticipants()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = this.getJiveNetworkID();
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof DicomMailNetwork)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        DicomMailNetwork dicomMailNetwork = (DicomMailNetwork)object;
        try {
            if (this.getJiveNetworkID() == 0L) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        try {
            if (this.getJiveNetworkID() != dicomMailNetwork.getJiveNetworkID()) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailNetwork.a(illegalArgumentException);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DicomMailNetwork\n");
        for (String string : COLUMN_NAMES) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this.getValue(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        COLUMN_NAMES.add(JIVE_NETWORK_ID);
        COLUMN_NAMES.add(NETWORK_UUID);
        COLUMN_NAMES.add(DISPLAY_NAME);
        COLUMN_NAMES.add(TYPE);
        COLUMN_NAMES.add(CHECK_CA_SIGNATURE);
        COLUMN_NAMES.add(ACCEPT_REMOTE_UPDATE);
        COLUMN_NAMES.add(ACCEPT_REMOTE_UPDATE_WITH_SIGNATURE_LIST);
        COLUMN_NAMES.add(CREATE_DUMMY_PARTICIPANTS);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

