/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.conference.objects;

import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.jTools.configManager.main.RootElement;
import com.visustt.jiveX.general.data.conference.objects.ObjectToSend;
import com.visustt.tools.config.main.ConfigurationException;

public class MouseInfoToSend
extends ObjectToSend {
    public static final String MOUSE_INFO_TO_SEND = "MouseInfoToSend";
    public static final String TYPE_CONTROL = "CONTROL";
    public static final String TYPE_DATA = "DATA";
    public static final String ACTION_START = "START";
    public static final String ACTION_STOP = "STOP";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ACTION = "action";
    private static final String ATTR_PERIOD = "period";
    private static final String ATTR_CONTENT = "content";
    private String type = "";
    private String action = "";
    private int period = -1;
    private String content = "";

    public MouseInfoToSend() {
        super(null);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String string) {
        this.action = string;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int n) {
        this.period = n;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String string) {
        this.content = string;
    }

    public String convertToXML() {
        ConfigurationElement configurationElement = new ConfigurationElement(MOUSE_INFO_TO_SEND);
        configurationElement.addAttribute(ATTR_TYPE, this.getType());
        configurationElement.addAttribute(ATTR_ACTION, this.getAction());
        configurationElement.addAttribute(ATTR_PERIOD, this.getPeriod());
        configurationElement.addAttribute(ATTR_CONTENT, this.getContent());
        return RootElement.getXMLString(configurationElement, true);
    }

    public static MouseInfoToSend createFromXML(String string) throws ConfigurationException {
        RootElement rootElement = RootElement.parseXMLString(string);
        MouseInfoToSend mouseInfoToSend = new MouseInfoToSend();
        mouseInfoToSend.setType(rootElement.getStringValue(ATTR_TYPE, ""));
        mouseInfoToSend.setAction(rootElement.getStringValue(ATTR_ACTION, ""));
        mouseInfoToSend.setPeriod(rootElement.getIntValue(ATTR_PERIOD, -1));
        mouseInfoToSend.setContent(rootElement.getStringValue(ATTR_CONTENT, ""));
        return mouseInfoToSend;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MousePositionExchange [");
        if (TYPE_CONTROL.equals(this.getType())) {
            stringBuilder.append("control packet");
            stringBuilder.append(", action=").append(this.getAction());
            stringBuilder.append(", period=").append(this.getPeriod());
        } else if (TYPE_DATA.equals(this.getType())) {
            stringBuilder.append("data packet");
            stringBuilder.append(", content={");
            stringBuilder.append(this.getContent());
            stringBuilder.append("}");
        } else {
            stringBuilder.append("unknown packet");
            stringBuilder.append(", type=").append(this.getType());
            stringBuilder.append(", action=").append(this.getAction());
            stringBuilder.append(", period=").append(this.getPeriod());
            stringBuilder.append(", content={");
            stringBuilder.append(this.getContent());
            stringBuilder.append("}");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

