/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data;

import com.visustt.jiveX.general.data.ImageType;
import com.visustt.tools.lang.StringTool;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class ImageTypeList
implements Serializable {
    private static final long serialVersionUID = 7878778L;
    public static final String emptyList = " ";
    private String[] imageTypes;

    public ImageTypeList(String[] stringArray) {
        this.imageTypes = stringArray;
    }

    public ImageTypeList(Collection<String> collection) {
        if (collection != null) {
            this.imageTypes = new String[collection.size()];
            int n = 0;
            Iterator<String> iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.imageTypes[n] = iterator.next();
                ++n;
            }
        }
    }

    public String[] getImageTypes() {
        return this.imageTypes;
    }

    public Vector<String> getImageTypesVector() {
        Vector<String> vector = new Vector<String>();
        if (this.imageTypes != null && this.imageTypes.length != 0) {
            for (int i = 0; i < this.imageTypes.length; ++i) {
                vector.add(this.imageTypes[i]);
            }
        }
        return vector;
    }

    public boolean containsImageType(String string) {
        return StringTool.containsString(this.imageTypes, string);
    }

    public boolean containsAny(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                if (!this.containsImageType(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsDicom() {
        if (this.imageTypes == null) {
            return false;
        }
        for (int i = 0; i < this.imageTypes.length; ++i) {
            if (!ImageType.isDicom(this.imageTypes[i])) continue;
            return true;
        }
        return false;
    }

    public boolean containsPixelAndDCMHeaders() {
        if (this.imageTypes == null) {
            return false;
        }
        return Arrays.asList(this.imageTypes).containsAll(ImageType.COMBINED_IMAGE_TYPE_DCMHEADERS_PIXEL);
    }

    public boolean containsLossless() {
        if (this.imageTypes == null) {
            return false;
        }
        for (int i = 0; i < this.imageTypes.length; ++i) {
            if (!ImageType.isLosslessImage(this.imageTypes[i])) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfImageTypes() {
        if (this.imageTypes == null) {
            return 0;
        }
        return this.imageTypes.length;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + Arrays.hashCode(this.imageTypes);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ImageTypeList)) {
            return false;
        }
        ImageTypeList imageTypeList = (ImageTypeList)object;
        Vector<String> vector = imageTypeList.getImageTypesVector();
        Collections.sort(vector);
        Vector<String> vector2 = this.getImageTypesVector();
        Collections.sort(vector2);
        return vector.equals(vector2);
    }

    public String toString() {
        if (this.getNumberOfImageTypes() == 0) {
            return emptyList;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append(this.imageTypes[0]);
        for (int i = 1; i < this.getNumberOfImageTypes(); ++i) {
            stringBuilder.append(emptyList).append(this.imageTypes[i]);
        }
        return stringBuilder.toString();
    }

    public boolean checkImageList() {
        if (this.imageTypes == null || this.imageTypes.length == 0) {
            return false;
        }
        for (int i = 0; i < this.imageTypes.length; ++i) {
            if (ImageType.isValidType(this.imageTypes[i])) continue;
            return false;
        }
        return true;
    }
}

