/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicommail.data;

import com.visustt.dicommail.data.DicomMailParticipantDetails;
import com.visustt.jiveX.general.data.pojo.DicomMailContact;
import com.visustt.jiveX.general.data.pojo.DicomMailNetwork;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DicomMailTarget
implements Serializable {
    private static final long serialVersionUID = 5771994334674490351L;
    private final DicomMailNetwork network;
    private final DicomMailParticipantDetails participant;
    private final List<DicomMailContact> contacts;

    public DicomMailTarget(DicomMailNetwork dicomMailNetwork, DicomMailParticipantDetails dicomMailParticipantDetails) {
        this.participant = dicomMailParticipantDetails;
        this.network = dicomMailNetwork;
        this.contacts = new LinkedList<DicomMailContact>();
    }

    public final DicomMailNetwork getDicomMailNetwork() {
        return this.network;
    }

    public final DicomMailParticipantDetails getDicomMailParticipant() {
        return this.participant;
    }

    public final boolean addDicomMailContact(DicomMailContact dicomMailContact) {
        long l = dicomMailContact.getJiveNetworkID();
        String string = dicomMailContact.getParticipantID();
        boolean bl = true;
        if (dicomMailContact.isEnabled() && l == dicomMailContact.getJiveNetworkID() && this.participant.getParticipantID().equals(string)) {
            long l2 = dicomMailContact.getJiveAccountID();
            for (DicomMailContact dicomMailContact2 : this.contacts) {
                if (l2 != dicomMailContact2.getJiveAccountID()) continue;
                bl = false;
                break;
            }
            if (bl) {
                this.contacts.add(dicomMailContact);
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public final List<DicomMailContact> getContacts() {
        return this.contacts;
    }

    public final DicomMailContact getContact(long l) {
        for (DicomMailContact dicomMailContact : this.contacts) {
            if (dicomMailContact.getJiveAccountID() != l) continue;
            return dicomMailContact;
        }
        return null;
    }

    public final boolean containsJiveContactID(long l) {
        for (DicomMailContact dicomMailContact : this.contacts) {
            if (dicomMailContact.getJiveContactID() != l) continue;
            return true;
        }
        return false;
    }

    public final String getFirstConnectionID() {
        Iterator<DicomMailContact> iterator = this.contacts.iterator();
        if (iterator.hasNext()) {
            DicomMailContact dicomMailContact = iterator.next();
            return dicomMailContact.getConnectionID();
        }
        return null;
    }

    public final boolean containsConnectionID(String string) {
        for (DicomMailContact dicomMailContact : this.contacts) {
            if (!dicomMailContact.getConnectionID().equals(string)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.network == null ? 0 : this.network.hashCode());
        n2 = 31 * n2 + (this.participant == null ? 0 : this.participant.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DicomMailTarget dicomMailTarget = (DicomMailTarget)object;
        if (this.network == null ? dicomMailTarget.network != null : !this.network.equals(dicomMailTarget.network)) {
            return false;
        }
        return !(this.participant == null ? dicomMailTarget.participant != null : !this.participant.equals(dicomMailTarget.participant));
    }
}

