/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicommail.data;

import com.visustt.dicommail.data.DicomMailAccountSendDetails;
import com.visustt.dicommail.data.DicomMailTarget;
import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import com.visustt.jiveX.general.data.pojo.DicomMailContact;
import com.visustt.jiveX.general.data.pojo.DicomMailNetwork;
import com.visustt.jiveX.general.data.pojo.DicomMailParticipant;
import com.visustt.jiveX.general.data.pojo.DicomMailParticipantAddress;
import com.visustt.jiveX.general.data.pojo.DicomMailParticipantInformation;
import com.visustt.jiveX.general.data.pojo.DicomMailParticipantReference;
import com.visustt.tools.io.ax;
import com.visustt.tools.lang.StringTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DicomMailParticipantDetails
extends DicomMailParticipant
implements Cloneable {
    private static final long serialVersionUID = -2102134105557737659L;
    private List<DicomMailParticipantAddress> addresses;
    private List<DicomMailParticipantInformation> informations;
    private List<DicomMailParticipantReference> references;
    private List<DicomMailContact> dicomMailContacts;

    public DicomMailParticipantDetails() {
        this.initialize();
    }

    public DicomMailParticipantDetails(DicomMailParticipant dicomMailParticipant) {
        super(dicomMailParticipant);
        this.initialize();
    }

    public DicomMailParticipantDetails(DicomMailParticipantDetails dicomMailParticipantDetails) {
        super(dicomMailParticipantDetails);
        this.initialize();
        if (dicomMailParticipantDetails != null) {
            this.copyLists(dicomMailParticipantDetails);
        }
    }

    private void initialize() {
        this.addresses = new ArrayList<DicomMailParticipantAddress>(0);
        this.informations = new ArrayList<DicomMailParticipantInformation>(0);
        this.references = new ArrayList<DicomMailParticipantReference>(0);
        this.dicomMailContacts = new ArrayList<DicomMailContact>(0);
    }

    private void copyLists(DicomMailParticipantDetails dicomMailParticipantDetails) {
        this.addresses.addAll(dicomMailParticipantDetails.addresses);
        this.informations.addAll(dicomMailParticipantDetails.informations);
        this.references.addAll(dicomMailParticipantDetails.references);
        this.dicomMailContacts.addAll(dicomMailParticipantDetails.dicomMailContacts);
    }

    public final void addDicomMailParticipantAddresses(DicomMailParticipantAddress dicomMailParticipantAddress) {
        if (dicomMailParticipantAddress != null) {
            this.addresses.add(dicomMailParticipantAddress);
        }
    }

    public final List<DicomMailParticipantAddress> getDicomMailParticipantAddresses() {
        return this.addresses;
    }

    public void addDicomMailParticipantInformation(DicomMailParticipantInformation dicomMailParticipantInformation) {
        if (dicomMailParticipantInformation != null) {
            this.informations.add(dicomMailParticipantInformation);
        }
    }

    public final List<DicomMailParticipantInformation> getDicomMailParticipantInformation() {
        return this.informations;
    }

    public final void addDicomMailParticipantReference(DicomMailParticipantReference dicomMailParticipantReference) {
        if (dicomMailParticipantReference != null) {
            this.references.add(dicomMailParticipantReference);
        }
    }

    public final List<DicomMailParticipantReference> getDicomMailParticipantReferences() {
        return this.references;
    }

    public final void addDicomMailContact(DicomMailContact dicomMailContact) {
        if (dicomMailContact != null) {
            this.dicomMailContacts.add(dicomMailContact);
        }
    }

    public final List<DicomMailContact> getDicomMailContacts() {
        return this.dicomMailContacts;
    }

    public final boolean containsAccountID(Set<Long> set) {
        if (this.isEnabled() && !this.dicomMailContacts.isEmpty()) {
            for (DicomMailContact dicomMailContact : this.dicomMailContacts) {
                long l = dicomMailContact.getJiveAccountID();
                if (!set.contains(l)) continue;
                return true;
            }
        }
        return false;
    }

    public final List<DicomMailTarget> getDicomMailTargets(Map<Long, DicomMailNetwork> map) {
        HashMap<Long, DicomMailTarget> hashMap = new HashMap<Long, DicomMailTarget>();
        if (this.isEnabled() && !this.dicomMailContacts.isEmpty()) {
            for (DicomMailContact dicomMailContact : this.dicomMailContacts) {
                DicomMailNetwork dicomMailNetwork;
                if (!dicomMailContact.isEnabled()) continue;
                long l = dicomMailContact.getJiveNetworkID();
                DicomMailTarget dicomMailTarget = (DicomMailTarget)hashMap.get(l);
                if (dicomMailTarget == null && (dicomMailNetwork = map.get(l)) != null) {
                    dicomMailTarget = new DicomMailTarget(dicomMailNetwork, this);
                    hashMap.put(l, dicomMailTarget);
                }
                if (dicomMailTarget == null) continue;
                dicomMailTarget.addDicomMailContact(dicomMailContact);
            }
        }
        return new ArrayList<DicomMailTarget>(hashMap.values());
    }

    public final List<DicomMailAccountSendDetails> getAssignedDicomMailAccountSendDetails(Map<Long, DicomMailAccountSendDetails> map, long l) {
        LinkedList<DicomMailAccountSendDetails> linkedList = new LinkedList<DicomMailAccountSendDetails>();
        for (DicomMailContact dicomMailContact : this.dicomMailContacts) {
            long l2;
            DicomMailAccountSendDetails dicomMailAccountSendDetails;
            if (!dicomMailContact.isEnabled() || l != dicomMailContact.getJiveNetworkID() || (dicomMailAccountSendDetails = map.get(l2 = dicomMailContact.getJiveAccountID())) == null || linkedList.contains(dicomMailAccountSendDetails)) continue;
            linkedList.add(dicomMailAccountSendDetails);
        }
        return linkedList;
    }

    public final String getDisplayName() {
        return DicomMailParticipantDetails.getDisplayName(this);
    }

    public static final String getDisplayName(DicomMailParticipant dicomMailParticipant) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = dicomMailParticipant.getTitle();
        String string2 = dicomMailParticipant.getGivenname();
        String string3 = dicomMailParticipant.getName();
        if (StringTool.isDefined(string)) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        if (StringTool.isDefined(string2)) {
            stringBuilder.append(string2);
            stringBuilder.append(" ");
        }
        if (StringTool.isDefined(string3)) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }

    public final String createOrganisationPath(List<DicomMailParticipantDetails> list) {
        StringBuilder stringBuilder = this.createOrganisationPath(this.getParentID(), list);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        return stringBuilder.toString();
    }

    private StringBuilder createOrganisationPath(String string, List<DicomMailParticipantDetails> list) {
        if (string != null) {
            for (DicomMailParticipant dicomMailParticipant : list) {
                if (!string.equals(dicomMailParticipant.getParticipantID())) continue;
                StringBuilder stringBuilder = this.createOrganisationPath(dicomMailParticipant.getParentID(), list);
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                } else {
                    stringBuilder.append(" / ");
                }
                stringBuilder.append(dicomMailParticipant.getName());
                return stringBuilder;
            }
        }
        return null;
    }

    public final String createOrganisationPath(Map<String, DicomMailParticipantDetails> map) {
        StringBuilder stringBuilder = this.createOrganisationPath(this.getParentID(), map);
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        return stringBuilder.toString();
    }

    private StringBuilder createOrganisationPath(String string, Map<String, DicomMailParticipantDetails> map) {
        DicomMailParticipantDetails dicomMailParticipantDetails;
        if (StringTool.isDefined(string) && (dicomMailParticipantDetails = map.get(string)) != null) {
            StringBuilder stringBuilder = this.createOrganisationPath(dicomMailParticipantDetails.getParentID(), map);
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder();
            } else {
                stringBuilder.append(" / ");
            }
            stringBuilder.append(dicomMailParticipantDetails.getName());
            return stringBuilder;
        }
        return null;
    }

    public final List<DicomMailParticipantDetails> getReferencedDicomMailParticipants(Map<String, DicomMailParticipantDetails> map) {
        if (map != null && !map.isEmpty()) {
            return DicomMailParticipantDetails.getReferencedDicomMailParticipants_(map, this.getParticipantID(), this);
        }
        return Collections.emptyList();
    }

    private static List<DicomMailParticipantDetails> getReferencedDicomMailParticipants_(Map<String, DicomMailParticipantDetails> map, String string, DicomMailParticipantDetails dicomMailParticipantDetails) {
        DicomMailParticipantDetails dicomMailParticipantDetails2;
        if (!dicomMailParticipantDetails.references.isEmpty()) {
            return DicomMailParticipantDetails.createReferenceList(map, string, dicomMailParticipantDetails.references);
        }
        String string2 = dicomMailParticipantDetails.getParentID();
        if (StringTool.isDefined(string2) && (dicomMailParticipantDetails2 = map.get(string2)) != null) {
            return DicomMailParticipantDetails.getReferencedDicomMailParticipants_(map, string, dicomMailParticipantDetails2);
        }
        return Collections.emptyList();
    }

    private static List<DicomMailParticipantDetails> createReferenceList(Map<String, DicomMailParticipantDetails> map, String string, List<DicomMailParticipantReference> list) {
        ArrayList<DicomMailParticipantDetails> arrayList = new ArrayList<DicomMailParticipantDetails>(list.size());
        for (DicomMailParticipantReference dicomMailParticipantReference : list) {
            DicomMailParticipantDetails dicomMailParticipantDetails;
            String string2 = dicomMailParticipantReference.getReferenceID();
            if (string.equals(string2) || (dicomMailParticipantDetails = map.get(string2)) == null || arrayList.contains(dicomMailParticipantDetails)) continue;
            arrayList.add(dicomMailParticipantDetails);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static DicomMailParticipantDetails getParticipant(List<DicomMailParticipantDetails> list, String string) {
        for (DicomMailParticipantDetails dicomMailParticipantDetails : list) {
            if (!string.equals(dicomMailParticipantDetails.getParticipantID())) continue;
            return dicomMailParticipantDetails;
        }
        return null;
    }

    public static Map<String, DicomMailParticipantDetails> toMap(List<DicomMailParticipantDetails> list) {
        HashMap<String, DicomMailParticipantDetails> hashMap = new HashMap<String, DicomMailParticipantDetails>(list.size());
        for (DicomMailParticipantDetails dicomMailParticipantDetails : list) {
            hashMap.put(dicomMailParticipantDetails.getParticipantID(), dicomMailParticipantDetails);
        }
        return hashMap;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            return ax.aa(this);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException(exception.getMessage());
        }
    }

    public boolean isModifiedWithDetails(DicomMailParticipantDetails dicomMailParticipantDetails) {
        Iterator<DatabaseBaseData> iterator;
        if (this.isModified(dicomMailParticipantDetails)) {
            return true;
        }
        if (this.addresses.size() != dicomMailParticipantDetails.addresses.size()) {
            return true;
        }
        if (this.informations.size() != dicomMailParticipantDetails.informations.size()) {
            return true;
        }
        if (!this.addresses.isEmpty()) {
            iterator = dicomMailParticipantDetails.addresses.iterator();
            for (DicomMailParticipantAddress databaseBaseData : this.addresses) {
                databaseBaseData.isModified((DicomMailParticipantAddress)iterator.next());
            }
        }
        if (!this.informations.isEmpty()) {
            iterator = dicomMailParticipantDetails.informations.iterator();
            for (DicomMailParticipantInformation dicomMailParticipantInformation : this.informations) {
                dicomMailParticipantInformation.isModified((DicomMailParticipantInformation)iterator.next());
            }
        }
        return false;
    }
}

