/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicommail.data;

import com.visustt.jiveX.general.data.pojo.DicomMailPGPCertificateInformation;
import com.visustt.tools.security.crt.data.CertificateData;
import com.visustt.tools.security.crt.data.CertificateDataPGP;
import java.io.Serializable;
import java.util.Date;

public class DicomMailCertificate
implements Serializable {
    private static final long serialVersionUID = 4741064698551123799L;
    private CertificateData certificate;
    private DicomMailPGPCertificateInformation information;

    public DicomMailCertificate(CertificateData certificateData) {
        this(certificateData, null);
    }

    public DicomMailCertificate(CertificateData certificateData, DicomMailPGPCertificateInformation dicomMailPGPCertificateInformation) {
        this.certificate = certificateData;
        this.information = dicomMailPGPCertificateInformation;
    }

    public final CertificateData getCertificate() {
        return this.certificate;
    }

    public final void setCertificate(CertificateData certificateData) {
        this.certificate = certificateData;
    }

    public final DicomMailPGPCertificateInformation getInformation() {
        return this.information;
    }

    public final void setInformation(DicomMailPGPCertificateInformation dicomMailPGPCertificateInformation) {
        this.information = dicomMailPGPCertificateInformation;
    }

    public final String getAlgorithm() {
        return this.certificate.aa();
    }

    public final String getBitStrength() {
        return this.certificate.ab();
    }

    public final String getDescription() {
        return this.certificate.ac();
    }

    public final String getID() {
        return this.certificate.ad();
    }

    public final Date getCreationDate() {
        return this.certificate.ae();
    }

    public final Date getExpireDate() {
        return this.certificate.af();
    }

    public final int getFormat() {
        return this.certificate.ag();
    }

    public final boolean isPrivateKeyAvailable() {
        return this.certificate.ah();
    }

    public final boolean isPGPKey() {
        return this.certificate.ai();
    }

    public final boolean isX509Key() {
        return this.certificate.aj();
    }

    public boolean isMasterKey() {
        return this.information != null && this.information.isMasterKey();
    }

    public final String getFingerprint() {
        if (this.isPGPKey()) {
            return ((CertificateDataPGP)this.certificate).ak();
        }
        return null;
    }

    public int hashCode() {
        return this.certificate.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DicomMailCertificate) {
            return this.certificate.equals(((DicomMailCertificate)object).certificate);
        }
        return false;
    }

    public String toString() {
        return this.certificate.toString();
    }
}

