/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.waveform;

import com.visustt.dicomTk.CommonDicomException;
import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomObject;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.NoValidDicomObjectException;
import com.visustt.dicomTk.NoValidValueIndexException;
import com.visustt.dicomTk.SeriesModule;
import com.visustt.dicomTk.UnavailableException;
import com.visustt.dicomTk.UnsupportedDicomObjectException;
import com.visustt.dicomTk.UnsupportedTransferSyntaxException;
import com.visustt.dicomTk.aa.ag;
import com.visustt.dicomTk.as;
import com.visustt.dicomTk.aw;
import com.visustt.dicomTk.codes.DicomCode;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.aaa;
import com.visustt.dicomTk.data.aac;
import com.visustt.dicomTk.data.aag;
import com.visustt.dicomTk.data.aam;
import com.visustt.dicomTk.data.aan;
import com.visustt.dicomTk.data.aas;
import com.visustt.dicomTk.data.an;
import com.visustt.dicomTk.data.ar;
import com.visustt.dicomTk.data.au;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.ax;
import com.visustt.dicomTk.data.az;
import com.visustt.dicomTk.sr.ad.aa.aj;
import com.visustt.dicomTk.waveform.ad.aa;
import com.visustt.dicomTk.waveform.ad.ac;
import com.visustt.dicomTk.waveform.ae;
import com.visustt.dicomTk.waveform.ah;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.Base64Facade;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.text.DateUtils;
import com.visustt.tools.text.al;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;

public class af
extends ae
implements ah {
    private static final al ag = new al("dd.MM.yyyy");
    protected static final String av = "RHYTHM";
    private static Logger az = LoggerFactory.getInstance("jx.gui.waveform");
    private static final short[] aA = new short[0];
    static final int aO = -2;
    private static Map<String, ab> aP = new HashMap<String, ab>();
    private ab abY = new ab();

    public af() {
        this.ar();
    }

    public af(byte[] byArray) throws CommonDicomException {
        super(byArray);
        this.aj();
    }

    private void aj() {
        block4: {
            String string = this.getSOPCommonModule().ac();
            try {
                if (!"".equals(string) && !"null".equals(string)) break block4;
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
            try {
                this.getSOPCommonModule().ac("ISO_IR 100");
            }
            catch (InvalidDataException invalidDataException) {
                az.error((Object)"No valid character set for waveform object.", invalidDataException);
            }
        }
        this.ar();
    }

    public af(String string) throws NoValidDicomObjectException, UnsupportedTransferSyntaxException, UnsupportedDicomObjectException, CommonDicomException, IOException {
        super(string);
        this.aj();
    }

    public af(DicomObject dicomObject) {
        super(dicomObject);
        this.aj();
    }

    @Override
    public boolean aa() throws NoValidValueIndexException {
        return true;
    }

    @Override
    public String ab() {
        return Optional.ofNullable(this.getSOPCommonModule().aa()).orElse("");
    }

    @Override
    public boolean ac() {
        return this.ae() || this.af() || this.ag();
    }

    @Override
    public boolean ad() throws InvalidDataException {
        boolean bl;
        block22: {
            bl = false;
            if (this.ab().equals("1.2.840.10008.5.1.4.1.1.9.1.1")) {
                bl = true;
            }
            int n = -1;
            int n2 = this.getNrOfItems(DicomTagNames.TAG_waveformSequence);
            int n3 = 0;
            while (true) {
                block19: {
                    int n4;
                    block21: {
                        block20: {
                            int n5;
                            block18: {
                                block17: {
                                    try {
                                        try {
                                            if (n3 >= n2) break;
                                            if (!av.equalsIgnoreCase(this.ag(n3))) break block17;
                                        }
                                        catch (InvalidDataException invalidDataException) {
                                            throw af.d(invalidDataException);
                                        }
                                        n5 = n3;
                                        break block18;
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        throw af.d(invalidDataException);
                                    }
                                }
                                n5 = n;
                            }
                            n = n5;
                            try {
                                try {
                                    if (n >= 0) break block19;
                                    if ((float)this.ab(n3) / this.ac(n3) != 10.0f) break block20;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw af.d(invalidDataException);
                                }
                                n4 = n3;
                                break block21;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw af.d(invalidDataException);
                            }
                        }
                        n4 = n;
                    }
                    n = n4;
                }
                ++n3;
            }
            if (n >= 0) {
                n3 = this.aa(n);
                float f = (float)this.ab(n) / this.ac(n);
                try {
                    try {
                        try {
                            if (n3 != 8 && n3 != 12) break block22;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw af.d(invalidDataException);
                        }
                        if (!(f >= 10.0f)) break block22;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                    if (!(f < 12.0f)) break block22;
                }
                catch (InvalidDataException invalidDataException) {
                    throw af.d(invalidDataException);
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean ae() {
        return "1.2.840.10008.5.1.4.1.1.9.1.1".equals(this.ab());
    }

    @Override
    public boolean af() {
        return "1.2.840.10008.5.1.4.1.1.9.1.2".equals(this.ab());
    }

    @Override
    public boolean ag() {
        return "1.2.840.10008.5.1.4.1.1.9.1.3".equals(this.ab());
    }

    public boolean ak() {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence);
        boolean bl = false;
        if (dicomElement != null) {
            int n = ((av)dicomElement).af();
            if (n > 0) {
                bl = true;
            } else {
                az.error("One or more items shall be present in waveform annotation sequence (0040,B020).");
            }
        }
        return bl;
    }

    @Override
    public boolean ah() throws NoValidValueIndexException {
        boolean bl;
        block8: {
            block7: {
                try {
                    if (this.abY.aa.equals(".*ge medical systems.*")) {
                        return true;
                    }
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
                com.visustt.dicomTk.waveform.ad.aa aa10 = this.ai();
                try {
                    try {
                        if (!this.aa(aa10.aa()) && !this.aa(aa10.ab())) break block7;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    bl = true;
                    break block8;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            bl = false;
        }
        return bl;
    }

    boolean aa(aa.ab ab5) {
        return ab5 != null && ab5.ab() != null && ab5.ab().length > 0;
    }

    @Override
    public com.visustt.dicomTk.waveform.ad.aa ai() throws NoValidValueIndexException {
        try {
            if (!this.ak()) {
                return new com.visustt.dicomTk.waveform.ad.aa();
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        av av3 = (av)this.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence);
        com.visustt.dicomTk.waveform.ad.aa aa10 = new com.visustt.dicomTk.waveform.ad.aa();
        aa.ab ab5 = aa10.aa();
        aa.ab ab6 = aa10.ab();
        ab5.aa(this.aa(av3, this.abY.ab));
        ab6.aa(this.aa(av3, this.abY.ah));
        this.aa(ab5, ab6, av3);
        av av4 = (av)this.getDicomElement(DicomTagNames.TAG_visusDataSaveSequence);
        try {
            if (av4 != null) {
                av4.ak().map(aas::ae).map(dicomElementList -> (av)dicomElementList.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence)).forEach(av2 -> {
                    this.aa((av)av2, aa10, this.abY.ab);
                    this.aa((av)av2, aa10, this.abY.ah);
                });
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return aa10;
    }

    private void aa(av av2, com.visustt.dicomTk.waveform.ad.aa aa10, int n) {
        block5: {
            if (av2 != null) {
                try {
                    String[] stringArray = this.aa(av2, n);
                    try {
                        if (stringArray == null || stringArray.length <= 0) break block5;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    com.visustt.dicomTk.waveform.ad.ab ab5 = ac.aa(n, av2);
                    aa aa11 = this.aa(ab5);
                    aa10.aa(stringArray, aa11.aa, aa11.ab);
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    az.error((Object)"Failed copying historic diagnosis from save sequence to diagnosis", noValidValueIndexException);
                }
            }
        }
    }

    private aa aa(com.visustt.dicomTk.waveform.ad.ab ab5) {
        aa aa10 = new aa();
        if (ab5 != null) {
            aa10.ab = ab5.aa();
            Date date = ab5.ab();
            String string = ag.aa(date);
            String string2 = DateUtils.simpleTimeSDF.aa(date);
            aa10.aa = string + " " + string2;
        } else {
            az.debug("There could be no Change Item found in the historic Diagnosis of the waveform object");
        }
        return aa10;
    }

    private void aa(aa.ab ab5, aa.ab ab6, av av2) {
        Object object;
        Object object2;
        Date date = this.getDate(DicomTagNames.TAG_waveformAcquisitionDateTime);
        if (date != null) {
            object2 = DateUtils.format(date, "dd.MM.yyyy");
            object = DateUtils.simpleTimeSDF.aa(date);
            ab5.ac((String)object2 + " " + (String)object);
            ab6.ac((String)object2 + " " + (String)object);
        }
        if ((object2 = ac.aa(this.abY.ah, av2)) != null) {
            object = ((com.visustt.dicomTk.waveform.ad.ab)object2).ab();
            String string = DateUtils.format((Date)object, "dd.MM.yyyy");
            String string2 = DateUtils.simpleTimeSDF.aa((Date)object);
            ab6.ac(string + " " + string2);
            ab6.aa(((com.visustt.dicomTk.waveform.ad.ab)object2).aa());
        }
    }

    public boolean al() {
        return af.aa((av)this.getDicomElement(DicomTagNames.TAG_acquisitionContextSequence));
    }

    public String am() throws InvalidDataException {
        try {
            if (!this.al()) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw af.d(invalidDataException);
        }
        DicomElementList dicomElementList = this.getDicomElement(DicomTagNames.TAG_acquisitionContextSequence).getValueAsSequence(0);
        DicomElementList dicomElementList2 = dicomElementList.getDicomElement(DicomTagNames.TAG_conceptCodeSequence).getValueAsSequence(0);
        if (af.ac(dicomElementList2)) {
            String string = af.aa(dicomElementList2, DicomTagNames.TAG_codeMeaning);
            DicomCode dicomCode = af.ab(dicomElementList2);
            try {
                if (dicomCode != null) {
                    return dicomCode.getMeaning();
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
            try {
                if (!"".equals(string)) {
                    return string;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
            az.warn("Code Meaning of electrode placement is neither available in codes dictionary nor in dicom object.");
        }
        return null;
    }

    public String an() throws InvalidDataException {
        if (this.existsDicomElement(DicomTagNames.TAG_visusWaveformExternalData)) {
            String string = af.aa(this, DicomTagNames.TAG_visusWaveformExternalData);
            return Base64Facade.decodeString(string);
        }
        return "";
    }

    @Override
    public int aa(int n) throws InvalidDataException {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
        DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_numberOfWaveformChannels);
        try {
            if (dicomElement2 == null) {
                az.error("Dicom tag for number of waveform channels (003A,0005) is empty or not present.");
                return 0;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw af.d(invalidDataException);
        }
        return dicomElement2.getValueAsInt(0);
    }

    @Override
    public float ab(int n, int n2) {
        float f = 0.0f;
        try {
            DicomElement dicomElement;
            DicomElementList dicomElementList = this.aj(n, n2);
            if (dicomElementList != null && (dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_filterHighFrequency)) != null) {
                f = Float.parseFloat(dicomElement.getValueAsString(0));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            az.warn("High filter element contains no valid value in element " + DicomTagNames.TAG_filterHighFrequency.toString() + ": " + noValidValueIndexException.getCause());
        }
        return f;
    }

    @Override
    public float ac(int n, int n2) {
        float f = 0.0f;
        try {
            DicomElement dicomElement;
            DicomElementList dicomElementList = this.aj(n, n2);
            if (dicomElementList != null && (dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_filterLowFrequency)) != null) {
                f = Float.parseFloat(dicomElement.getValueAsString(0));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            az.warn("Low filter element contains no valid value in element " + DicomTagNames.TAG_filterLowFrequency.toString() + ": " + noValidValueIndexException.getCause());
        }
        return f;
    }

    public float ai(int n, int n2) {
        float f = 0.0f;
        try {
            DicomElement dicomElement;
            DicomElementList dicomElementList = this.aj(n, n2);
            if (dicomElementList != null && (dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_notchFilterFrequency)) != null) {
                f = Float.parseFloat(dicomElement.getValueAsString(0));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            az.warn("Notch filter element contains no valid value in element " + DicomTagNames.TAG_notchFilterFrequency.toString() + ": " + noValidValueIndexException.getCause());
        }
        return f;
    }

    @Override
    public long ab(int n) throws NoValidValueIndexException {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
        DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_numberOfWaveformSamples);
        try {
            if (dicomElement2 == null) {
                az.error("Dicom tag for number of waveform samples (003A,0010) is empty or not present.");
                return 0L;
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return dicomElement2.getValueAsLong(0);
    }

    public int ao() {
        return this.getNrOfItems(DicomTagNames.TAG_waveformSequence);
    }

    @Override
    public float ac(int n) throws NoValidValueIndexException {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
        DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_samplingFrequency);
        try {
            if (dicomElement2 == null) {
                az.error("Dicom tag for sampling frequency (003A,001A) is empty or not present.");
                return 0.0f;
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return Float.parseFloat(dicomElement2.getValueAsString(0));
    }

    private DicomElementList aj(int n, int n2) throws NoValidValueIndexException {
        DicomElementList dicomElementList = this.getDicomElement(DicomTagNames.TAG_waveformSequence).getValueAsSequence(n);
        return dicomElementList.getDicomElement(DicomTagNames.TAG_channelDefinitionSequence).getValueAsSequence(n2);
    }

    @Override
    public float ad(int n, int n2) throws NoValidValueIndexException {
        DicomElement dicomElement;
        block4: {
            block5: {
                DicomElementList dicomElementList = this.aj(n, n2);
                dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSensitivity);
                try {
                    try {
                        if (dicomElement != null) break block4;
                        if (!az.warnIsEnabled()) break block5;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    az.warn("Dicom tag for channel sensitivity (003A,0210) is empty or not present. An arbitrary unit of 1 is assumed.");
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            return 1.0f;
        }
        return Float.parseFloat(dicomElement.getValueAsString(0));
    }

    @Override
    public float ae(int n, int n2) throws NoValidValueIndexException {
        DicomElement dicomElement;
        block7: {
            block8: {
                DicomElementList dicomElementList = this.aj(n, n2);
                DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSensitivity);
                dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSensitivityCorrectionFactor);
                try {
                    try {
                        if (dicomElement2 == null) break block7;
                        if (dicomElement != null) break block8;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    az.error("Dicom tag for waveform channel sensitivity correction factor (003A,0212) is empty or not present.");
                    return 0.0f;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            return Float.parseFloat(dicomElement.getValueAsString(0));
        }
        try {
            if (dicomElement != null) {
                az.error("Dicom tag for waveform channel sensitivity correction factor (003A,0212) should not be present.");
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return 0.0f;
    }

    @Override
    public String[] af(int n, int n2) throws NoValidValueIndexException {
        DicomElement dicomElement;
        block7: {
            block8: {
                DicomElementList dicomElementList = this.aj(n, n2);
                DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSensitivity);
                dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSensitivityUnitsSequence);
                try {
                    try {
                        if (dicomElement2 == null) break block7;
                        if (dicomElement != null) break block8;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    az.error("Dicom tag for waveform channel sensitivity unit sequence (003A,0211) is empty or not present.");
                    return null;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            DicomElementList dicomElementList = dicomElement.getValueAsSequence(0);
            String[] stringArray = new String[]{af.aa(dicomElementList, DicomTagNames.TAG_codeValue), af.aa(dicomElementList, DicomTagNames.TAG_codeMeaning)};
            return stringArray;
        }
        try {
            if (dicomElement != null) {
                az.error("Dicom tag for waveform channel sensitivity unit sequence (003A,0211) should not be present.");
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return null;
    }

    @Override
    public float ah(int n, int n2) throws NoValidValueIndexException {
        DicomElement dicomElement;
        block7: {
            block8: {
                DicomElementList dicomElementList = this.aj(n, n2);
                DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSensitivity);
                dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_channelBaseline);
                try {
                    try {
                        if (dicomElement2 == null) break block7;
                        if (dicomElement != null) break block8;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    az.error("Dicom tag for waveform channel baseline (003A,0213) is empty or not present.");
                    return 0.0f;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            return Float.parseFloat(dicomElement.getValueAsString(0));
        }
        try {
            if (dicomElement != null) {
                az.error("Dicom tag for waveform channel baseline (003A,0213) should not be present.");
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return 0.0f;
    }

    public float ak(int n, int n2) throws NoValidValueIndexException {
        block14: {
            DicomElement dicomElement;
            DicomElement dicomElement2;
            block13: {
                block12: {
                    DicomElementList dicomElementList = this.aj(n, n2);
                    dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSampleSkew);
                    dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_channelTimeSkew);
                    try {
                        try {
                            if (dicomElement2 != null || dicomElement == null) break block12;
                        }
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw af.d(noValidValueIndexException);
                        }
                        return Float.parseFloat(dicomElement.getValueAsString(0));
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                }
                try {
                    try {
                        if (dicomElement2 != null || dicomElement != null) break block13;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    az.error("Dicom tags for waveform channel time skew (003A,0214) and waveform channel sample skew ((003A,0214) are not present. At least one of them must be present.");
                    break block14;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            try {
                try {
                    if (dicomElement2 == null || dicomElement == null) break block14;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
                az.error("Dicom tags for waveform channel time skew (003A,0214) and waveform channel sample skew ((003A,0214) are both present. Only one of them should be present.");
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw af.d(noValidValueIndexException);
            }
        }
        return 0.0f;
    }

    public float al(int n, int n2) throws NoValidValueIndexException {
        block14: {
            DicomElement dicomElement;
            DicomElement dicomElement2;
            block13: {
                block12: {
                    DicomElementList dicomElementList = this.aj(n, n2);
                    dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_channelSampleSkew);
                    dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_channelTimeSkew);
                    try {
                        try {
                            if (dicomElement2 == null || dicomElement != null) break block12;
                        }
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw af.d(noValidValueIndexException);
                        }
                        return Float.parseFloat(dicomElement2.getValueAsString(0));
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                }
                try {
                    try {
                        if (dicomElement2 != null || dicomElement != null) break block13;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    az.error("Dicom tags for waveform channel time skew (003A,0214) and waveform channel sample skew ((003A,0214) are not present. At least one of them must be present.");
                    break block14;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            try {
                try {
                    if (dicomElement2 == null || dicomElement == null) break block14;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
                az.error("Dicom tags for waveform channel time skew (003A,0214) and waveform channel sample skew ((003A,0214) are both present. Only one of them should be present.");
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw af.d(noValidValueIndexException);
            }
        }
        return 0.0f;
    }

    public float am(int n, int n2) throws NoValidValueIndexException {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
        DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_channelDefinitionSequence);
        dicomElementList = dicomElement2.getValueAsSequence(n2);
        try {
            if (this.existsDicomElement(DicomTagNames.TAG_channelOffset)) {
                return Float.parseFloat(af.aa(dicomElementList, DicomTagNames.TAG_channelOffset));
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return 0.0f;
    }

    @Override
    public String ag(int n, int n2) throws NoValidValueIndexException {
        DicomModule dicomModule = new DicomModule(this.aj(n, n2));
        DicomElement dicomElement = dicomModule.getDicomElement(DicomTagNames.TAG_channelSourceSequence);
        dicomModule = new DicomModule(dicomElement.getValueAsSequence(0));
        String string = "";
        String string2 = dicomModule.getString(DicomTagNames.TAG_codeValue);
        String string3 = dicomModule.getString(DicomTagNames.TAG_codingSchemeDesignator);
        String string4 = dicomModule.getString(DicomTagNames.TAG_codingSchemeVersion);
        com.visustt.dicomTk.dict.ac ac2 = com.visustt.dicomTk.dict.ac.aa();
        DicomCode dicomCode = ac2.aa(string2, string3, string4);
        if (dicomModule.existsDicomElement(DicomTagNames.TAG_codeMeaning)) {
            string = af.aa(dicomModule, DicomTagNames.TAG_codeMeaning);
        }
        try {
            if (dicomCode != null) {
                return dicomCode.getMeaning();
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        try {
            if (!"".equals(string)) {
                return string + "*";
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        try {
            if (az.warnIsEnabled()) {
                az.warn("Code Meaning is neither available in codes dictionary nor in dicom object.");
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return string + "*";
    }

    public String an(int n, int n2) throws NoValidValueIndexException {
        DicomModule dicomModule = new DicomModule(this.aj(n, n2));
        DicomElement dicomElement = dicomModule.getDicomElement(DicomTagNames.TAG_channelSourceSequence);
        dicomModule = new DicomModule(dicomElement.getValueAsSequence(0));
        String string = dicomModule.getString(DicomTagNames.TAG_codeValue);
        return string;
    }

    public void aa(Map<String, aj.aa> map, av av2) {
        av av3 = (av)this.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence);
        if (av3 != null && map != null && !map.isEmpty()) {
            av3.ak().map(aas::ab).map(DicomModule::new).forEach(dicomModule -> this.aa((DicomModule)dicomModule, map, av2));
        }
    }

    void aa(DicomModule dicomModule, Map<String, aj.aa> map, av av2) {
        block7: {
            av av3 = (av)dicomModule.getDicomElement(DicomTagNames.TAG_conceptNameCodeSequence);
            try {
                if (!af.aa(av3) || !af.aa(dicomModule.getDicomElement(DicomTagNames.TAG_measurementUnitsCodeSequence))) break block7;
            }
            catch (Exception exception) {
                throw af.d(exception);
            }
            try {
                String string = af.aa(av3, DicomTagNames.TAG_codeValue);
                aj.aa aa10 = map.get(string);
                try {
                    if (aa10 != null) {
                        this.aa(dicomModule, av2, aa10);
                    }
                }
                catch (Exception exception) {
                    throw af.d(exception);
                }
            }
            catch (Exception exception) {
                az.error((Object)"Failed updating the WaveformAnnotationSequence", exception);
            }
        }
    }

    void aa(DicomModule dicomModule, av av2, aj.aa aa10) throws InvalidDataException {
        block9: {
            String string;
            String string2;
            DicomElementList dicomElementList;
            block10: {
                aan aan2 = (aan)dicomModule.getDicomElement(DicomTagNames.TAG_numericValue);
                DicomElement dicomElement = dicomModule.getDicomElement(DicomTagNames.TAG_measurementUnitsCodeSequence);
                dicomElementList = dicomElement.getValueAsSequence(0);
                string2 = af.aa(dicomElementList, DicomTagNames.TAG_codeValue);
                string = aa10.ab().getValue();
                try {
                    try {
                        try {
                            if (aa10.aa().equals(aan2.ac()) && string.equals(string2)) break block9;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw af.d(invalidDataException);
                        }
                        av2.aa((DicomElementList)dicomModule.getDicomElementList().clone());
                        if (aa10.aa().equals(aan2.ac())) break block10;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                    aan2.ab(aa10.aa());
                }
                catch (InvalidDataException invalidDataException) {
                    throw af.d(invalidDataException);
                }
            }
            try {
                if (!string.equals(string2)) {
                    af.aa(dicomElementList, DicomTagNames.TAG_codeValue, string);
                    af.aa(dicomElementList, DicomTagNames.TAG_codeMeaning, aa10.ab().getMeaning());
                    af.aa(dicomElementList, DicomTagNames.TAG_codingSchemeDesignator, aa10.ab().getSchemeDesignator());
                    af.aa(dicomElementList, DicomTagNames.TAG_codingSchemeVersion, aa10.ab().getVersion());
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
        }
    }

    public HashMap ap() throws NoValidValueIndexException, InvalidDataException {
        return this.ae(-1);
    }

    private av ad(int n) throws InvalidDataException {
        av av2 = new av(DicomTagNames.TAG_waveformAnnotationSequence);
        av av3 = (av)this.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence);
        if (av3 != null) {
            int n2 = av3.af();
            for (int i = 0; i < n2; ++i) {
                DicomElementList dicomElementList = av3.getValueAsSequence(i);
                DicomModule dicomModule = new DicomModule(dicomElementList);
                DicomElement dicomElement = dicomModule.getDicomElement(DicomTagNames.TAG_annotationGroupNumber);
                try {
                    try {
                        if (dicomElement == null || dicomElement.getValueAsInt(0) != n) continue;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                    av2.aa(dicomElementList);
                    continue;
                }
                catch (InvalidDataException invalidDataException) {
                    throw af.d(invalidDataException);
                }
            }
        }
        return av2;
    }

    public HashMap ae(int n) throws NoValidValueIndexException, InvalidDataException {
        HashMap hashMap = new HashMap();
        av av2 = n != -1 ? this.ad(n) : (av)this.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence);
        try {
            if (!af.aa(av2)) {
                return hashMap;
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        av2.ak().map(aas::ae).map(DicomModule::new).filter(dicomModule -> dicomModule.existsDicomElement(DicomTagNames.TAG_conceptNameCodeSequence)).forEach(dicomModule -> this.aa((DicomModule)dicomModule, n, hashMap));
        return hashMap;
    }

    /*
     * Loose catch block
     */
    private void aa(DicomModule dicomModule, int n, HashMap<String, String[]> hashMap) {
        block23: {
            int n2;
            block20: {
                n2 = Optional.ofNullable(dicomModule.getDicomElement(DicomTagNames.TAG_annotationGroupNumber)).filter(dicomElement -> dicomElement.getValueMultiplication() > 0).map(DicomElement::getValuesAsObject).map(object -> (Integer)object).map(Integer::intValue).orElse(-2);
                if (n == -1) break block20;
                try {
                    block25: {
                        if (n == n2) break block20;
                        break block25;
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw af.d(noValidValueIndexException);
                        }
                    }
                    return;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            av av2 = (av)dicomModule.getDicomElement(DicomTagNames.TAG_conceptNameCodeSequence);
            try {
                if (av2 == null) {
                    return;
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw af.d(noValidValueIndexException);
            }
            try {
                String string;
                String string2;
                block24: {
                    block21: {
                        block22: {
                            DicomElementList dicomElementList = av2.getValueAsSequence(0);
                            string2 = af.aa(dicomElementList, DicomTagNames.TAG_codeValue);
                            string = af.aa(dicomElementList, DicomTagNames.TAG_codeMeaning);
                            try {
                                if (this.abY.ac != n2) break block21;
                                if (!this.ab(dicomModule, string2, string, hashMap)) break block22;
                            }
                            catch (NoValidValueIndexException noValidValueIndexException) {
                                throw af.d(noValidValueIndexException);
                            }
                            return;
                        }
                        if (this.aa(dicomModule, string2, string, hashMap)) {
                            return;
                        }
                        try {
                            if (az.debugIsEnabled()) {
                                az.debug("\n-------------------------------------------------\nUnable to process annotation\nCodeMeaning: " + string);
                            }
                            break block23;
                        }
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw af.d(noValidValueIndexException);
                        }
                    }
                    try {
                        if (this.abY.ad != n2) break block24;
                        this.aa(dicomModule, string2, string, hashMap);
                        break block23;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                }
                try {
                    if (this.abY.ae == n2) {
                        this.aa(dicomModule, string2, string, hashMap);
                    }
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                az.error((Object)("Failed getting waveform annotation item: " + af.aa(av2, DicomTagNames.TAG_codeMeaning)), noValidValueIndexException);
            }
        }
    }

    private String aa(String string) {
        Double d = Double.parseDouble(string);
        int n = d.intValue();
        return String.valueOf(n);
    }

    boolean aa(DicomModule dicomModule, String string, String string2, HashMap<String, String[]> hashMap) throws NoValidValueIndexException {
        block6: {
            try {
                if (!dicomModule.existsDicomElementWithAtLeastOneValue(DicomTagNames.TAG_temporalRangeType) || !dicomModule.existsDicomElementWithAtLeastOneValue(DicomTagNames.TAG_referencedSamplePositions)) break block6;
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw af.d(noValidValueIndexException);
            }
            String string3 = dicomModule.getDicomElement(DicomTagNames.TAG_temporalRangeType).getValueAsString(0);
            String string4 = dicomModule.getDicomElement(DicomTagNames.TAG_referencedSamplePositions).getValueAsString(0);
            try {
                if (string3.isEmpty() || string4.isEmpty()) break block6;
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw af.d(noValidValueIndexException);
            }
            String[] stringArray = new String[3];
            stringArray[0] = string2;
            if (hashMap.containsKey(string)) {
                String[] stringArray2 = hashMap.get(string);
                stringArray[1] = stringArray2[1] + ";" + string4;
                stringArray[2] = stringArray2[2] + ";" + string3;
            } else {
                stringArray[1] = string4;
                stringArray[2] = string3;
            }
            hashMap.put(string, stringArray);
            return true;
        }
        return false;
    }

    private boolean ab(DicomModule dicomModule, String string, String string2, HashMap<String, String[]> hashMap) throws NoValidValueIndexException {
        block5: {
            try {
                try {
                    if (dicomModule.existsDicomElementWithAtLeastOneValue(DicomTagNames.TAG_measurementUnitsCodeSequence) && dicomModule.existsDicomElementWithAtLeastOneValue(DicomTagNames.TAG_numericValue)) break block5;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
                az.debug("\n-------------------------------------------------\nUnable to process annotation\nCodeMeaning: " + string2);
                return false;
            }
            catch (NoValidValueIndexException noValidValueIndexException) {
                throw af.d(noValidValueIndexException);
            }
        }
        DicomElement dicomElement = dicomModule.getDicomElement(DicomTagNames.TAG_measurementUnitsCodeSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(0);
        String string3 = af.aa(dicomElementList, DicomTagNames.TAG_codeValue);
        String string4 = af.aa(dicomModule, DicomTagNames.TAG_numericValue);
        if (!string4.isEmpty()) {
            String[] stringArray = new String[]{string2, this.aa(string4), string3};
            hashMap.put(string, StringTool.cloneArray(stringArray));
        }
        return true;
    }

    public String af(int n) throws NoValidValueIndexException {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
        return af.aa(dicomElementList, DicomTagNames.TAG_waveformOriginality);
    }

    public String ag(int n) throws NoValidValueIndexException {
        block4: {
            String string;
            block6: {
                block5: {
                    DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
                    DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
                    DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_multiplexGroupLabel);
                    try {
                        try {
                            if (dicomElement2 == null) break block4;
                            if (dicomElement2.getValueMultiplication() <= 0) break block5;
                        }
                        catch (NoValidValueIndexException noValidValueIndexException) {
                            throw af.d(noValidValueIndexException);
                        }
                        string = dicomElement2.getValueAsString(0);
                        break block6;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                }
                string = "(no value available)";
            }
            return string;
        }
        return "(No Multiplex Group Label found.)";
    }

    public short[] aa(int n, int n2, int n3, long l, long l2) throws InvalidDataException, UnavailableException {
        long l3;
        short[] sArray;
        short[] sArray2;
        block24: {
            short[] sArray3;
            block20: {
                DicomElement dicomElement;
                block21: {
                    DicomElement dicomElement2 = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
                    DicomElementList dicomElementList = dicomElement2.getValueAsSequence(n);
                    dicomElement = dicomElementList.getDicomElement(DicomTagNames.TAG_waveformData);
                    sArray2 = null;
                    sArray = null;
                    sArray3 = null;
                    l3 = this.ab(n);
                    try {
                        if (dicomElement == null) break block20;
                        if (!dicomElement.getValueRepresentation().equals("OW")) break block21;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                    sArray3 = ((au)dicomElement).ab();
                    break block20;
                }
                byte[] byArray = ((ar)dicomElement).ab();
                sArray3 = new short[byArray.length];
                try {
                    for (int i = 0; i < byArray.length; ++i) {
                        sArray3[i] = byArray[i];
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw af.d(invalidDataException);
                }
            }
            if (sArray3 != null) {
                block22: {
                    long l4;
                    block23: {
                        l4 = sArray3.length / n3;
                        try {
                            try {
                                if (l3 == l4) break block22;
                                if (!az.debugIsEnabled()) break block23;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw af.d(invalidDataException);
                            }
                            az.debug("Total number of samples is not a multiple of lead samples in multiplex group number " + n + " . Check dicom object.");
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw af.d(invalidDataException);
                        }
                    }
                    l3 = l4;
                }
                sArray2 = new short[(int)l3];
                int n4 = 0;
                try {
                    while ((long)n4 < l3) {
                        sArray2[n4] = sArray3[n4 * n3 + n2];
                        ++n4;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw af.d(invalidDataException);
                }
            }
            try {
                if (l <= 0L || sArray2 == null) break block24;
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
            sArray = new short[(int)l];
            int n5 = 0;
            try {
                while ((long)n5 < l) {
                    sArray[n5] = sArray2[(int)((long)n5 + l2)];
                    ++n5;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
        }
        if (sArray2 != null) {
            sArray = new short[(int)l3];
            sArray = sArray2;
        } else {
            throw new UnavailableException("Waveform data samples are missing in multiplex group " + n + ".");
        }
        return sArray;
    }

    @Override
    public short[] aa(int n, int n2) throws InvalidDataException, UnavailableException {
        int n3 = this.aa(n);
        return this.aa(n, n2, n3, 0L, 0L);
    }

    public short[] aa(int n, int n2, long l, long l2) throws InvalidDataException, UnavailableException {
        int n3 = this.aa(n);
        short[] sArray = this.aa(n, n2, n3, l, l2);
        return sArray;
    }

    public short[] ah(int n) throws NoValidValueIndexException {
        DicomElement dicomElement = this.getDicomElement(DicomTagNames.TAG_waveformSequence);
        DicomElementList dicomElementList = dicomElement.getValueAsSequence(n);
        DicomElement dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_waveformData);
        try {
            if (dicomElement2 != null) {
                return ((au)dicomElement2).ab();
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return aA;
    }

    /*
     * WARNING - void declaration
     */
    public int ao(int n, int n2) throws InvalidDataException {
        void var4_7;
        block4: {
            short[] sArray = this.aa(n, n2);
            int s = Integer.MIN_VALUE;
            if (sArray.length > 0) {
                int n3 = 0;
                while (true) {
                    block5: {
                        short s2;
                        try {
                            if (n3 >= sArray.length) break block4;
                            if (sArray[n3] <= s2) break block5;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw af.d(invalidDataException);
                        }
                        s2 = sArray[n3];
                    }
                    ++n3;
                }
            }
            boolean bl = false;
        }
        return (int)var4_7;
    }

    /*
     * WARNING - void declaration
     */
    public int ap(int n, int n2) throws InvalidDataException {
        void var4_7;
        block4: {
            short[] sArray = this.aa(n, n2);
            int s = Integer.MAX_VALUE;
            if (sArray.length > 0) {
                int n3 = 0;
                while (true) {
                    block5: {
                        short s2;
                        try {
                            if (n3 >= sArray.length) break block4;
                            if (sArray[n3] >= s2) break block5;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw af.d(invalidDataException);
                        }
                        s2 = sArray[n3];
                    }
                    ++n3;
                }
            }
            boolean bl = false;
        }
        return (int)var4_7;
    }

    @Override
    public DicomObject aa(String[] stringArray, String string) {
        return this.aa(stringArray, null, string, this.abY.ah);
    }

    public DicomObject aa(String[] stringArray, Map<String, aj.aa> map, String string) {
        return this.aa(stringArray, map, string, this.abY.ah);
    }

    /*
     * Unable to fully structure code
     */
    DicomObject aa(String[] var1_1, Map<String, aj.aa> var2_2, String var3_3, int var4_4) {
        block16: {
            var5_5 = new Date();
            if (var1_1 == null) {
                var1_1 = new String[]{};
            }
            this.aa(var5_5);
            try {
                var6_6 = (av)this.getDicomElement(DicomTagNames.TAG_waveformAnnotationSequence);
                var7_8 = new av(DicomTagNames.TAG_waveformAnnotationSequence);
                var8_9 = null;
                if (var6_6 != null) {
                    var8_9 = this.aa(var6_6, var7_8, var4_4);
                } else {
                    var6_6 = new av(DicomTagNames.TAG_waveformAnnotationSequence);
                    this.insertDicomElement(var6_6);
                }
                try {
                    if (var2_2 != null) {
                        this.aa(var2_2, var7_8);
                    }
                }
                catch (InvalidDataException v0) {
                    throw af.d(v0);
                }
                this.aa(var3_3, var7_8, var4_4);
                if (var8_9 == null) {
                    var8_9 = new com.visustt.dicomTk.data.al(DicomTagNames.TAG_referencedWaveformChannels);
                    var8_9.aa(new int[]{1, 0});
                }
                try {
                    if (var1_1.length > 0) {
                        this.aa(var1_1, var6_6, var8_9, var4_4);
                    }
                }
                catch (InvalidDataException v1) {
                    throw af.d(v1);
                }
                if (var7_8.aj()) ** GOTO lbl37
                try {
                    block17: {
                        if (var1_1.length <= 0) break block16;
                        break block17;
                        catch (InvalidDataException v2) {
                            throw af.d(v2);
                        }
                    }
                    ac.aa(var3_3, var5_5, var6_6, var4_4);
                }
                catch (InvalidDataException v3) {
                    throw af.d(v3);
                }
            }
            catch (InvalidDataException var6_7) {
                af.az.error((Object)"An error occoured while updating the diagnosis statement", var6_7);
            }
        }
        return this;
    }

    void aa(String[] stringArray, av av2, DicomElement dicomElement, int n) throws InvalidDataException {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.ab(stringArray[i]);
            DicomElementList dicomElementList = new DicomElementList();
            com.visustt.dicomTk.data.al al2 = new com.visustt.dicomTk.data.al(DicomTagNames.TAG_annotationGroupNumber, n);
            aag aag2 = new aag(DicomTagNames.TAG_unformattedTextValue, string);
            dicomElementList.insertDicomElement(al2);
            dicomElementList.insertDicomElement(aag2);
            dicomElementList.insertDicomElement((DicomElement)dicomElement.clone());
            av2.aa(dicomElementList, i);
        }
    }

    String ab(String string) throws InvalidDataException {
        block4: {
            com.visustt.dicomTk.aa.af af2 = this.contents.getDefinedTerm();
            Charset charset = af2.ab();
            CharBuffer charBuffer = charset.decode(charset.encode(string));
            try {
                if (charBuffer.toString().equals(string) || af2.equals(com.visustt.dicomTk.aa.ag.aB)) break block4;
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
            aam aam2 = (aam)this.contents.getDicomElement(DicomTagNames.TAG_specificCharacterSet);
            if (aam2 == null) {
                aam2 = new aam(DicomTagNames.TAG_specificCharacterSet, com.visustt.dicomTk.aa.ag.aB.aa());
                this.contents.insertDicomElement(aam2);
            } else {
                aam2.ab(com.visustt.dicomTk.aa.ag.aB.aa());
            }
            this.contents.setDefinedTerm(com.visustt.dicomTk.aa.ag.aB);
        }
        return string;
    }

    com.visustt.dicomTk.data.al aa(av av2, av av3, int n) throws NoValidValueIndexException {
        int n2 = av3.af();
        com.visustt.dicomTk.data.al al2 = null;
        for (int i = av2.af() - 1; i >= 0; --i) {
            DicomElementList dicomElementList;
            block3: {
                dicomElementList = av2.getValueAsSequence(i);
                try {
                    if (af.aa(dicomElementList) != n) continue;
                    if (al2 != null) break block3;
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
                al2 = (com.visustt.dicomTk.data.al)dicomElementList.getDicomElement(DicomTagNames.TAG_referencedWaveformChannels);
            }
            av3.aa(dicomElementList, n2);
            av2.ad(i);
        }
        return al2;
    }

    static int aa(DicomElementList dicomElementList) {
        int n = -2;
        if (dicomElementList != null) {
            try {
                com.visustt.dicomTk.data.al al2 = (com.visustt.dicomTk.data.al)dicomElementList.getDicomElement(DicomTagNames.TAG_annotationGroupNumber);
                if (al2 != null) {
                    n = al2.aa();
                }
            }
            catch (InvalidDataException invalidDataException) {
                // empty catch block
            }
        }
        return n;
    }

    void aa(String string, av av2, int n) throws InvalidDataException {
        if (av2.aj()) {
            Comparable<Date> comparable;
            DicomElementList dicomElementList;
            block8: {
                block7: {
                    Date date = new Date();
                    dicomElementList = new DicomElementList();
                    try {
                        dicomElementList.insertDicomElement(av2);
                        dicomElementList.insertDicomElement(new aac(DicomTagNames.TAG_visusPrivateCreatorDataElementChange, "Visus Change"));
                        if (ac.aa(n, av2) == null) break block7;
                        dicomElementList.insertDicomElement(new aac(DicomTagNames.TAG_visusDataSaveOrginator, string));
                        dicomElementList.insertDicomElement(new az(DicomTagNames.TAG_visusDataSaveDate, date));
                        dicomElementList.insertDicomElement(new aaa(DicomTagNames.TAG_visusDataSaveTime, date));
                        dicomElementList.insertDicomElement(new an(DicomTagNames.TAG_visusDataSaveID, 1.0));
                        break block8;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                }
                comparable = this.getDate(DicomTagNames.TAG_waveformAcquisitionDateTime);
                ac.aa("", (Date)comparable, av2, n);
                dicomElementList.insertDicomElement(new aac(DicomTagNames.TAG_visusDataSaveOrginator, ""));
                dicomElementList.insertDicomElement(new az(DicomTagNames.TAG_visusDataSaveDate, (Date)comparable));
                dicomElementList.insertDicomElement(new aaa(DicomTagNames.TAG_visusDataSaveTime, (Date)comparable));
                dicomElementList.insertDicomElement(new an(DicomTagNames.TAG_visusDataSaveID, 1.0));
            }
            comparable = (av)this.getDicomElement(DicomTagNames.TAG_visusDataSaveSequence);
            if (comparable == null) {
                comparable = new av(DicomTagNames.TAG_visusDataSaveSequence);
                this.insertDicomElement((DicomElement)comparable);
            }
            try {
                ((av)comparable).aa(dicomElementList);
                if (!this.existsDicomElement(DicomTagNames.TAG_visusPrivateCreatorDataElementChange)) {
                    this.insertDicomElement(new aac(DicomTagNames.TAG_visusPrivateCreatorDataElementChange, "Visus Change"));
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw af.d(invalidDataException);
            }
        }
    }

    void aa(Date date) {
        try {
            as as2 = new as(this.getDicomElementList());
            SeriesModule seriesModule = this.getSeriesModule();
            aw aw2 = this.getSOPCommonModule();
            as2.aa(aw2.aa(), aw2.ab());
            as2.aa(false, false);
            seriesModule.setSeriesDate(date);
            seriesModule.setSeriesTime(date);
            as2.aa(date);
            aw2.ab(date);
            aw2.aa(date);
        }
        catch (InvalidDataException invalidDataException) {
            az.error((Object)"Invalid format: ", invalidDataException);
        }
    }

    private String[] aa(DicomElement dicomElement, int n) throws NoValidValueIndexException {
        try {
            if (dicomElement == null) {
                return new String[0];
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw af.d(invalidDataException);
        }
        int n2 = ((av)dicomElement).af();
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            DicomElement dicomElement2;
            block20: {
                block21: {
                    DicomElementList dicomElementList = null;
                    dicomElementList = dicomElement.getValueAsSequence(i);
                    try {
                        if (dicomElementList == null) {
                            continue;
                        }
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                    DicomElement dicomElement3 = dicomElementList.getDicomElement(DicomTagNames.TAG_annotationGroupNumber);
                    try {
                        if (dicomElement3 == null) {
                            continue;
                        }
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                    int n4 = -1;
                    try {
                        n4 = dicomElement3.getValueAsInt(0);
                    }
                    catch (InvalidDataException invalidDataException) {
                        az.error((Object)invalidDataException, invalidDataException);
                    }
                    if (n4 != n) continue;
                    dicomElement2 = dicomElementList.getDicomElement(DicomTagNames.TAG_unformattedTextValue);
                    try {
                        try {
                            try {
                                if (dicomElement2 == null) continue;
                                if (dicomElement2.getValueMultiplication() != 0) break block20;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw af.d(invalidDataException);
                            }
                            if (!az.debugIsEnabled()) break block21;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw af.d(invalidDataException);
                        }
                        az.debug("Number of elements and/or value multiplication is zero");
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw af.d(invalidDataException);
                    }
                }
                stringArray[n3++] = "";
                continue;
            }
            String[] stringArray2 = dicomElement2.getValues();
            stringArray[n3++] = stringArray2[0];
        }
        if (n3 > 0) {
            String[] stringArray3 = new String[n3];
            System.arraycopy(stringArray, 0, stringArray3, 0, n3);
            stringArray = stringArray3;
        } else {
            String[] stringArray4 = new String[]{};
            stringArray = stringArray4;
        }
        return stringArray;
    }

    ab aq() {
        return this.abY;
    }

    static boolean aa(ab ab5) {
        if (ab5 != null && ab5.aa != null && !ab5.aa.isEmpty()) {
            return aP.putIfAbsent(ab5.aa, ab5) == null;
        }
        return false;
    }

    public void ar() {
        String string = this.as();
        this.ac(string);
    }

    void ac(String string) {
        this.abY = aP.entrySet().stream().filter(entry -> Pattern.compile((String)entry.getKey(), 2).matcher(string).matches()).map(entry -> (ab)entry.getValue()).findFirst().orElse(new ab("<UNKNOWN>", 0, 1, 2, 3, -1, -1, 6));
    }

    public final String ad(String string) throws NoValidValueIndexException {
        return this.aa(string, true);
    }

    public final String aa(String string, boolean bl) throws NoValidValueIndexException {
        String string2;
        String string3;
        aa.ab ab5;
        block10: {
            block9: {
                try {
                    if (!Boolean.valueOf(System.getProperty("com.visustt.waveform.displayDiagnosis", "true")).booleanValue()) {
                        return "";
                    }
                }
                catch (NoValidValueIndexException noValidValueIndexException) {
                    throw af.d(noValidValueIndexException);
                }
                boolean bl2 = Boolean.valueOf(System.getProperty("com.visustt.waveform.displayAutomaticDiagnosis", "true"));
                com.visustt.dicomTk.waveform.ad.aa aa10 = this.ai();
                if (aa10.ad()) {
                    ab5 = aa10.ab();
                } else {
                    try {
                        if (!bl2 || !aa10.ae()) break block9;
                    }
                    catch (NoValidValueIndexException noValidValueIndexException) {
                        throw af.d(noValidValueIndexException);
                    }
                    ab5 = aa10.aa();
                }
                break block10;
            }
            return "";
        }
        try {
            string3 = ab5.ab(string);
            string2 = bl ? string : "";
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            throw af.d(noValidValueIndexException);
        }
        return string3 + string2;
    }

    private String as() {
        try {
            ax ax2 = (ax)this.getDicomElement(DicomTagNames.TAG_manufacturer);
            if (ax2 != null) {
                return StringTool.nullToEmpty(ax2.ac());
            }
        }
        catch (NoValidValueIndexException noValidValueIndexException) {
            az.error((Object)"Unable to determine object's manufacturer", noValidValueIndexException);
        }
        return "";
    }

    private static DicomCode ab(DicomElementList dicomElementList) throws NoValidValueIndexException {
        String string = af.aa(dicomElementList, DicomTagNames.TAG_codeValue);
        String string2 = af.aa(dicomElementList, DicomTagNames.TAG_codingSchemeDesignator);
        String string3 = af.aa(dicomElementList, DicomTagNames.TAG_codingSchemeVersion);
        return com.visustt.dicomTk.dict.ac.aa().aa(string, string2, string3);
    }

    private static void aa(DicomElementList dicomElementList, DicomTag dicomTag, String string) throws InvalidDataException {
        ((ax)dicomElementList.getDicomElement(dicomTag)).ab(string);
    }

    private static String aa(DicomElementList dicomElementList, DicomTag dicomTag) throws NoValidValueIndexException {
        DicomElement dicomElement = dicomElementList.getDicomElement(dicomTag);
        return dicomElement.getValueAsString(0);
    }

    private static String ab(DicomElementList dicomElementList, DicomTag dicomTag, String string) {
        try {
            return dicomElementList.getDicomElement(dicomTag).getValueAsString(0);
        }
        catch (Exception exception) {
            return string;
        }
    }

    private static String aa(DicomModule dicomModule, DicomTag dicomTag) throws NoValidValueIndexException {
        return dicomModule.getDicomElement(dicomTag).getValueAsString(0);
    }

    static String aa(av av2, DicomTag dicomTag) {
        if (av2 != null && av2.aj()) {
            DicomElementList dicomElementList = av2.ak().findFirst().orElseGet(null).ae();
            return af.ab(dicomElementList, dicomTag, null);
        }
        return null;
    }

    private static boolean aa(DicomElement dicomElement) {
        if (dicomElement instanceof av) {
            return ((av)dicomElement).aj();
        }
        return false;
    }

    private static boolean ac(DicomElementList dicomElementList) {
        return dicomElementList != null && dicomElementList.getSize() > 0;
    }

    static {
        af.aa(new ab(".*mortara.*", 0, 1, 2, 3, -1, -1, 6));
        af.aa(new ab(".*schiller.*", 0, 1, 2, 3, -1, -1, 6));
        af.aa(new ab(".*ge medical systems.*", 0, 1, 2, 3, -1, -1, 6));
        af.aa(new ab(".*philips.*", 0, 1, 2, 3, -1, -1, 6));
        af.aa(new ab(".*scp.*", 0, 1, 2, 3, -1, -1, 6));
    }

    private static Exception d(Exception exception) {
        return exception;
    }

    static class ab {
        private String aa;
        private int ab;
        private int ac;
        private int ad;
        private int ae;
        private int af;
        private int ag;
        private int ah;

        private ab() {
            this.aa = "<UNSPECIFIED>";
            this.ab = -1;
            this.ac = -1;
            this.ad = -1;
            this.ae = -1;
            this.af = -1;
            this.ag = -1;
            this.ah = -1;
        }

        ab(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            this.aa = string;
            this.ab = n;
            this.ac = n2;
            this.ad = n3;
            this.ae = n4;
            this.af = n5;
            this.ag = n6;
            this.ah = n7;
        }

        public int aa() {
            return this.ab;
        }

        public int ab() {
            return this.ac;
        }

        public int ac() {
            return this.ad;
        }

        public int ad() {
            return this.ae;
        }

        public int ae() {
            return this.af;
        }

        public int af() {
            return this.ag;
        }

        public int ag() {
            return this.ah;
        }

        public String ah() {
            return this.aa;
        }

        public String toString() {
            return "VendorSettings [manufacturer=" + this.aa + ", machineStatements=" + this.ab + ", machineMeasurements=" + this.ac + ", machineFiducialMarkers=" + this.ad + ", machinePacemakerSpikeMarkers=" + this.ae + ", manualMeasurements=" + this.af + ", manualFiducialMarkers=" + this.ag + ", manualStatements=" + this.ah + "]";
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + this.ad;
            n2 = 31 * n2 + this.ac;
            n2 = 31 * n2 + this.ae;
            n2 = 31 * n2 + this.ab;
            n2 = 31 * n2 + this.ag;
            n2 = 31 * n2 + this.af;
            n2 = 31 * n2 + this.ah;
            n2 = 31 * n2 + (this.aa == null ? 0 : this.aa.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            ab ab5 = (ab)object;
            if (this.ad != ab5.ad) {
                return false;
            }
            if (this.ac != ab5.ac) {
                return false;
            }
            if (this.ae != ab5.ae) {
                return false;
            }
            if (this.ab != ab5.ab) {
                return false;
            }
            if (this.ag != ab5.ag) {
                return false;
            }
            if (this.af != ab5.af) {
                return false;
            }
            if (this.ah != ab5.ah) {
                return false;
            }
            return !(this.aa == null ? ab5.aa != null : !this.aa.equals(ab5.aa));
        }
    }

    private class aa {
        String aa = "";
        String ab = "";

        aa() {
        }
    }
}

