/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.dicomTk.util;

import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.tools.config.main.ConfigurationException;
import java.io.Serializable;
import java.util.Date;

public class DicomNode
implements Serializable {
    static final long serialVersionUID = 3017112519642461521L;
    public String name;
    public String host;
    public String failoverHost;
    public int port;
    public int commitmentPort;
    public String aeTitle;
    public String description;
    public String callingAETitle;
    public int timeout;
    public String moveAETitle;
    public boolean queryRetrieveSCP = false;
    public int queryRetrieveSCPPort;
    public int movePort;
    public boolean storageSCP = false;
    public int storageSCPPort;
    public boolean printSCP = false;
    public int printSCPPort;
    public boolean dicomStudyContentNotificationSCP = false;
    public int dicomStudyContentNotificationSCPPort;
    public String dicomStorageSCUServiceName;
    public String dicomPrintSCUServiceName;
    public String userName;
    public String checkValue;
    public boolean hideInViewer;
    private boolean includeCategoryData;
    public int maxPDUSize = 0;
    public String sslConfiguration = null;
    public int clientDisplayOrder = 0;
    public long creationTimestamp = -1L;
    public long lastUpdateTimestamp = -1L;
    private boolean allowDeletionForDataRetention;
    public boolean iocmTargetForRevocationOrDeletion;
    public boolean iocmTargetForSyncChanges;
    public boolean iocmTargetForSyncPatientDataChange;
    private boolean dateSingleMatching;

    public DicomNode() {
    }

    public DicomNode(DicomNode dicomNode) {
        this.name = dicomNode.name;
        this.host = dicomNode.host;
        this.failoverHost = dicomNode.failoverHost;
        this.port = dicomNode.port;
        this.commitmentPort = dicomNode.commitmentPort;
        this.aeTitle = dicomNode.aeTitle;
        this.description = dicomNode.description;
        this.callingAETitle = dicomNode.callingAETitle;
        this.timeout = dicomNode.timeout;
        this.moveAETitle = dicomNode.moveAETitle;
        this.queryRetrieveSCP = dicomNode.queryRetrieveSCP;
        this.queryRetrieveSCPPort = dicomNode.queryRetrieveSCPPort;
        this.movePort = dicomNode.movePort;
        this.storageSCP = dicomNode.storageSCP;
        this.storageSCPPort = dicomNode.storageSCPPort;
        this.printSCP = dicomNode.printSCP;
        this.printSCPPort = dicomNode.printSCPPort;
        this.dicomStudyContentNotificationSCP = dicomNode.dicomStudyContentNotificationSCP;
        this.dicomStudyContentNotificationSCPPort = dicomNode.dicomStudyContentNotificationSCPPort;
        this.dicomStorageSCUServiceName = dicomNode.dicomStorageSCUServiceName;
        this.dicomPrintSCUServiceName = dicomNode.dicomPrintSCUServiceName;
        this.userName = dicomNode.userName;
        this.checkValue = dicomNode.checkValue;
        this.hideInViewer = dicomNode.hideInViewer;
        this.maxPDUSize = dicomNode.maxPDUSize;
        this.clientDisplayOrder = dicomNode.clientDisplayOrder;
        this.creationTimestamp = dicomNode.creationTimestamp;
        this.lastUpdateTimestamp = dicomNode.lastUpdateTimestamp;
        this.includeCategoryData = dicomNode.includeCategoryData;
        this.allowDeletionForDataRetention = dicomNode.allowDeletionForDataRetention;
        this.iocmTargetForRevocationOrDeletion = dicomNode.iocmTargetForRevocationOrDeletion;
        this.iocmTargetForSyncChanges = dicomNode.iocmTargetForSyncChanges;
        this.iocmTargetForSyncPatientDataChange = dicomNode.iocmTargetForSyncPatientDataChange;
    }

    public DicomNode(String string, String string2, int n, String string3, String string4, String string5, int n2, boolean bl, boolean bl2, String string6, String string7) {
        this(string, string2, n, string3, string4, string5, n2, bl, bl2, string6, string7, true, -1, -1L, -1L);
    }

    /*
     * Loose catch block
     */
    public DicomNode(ConfigurationElement configurationElement) throws ConfigurationException {
        this.name = configurationElement.getStringValue("name");
        try {
            ConfigurationElement configurationElement2;
            block22: {
                block23: {
                    block20: {
                        block21: {
                            this.host = configurationElement.getStringValue("Host");
                            this.failoverHost = configurationElement.getStringValue("FailoverHost", null);
                            this.port = configurationElement.getIntValueMinMaxDefault("Port", 1, 65536, 104);
                            this.aeTitle = configurationElement.getStringValue("AETitle");
                            this.description = configurationElement.getStringValue("Description");
                            this.callingAETitle = configurationElement.getStringValue("CallingAETitle", "JIVEX");
                            this.maxPDUSize = configurationElement.getIntValueMinMaxDefault("MaxPDUSize", 1024, Integer.MAX_VALUE, 32768);
                            this.commitmentPort = configurationElement.getIntValue("CommitmentPort", this.port);
                            this.storageSCPPort = this.port;
                            this.queryRetrieveSCPPort = this.port;
                            this.movePort = this.port;
                            this.printSCPPort = this.port;
                            this.dicomStudyContentNotificationSCPPort = this.port;
                            this.storageSCP = false;
                            this.queryRetrieveSCP = false;
                            this.moveAETitle = null;
                            this.dicomStorageSCUServiceName = "JiveX";
                            this.userName = configurationElement.getStringValue("userName", null);
                            this.checkValue = configurationElement.getStringValue("checkValue", null);
                            this.timeout = configurationElement.getIntValue("timeout", 0);
                            this.hideInViewer = configurationElement.getBooleanValue("hideInViewer", false);
                            this.includeCategoryData = configurationElement.getBooleanValue("includeCategoryData", false);
                            this.allowDeletionForDataRetention = configurationElement.getBooleanValue("allowDeletionForDataRetention", false);
                            this.clientDisplayOrder = configurationElement.getIntValue("ClientDisplayOrder", 0);
                            this.creationTimestamp = configurationElement.getLongValue("CreationTimestamp", System.currentTimeMillis());
                            this.lastUpdateTimestamp = configurationElement.getLongValue("LastUpdateTimestamp", System.currentTimeMillis());
                            this.iocmTargetForRevocationOrDeletion = configurationElement.getBooleanValue("iocmTargetForRevocationOrDeletion", false);
                            this.iocmTargetForSyncChanges = configurationElement.getBooleanValue("iocmTargetForSyncChanges", false);
                            this.iocmTargetForSyncPatientDataChange = configurationElement.getBooleanValue("iocmTargetForSyncPatientDataChange", false);
                            if (!configurationElement.isExisting("DicomQueryRetrieveSCP")) break block20;
                            configurationElement2 = configurationElement.getChild("DicomQueryRetrieveSCP");
                            this.queryRetrieveSCP = configurationElement2.getBooleanValue("enabled", false);
                            this.dateSingleMatching = configurationElement2.getBooleanValue("DateSingleMatching", false);
                            if (!this.queryRetrieveSCP) break block20;
                            try {
                                block24: {
                                    if (!configurationElement2.checkForAttribute("QRPort")) break block21;
                                    break block24;
                                    catch (Exception exception) {
                                        throw DicomNode.a(exception);
                                    }
                                }
                                this.queryRetrieveSCPPort = configurationElement2.getIntValueMinMax("QRPort", 1, 65536);
                            }
                            catch (Exception exception) {
                                throw DicomNode.a(exception);
                            }
                        }
                        try {
                            if (configurationElement2.checkForAttribute("MovePort")) {
                                this.movePort = configurationElement2.getIntValueMinMax("MovePort", 1, 65536);
                            }
                        }
                        catch (Exception exception) {
                            throw DicomNode.a(exception);
                        }
                        try {
                            if (configurationElement2.checkForAttribute("MoveDestinationAETitle")) {
                                this.moveAETitle = configurationElement2.getStringValue("MoveDestinationAETitle");
                            }
                        }
                        catch (Exception exception) {
                            throw DicomNode.a(exception);
                        }
                    }
                    if (!configurationElement.isExisting("DicomStorageSCP")) break block22;
                    configurationElement2 = configurationElement.getChild("DicomStorageSCP");
                    this.storageSCP = configurationElement2.getBooleanValue("enabled", false);
                    if (!this.storageSCP) break block22;
                    try {
                        block25: {
                            if (!configurationElement2.checkForAttribute("StoragePort")) break block23;
                            break block25;
                            catch (Exception exception) {
                                throw DicomNode.a(exception);
                            }
                        }
                        this.storageSCPPort = configurationElement2.getIntValueMinMax("StoragePort", 1, 65536);
                    }
                    catch (Exception exception) {
                        throw DicomNode.a(exception);
                    }
                }
                try {
                    if (configurationElement2.checkForAttribute("handleServiceName")) {
                        this.dicomStorageSCUServiceName = configurationElement2.getStringValue("handleServiceName");
                    }
                }
                catch (Exception exception) {
                    throw DicomNode.a(exception);
                }
            }
            if (configurationElement.isExisting("DicomStudyContentNotificationSCP")) {
                configurationElement2 = configurationElement.getChild("DicomStudyContentNotificationSCP");
                this.dicomStudyContentNotificationSCP = configurationElement2.getBooleanValue("enabled", false);
            }
        }
        catch (Exception exception) {
            throw new ConfigurationException("Failed initializing DicomNode: " + this.name, exception);
        }
    }

    public DicomNode(String string, String string2, int n, String string3, String string4, String string5, int n2, boolean bl, boolean bl2, String string6, String string7, boolean bl3, int n3, long l, long l2) {
        this.name = string;
        this.host = string2;
        this.port = n;
        this.commitmentPort = n;
        this.storageSCPPort = n;
        this.queryRetrieveSCPPort = n;
        this.movePort = n;
        this.printSCPPort = n;
        this.dicomStudyContentNotificationSCPPort = n;
        this.aeTitle = string3;
        this.description = string4;
        this.callingAETitle = string5;
        this.maxPDUSize = n2;
        this.storageSCP = bl;
        this.queryRetrieveSCP = bl2;
        this.moveAETitle = string6;
        this.dicomStorageSCUServiceName = string7;
        this.hideInViewer = bl3;
        this.clientDisplayOrder = n3;
        this.creationTimestamp = l;
        this.lastUpdateTimestamp = l2;
    }

    public boolean isIncludeCategoryData() {
        return this.includeCategoryData;
    }

    public void setIncludeCategoryData(boolean bl) {
        this.includeCategoryData = bl;
    }

    public boolean isAllowDeletionForDataRetention() {
        return this.allowDeletionForDataRetention;
    }

    public void setAllowDeletionForDataRetention(boolean bl) {
        this.allowDeletionForDataRetention = bl;
    }

    public boolean isDateSingleMatching() {
        return this.dateSingleMatching;
    }

    public void setDateSingleMatching(boolean bl) {
        this.dateSingleMatching = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(4096);
        stringBuilder.append("Name: ").append(this.name);
        stringBuilder.append("\n|   Description: ").append(this.description);
        stringBuilder.append("\n|   Host: ").append(this.host);
        if (this.failoverHost != null) {
            stringBuilder.append("\n|   FailOverHost: ").append(this.failoverHost);
        }
        stringBuilder.append("\n|   Port: ").append(this.port);
        if (this.commitmentPort != this.port && this.commitmentPort > 0) {
            stringBuilder.append("\n|   Commitment Port: ").append(this.commitmentPort);
        }
        if (this.storageSCPPort != this.port && this.storageSCPPort > 0) {
            stringBuilder.append("\n|   DICOM Storage SCP Port: ").append(this.storageSCPPort);
        }
        if (this.queryRetrieveSCPPort != this.port && this.queryRetrieveSCPPort > 0) {
            stringBuilder.append("\n|   DICOM Query Retrieve SCP Port: ");
            stringBuilder.append(this.queryRetrieveSCPPort);
        }
        if (this.movePort != this.port && this.movePort != this.queryRetrieveSCPPort && this.movePort > 0) {
            stringBuilder.append("\n|   DICOM Move Port: ");
            stringBuilder.append(this.movePort);
        }
        if (this.printSCPPort != this.port && this.printSCPPort > 0) {
            stringBuilder.append("\n|   DICOM Print SCP Port: ").append(this.printSCPPort);
        }
        if (this.dicomStudyContentNotificationSCPPort != this.port) {
            stringBuilder.append("\n|   DICOM Study Content Notification SCP Port: ");
            stringBuilder.append(this.dicomStudyContentNotificationSCPPort);
        }
        stringBuilder.append("\n|   Max PDU Size: ").append(this.maxPDUSize);
        stringBuilder.append("\n|   AE Title: ").append(this.aeTitle);
        stringBuilder.append("\n|   Calling AE Title: ").append(this.callingAETitle);
        stringBuilder.append("\n|   Check Value: ").append(this.checkValue);
        stringBuilder.append("\n|   User Name: ").append(this.userName);
        stringBuilder.append("\n|   Storage SCP: ").append(this.storageSCP);
        stringBuilder.append("\n|   Print SCP: ").append(this.printSCP);
        stringBuilder.append("\n|   Query Retrieve SCP: ").append(this.queryRetrieveSCP);
        stringBuilder.append("\n|   Date Single Matching: ").append(this.dateSingleMatching);
        stringBuilder.append("\n|   Move Destination AE Title: ").append(this.moveAETitle);
        stringBuilder.append("\n|   Study Content Notification SCP: ");
        stringBuilder.append(this.dicomStudyContentNotificationSCP);
        stringBuilder.append("\n|   Dicom Print SCU Service Name: ");
        stringBuilder.append(this.dicomPrintSCUServiceName);
        stringBuilder.append("\n|   Hide In Viewer: ").append(this.hideInViewer);
        stringBuilder.append("\n|   Client Sort Order: ").append(this.clientDisplayOrder);
        stringBuilder.append("\n|   Creation Timestamp: ").append(new Date(this.creationTimestamp));
        stringBuilder.append("\n|   Last Update Timestamp: ").append(new Date(this.lastUpdateTimestamp));
        stringBuilder.append("\n|   Timeout: ").append(this.timeout);
        stringBuilder.append("\n|   Include Categories: ").append(this.includeCategoryData);
        stringBuilder.append("\n|   Allow Deletion for DataRetention: ").append(this.allowDeletionForDataRetention);
        stringBuilder.append("\n|   Is target for iocm revocation or deletion: ").append(this.iocmTargetForRevocationOrDeletion);
        stringBuilder.append("\n|   Is target for iocm sync changes: ").append(this.iocmTargetForSyncChanges);
        stringBuilder.append("\n|   Is target for iocm sync changes on patient data per HL7: ").append(this.iocmTargetForSyncPatientDataChange);
        return stringBuilder.toString();
    }

    public ConfigurationElement getConfig() {
        ConfigurationElement configurationElement = new ConfigurationElement("DicomNode");
        configurationElement.addAttribute("name", this.name);
        configurationElement.addAttribute("Description", this.description);
        configurationElement.addAttribute("Host", this.host);
        if (this.failoverHost != null) {
            configurationElement.addAttribute("FailoverHost", this.failoverHost);
        }
        configurationElement.addAttribute("Port", Integer.toString(Math.max(1, this.port)));
        configurationElement.addAttribute("AETitle", this.aeTitle);
        configurationElement.addAttribute("CallingAETitle", this.callingAETitle);
        configurationElement.addAttribute("MaxPDUSize", String.valueOf(this.maxPDUSize));
        if (this.timeout > 0) {
            configurationElement.addAttribute("timeout", String.valueOf(this.timeout));
        }
        if (this.commitmentPort > 0) {
            configurationElement.addAttribute("CommitmentPort", String.valueOf(this.commitmentPort));
        }
        configurationElement.addAttribute("hideInViewer", String.valueOf(this.hideInViewer));
        configurationElement.addAttribute("includeCategoryData", String.valueOf(this.includeCategoryData));
        configurationElement.addAttribute("checkValue", this.checkValue);
        configurationElement.addAttribute("userName", this.userName);
        configurationElement.addAttribute("allowDeletionForDataRetention", this.allowDeletionForDataRetention);
        configurationElement.addAttribute("iocmTargetForRevocationOrDeletion", this.iocmTargetForRevocationOrDeletion);
        configurationElement.addAttribute("iocmTargetForSyncChanges", this.iocmTargetForSyncChanges);
        configurationElement.addAttribute("iocmTargetForSyncPatientDataChange", this.iocmTargetForSyncPatientDataChange);
        if (this.clientDisplayOrder > 0) {
            configurationElement.addAttribute("ClientDisplayOrder", String.valueOf(this.clientDisplayOrder));
        }
        if (this.creationTimestamp > 0L) {
            configurationElement.addAttribute("CreationTimestamp", String.valueOf(this.creationTimestamp));
        }
        if (this.lastUpdateTimestamp > 0L) {
            configurationElement.addAttribute("LastUpdateTimestamp", String.valueOf(this.lastUpdateTimestamp));
        }
        ConfigurationElement configurationElement2 = new ConfigurationElement("DicomStorageSCP");
        configurationElement2.addAttribute("enabled", String.valueOf(this.storageSCP));
        configurationElement2.addAttribute("handleServiceName", this.dicomStorageSCUServiceName);
        configurationElement.addChild(configurationElement2);
        ConfigurationElement configurationElement3 = new ConfigurationElement("DicomStudyContentNotificationSCP");
        configurationElement3.addAttribute("enabled", String.valueOf(this.dicomStudyContentNotificationSCP));
        configurationElement.addChild(configurationElement3);
        ConfigurationElement configurationElement4 = new ConfigurationElement("DicomQueryRetrieveSCP");
        configurationElement4.addAttribute("enabled", String.valueOf(this.queryRetrieveSCP));
        configurationElement4.addAttribute("DateSingleMatching", String.valueOf(this.dateSingleMatching));
        configurationElement4.addAttribute("MoveDestinationAETitle", this.moveAETitle);
        configurationElement4.addAttribute("QRPort", Integer.toString(this.queryRetrieveSCPPort));
        if (this.movePort > 0) {
            configurationElement4.addAttribute("MovePort", Integer.toString(this.movePort));
        }
        configurationElement.addChild(configurationElement4);
        return configurationElement;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.aeTitle == null ? 0 : this.aeTitle.hashCode());
        n2 = 31 * n2 + (this.callingAETitle == null ? 0 : this.callingAETitle.hashCode());
        n2 = 31 * n2 + (this.checkValue == null ? 0 : this.checkValue.hashCode());
        n2 = 31 * n2 + this.clientDisplayOrder;
        n2 = 31 * n2 + this.commitmentPort;
        n2 = 31 * n2 + (int)(this.creationTimestamp ^ this.creationTimestamp >>> 32);
        n2 = 31 * n2 + (this.description == null ? 0 : this.description.hashCode());
        n2 = 31 * n2 + (this.dicomPrintSCUServiceName == null ? 0 : this.dicomPrintSCUServiceName.hashCode());
        n2 = 31 * n2 + (this.dicomStorageSCUServiceName == null ? 0 : this.dicomStorageSCUServiceName.hashCode());
        n2 = 31 * n2 + (this.dicomStudyContentNotificationSCP ? 1231 : 1237);
        n2 = 31 * n2 + this.dicomStudyContentNotificationSCPPort;
        n2 = 31 * n2 + (this.failoverHost == null ? 0 : this.failoverHost.hashCode());
        n2 = 31 * n2 + (this.hideInViewer ? 1231 : 1237);
        n2 = 31 * n2 + (this.host == null ? 0 : this.host.hashCode());
        n2 = 31 * n2 + (int)(this.lastUpdateTimestamp ^ this.lastUpdateTimestamp >>> 32);
        n2 = 31 * n2 + this.maxPDUSize;
        n2 = 31 * n2 + (this.moveAETitle == null ? 0 : this.moveAETitle.hashCode());
        n2 = 31 * n2 + this.movePort;
        n2 = 31 * n2 + (this.name == null ? 0 : this.name.hashCode());
        n2 = 31 * n2 + this.port;
        n2 = 31 * n2 + (this.printSCP ? 1231 : 1237);
        n2 = 31 * n2 + this.printSCPPort;
        n2 = 31 * n2 + (this.queryRetrieveSCP ? 1231 : 1237);
        n2 = 31 * n2 + this.queryRetrieveSCPPort;
        n2 = 31 * n2 + (this.sslConfiguration == null ? 0 : this.sslConfiguration.hashCode());
        n2 = 31 * n2 + (this.storageSCP ? 1231 : 1237);
        n2 = 31 * n2 + this.storageSCPPort;
        n2 = 31 * n2 + this.timeout;
        n2 = 31 * n2 + (this.userName == null ? 0 : this.userName.hashCode());
        n2 = 31 * n2 + (this.includeCategoryData ? 1231 : 1237);
        n2 = 31 * n2 + (this.allowDeletionForDataRetention ? 1231 : 1237);
        n2 = 31 * n2 + (this.iocmTargetForRevocationOrDeletion ? 1231 : 1237);
        n2 = 31 * n2 + (this.iocmTargetForSyncChanges ? 1231 : 1237);
        n2 = 31 * n2 + (this.iocmTargetForSyncPatientDataChange ? 1231 : 1237);
        n2 = 31 * n2 + (this.dateSingleMatching ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DicomNode dicomNode = (DicomNode)object;
        if (this.aeTitle == null ? dicomNode.aeTitle != null : !this.aeTitle.equals(dicomNode.aeTitle)) {
            return false;
        }
        if (this.callingAETitle == null ? dicomNode.callingAETitle != null : !this.callingAETitle.equals(dicomNode.callingAETitle)) {
            return false;
        }
        if (this.checkValue == null ? dicomNode.checkValue != null : !this.checkValue.equals(dicomNode.checkValue)) {
            return false;
        }
        if (this.clientDisplayOrder != dicomNode.clientDisplayOrder) {
            return false;
        }
        if (this.commitmentPort != dicomNode.commitmentPort) {
            return false;
        }
        if (this.creationTimestamp != dicomNode.creationTimestamp) {
            return false;
        }
        if (this.description == null ? dicomNode.description != null : !this.description.equals(dicomNode.description)) {
            return false;
        }
        if (this.dicomPrintSCUServiceName == null ? dicomNode.dicomPrintSCUServiceName != null : !this.dicomPrintSCUServiceName.equals(dicomNode.dicomPrintSCUServiceName)) {
            return false;
        }
        if (this.dicomStorageSCUServiceName == null ? dicomNode.dicomStorageSCUServiceName != null : !this.dicomStorageSCUServiceName.equals(dicomNode.dicomStorageSCUServiceName)) {
            return false;
        }
        if (this.dicomStudyContentNotificationSCP != dicomNode.dicomStudyContentNotificationSCP) {
            return false;
        }
        if (this.dicomStudyContentNotificationSCPPort != dicomNode.dicomStudyContentNotificationSCPPort) {
            return false;
        }
        if (this.failoverHost == null ? dicomNode.failoverHost != null : !this.failoverHost.equals(dicomNode.failoverHost)) {
            return false;
        }
        if (this.hideInViewer != dicomNode.hideInViewer) {
            return false;
        }
        if (this.host == null ? dicomNode.host != null : !this.host.equals(dicomNode.host)) {
            return false;
        }
        if (this.lastUpdateTimestamp != dicomNode.lastUpdateTimestamp) {
            return false;
        }
        if (this.maxPDUSize != dicomNode.maxPDUSize) {
            return false;
        }
        if (this.moveAETitle == null ? dicomNode.moveAETitle != null : !this.moveAETitle.equals(dicomNode.moveAETitle)) {
            return false;
        }
        if (this.movePort != dicomNode.movePort) {
            return false;
        }
        if (this.name == null ? dicomNode.name != null : !this.name.equals(dicomNode.name)) {
            return false;
        }
        if (this.port != dicomNode.port) {
            return false;
        }
        if (this.printSCP != dicomNode.printSCP) {
            return false;
        }
        if (this.printSCPPort != dicomNode.printSCPPort) {
            return false;
        }
        if (this.queryRetrieveSCP != dicomNode.queryRetrieveSCP) {
            return false;
        }
        if (this.queryRetrieveSCPPort != dicomNode.queryRetrieveSCPPort) {
            return false;
        }
        if (this.sslConfiguration == null ? dicomNode.sslConfiguration != null : !this.sslConfiguration.equals(dicomNode.sslConfiguration)) {
            return false;
        }
        if (this.storageSCP != dicomNode.storageSCP) {
            return false;
        }
        if (this.storageSCPPort != dicomNode.storageSCPPort) {
            return false;
        }
        if (this.timeout != dicomNode.timeout) {
            return false;
        }
        if (this.userName == null ? dicomNode.userName != null : !this.userName.equals(dicomNode.userName)) {
            return false;
        }
        if (this.includeCategoryData != dicomNode.includeCategoryData) {
            return false;
        }
        if (this.allowDeletionForDataRetention != dicomNode.allowDeletionForDataRetention) {
            return false;
        }
        if (this.iocmTargetForRevocationOrDeletion != dicomNode.iocmTargetForRevocationOrDeletion) {
            return false;
        }
        if (this.iocmTargetForSyncChanges != dicomNode.iocmTargetForSyncChanges) {
            return false;
        }
        if (this.iocmTargetForSyncPatientDataChange != dicomNode.iocmTargetForSyncPatientDataChange) {
            return false;
        }
        return this.dateSingleMatching == dicomNode.dateSingleMatching;
    }

    public String getRetrieveAETitle() {
        if (this.moveAETitle != null) {
            return this.moveAETitle;
        }
        return this.callingAETitle;
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

